/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import hec.map.GlyphDataRecord;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.image.DragPoint;
import hec.map.image.IImageGlyph;
import hec.map.image.ImageGlyphDataRecord;
import hec.map.image.ImageMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class ImageGlyph
extends MapGlyph
implements ImageObserver,
IImageGlyph {
    MediaTracker _tracker = null;
    protected Image _image = null;
    Dimension _imageSize = new Dimension();
    AlphaComposite _ac = null;
    protected boolean _adjustmentEnabled = false;
    List<DragPoint> _dragPointList = new ArrayList<DragPoint>();
    Point2D.Double TEST_PT0 = new Point2D.Double();
    Point2D.Double TEST_PT1 = new Point2D.Double();
    BufferedImage IMG_BUFFER = null;
    Point2D[] tempPoints = null;

    public ImageGlyph() {
    }

    public ImageGlyph(MapPanel panel, ImageMap map) {
        this.setMapPanel(panel);
        this.setMap(map);
    }

    @Override
    public List<DragPoint> getDragPoints() {
        return this._dragPointList;
    }

    @Override
    public void setAdjustmentEnabled(boolean b) {
        this._adjustmentEnabled = b;
    }

    @Override
    public boolean isAdjustmentEnabled() {
        return this._adjustmentEnabled;
    }

    @Override
    public void fillMap(boolean load) {
        block13: {
            super.fillMap(load);
            this._dragPointList.clear();
            this._dragPointList.add(new DragPoint(0));
            this._dragPointList.add(new DragPoint(2));
            this._dragPointList.add(new DragPoint(1));
            this._dragPointList.add(new DragPoint(3));
            this._dragPointList.add(new DragPoint(4));
            this._dragPointList.add(new DragPoint(5));
            this._dragPointList.add(new DragPoint(6));
            this._dragPointList.add(new DragPoint(8));
            this._dragPointList.add(new DragPoint(7));
            this._dragPointList.add(new DragPoint(9));
            try {
                if (load) {
                    Image img = ((ImageMap)this._map).getImage();
                    if (img == null || this._mapPanel == null) {
                        return;
                    }
                    if (this._tracker == null) {
                        this._tracker = new MediaTracker(this._mapPanel);
                    }
                    if (img == this._image) break block13;
                    if (this._image != null) {
                        try {
                            this._tracker.removeImage(this._image);
                        }
                        catch (Exception e) {
                            System.out.println("Error removing image from tracker.  " + e);
                        }
                    }
                    this._image = img;
                    this._tracker.addImage(this._image, 0);
                    try {
                        this._tracker.waitForAll();
                    }
                    catch (Exception e) {
                        System.out.println("Error waiting on image from tracker.  " + e);
                    }
                    break block13;
                }
                if (this._image == null || this._tracker == null) break block13;
                try {
                    this._tracker.removeImage(this._image);
                }
                catch (Exception e) {
                    System.out.println("Error removing image from tracker.  " + e);
                }
                this._image = null;
            }
            catch (Exception e) {
                if (load) {
                    System.out.println("Error loading image.  " + e);
                }
                System.out.println("Error unloading image.  " + e);
            }
        }
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        return new ImageGlyphDataRecord();
    }

    protected ImageGlyphDataRecord getImageGlyphDataRecord() {
        ImageGlyphDataRecord data = (ImageGlyphDataRecord)this.getDataRecord();
        if (data == null) {
            data = new ImageGlyphDataRecord();
            this.setDataRecord(data);
        }
        return data;
    }

    protected void scaleTransform(AffineTransform af, MapScale scl) {
        WorldRect rc = this._map.getExtent();
        double worldWidth = Math.abs(rc.w - rc.e);
        double worldHeight = Math.abs(rc.n - rc.s);
        double zoomX = worldWidth / (double)this._image.getWidth(null);
        double zoomY = worldHeight / (double)this._image.getHeight(null);
        af.scale(Math.abs(zoomX * scl.getXScale()), Math.abs(zoomY * scl.getYScale()));
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        if (this._image == null) {
            return;
        }
        ImageGlyphDataRecord data = this.getImageGlyphDataRecord();
        WorldRect rc = this._map.getExtent();
        LocalRect lc = scl.wr2lr(rc);
        int x = scl.e2x(rc.w);
        int y = scl.n2y(rc.n);
        int x1 = scl.e2x(rc.e);
        int y1 = scl.n2y(rc.s);
        int w = x1 - x;
        int h = y1 - y;
        if (!_paintOk) {
            return;
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g.create();
            Composite oldac = g2.getComposite();
            float alpha = data.getAlpha();
            WorldPt cPT1 = new WorldPt(rc.w + (rc.e - rc.w) / 2.0, rc.s + (rc.n - rc.s) / 2.0);
            LocalPt lPT1 = scl.wp2lp(cPT1);
            AffineTransform newAF = new AffineTransform();
            newAF.translate(lc.l, lc.t);
            this.scaleTransform(newAF, scl);
            AffineTransform oldTransform = g2.getTransform();
            AffineTransform localRotatedTransform = new AffineTransform();
            localRotatedTransform.rotate(((ImageMap)this._map).getRotation(), lc.l + lc.width() / 2, lc.t + lc.height() / 2);
            if (!data.getDrawImageOutline()) {
                if (alpha < 0.0f || alpha > 1.0f) {
                    alpha = 1.0f;
                }
                this._ac = AlphaComposite.getInstance(3, alpha);
                g2.setComposite(this._ac);
                AffineTransform t = g2.getTransform();
                g2.setTransform(localRotatedTransform);
                g2.drawImage(this._image, newAF, this);
                g2.setTransform(t);
            } else {
                g2.setTransform(localRotatedTransform);
                this.drawBorder(g2, lc);
                this.drawFileName(g2, lc);
            }
            if (this._adjustmentEnabled) {
                g2.setTransform(localRotatedTransform);
                this.drawDragPoints(g2, lc);
            }
            g2.setTransform(oldTransform);
            if (oldac != null) {
                g2.setComposite(oldac);
            }
            g2.dispose();
        }
    }

    private BufferedImage scaleTo(Image src, int w, int h) {
        BufferedImage out = new BufferedImage(w, h, 2);
        Graphics2D g2 = out.createGraphics();
        double xScale = (double)w / (double)src.getWidth(this._mapPanel);
        double yScale = (double)h / (double)src.getHeight(this._mapPanel);
        double x = ((double)w - xScale * (double)src.getWidth(this._mapPanel)) / 2.0;
        double y = ((double)h - yScale * (double)src.getHeight(this._mapPanel)) / 2.0;
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        at.scale(xScale, yScale);
        g2.drawRenderedImage((BufferedImage)src, at);
        g2.dispose();
        return out;
    }

    protected void drawFileName(Graphics g2, LocalRect rect) {
        int fontSize = 12;
        Font f = new Font("DialogInput", 0, fontSize);
        FontMetrics fm = g2.getFontMetrics(f);
        ImageMap imageMap = (ImageMap)this.getMap();
        MapIdentifier mapId = imageMap.getMapIdentifier();
        String name = mapId.toString();
        while (fm.stringWidth(name) >= rect.width() && fontSize >= 0) {
            f = new Font("DialogInput", 0, --fontSize);
            fm = g2.getFontMetrics(f);
        }
        if (fontSize == 0) {
            return;
        }
        int stringWidth = fm.stringWidth(name);
        int xPos = rect.l + rect.width() / 2 - stringWidth / 2;
        int yPos = rect.t + rect.height() / 2 - fm.getHeight() / 2;
        g2.setFont(f);
        g2.drawString(name, xPos, yPos);
    }

    protected void drawBorder(Graphics2D g2, LocalRect rect) {
        g2.setColor(Color.black);
        g2.drawRect(rect.l, rect.t, rect.width(), rect.height());
        g2.drawRect(rect.l + 1, rect.t + 1, rect.width() - 2, rect.height() - 2);
        g2.drawRect(rect.l + 2, rect.t + 2, rect.width() - 4, rect.height() - 4);
    }

    protected void drawDragPoints(Graphics2D g2, LocalRect rect) {
        this.drawBorder(g2, rect);
        for (int i = 0; i < this._dragPointList.size(); ++i) {
            DragPoint dp = this._dragPointList.get(i);
            dp.udpate(rect);
            dp.drawPoint(g2);
        }
    }

    private BufferedImage createBufferedImage() {
        MapCanvas canvas = this.getMapPanel().viewport();
        if (this.IMG_BUFFER == null || this.IMG_BUFFER.getHeight() != canvas.getHeight() || this.IMG_BUFFER.getWidth() != canvas.getWidth()) {
            this.IMG_BUFFER = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
        }
        return this.IMG_BUFFER;
    }

    @Override
    public void adjustImage(DragPoint dragPoint, Point PT0, Point PT1) {
        MapObjectInterface mapObject = this.getMap();
        WorldRect wr = mapObject.getExtent();
        MapScale scale = this.getMapPanel().scale();
        Graphics2D g2d = null;
        ImageGlyphDataRecord data = this.getImageGlyphDataRecord();
        LocalRect lc = this.getMapPanel().scale().wr2lr(wr);
        AffineTransform localRotatedTransform = new AffineTransform();
        localRotatedTransform.rotate(((ImageMap)this._map).getRotation(), lc.l + lc.width() / 2, lc.t + lc.height() / 2);
        if (this.tempPoints == null) {
            this.tempPoints = new Point2D[4];
            for (int i = 0; i < this.tempPoints.length; ++i) {
                this.tempPoints[i] = new Point2D.Double();
            }
        }
        if (!data.getShowImageWhileDragging()) {
            g2d = (Graphics2D)this.getMapPanel().viewport().getGraphics().create();
            g2d.setXORMode(new Color(255, 255, 255));
            g2d.setTransform(localRotatedTransform);
            this.drawDragPoints(g2d, lc);
        }
        this.TEST_PT0.x = PT0.x;
        this.TEST_PT0.y = PT0.y;
        this.TEST_PT1.x = PT1.x;
        this.TEST_PT1.y = PT1.y;
        double diffX = 0.0;
        double diffY = 0.0;
        if (dragPoint.getPosition() != 5) {
            // empty if block
        }
        diffX = scale.x2e((int)this.TEST_PT1.x) - scale.x2e((int)this.TEST_PT0.x);
        diffY = scale.y2n((int)this.TEST_PT1.y) - scale.y2n((int)this.TEST_PT0.y);
        double rotation = ((ImageMap)this._map).getRotation();
        double cosRot = Math.cos(rotation);
        double sinRot = Math.sin(rotation);
        double de = diffX;
        double dn = diffY;
        if (dragPoint.getPosition() == 5) {
            wr.e += diffX;
            wr.w += diffX;
            wr.n += diffY;
            wr.s += diffY;
        } else if (dragPoint.getPosition() == 4) {
            diffX = de * cosRot - dn * sinRot;
            wr.e += diffX;
            double dxCen = -diffX / 2.0 * (1.0 - cosRot);
            double dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 3) {
            diffX = de * cosRot - dn * sinRot;
            wr.w += diffX;
            double dxCen = -diffX / 2.0 * (1.0 - cosRot);
            double dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 2) {
            diffY = de * sinRot + dn * cosRot;
            wr.n += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 8) {
            diffY = de * sinRot + dn * cosRot;
            wr.s += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 0) {
            diffY = de * sinRot + dn * cosRot;
            wr.n += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            diffX = de * cosRot - dn * sinRot;
            wr.w += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 1) {
            diffY = de * sinRot + dn * cosRot;
            wr.n += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            diffX = de * cosRot - dn * sinRot;
            wr.e += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 6) {
            diffY = de * sinRot + dn * cosRot;
            wr.s += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            diffX = de * cosRot - dn * sinRot;
            wr.w += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 7) {
            diffY = de * sinRot + dn * cosRot;
            wr.s += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            diffX = de * cosRot - dn * sinRot;
            wr.e += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
        } else if (dragPoint.getPosition() == 9) {
            WorldPt cPT1 = new WorldPt(wr.w + (wr.e - wr.w) / 2.0, wr.s + (wr.n - wr.s) / 2.0);
            Point cPT = new Point(scale.e2x(cPT1.e), scale.n2y(cPT1.n));
            double dx0 = cPT.x - PT0.x;
            double dy0 = cPT.y - PT0.y;
            double dx1 = cPT.x - PT1.x;
            double dy1 = cPT.y - PT1.y;
            rotation = Math.atan2(dx0, dy0) - Math.atan2(dx1, dy1);
            ((ImageMap)this._map).setRotation(rotation);
        }
        if (!data.getShowImageWhileDragging()) {
            this.drawDragPoints(g2d, this.getMapPanel().scale().wr2lr(wr));
            g2d.setPaintMode();
        } else {
            this.getMapPanel().paintMap();
        }
        if (g2d != null) {
            g2d.dispose();
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    @Override
    public void saveImageCoordinates() {
        try {
            ((ImageMap)this._map).write();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getMapPanel(), e.getMessage());
        }
    }

    @Override
    public void adjustFinished() {
        ImageGlyphDataRecord data = this.getImageGlyphDataRecord();
        if (!data.getShowImageWhileDragging()) {
            this.getMapPanel().paintMap();
        }
    }
}

