/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import hec.map.MapScaleEditorPanel;
import hec.map.WorldRect;
import hec.map.image.IImageGlyph;
import hec.map.image.ImageGlyphDataRecord;
import hec.map.image.ImageLayerSelection;
import hec.map.image.ImageMap;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.util.RMAUtil;

public class ImageGlyphOptionsDlg
extends RmaJDialog {
    MapScaleEditorPanel _mapScalePanel = null;
    IImageGlyph _imageGlyph = null;
    ImageGlyphDataRecord _glyphDataRecord = null;
    ImageLayerSelection _imageLayerSelection = null;
    RmaJDecimalField _westTextField;
    RmaJDecimalField _eastTextField;
    RmaJDecimalField _northTextField;
    RmaJDecimalField _southTextField;
    RmaJDecimalField _rotation;
    RmaJCheckBox _drawBorderOnly;
    RmaJCheckBox _dragBorderOnly;
    RmaJDecimalField _alphaTxt;
    JSlider _alphaSlider;
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    private static final double RADIANS_TO_DEGREES = 57.29577951308232;

    public ImageGlyphOptionsDlg(JFrame parent, boolean modal, IImageGlyph imgGlyph, ImageGlyphDataRecord dataRec, ImageLayerSelection imgLayerSelection) {
        super((Frame)parent, modal);
        this.setTitle(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.Title.label"));
        this.buildControls();
        this._imageGlyph = imgGlyph;
        this._glyphDataRecord = dataRec;
        this._mapScalePanel.setMapPanel(imgGlyph.getMapPanel());
        this._imageLayerSelection = imgLayerSelection;
        this.fillForm();
    }

    private void buildControls() {
        int NW = 18;
        int SW = 16;
        int HORIZONTAL = 2;
        int BOTH = 1;
        this.getContentPane().setLayout(new GridBagLayout());
        this._mapScalePanel = new MapScaleEditorPanel();
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.Properties"), propertiesPanel);
        tabbedPane.add(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.Scale.label"), this._mapScalePanel);
        JPanel locationPanel = new JPanel(new GridBagLayout());
        locationPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.Boundary")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        propertiesPanel.add((Component)locationPanel, gbc);
        JLabel label = new JLabel(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.West.label"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)label, gbc);
        this._westTextField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)this._westTextField, gbc);
        label = new JLabel(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.North.label"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)label, gbc);
        this._northTextField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)this._northTextField, gbc);
        label = new JLabel(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.East.label"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)label, gbc);
        this._eastTextField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)this._eastTextField, gbc);
        label = new JLabel(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.South.label"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)label, gbc);
        this._southTextField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)this._southTextField, gbc);
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(new TitledBorder(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.Transparency")));
        sizePanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        propertiesPanel.add((Component)sizePanel, gbc);
        this._alphaTxt = new RmaJDecimalField();
        this._alphaTxt.setEditable(false);
        final RmaJDecimalField tempAlphaTxt = this._alphaTxt;
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.ipadx = 20;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        sizePanel.add((Component)this._alphaTxt, gbc);
        this._alphaSlider = new JSlider(0, 5, 40, 10);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.ipadx = 10;
        sizePanel.add((Component)this._alphaSlider, gbc);
        final JSlider tempSlider = this._alphaSlider;
        this._alphaSlider.setMinimum(0);
        this._alphaSlider.setMaximum(100);
        this._alphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(tempSlider);
                tempAlphaTxt.setText("" + tempSlider.getValue());
            }
        });
        label = new JLabel(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.Rotation.label"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        propertiesPanel.add((Component)label, gbc);
        this._rotation = new RmaJDecimalField();
        this._rotation.setMinValue(0.0);
        this._rotation.setMaxValue(360.0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        propertiesPanel.add((Component)this._rotation, gbc);
        this._dragBorderOnly = new RmaJCheckBox(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.ShowImageWhileDragging.label"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        propertiesPanel.add((Component)this._dragBorderOnly, gbc);
        this._drawBorderOnly = new RmaJCheckBox(ResourceBundle.getBundle("hec/map/image/ImageMap").getString("ImageMap.Properties.Editor.DrawImageBorder.label"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weighty = 1.0;
        propertiesPanel.add((Component)this._drawBorderOnly, gbc);
        this.getContentPane().add((Component)tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.1, 1.0, NW, BOTH, new Insets(5, 5, 0, 5), 0, 0));
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)cmdPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, SW, HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        ImageGlyphOptionsDlg.this.OkButtonPushed();
                        break;
                    }
                    case 2: {
                        ImageGlyphOptionsDlg.this.ApplyButtonPushed();
                        break;
                    }
                    case 4: {
                        ImageGlyphOptionsDlg.this.CancelButtonPushed();
                    }
                }
            }
        });
    }

    public void setDataRecord(ImageGlyphDataRecord dataRec) {
        this._glyphDataRecord = dataRec;
        this.fillForm();
    }

    public void fillForm() {
        if (this._imageGlyph != null) {
            this._mapScalePanel.setScale(this._imageGlyph.getMinimumScale(), this._imageGlyph.getMaximumScale());
            ImageMap map = (ImageMap)this._imageGlyph.getMap();
            if (map != null) {
                if (map.getExtent() != null) {
                    WorldRect ext = map.getExtent();
                    this._westTextField.setValue(ext.w);
                    this._northTextField.setValue(ext.n);
                    this._eastTextField.setValue(ext.e);
                    this._southTextField.setValue(ext.s);
                }
                this._rotation.setValue(57.29577951308232 * map.getRotation());
            }
        }
        if (this._glyphDataRecord != null) {
            double alpha = this._glyphDataRecord.getAlpha();
            this._alphaTxt.setText("" + (int)(100.0 - alpha * 100.0));
            this._alphaSlider.setValue((int)(100.0 - alpha * 100.0));
            this._drawBorderOnly.setSelected(this._glyphDataRecord.getDrawImageOutline());
            this._dragBorderOnly.setSelected(this._glyphDataRecord.getShowImageWhileDragging());
        }
    }

    private void OkButtonPushed() {
        this.ApplyButtonPushed();
        this.setVisible(false);
    }

    private void ApplyButtonPushed() {
        if (this._imageGlyph != null) {
            this._imageGlyph.setMaximumScale(this._mapScalePanel.getMaximumScale());
            this._imageGlyph.setMinimumScale(this._mapScalePanel.getMinimumScale());
            ImageMap map = (ImageMap)this._imageGlyph.getMap();
            if (map != null) {
                WorldRect ext = map.getExtent();
                if (ext == null) {
                    ext = new WorldRect();
                    map.setExtent(ext);
                }
                ext.w = this._westTextField.getValue();
                ext.n = this._northTextField.getValue();
                ext.e = this._eastTextField.getValue();
                ext.s = this._southTextField.getValue();
                map.setRotation(Math.PI / 180 * this._rotation.getValueUndefined(0.0));
                try {
                    map.write();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this._glyphDataRecord != null) {
            double transparency = this._alphaSlider.getValue();
            this._glyphDataRecord.setAlpha((float)(100.0 - transparency) / 100.0f);
            this._glyphDataRecord.setShowImageWhileDragging(this._dragBorderOnly.isSelected());
            this._glyphDataRecord.setDrawImageOutline(this._drawBorderOnly.isSelected());
            this._imageLayerSelection.setDataRecord(this._glyphDataRecord);
            this._glyphDataRecord.setModified(true);
            this._glyphDataRecord.notifyObservers();
            this._glyphDataRecord = (ImageGlyphDataRecord)this._glyphDataRecord.clone();
        }
        this.setModified(false);
    }

    private void CancelButtonPushed() {
        this.setModified(false);
        this.setVisible(false);
    }
}

