/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import hec.event.GlyphSelectionListener;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.map.GlyphDataRecord;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapIdentifier;
import hec.map.MapObjectFactory;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModelDrawingAttributeSet;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.image.DragPoint;
import hec.map.image.IImageGlyph;
import hec.map.image.ImageGlyph;
import hec.map.image.ImageGlyphDataRecord;
import hec.map.image.ImageMap;
import hec.map.mrsid.MrSidMap;
import hec.map.mrsid.MrSidMapGlyph;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeListener;

public class ImageGlyphProxy
extends ImageGlyph
implements IImageGlyph {
    ImageGlyph mImageGlyph = null;
    MapPanel mMapPanel = null;

    @Override
    public void adjustFinished() {
        this.mImageGlyph.adjustFinished();
    }

    @Override
    public void adjustImage(DragPoint dragPoint, Point PT0, Point PT1) {
        this.mImageGlyph.adjustImage(dragPoint, PT0, PT1);
    }

    @Override
    public List<DragPoint> getDragPoints() {
        return this.mImageGlyph.getDragPoints();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return this.mImageGlyph.imageUpdate(img, infoflags, x, y, width, height);
    }

    @Override
    protected ImageGlyphDataRecord getImageGlyphDataRecord() {
        return this.mImageGlyph.getImageGlyphDataRecord();
    }

    @Override
    public int compareTo(MapGlyph o) {
        return this.mImageGlyph.compareTo(o);
    }

    @Override
    public MapGlyph getParentGlyph() {
        return this.mImageGlyph.getParentGlyph();
    }

    @Override
    public void setParentGlyph(MapGlyph glyph) {
        this.mImageGlyph.setParentGlyph(glyph);
    }

    @Override
    public void saveImageCoordinates() {
        this.mImageGlyph.saveImageCoordinates();
    }

    @Override
    protected void scaleTransform(AffineTransform af, MapScale scl) {
        super.scaleTransform(af, scl);
    }

    public ImageGlyphProxy() {
    }

    public ImageGlyphProxy(MapPanel panel, ImageMap map) {
        this.createProxyGlyph(panel, map);
        this.setMapPanel(panel);
        this.setMap(map);
    }

    @Override
    public void addChangeListener(ChangeListener cl) {
        this.mImageGlyph.addChangeListener(cl);
    }

    @Override
    public void addGlyphSelectionListener(GlyphSelectionListener msl) {
        this.mImageGlyph.addGlyphSelectionListener(msl);
    }

    @Override
    public void clearSelection() {
        this.mImageGlyph.clearSelection();
    }

    @Override
    public void clearSelection(String name) {
        this.mImageGlyph.clearSelection(name);
    }

    @Override
    public void close() {
        this.mImageGlyph.close();
    }

    @Override
    public boolean containsSelection(Object object) {
        return this.mImageGlyph.containsSelection(object);
    }

    @Override
    public void drawConformingString(Graphics g, MapScale scl, WorldLine line, String str, double coord, int baseoffset, Font font, Color color, int bank, float priority) {
        this.mImageGlyph.drawConformingString(g, scl, line, str, coord, baseoffset, font, color, bank, priority);
    }

    @Override
    public void drawConformingString2(Graphics g, MapScale scl, WorldLine line, String str, double coord, Font font, Color color, int bank) {
        this.mImageGlyph.drawConformingString2(g, scl, line, str, coord, font, color, bank);
    }

    @Override
    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor) {
        this.mImageGlyph.drawLine(g, line, scl, halfwidth, fillColor, outlineColor);
    }

    @Override
    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize) {
        this.mImageGlyph.drawLine(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize);
    }

    @Override
    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize, boolean isXOR) {
        this.mImageGlyph.drawLine(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize, isXOR);
    }

    @Override
    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize, boolean isXOR, float alpha) {
        this.mImageGlyph.drawLine(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize, isXOR, alpha);
    }

    @Override
    public void drawLine2D(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize, boolean isXOR) {
        this.mImageGlyph.drawLine2D(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize, isXOR);
    }

    @Override
    public void drawRegion(Graphics g, MapScale scl, WorldRegion region, boolean drawPts, Color outline, Color fill) {
        this.mImageGlyph.drawRegion(g, scl, region, drawPts, outline, fill);
    }

    @Override
    public void fillMap(boolean load) {
        this.mImageGlyph.fillMap(load);
    }

    @Override
    public MapGlyph findGlyphOfClass(String classname) {
        return this.mImageGlyph.findGlyphOfClass(classname);
    }

    @Override
    public NamedType findObject(LocalPt pt) {
        return this.mImageGlyph.findObject(pt);
    }

    @Override
    public ModelDrawingAttributeSet getAttributeSet() {
        return this.mImageGlyph.getAttributeSet();
    }

    @Override
    public WorldRect getBounds() {
        return this.mImageGlyph.getBounds();
    }

    @Override
    public GlyphDataRecord getDataRecord() {
        return this.mImageGlyph.getDataRecord();
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        return this.mImageGlyph.getDefaultDataRecord();
    }

    @Override
    public float getGlyphLevel() {
        return this.mImageGlyph.getGlyphLevel();
    }

    @Override
    public MapObjectInterface getMap() {
        return this.mImageGlyph.getMap();
    }

    @Override
    public MapPanel getMapPanel() {
        return this.mImageGlyph.getMapPanel();
    }

    @Override
    public int getMaximumScale() {
        return this.mImageGlyph.getMaximumScale();
    }

    @Override
    public int getMinimumScale() {
        return this.mImageGlyph.getMinimumScale();
    }

    @Override
    public String getName() {
        return this.mImageGlyph.getName();
    }

    @Override
    public NamedType getSelectedObject() {
        return this.mImageGlyph.getSelectedObject();
    }

    @Override
    public NamedType[] getSelections() {
        return this.mImageGlyph.getSelections();
    }

    @Override
    public String getToolTipText(WorldPt wpt, MouseEvent e) {
        return this.mImageGlyph.getToolTipText(wpt, e);
    }

    public Vector glyphVector() {
        return this.mImageGlyph.glyphVector();
    }

    @Override
    public boolean hasChildGlyphs() {
        return this.mImageGlyph.hasChildGlyphs();
    }

    @Override
    public boolean hasMap() {
        return this.mImageGlyph.hasMap();
    }

    @Override
    public boolean intersects(Graphics2D graphics, MapScale scl, int[] xarray, int[] yarray, int numpts) {
        return this.mImageGlyph.intersects(graphics, scl, xarray, yarray, numpts);
    }

    @Override
    public boolean isAttributeAvailable(String s) {
        return this.mImageGlyph.isAttributeAvailable(s);
    }

    @Override
    public boolean isShown() {
        return this.mImageGlyph.isShown();
    }

    @Override
    public boolean isWriteLocked() {
        return this.mImageGlyph.isWriteLocked();
    }

    @Override
    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        return this.mImageGlyph.objectDoubleClick(pt, modifiers);
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        return this.mImageGlyph.objectPopupMenu(pt, modifiers);
    }

    @Override
    public NamedType objectSelect(LocalPt pt, int modifiers) {
        return this.mImageGlyph.objectSelect(pt, modifiers);
    }

    @Override
    public void removeChangeListener(ChangeListener cl) {
        this.mImageGlyph.removeChangeListener(cl);
    }

    @Override
    public void removeGlyphSelectionListener(GlyphSelectionListener msl) {
        this.mImageGlyph.removeGlyphSelectionListener(msl);
    }

    @Override
    public void setDataRecord(GlyphDataRecord rec) {
        this.mImageGlyph.setDataRecord(rec);
    }

    @Override
    public void setGlyphLevel(float glyphLevel) {
        this.mImageGlyph.setGlyphLevel(glyphLevel);
    }

    @Override
    public void setMap(MapObjectInterface map) {
        if (this.mImageGlyph == null) {
            this.createProxyGlyph(this.mMapPanel, (ImageMap)map);
        }
    }

    @Override
    public void setMapPanel(MapPanel panel) {
        this.mMapPanel = panel;
        if (this.mImageGlyph != null) {
            this.mImageGlyph.setMapPanel(panel);
        }
    }

    @Override
    public void setMaximumScale(int maxScale) {
        this.mImageGlyph.setMaximumScale(maxScale);
    }

    @Override
    public void setMinimumScale(int minScale) {
        this.mImageGlyph.setMinimumScale(minScale);
    }

    @Override
    public void setShown(boolean shown) {
        this.mImageGlyph.setShown(shown);
    }

    @Override
    public void showMapElement(String glyphName, String glyphElement, boolean show) {
        this.mImageGlyph.showMapElement(glyphName, glyphElement, show);
    }

    @Override
    public String toString() {
        return this.mImageGlyph.toString();
    }

    @Override
    public void draw(Graphics graphics, MapScale scl) {
        this.mImageGlyph.draw(graphics, scl);
    }

    private void createProxyGlyph(MapPanel panel, ImageMap map) {
        try {
            map.load(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MapIdentifier mapId = map.getMapIdentifier();
        Identifier imageFileId = map.getImageID();
        if (imageFileId != null && imageFileId.getPath().indexOf(".sid") > 0) {
            MapIdentifier newMapId = new MapIdentifier(map.getMapIdentifier());
            newMapId.setPath(mapId.getPath());
            newMapId.setFile(mapId.getFile());
            newMapId.setClassName(MrSidMap.class.getName());
            newMapId.setGlyphDataRecord(mapId.getGlyphDataRecord());
            MrSidMap newMap = (MrSidMap)MapObjectFactory.newMapObject(map.getFileOpener(), newMapId);
            try {
                newMap.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mImageGlyph = new MrSidMapGlyph(panel, newMap);
        } else {
            try {
                map.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mImageGlyph = new ImageGlyph(panel, map);
        }
    }

    @Override
    public boolean isAdjustmentEnabled() {
        return this.mImageGlyph.isAdjustmentEnabled();
    }

    @Override
    public void setAdjustmentEnabled(boolean b) {
        this.mImageGlyph.setAdjustmentEnabled(b);
    }
}

