/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import com.sun.media.jai.codec.SeekableStream;
import hec.appInterface.AppDaddy;
import hec.appInterface.Workspace;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import rma.util.RMAIO;

public class ImageMap
extends MapObject
implements MapObjectInterface {
    Image _image = null;
    protected String _URLstring = null;
    protected Identifier _imageID = null;
    double _rotation = 0.0;

    public ImageMap(String path) {
        super(path);
    }

    public ImageMap(MapIdentifier id) {
        super(id);
    }

    public ImageMap() {
    }

    public Image getImage() {
        return this._image;
    }

    public void setRotation(double rotation) {
        this._rotation = rotation;
    }

    public double getRotation() {
        return this._rotation;
    }

    public String getURLString() {
        return this._URLstring;
    }

    @Override
    public void load() throws IOException {
        this.load(true);
    }

    public void load(boolean loadImage) throws IOException {
        HecFile file = this._mapId.getFile();
        if (file == null) {
            Identifier tempMapId = this._fileOpener.openFile(this._mapId, true);
            if (tempMapId == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Null image file in ImageMap");
                return;
            }
            file = tempMapId.getFile();
            this._mapId.setFile(file);
        }
        BufferedReader input = null;
        try {
            int indexOf;
            input = file.getBufferedReader();
            if (input == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Null Buffered Reader generated from Image File \"" + file.toString() + "\"");
                return;
            }
            this.load(input, loadImage);
            input.close();
            Object path = file.getPath();
            if (path != null && !((String)path).isEmpty() && (indexOf = ((String)path).toLowerCase().indexOf(".img")) >= 0) {
                path = ((String)path).substring(0, indexOf) + ".prj";
                this.readProjection(new Identifier((String)path));
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void load(BufferedReader input, boolean loadImage) throws IOException {
        this.readImg(input);
        if (loadImage) {
            this.loadImage();
        }
    }

    protected void readImg(BufferedReader input) {
        try {
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if (type.compareTo("Image South") == 0) {
                    this._extent.s = RMAIO.parseDouble(param);
                } else if (type.compareTo("Image West") == 0) {
                    this._extent.w = RMAIO.parseDouble(param);
                } else if (type.compareTo("Image North") == 0) {
                    this._extent.n = RMAIO.parseDouble(param);
                } else if (type.compareTo("Image East") == 0) {
                    this._extent.e = RMAIO.parseDouble(param);
                } else if (type.compareTo("Rotation") == 0) {
                    this._rotation = RMAIO.parseDouble(param, 0.0);
                } else if (type.compareTo("Image URL") == 0) {
                    this._URLstring = param.trim();
                }
                line = input.readLine();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    public void write() throws IOException {
        HecFile file = this._mapId.getFile();
        try {
            BufferedWriter output = null;
            if (file != null) {
                output = file.getBufferedWriter();
            } else {
                FileWriter fileWriter = new FileWriter(this._mapId.getPath());
                output = new BufferedWriter(fileWriter);
            }
            this.write(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(BufferedWriter output) throws IOException {
        try {
            output.write("Image West=" + this._extent.w);
            output.newLine();
            output.write("Image North=" + this._extent.n);
            output.newLine();
            output.write("Image East=" + this._extent.e);
            output.newLine();
            output.write("Image South=" + this._extent.s);
            output.newLine();
            output.write("Rotation=" + this._rotation);
            output.newLine();
            output.write("Image URL=" + this._URLstring);
            output.newLine();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setImageFilePath(String path) {
        this._URLstring = path;
    }

    @Override
    public void unload() {
        this._image = null;
        this._loaded = false;
    }

    @Override
    public List getFilenames() {
        String projectionPath;
        int indexOf;
        ArrayList<Object> l = new ArrayList<Object>();
        String path = this._mapId.getPath();
        l.add(path);
        try {
            this.load(false);
        }
        catch (IOException ioe) {
            System.out.println("getFilenames:failed to load Image file " + l.get(0));
            return l;
        }
        this.getImageID();
        if (this._imageID != null) {
            l.add(this._imageID.getPath());
        }
        if ((indexOf = path.toLowerCase().indexOf(".img")) >= 0 && new File(projectionPath = path.substring(0, indexOf) + ".prj").exists()) {
            l.add(projectionPath);
        }
        return l;
    }

    public void loadImage() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this._URLstring != null && !this._URLstring.equals("")) {
            Object id = null;
            if (this._imageID == null) {
                this.getImageID();
            }
            if (this._imageID == null || this._imageID.getFile() == null) {
                System.out.println("ImageMap.loadImage: failed to open " + this._URLstring);
            } else {
                String path = this._imageID.getPath();
                if (path.endsWith(".tif") || path.endsWith(".tiff")) {
                    System.out.println("loadImage:reading TIFF file");
                    SeekableStream stream = null;
                    try {
                        stream = SeekableStream.wrapInputStream((InputStream)this._imageID.getFile().getDataInputStream(), (boolean)true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    ParameterBlock params = new ParameterBlock();
                    params.add(stream);
                    RenderedOp image1 = JAI.create((String)"TIFF", (ParameterBlock)params);
                    System.out.println("loadImage:renderedOp=" + image1);
                    this._image = image1.getColorModel() == null ? image1.getAsBufferedImage(null, (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 2){

                        @Override
                        public int getRed(Object inData) {
                            return this.getRGBComponent2(inData, 0);
                        }

                        @Override
                        public int getGreen(Object inData) {
                            return this.getRGBComponent2(inData, 1);
                        }

                        @Override
                        public int getBlue(Object inData) {
                            return this.getRGBComponent2(inData, 2);
                        }

                        private int getRGBComponent2(Object inData, int idx) {
                            float[] norm = this.getNormalizedComponents(inData, null, 0);
                            float[] rgb = this.getColorSpace().toRGB(norm);
                            return (int)(rgb[idx] * 255.0f + 0.5f);
                        }
                    }) : image1.getAsBufferedImage();
                } else if (this._imageID.getPath().endsWith(".bmp")) {
                    byte[] imageBytes = this._imageID.getFile().getByteArray();
                    System.out.println("loadImage:reading BMP file");
                    ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                    SeekableStream s = SeekableStream.wrapInputStream((InputStream)is, (boolean)false);
                    ParameterBlock pb = new ParameterBlock();
                    pb.add(s);
                    RenderedOp op = JAI.create((String)"BMP", (ParameterBlock)pb);
                    this._image = op.getAsBufferedImage();
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                } else {
                    byte[] imageBytes = this._imageID.getFile().getByteArray();
                    this._image = tk.createImage(imageBytes);
                }
            }
        }
        this._loaded = true;
    }

    protected Identifier getImageID() {
        Identifier id = new Identifier(this._URLstring);
        if (!RMAIO.isFullPath(this._URLstring)) {
            Workspace workspace = AppDaddy.getWorkspace();
            if (workspace == null) {
                return null;
            }
            id = new Identifier(workspace.getWorkspacePath() + "/" + this._URLstring);
        }
        this._imageID = this._fileOpener.openFile(id, false);
        if (this._imageID == null || this._imageID.getFile() == null) {
            // empty if block
        }
        return this._imageID;
    }
}

