/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import hec.map.ButtonGifStrings;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.image.DragPoint;
import hec.map.image.IImageGlyph;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class ImageMouseAdapter
extends MapMouseAdapter {
    private static ButtonGifStrings BGS = null;
    DragPoint SELECTED_DRAG_POINT = null;
    Point PT0;
    Point PT1;
    Point DRAG_POINT_PT = new Point();
    IImageGlyph ADJUSTABLE_GLYPH = null;
    Point2D.Double TRANSFORM_PT = new Point2D.Double();

    public ImageMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    public static ButtonGifStrings createButtonGifStrings() {
        if (BGS == null) {
            BGS = new ButtonGifStrings();
            ImageMouseAdapter.BGS.up = "Images/GeoPoint.gif";
            ImageMouseAdapter.BGS.down = "Images/GeoPoint.gif";
            ImageMouseAdapter.BGS.over = "Images/GeoPoint.gif";
            ImageMouseAdapter.BGS.on = "Images/GeoPoint.gif";
            ImageMouseAdapter.BGS.adapter = "hec.map.image.ImageMouseAdapter";
            ImageMouseAdapter.BGS.toolTipText = "Image Tool";
            ImageMouseAdapter.BGS.borderPainted = true;
        }
        return BGS;
    }

    private List<IImageGlyph> getAdjustableImageGlyphs() {
        ArrayList<IImageGlyph> list = new ArrayList<IImageGlyph>();
        for (int i = 0; i < this._mapPanel.glyphList().size(); ++i) {
            MapGlyph glyph = (MapGlyph)this._mapPanel.glyphList().get(i);
            if (glyph == null || !(glyph instanceof IImageGlyph) || !((IImageGlyph)((Object)glyph)).isAdjustmentEnabled()) continue;
            list.add((IImageGlyph)((Object)glyph));
        }
        return list;
    }

    private List<IImageGlyph> getImageGlyphs() {
        ArrayList<IImageGlyph> list = new ArrayList<IImageGlyph>();
        for (int i = this._mapPanel.glyphList().size() - 1; i >= 0; --i) {
            MapGlyph glyph = (MapGlyph)this._mapPanel.glyphList().get(i);
            if (glyph == null || !(glyph instanceof IImageGlyph)) continue;
            list.add((IImageGlyph)((Object)glyph));
        }
        return list;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        List<IImageGlyph> glyphList = this.getAdjustableImageGlyphs();
        this.SELECTED_DRAG_POINT = null;
        Point mousePt = e.getPoint();
        boolean foundDragPoint = false;
        this.ADJUSTABLE_GLYPH = null;
        for (int z = 0; z < glyphList.size(); ++z) {
            IImageGlyph glyph = glyphList.get(z);
            List<DragPoint> dragPoints = glyph.getDragPoints();
            Cursor cursor = Cursor.getDefaultCursor();
            for (int i = 0; dragPoints != null && i < dragPoints.size(); ++i) {
                DragPoint dp = dragPoints.get(i);
                if (!dp.contains(mousePt)) continue;
                cursor = dp.getCursor();
                this.SELECTED_DRAG_POINT = dp;
                this.PT0 = mousePt;
                this.TRANSFORM_PT.x = mousePt.x;
                this.TRANSFORM_PT.y = mousePt.y;
                if (dp.TRANSFORM != null) {
                    try {
                        dp.INV_TRANSFORM.transform(this.TRANSFORM_PT, this.TRANSFORM_PT);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.DRAG_POINT_PT.x = (int)this.TRANSFORM_PT.x;
                this.DRAG_POINT_PT.y = (int)this.TRANSFORM_PT.y;
                foundDragPoint = true;
                this.ADJUSTABLE_GLYPH = glyph;
            }
            this._mapCanvas.setCursor(cursor);
            if (foundDragPoint) break;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.SELECTED_DRAG_POINT == null) {
            return;
        }
        IImageGlyph glyph = this.ADJUSTABLE_GLYPH;
        if (glyph == null) {
            return;
        }
        this.PT1 = e.getPoint();
        if (this.SELECTED_DRAG_POINT.getPosition() == 9) {
            glyph.adjustImage(this.SELECTED_DRAG_POINT, this.DRAG_POINT_PT, this.PT1);
        } else {
            glyph.adjustImage(this.SELECTED_DRAG_POINT, this.PT0, this.PT1);
        }
        this.PT0 = new Point(this.PT1);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.SELECTED_DRAG_POINT == null) {
            return;
        }
        IImageGlyph glyph = this.ADJUSTABLE_GLYPH;
        if (glyph == null) {
            return;
        }
        glyph.saveImageCoordinates();
        glyph.adjustFinished();
    }
}

