/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import com.mrsid.LTIGeoCoord;
import com.mrsid.MrSidImageReader;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import hec.map.MapIdentifier;
import hec.map.MapPanel;
import hec.map.WorldRect;
import hec.map.image.DefineWorldCoordinatesWizardDialog;
import hec.map.image.ImageInfo;
import hec.map.image.ImageMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import rma.services.annotations.ServiceProvider;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;
import rma.util.lookup.Lookup;

public class ImportImageAction
extends AbstractAction {
    private String mRootDirectory = "";
    private String mMapsDirectory = "";
    private MapPanel mMapPanel = null;
    Component _parent = null;

    public ImportImageAction() {
        this.putValue("Name", ResourceBundle.getBundle("hec/map/image/ImageMap").getString("Image.Import.Action.label"));
    }

    public void setMapsDirectory(String mapsDirectory) {
        this.mMapsDirectory = mapsDirectory;
    }

    public void setMapPanel(MapPanel mapPanel) {
        this.mMapPanel = mapPanel;
    }

    public void setParentComponent(Component parent) {
        this._parent = parent;
    }

    protected File createFile(String path) {
        return new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        File[] imageFiles = this.getImageFiles();
        if (imageFiles == null) {
            return;
        }
        ArrayList<File> filesWithGeoReferencing = new ArrayList<File>();
        ArrayList<File> filesWithOutGeoReferencing = new ArrayList<File>();
        ArrayList<File> pictureWithOutGeoReferencing = new ArrayList<File>();
        for (int i = 0; i < imageFiles.length; ++i) {
            WorldRect wr;
            String imgFileName;
            File imgFile;
            Object imgFilePath;
            File f = imageFiles[i];
            String path = f.getAbsolutePath();
            int idx = path.lastIndexOf(46);
            if (idx <= 0) continue;
            String ext = path.substring(idx);
            String worldFilePath = path.substring(0, idx);
            String worldFileExt = "." + ext.charAt(1) + ext.charAt(ext.length() - 1) + "w";
            File worldFile = this.createFile(worldFilePath + worldFileExt);
            Object object = imgFilePath = this.mMapsDirectory != null || this.mMapsDirectory.length() > 0 ? this.mMapsDirectory : RMAIO.getDirectoryFromPath(path);
            if (!((String)imgFilePath).endsWith("/") && !((String)imgFilePath).endsWith("\\")) {
                imgFilePath = (String)imgFilePath + "/";
            }
            if ((imgFile = this.createFile((String)imgFilePath + (imgFileName = RMAIO.getFileNameNoExtension(path)) + ".img")).exists()) {
                filesWithGeoReferencing.add(imgFile);
                continue;
            }
            if (worldFile.exists()) {
                WorldRect rect = this.getWorldFileExtents(worldFile, f);
                if (rect != null) {
                    this.writeImageFile(imgFile, f, rect, 0.0);
                    filesWithGeoReferencing.add(imgFile);
                    continue;
                }
                filesWithOutGeoReferencing.add(imgFile);
                pictureWithOutGeoReferencing.add(f);
                continue;
            }
            String filePath = f.getAbsolutePath().toLowerCase();
            if (filePath.endsWith(".tiff") || filePath.endsWith(".tif")) {
                wr = this.readGeoTiffExtents(f);
                if (wr != null) {
                    this.writeImageFile(imgFile, f, wr, 0.0);
                    filesWithGeoReferencing.add(imgFile);
                    continue;
                }
                filesWithOutGeoReferencing.add(imgFile);
                pictureWithOutGeoReferencing.add(f);
                continue;
            }
            if (filePath.endsWith(".sid")) {
                wr = this.readSidFileExtents(f);
                if (wr != null) {
                    this.writeImageFile(imgFile, f, wr, 0.0);
                    filesWithGeoReferencing.add(imgFile);
                    continue;
                }
                filesWithOutGeoReferencing.add(imgFile);
                pictureWithOutGeoReferencing.add(f);
                continue;
            }
            filesWithOutGeoReferencing.add(imgFile);
            pictureWithOutGeoReferencing.add(f);
        }
        if (filesWithOutGeoReferencing.size() > 0) {
            DefineWorldCoordinatesWizardDialog dialog = new DefineWorldCoordinatesWizardDialog(null, true, filesWithOutGeoReferencing);
            dialog.pack();
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                Map<File, WorldRect> map = dialog.getImageBounds();
                for (int z = 0; z < filesWithOutGeoReferencing.size(); ++z) {
                    File imgFile = (File)filesWithOutGeoReferencing.get(z);
                    File pictureFile = (File)pictureWithOutGeoReferencing.get(z);
                    WorldRect bounds = map.get(imgFile);
                    this.writeImageFile(imgFile, pictureFile, bounds, 0.0);
                    filesWithGeoReferencing.add(imgFile);
                }
            }
        }
        try {
            if (this.mMapPanel != null) {
                this.mMapPanel.setCursor(Cursor.getPredefinedCursor(3));
            }
            final JDialog dialog = this.buildProgressDialog();
            final ArrayList<File> mapsToAdd = filesWithGeoReferencing;
            if (this._parent != null) {
                dialog.setLocationRelativeTo(this._parent);
            }
            dialog.setVisible(true);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ImportImageAction.this.addMaps(mapsToAdd);
                    dialog.setVisible(false);
                }
            });
            t.start();
        }
        finally {
            if (this.mMapPanel != null) {
                this.mMapPanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private JDialog buildProgressDialog() {
        Window window = this._parent != null ? SwingUtilities.windowForComponent(this._parent) : null;
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, "Import Images", false) : new JDialog((Dialog)window, "Import Images", false);
        Container c2 = dialog.getContentPane();
        ((JComponent)c2).setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Importing images ...");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 0, 5);
        c2.add((Component)label, gbc);
        JProgressBar bar = new JProgressBar();
        bar.setIndeterminate(true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 10, 5);
        c2.add((Component)bar, gbc);
        dialog.setSize(250, 75);
        dialog.setLocationRelativeTo(this._parent);
        return dialog;
    }

    public Dimension getTiffBounds(File tiffFile) {
        Dimension d = new Dimension();
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(tiffFile);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(stream);
            while (iterator.hasNext()) {
                ImageReader reader = iterator.next();
                reader.setInput(stream);
                IIOMetadata metadata = reader.getImageMetadata(0);
                TIFFDirectory tiffDir = TIFFDirectory.createFromMetadata((IIOMetadata)metadata);
                TIFFField tiffField = tiffDir.getTIFFField(256);
                if (tiffField == null) {
                    return null;
                }
                d.width = tiffField.getAsInt(0);
                tiffField = tiffDir.getTIFFField(257);
                d.height = tiffField.getAsInt(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return d;
    }

    public WorldRect readSidFileExtents(File sidFile) {
        Object wr = null;
        try {
            MrSidImageReader reader = new MrSidImageReader();
            reader.openFile(sidFile.getPath());
            LTIGeoCoord coord = reader.getGeoCoord();
            double n = coord.getY();
            double w = coord.getX();
            double e = coord.getXRes() * (double)reader.getWidth() + w;
            double s = n - Math.abs(coord.getYRes() * (double)reader.getHeight());
            return new WorldRect(w, n, e, s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public WorldRect readGeoTiffExtents(File tiffFile) {
        WorldRect wr = null;
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(tiffFile);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(stream);
            if (iterator.hasNext()) {
                ImageReader reader = iterator.next();
                reader.setInput(stream);
                IIOMetadata metadata = reader.getImageMetadata(0);
                TIFFDirectory tiffDir = TIFFDirectory.createFromMetadata((IIOMetadata)metadata);
                TIFFField tiffField = tiffDir.getTIFFField(33922);
                if (tiffField == null) {
                    return null;
                }
                wr = new WorldRect();
                wr.w = ((double[])tiffField.getData())[3];
                wr.n = ((double[])tiffField.getData())[4];
                tiffField = tiffDir.getTIFFField(256);
                if (tiffField == null) {
                    return null;
                }
                double imgWidth = tiffField.getAsDouble(0);
                tiffField = tiffDir.getTIFFField(257);
                double imgHeight = tiffField.getAsDouble(0);
                tiffField = tiffDir.getTIFFField(33550);
                if (tiffField == null) {
                    return null;
                }
                double pixelScaleX = ((double[])tiffField.getData())[0];
                double pixelScaleY = ((double[])tiffField.getData())[1];
                wr.e = wr.w + pixelScaleX * imgWidth;
                wr.s = wr.n - pixelScaleY * imgHeight;
            }
            stream.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return wr;
    }

    protected void addMaps(List<File> maps) {
        ArrayList<ImageMap> mapObjects = new ArrayList<ImageMap>();
        try {
            for (int i = 0; i < maps.size(); ++i) {
                File f = maps.get(i);
                ImageMap imgMap = new ImageMap();
                MapIdentifier mapId = new MapIdentifier(f.getAbsolutePath());
                mapId.setMapShown(true);
                imgMap.setMapIdentifier(mapId);
                BufferedReader reader = this.getBufferedReader(f);
                imgMap.load(reader, true);
                reader.close();
                mapObjects.add(imgMap);
            }
            this.mMapPanel.addMaps(mapObjects);
            this.mMapPanel.updateExtents();
            this.mMapPanel.paintMap();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this._parent, ioe.getMessage(), "", 0);
            ioe.printStackTrace();
        }
    }

    public InputStream getInputStream(File f) {
        try {
            return new FileInputStream(f);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this._parent, e.getMessage(), "", 0);
            return null;
        }
    }

    public BufferedReader getBufferedReader(File f) {
        try {
            return new BufferedReader(new FileReader(f.getAbsolutePath()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this._parent, e.getMessage(), "", 0);
            return null;
        }
    }

    public BufferedWriter getBufferedWriter(File f) {
        try {
            return new BufferedWriter(new FileWriter(f.getAbsolutePath()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this._parent, e.getMessage(), "", 0);
            return null;
        }
    }

    protected File[] getImageFiles() {
        ArrayList imageFiles = new ArrayList();
        JFileChooser fileChooser = new JFileChooser(this.mMapsDirectory);
        List<FileFilter> fileFilters = this.getFileFilters();
        for (int i = 0; fileFilters != null && i < fileFilters.size(); ++i) {
            fileChooser.addChoosableFileFilter(fileFilters.get(i));
        }
        fileChooser.setApproveButtonText("Import");
        fileChooser.setApproveButtonToolTipText("Import");
        File[] selectedFiles = null;
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showOpenDialog(this._parent) == 0) {
            selectedFiles = fileChooser.getSelectedFiles();
        }
        return selectedFiles;
    }

    protected List<FileFilter> getFileFilters() {
        ImageFilterProvider lookup = (ImageFilterProvider)Lookup.getDefault().lookup(ImageFilterProvider.class);
        if (lookup == null) {
            return Collections.EMPTY_LIST;
        }
        return lookup.getFileFilters();
    }

    protected ImageMap writeImageFile(File imgFile, File pictureFile, WorldRect rect, double rotation) {
        ImageMap imageMap = new ImageMap();
        imageMap.setExtent(rect);
        imageMap.setRotation(rotation);
        imageMap.setImageFilePath(RMAIO.getRelativePath(this.mRootDirectory, pictureFile.getAbsolutePath()));
        try {
            File mapDirectory = imgFile.getParentFile();
            if (!mapDirectory.exists()) {
                mapDirectory.mkdirs();
            }
            BufferedWriter writer = this.getBufferedWriter(imgFile);
            imageMap.write(writer);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return imageMap;
    }

    public void setRootDirctory(String string) {
        this.mRootDirectory = string;
    }

    private WorldRect getWorldFileExtents(File worldFile, File imageFile) {
        ImageInfo imgInfo = new ImageInfo();
        imgInfo.setInput(this.getInputStream(imageFile));
        imgInfo.check();
        int imageWidth = 0;
        int imageHeight = 0;
        String filePath = imageFile.getAbsolutePath().toLowerCase();
        if (filePath.endsWith(".tiff") || filePath.endsWith(".tif")) {
            Dimension d = this.getTiffBounds(imageFile);
            imageWidth = d.width;
            imageHeight = d.height;
        } else {
            imageWidth = imgInfo.getWidth();
            imageHeight = imgInfo.getHeight();
        }
        BufferedReader reader = this.getBufferedReader(worldFile);
        if (reader == null) {
            return null;
        }
        WorldRect wr = null;
        ArrayList<String> dataList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                dataList.add(line);
            }
        }
        catch (IOException e) {
            String message = "The following error occurred while parsing\n" + worldFile.getAbsolutePath() + "\n\n";
            JOptionPane.showMessageDialog(this._parent, message + e.getMessage(), "", 0);
            return null;
        }
        try {
            double xscale = Double.valueOf(dataList.get(0).toString());
            double yrotation = Double.valueOf(dataList.get(1).toString());
            double xrotation = Double.valueOf(dataList.get(2).toString());
            double yscale = Math.abs(Double.valueOf(dataList.get(3).toString()));
            double x = Double.valueOf(dataList.get(4).toString());
            double y = Double.valueOf(dataList.get(5).toString());
            wr = new WorldRect(x, y, x + (double)imageWidth * xscale, y - (double)imageHeight * yscale);
        }
        catch (Exception e) {
            String message = "The following error occurred while parsing\n" + worldFile.getAbsolutePath() + "\n\n";
            JOptionPane.showMessageDialog(this._parent, message + e.getMessage(), "", 0);
        }
        return wr;
    }

    public static interface ImageFilterProvider {
        public List<FileFilter> getFileFilters();
    }

    @ServiceProvider(service=ImageFilterProvider.class)
    public static class ImageFilterProviderImpl
    implements ImageFilterProvider {
        @Override
        public List<FileFilter> getFileFilters() {
            ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
            filters.add(new RMAFilenameFilter("gif", "GIF (*.gif)"));
            filters.add(new RMAFilenameFilter("png", "PNG (*.png)"));
            filters.add(new RMAFilenameFilter(new String[]{"jpg", "jpeg"}, "JPEG (*.jpg,*.jpeg)"));
            filters.add(new RMAFilenameFilter(new String[]{"tif", "tiff"}, "TIFF (*.tif, *.tiff)"));
            filters.add(new RMAFilenameFilter("bmp", "Bitmap(*.bmp)"));
            filters.add(new RMAFilenameFilter("sid", "MrSid (*.sid)"));
            return filters;
        }
    }
}

