/*
 * Decompiled with CFR 0.152.
 */
package hec.map.importer;

import hec.map.aishape.ShapeImportTableModel;
import hec.map.aishape.stream.ShapeFileSelector;
import hec.map.importer.ShapeSource;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectListener;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.RmaListModel;

public abstract class AbstractShapeImportDialog
extends RmaJDialog
implements ListSelectionListener {
    protected RmaJTable _table;
    protected ShapeImportTableModel _model;
    protected ShapeSource _selectedSource;
    protected StreamAlignmentGlyph _streamAlignmentGlyph;
    protected RmaJComboBox _availableFieldsComboBox;
    protected ReflectMultiListener _listener = new ReflectMultiListener();
    protected JPanel _tablePanel;
    protected RmaJComboBox _shapefileNameCombo;
    protected RmaJTextField _streamAlignmentFileTxt;
    protected JLabel _msgText;
    protected JButton _fileButton;
    protected JButton _importAllButton;
    protected ShapeFileSelector _shapeSelector;
    protected JPanel _buttonPanel;
    protected JPanel _optionsPanel;
    protected JMenuBar _menuBar;
    protected SymWindow _windowListener;
    protected JPanel _dbFieldNamePanel;
    protected JLabel _dbFieldNameLabel;
    protected JButton _importButton;
    protected JMenuItem _importMenuItem;
    protected JMenuItem _flagAllMenuItem;
    protected JMenuItem _clearAllMenuItem;

    public AbstractShapeImportDialog(Frame parent, boolean modal, List<ShapeSource> sourceList, ShapeSource selectedShapeSource, StreamAlignmentGlyph streamGlyph, ShapeFileSelector selector) {
        super(parent, modal);
        this._shapeSelector = selector;
        this.buildMenus();
        this.buildControls(sourceList, selectedShapeSource, streamGlyph);
        this.addListeners();
    }

    protected void buildControls(List<ShapeSource> sourceList, ShapeSource selectedShapeSource, StreamAlignmentGlyph streamGlyph) {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Shapefile Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)label, gbc);
        this._shapefileNameCombo = new RmaJComboBox();
        this._shapefileNameCombo.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this._shapefileNameCombo, gbc);
        this._fileButton = new JButton("...");
        this._fileButton.setMargin(new Insets(2, 12, 2, 12));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._fileButton, gbc);
        this._tablePanel = new JPanel(new GridBagLayout());
        this._tablePanel.setBorder(BorderFactory.createTitledBorder("Shapefile Information:"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._tablePanel, gbc);
        this._dbFieldNamePanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this._tablePanel.add((Component)this._dbFieldNamePanel, gbc);
        this._dbFieldNameLabel = new JLabel("Database Field Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this._dbFieldNamePanel.add((Component)this._dbFieldNameLabel, gbc);
        this._availableFieldsComboBox = new RmaJComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this._dbFieldNamePanel.add((Component)this._availableFieldsComboBox, gbc);
        this._table = this.createTable();
        this._model = this.createTableModel(this._table);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this._tablePanel.add((Component)this._table.getScrollPane(), gbc);
        this._msgText = new JLabel();
        this._msgText.setForeground(Color.RED);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._tablePanel.add((Component)this._msgText, gbc);
        this._buttonPanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._buttonPanel, gbc);
        this._importAllButton = new JButton("Import All");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._buttonPanel.add((Component)this._importAllButton, gbc);
        this._optionsPanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._optionsPanel, gbc);
        JPanel importPanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)importPanel, gbc);
        this._importButton = new JButton("Import");
        this._importButton.addActionListener(new ReflectListener(this, "importShapes"));
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        importPanel.add((Component)this._importButton, gbc);
        this.pack();
        Dimension d = this.getPreferredSize();
        this.setDefaultSize(d.width, d.height);
        this.clearForm();
        this._shapefileNameCombo.setModel(new RmaListModel<ShapeSource>(true, (Collection<ShapeSource>)sourceList));
        this.setShapeSource(selectedShapeSource);
        this.setStreamAlignmentGlyph(streamGlyph);
        this.streamNameChanged();
        this._shapefileNameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractShapeImportDialog.this.setShapeSource((ShapeSource)AbstractShapeImportDialog.this._shapefileNameCombo.getSelectedItem());
                int itemCount = AbstractShapeImportDialog.this._availableFieldsComboBox.getItemCount();
                if (itemCount > 0) {
                    AbstractShapeImportDialog.this._availableFieldsComboBox.setSelectedIndex(0);
                }
            }
        });
    }

    protected RmaJTable createTable() {
        RmaJTable table = new RmaJTable(this){

            @Override
            public String getToolTipText(MouseEvent event) {
                int row;
                Point p = event.getPoint();
                int column = this.columnAtPoint(p);
                String toolTip = AbstractShapeImportDialog.this._model.getToolTip(column, row = this.rowAtPoint(p));
                if (toolTip != null) {
                    return toolTip;
                }
                return super.getToolTipText(event);
            }
        };
        return table;
    }

    protected abstract ShapeImportTableModel createTableModel(RmaJTable var1);

    protected void addListeners() {
        this._availableFieldsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                AbstractShapeImportDialog.this.streamNameChanged();
            }
        });
        this._importAllButton.addActionListener(this._listener.add(this, this._importAllButton, "importButtonAction"));
        this._fileButton.addActionListener(this._listener.add(this, this._fileButton, "chooseShapeSource"));
        this._table.getSelectionModel().addListSelectionListener(this);
        this._windowListener = new SymWindow();
        this.addWindowListener(this._windowListener);
    }

    protected void buildMenus() {
        this._menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        this._menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Choose Shapefile", 83);
        menuItem.addActionListener(new ReflectListener(this, "chooseShapeSource"));
        menu.add(menuItem);
        this._importMenuItem = new JMenuItem("Import", 73);
        this._importMenuItem.addActionListener(new ReflectListener(this, "importShapes"));
        menu.add(this._importMenuItem);
        menuItem = new JMenuItem("Close", 69);
        menuItem.addActionListener(new ReflectListener(this, "closeDialog"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        this._menuBar.add(menu);
        this._flagAllMenuItem = new JMenuItem("Flag All " + this.getTypeString() + " For Importing", 65);
        this._flagAllMenuItem.addActionListener(new ReflectListener(this, "selectAllImport"));
        menu.add(this._flagAllMenuItem);
        this._clearAllMenuItem = new JMenuItem("Clear All " + this.getTypeString() + " For Importing", 67);
        this._clearAllMenuItem.addActionListener(new ReflectListener(this, "clearAllImport"));
        menu.add(this._clearAllMenuItem);
        this.getRootPane().setJMenuBar(this._menuBar);
    }

    protected abstract String getTypeString();

    public void reverseAllAction() {
        int rowCnt = this._table.getNumRows();
        for (int i = 0; i < rowCnt; ++i) {
            this._table.setValueAt(Boolean.TRUE, i, 2);
        }
        this._model.fireTableRowsUpdated(0, rowCnt - 1);
    }

    public void chooseShapeSource() {
        if (this._shapeSelector == null) {
            return;
        }
        ShapeSource ss = this._shapeSelector.selectShapeSource();
        if (ss == null) {
            return;
        }
        this._shapefileNameCombo.addItem(ss);
        this._shapefileNameCombo.setSelectedItem(ss);
    }

    public abstract void importShapes();

    public void importButtonAction() {
        if ("Import All".equals(this._importAllButton.getText())) {
            this.selectAllImport();
            this._importAllButton.setText("Clear All");
        } else {
            this.clearAllImport();
            this._importAllButton.setText("Import All");
        }
    }

    public void selectAllImport() {
        this._model.setImportAll(true);
        this._table.repaint();
    }

    public void clearAllImport() {
        this._model.setImportAll(false);
        this._table.repaint();
    }

    private void setStreamAlignmentGlyph(StreamAlignmentGlyph glyph) {
        this._streamAlignmentGlyph = glyph;
        this._model.setStreamAlignmentGlyph(glyph);
        this._msgText.setText("");
        if (this._streamAlignmentGlyph != null) {
            if (this._streamAlignmentGlyph.getStreamAlignment().getElementVector().size() == 0 && !this.isStreamAlignmentImporter()) {
                this._msgText.setText("No Stream Reaches found in the selected Stream Alignment");
            }
        } else {
            this._msgText.setText("No Stream Alignment");
        }
        if (!this.canImport()) {
            this._importButton.setEnabled(false);
            this._importMenuItem.setEnabled(false);
        } else {
            this._importButton.setEnabled(true);
            this._importMenuItem.setEnabled(true);
        }
    }

    protected boolean isStreamAlignmentImporter() {
        return false;
    }

    protected void setShapeSource(ShapeSource source) {
        if (this._selectedSource != null && this._selectedSource.equals(source)) {
            return;
        }
        this._selectedSource = source;
        this._shapefileNameCombo.setSelectedItem(this._selectedSource);
        this._model.setShapeSource(source);
        if (this._selectedSource != null) {
            List fieldDescriptors = this._selectedSource.getFieldDescriptors();
            Object streamIdField = null;
            for (int ii = 0; ii < fieldDescriptors.size(); ++ii) {
                Object fieldDescriptor = fieldDescriptors.get(ii);
                if (!fieldDescriptor.toString().equalsIgnoreCase("Stream_ID")) continue;
                streamIdField = fieldDescriptor;
            }
            this._availableFieldsComboBox.removeActionListener(this._listener);
            this._availableFieldsComboBox.setModel(new RmaListModel(true, this._selectedSource.getFieldDescriptors()));
            this._availableFieldsComboBox.addActionListener(this._listener);
            if (streamIdField != null) {
                this._availableFieldsComboBox.setSelectedItem(streamIdField);
            }
        } else {
            this._availableFieldsComboBox.setModel(new RmaListModel(true));
        }
    }

    public void streamNameChanged() {
        Object selectedItem = this._availableFieldsComboBox.getSelectedItem();
        if (this._selectedSource != null) {
            List fieldDescriptors = this._selectedSource.getFieldDescriptors();
            for (int i = 0; i < fieldDescriptors.size(); ++i) {
                if (!fieldDescriptors.get(i).equals(selectedItem)) continue;
                this._model.setNameFieldIndex(i);
                break;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] rows = this._table.getSelectedRows();
        this._model.rowSelected(rows);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this._model.fillModel();
        }
        super.setVisible(b);
    }

    public boolean closeDialog() {
        this.setVisible(false);
        this._model.clearHighlights(true);
        return true;
    }

    protected boolean canImport() {
        return this._msgText.getText().length() == 0;
    }

    protected class SymWindow
    extends WindowAdapter {
        private boolean _allowClose = true;

        protected SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (!this._allowClose) {
                return;
            }
            Object object = event.getSource();
            if (object == AbstractShapeImportDialog.this) {
                AbstractShapeImportDialog.this.closeDialog();
            }
        }

        public void preventClose() {
            this._allowClose = false;
            AbstractShapeImportDialog.this.setDefaultCloseOperation(0);
        }

        public void allowClose() {
            this._allowClose = true;
            AbstractShapeImportDialog.this.setDefaultCloseOperation(1);
        }
    }
}

