/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.appInterface.AppDaddy;
import hec.client.FileChooserFld;
import hec.map.inundation.InundationConst;
import hec.map.inundation.InundationGroup;
import hec.map.inundation.InundationGroupTableModel;
import hec.map.inundation.InundationLayer;
import hec.map.inundation.InundationParameter;
import rma.swing.RmaJTable;
import rma.swing.table.FileNameCellRenderer;
import rma.swing.table.RmaCellEditor;
import rma.util.RMAIO;

public class EditingInundationGroupTableModel
extends InundationGroupTableModel
implements InundationConst {
    RmaCellEditor _editor;
    FileNameCellRenderer _renderer;

    public EditingInundationGroupTableModel(RmaJTable table, InundationGroup ig) {
        super(table, ig);
    }

    @Override
    public void setData(Object obj) {
        if (!(obj instanceof InundationGroup)) {
            return;
        }
        this.setInundationGroup((InundationGroup)obj);
    }

    @Override
    public void saveData() {
    }

    @Override
    protected void initializeComponents() {
        this._table.setColumnEnabled(false, 0);
        if (this._editor == null) {
            FileChooserFld fileCellEditor = new FileChooserFld();
            fileCellEditor.setDefaultPath(AppDaddy.getWorkspace().getWorkspacePath() + "/maps");
            this._editor = new RmaCellEditor(fileCellEditor);
        }
        if (this._renderer == null) {
            this._renderer = new FileNameCellRenderer();
        }
        for (int ii = 0; ii < this._currentGroup.getNumberOfParameters(); ++ii) {
            this._table.setColumnEditor(ii + 1, this._editor);
            this._table.getColumnModel().getColumn(ii + 1).setCellRenderer(this._renderer);
        }
        this.fireTableDataChanged();
    }

    public boolean addExceedenceProbability(Double D) {
        boolean tf = this._currentGroup.addExceedenceProbability(D);
        if (tf) {
            this.fireTableDataChanged();
        }
        return tf;
    }

    public boolean removeExceedenceProbability(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.getRowCount()) {
            RMAIO.postError(this._table, "Please Select an Exceedence Probability to remove.");
            return false;
        }
        if (this.getRowCount() <= 5) {
            RMAIO.postError(this._table, "Unable to remove Exceedence Probability, a minimum of 5 Exceedence Probabilities is required.");
            return false;
        }
        Double D = (Double)this.getValueAt(rowIdx, 0);
        for (int ii = 0; ii < InundationConst.REQUIRED_EXCEEDENCE_PROBABILITIES.length; ++ii) {
            if (D != InundationConst.REQUIRED_EXCEEDENCE_PROBABILITIES[ii]) continue;
            RMAIO.postError(this._table, "The " + InundationConst.REQUIRED_EXCEEDENCE_PROBABILITIES[ii] + " Exceedence Probability is required and cannot be removed.");
            return false;
        }
        boolean tf = this._currentGroup.removeExceedenceProbability(D);
        if (tf) {
            this.fireTableDataChanged();
        }
        return tf;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = super.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            InundationParameter ip = this._currentGroup.getInundationParameter(columnIndex - 1);
            return ip.get(rowIndex);
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return;
        }
        InundationParameter ip = this._currentGroup.getInundationParameter(columnIndex - 1);
        try {
            ip.validate(aValue.toString());
        }
        catch (Exception e) {
            RMAIO.postError(this._table, e.getMessage());
            return;
        }
        InundationLayer il = ip.get(rowIndex);
        boolean tf = il.setMapUrl(aValue.toString());
        if (!tf) {
            RMAIO.postError(this._table, "Inundation Layer is not an Elevation Map.");
        }
    }
}

