/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.io.AsciiDeserializer;
import hec.io.AsciiSerializable;
import hec.io.AsciiSerializer;
import hec.io.HecFile;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.WorldRect;
import hec.map.inundation.InundationConst;
import hec.map.inundation.InundationLayer;
import hec.map.inundation.InundationParameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;

public class InundationGroup
extends MapObject
implements AsciiSerializable {
    transient boolean _needsExtentsBuilt = true;
    transient boolean _needsInit = true;
    List _exceedenceProbabilities = new Vector(5);
    List _parameters = new Vector(1);
    public static final String EXTENSION = ".ifg";

    public InundationGroup() {
        this.init();
    }

    public InundationGroup(MapIdentifier id) {
        super(id);
        this.init();
    }

    public int getNumberOfExceedenceProbabilities() {
        return this._exceedenceProbabilities.size();
    }

    public int getNumberOfParameters() {
        return this._parameters.size();
    }

    public InundationParameter getInundationParameter(int ii) {
        return (InundationParameter)this._parameters.get(ii);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void init() {
        if (this._mapId == null) {
            return;
        }
        this.asciiDeSerialize();
        this._needsInit = false;
    }

    public boolean save() {
        return this.asciiSerialize();
    }

    private boolean asciiDeSerialize() {
        if (this._mapId == null) {
            return false;
        }
        HecFile file = this._mapId.getFile();
        if (file == null) {
            return false;
        }
        BufferedReader input = file.getBufferedReader();
        AsciiDeserializer deserialize = new AsciiDeserializer(input);
        boolean tf = deserialize.deserializeObject(this);
        try {
            input.close();
        }
        catch (Exception e) {
            return false;
        }
        return tf;
    }

    private boolean asciiSerialize() {
        if (this._mapId == null) {
            return false;
        }
        HecFile file = this._mapId.getFile();
        if (file == null) {
            return false;
        }
        BufferedWriter output = file.getBufferedWriter();
        AsciiSerializer serialize = new AsciiSerializer(output);
        boolean tf = serialize.serializeObject(this);
        try {
            output.close();
        }
        catch (Exception e) {
            return false;
        }
        return tf;
    }

    @Override
    public WorldRect getExtent() {
        if (this._needsExtentsBuilt) {
            this._needsExtentsBuilt = false;
            for (int ii = 0; ii < this._parameters.size(); ++ii) {
                InundationParameter ip = (InundationParameter)this._parameters.get(ii);
                ip.growExtents(this._extent);
            }
        }
        return super.getExtent();
    }

    @Override
    public void load() throws IOException {
        if (this._needsInit) {
            this.init();
        }
        for (int ii = 0; ii < this._parameters.size(); ++ii) {
            InundationParameter ip = (InundationParameter)this._parameters.get(ii);
            ip.load();
        }
        this._needsExtentsBuilt = true;
        this._loaded = true;
    }

    @Override
    public void unload() {
        this.asciiDeSerialize();
        for (int ii = 0; ii < this._parameters.size(); ++ii) {
            InundationParameter ip = (InundationParameter)this._parameters.get(ii);
            ip.unload();
        }
        this._loaded = false;
    }

    public Double getExceedenceProbability(int ii) {
        return (Double)this._exceedenceProbabilities.get(ii);
    }

    public void addInundationParameter(InundationParameter ip) {
        this._parameters.add(ip);
        if (this._exceedenceProbabilities.size() < 1) {
            for (int ii = 0; ii < ip.size(); ++ii) {
                InundationLayer il = ip.get(ii);
                double d = il.getExceedenceProbability();
                Double D = new Double(d);
                this._exceedenceProbabilities.add(D);
            }
        }
    }

    public static InundationGroup buildDefault() {
        InundationGroup ig = new InundationGroup();
        for (int jj = 0; jj < InundationConst.REQUIRED_PARAMETERS.length; ++jj) {
            InundationParameter ip = new InundationParameter(InundationConst.REQUIRED_PARAMETERS[jj]);
            for (int ii = 0; ii < InundationConst.DEFAULT_EXCEEDENCE_PROBABILITIES.length; ++ii) {
                InundationLayer il = new InundationLayer(InundationConst.DEFAULT_EXCEEDENCE_PROBABILITIES[ii]);
                ip.addInundationLayer(il);
            }
            ig.addInundationParameter(ip);
        }
        return ig;
    }

    public boolean addExceedenceProbability(Double incomingD) {
        for (int ii = 0; ii < this._exceedenceProbabilities.size(); ++ii) {
            Double exceedenceD = (Double)this._exceedenceProbabilities.get(ii);
            if (incomingD.equals(exceedenceD)) {
                return false;
            }
            if (!(exceedenceD < incomingD)) continue;
            this._exceedenceProbabilities.add(ii, incomingD);
            for (int jj = 0; jj < this._parameters.size(); ++jj) {
                InundationParameter ip = (InundationParameter)this._parameters.get(jj);
                ip.addExceedenceProbability(ii, incomingD);
            }
            return true;
        }
        this._exceedenceProbabilities.add(incomingD);
        for (int jj = 0; jj < this._parameters.size(); ++jj) {
            InundationParameter ip = (InundationParameter)this._parameters.get(jj);
            ip.addExceedenceProbability(incomingD);
        }
        return true;
    }

    public boolean removeExceedenceProbability(Double D) {
        boolean tf = this._exceedenceProbabilities.remove(D);
        if (!tf) {
            return false;
        }
        for (int jj = 0; jj < this._parameters.size(); ++jj) {
            InundationParameter ip = (InundationParameter)this._parameters.get(jj);
            ip.removeExceedenceProbability(D);
        }
        return true;
    }
}

