/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.appInterface.Workspace;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObjectFactory;
import hec.map.inundation.EditingInundationGroupPanel;
import hec.map.inundation.InundationConst;
import hec.map.inundation.InundationGroup;
import hec.map.inundation.InundationGroupDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.event.ReflectListener;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class InundationGroupEditor
extends InundationGroupDialog
implements InundationConst {
    public static final boolean DEBUG = true;

    public InundationGroupEditor(Frame parent, boolean modal) {
        super("Inundation Group Editor", parent, modal);
        long t1 = System.currentTimeMillis();
        this.buildControls();
        long t2 = System.currentTimeMillis();
        long t3 = (t2 - t1) / 1000L;
        System.out.println("BuildControls() - " + t3 + " seconds.");
        this.fillForm(null);
    }

    private void buildControls() {
        this.setTitle("Inundation Group Editor");
        this.buildMenus();
        this.getContentPane().setLayout(new GridBagLayout());
        this._inundationGroupPanel = new EditingInundationGroupPanel("Inundation Layers");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this._inundationGroupPanel, gbc);
        this.pack();
        Dimension d = this.getPreferredSize();
        this.setDefaultSize(d.width, d.height);
    }

    public void newForm() {
        this.checkSave();
        this.fillForm(null);
        this.setFileNameAsTitle();
    }

    public boolean openForm() {
        this.checkSave();
        JFileChooser chooser = new JFileChooser(AppDaddy.getWorkspace().getWorkspacePath() + "/maps");
        RMAFilenameFilter filter = new RMAFilenameFilter("ifg", "Innundation Group");
        chooser.addChoosableFileFilter(filter);
        int rv = chooser.showOpenDialog(this);
        if (rv != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return false;
        }
        Identifier openId = new Identifier(f.getAbsolutePath());
        Identifier fileId = AppDaddy.getWorkspace().openFile(openId, false);
        if (fileId == null) {
            return false;
        }
        Workspace fileOpener = AppDaddy.getWorkspace();
        InundationGroup ig = (InundationGroup)MapObjectFactory.newMapObject((FileOpener)fileOpener, fileId);
        this.fillForm(ig);
        this.setFileNameAsTitle();
        return true;
    }

    public void saveFormAs() {
        if (this.showSaveAs()) {
            this.saveForm();
        }
    }

    public void addExceedenceProbability() {
        RmaJDecimalField dField = new RmaJDecimalField();
        dField.setValue(Double.NEGATIVE_INFINITY);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Exceedence Probability: "), "West");
        panel.add((Component)dField, "Center");
        JOptionPane pane = new JOptionPane(panel, 3, 2);
        JRootPane root = SwingUtilities.getRootPane(pane);
        if (root != null) {
            root.setDefaultButton(null);
        }
        JDialog dialog = pane.createDialog(this, "Add Exceedence Probability");
        dialog.getRootPane().setDefaultButton(null);
        dialog.setVisible(true);
        Integer value = (Integer)pane.getValue();
        if (value != null && value == 0) {
            double val = dField.getValue();
            if (dField.getText().trim().length() < 1 || val < 0.0 || val > 1.0) {
                RMAIO.postError(this, "Exceedence Probability must be between 0.0 and 1.0.");
                this.addExceedenceProbability();
            } else {
                boolean tf = ((EditingInundationGroupPanel)this._inundationGroupPanel).addExceedenceProbability(new Double(val));
                if (!tf) {
                    RMAIO.postError(this, "Exceedence Probability already exists.");
                    this.addExceedenceProbability();
                }
            }
        }
    }

    public void removeExceedenceProbability() {
        ((EditingInundationGroupPanel)this._inundationGroupPanel).removeExceedenceProbability();
    }

    public void paramChange() {
    }

    private void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("New", 78);
        menuItem.addActionListener(new ReflectListener(this, "newForm"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        menu.add(menuItem);
        menuItem = new JMenuItem("Open", 79);
        menuItem.addActionListener(new ReflectListener(this, "openForm"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        menu.add(menuItem);
        menuItem = new JMenuItem("Save", 83);
        menuItem.addActionListener(new ReflectListener(this, "saveForm"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        menu.add(menuItem);
        menuItem = new JMenuItem("Save As", 65);
        menuItem.addActionListener(new ReflectListener(this, "saveFormAs"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Exit", 69);
        menuItem.addActionListener(new ReflectListener(this, "closeDialog"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        menuBar.add(menu);
        menuItem = new JMenuItem("Add Exceedence Probability", 65);
        menuItem.addActionListener(new ReflectListener(this, "addExceedenceProbability"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Remove Exceedence Probability", 82);
        menuItem.addActionListener(new ReflectListener(this, "removeExceedenceProbability"));
        menu.add(menuItem);
        menu = new JMenu("Parameters");
        menu.setMnemonic('P');
        menuBar.add(menu);
        menuItem = new JCheckBoxMenuItem("WSE");
        menuItem.setMnemonic('W');
        menuItem.addActionListener(new ReflectListener(this, "paramChange"));
        menuItem.setSelected(true);
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Depth");
        menuItem.setMnemonic('D');
        menuItem.addActionListener(new ReflectListener(this, "paramChange"));
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Velocity");
        menuItem.setMnemonic('V');
        menuItem.addActionListener(new ReflectListener(this, "paramChange"));
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuBar.add(menu);
        this.getRootPane().setMenuBar(menuBar);
    }

    public static void runStaticTest() {
        Frame frame = new Frame();
        frame.setLocation(50, 50);
        InundationGroupEditor editor = new InundationGroupEditor(frame, true);
        editor.fillForm(null);
        editor.pack();
        editor.setVisible(true);
    }

    @Override
    public void fillForm(Object obj) {
        if (obj == null) {
            obj = InundationGroup.buildDefault();
        } else if (!(obj instanceof InundationGroup)) {
            return;
        }
        this._currentGroup = (InundationGroup)obj;
        this._inundationGroupPanel.fillPanel(this._currentGroup);
    }

    @Override
    protected void windowClosing() {
        this.checkSave();
    }

    public boolean checkSave() {
        int opt;
        if (this.isModified() && this.isVisible() && (opt = JOptionPane.showConfirmDialog(this, "Data has changed. Save Changes?", "Confirm Changes", 0)) == 0) {
            this.saveForm();
            return true;
        }
        return false;
    }

    private boolean showSaveAs() {
        Identifier fileId;
        Object startDir = this._currentGroup.getMapIdentifier() == null ? AppDaddy.getWorkspace().getWorkspacePath() + "/maps" : RMAIO.getDirectoryFromPath(this._currentGroup.getMapIdentifier().getPath());
        JFileChooser chooser = new JFileChooser((String)startDir);
        RMAFilenameFilter filter = new RMAFilenameFilter("ifg", "Innundation Group");
        chooser.addChoosableFileFilter(filter);
        int rv = chooser.showSaveDialog(this);
        if (rv != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return false;
        }
        Identifier saveAsId = new Identifier(f.getAbsolutePath());
        if (saveAsId.getPath().indexOf(".ifg") == -1) {
            saveAsId.setPath(saveAsId.getPath() + ".ifg");
        }
        if ((fileId = AppDaddy.getWorkspace().openFile(saveAsId, false)) == null) {
            fileId = AppDaddy.getWorkspace().createFile(saveAsId);
        }
        this._currentGroup.setMapIdentifier(new MapIdentifier(fileId));
        return true;
    }

    public void saveForm() {
        boolean saved = this._inundationGroupPanel.savePanel();
        if (!saved) {
            return;
        }
        if (this._currentGroup.getMapIdentifier() == null) {
            boolean tf = this.showSaveAs();
            if (tf) {
                saved = this._currentGroup.save();
            }
        } else {
            saved = this._currentGroup.save();
        }
        if (saved) {
            this.setFileNameAsTitle();
        }
        this.setModified(false);
    }
}

