/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.appInterface.AppDaddy;
import hec.appInterface.Workspace;
import hec.map.GlyphDataRecord;
import hec.map.MapGlyph;
import hec.map.MapGlyphFactory;
import hec.map.MapObject;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.inundation.InundationGroup;
import hec.map.inundation.InundationGroupGlyphDataRecord;
import hec.map.inundation.InundationLayer;
import hec.map.inundation.InundationParameter;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;

public class InundationGroupGlyph
extends MapGlyph {
    boolean _needsInit = true;
    Map _glyphMap;

    public InundationGroupGlyph() {
    }

    public InundationGroupGlyph(MapPanel panel, InundationGroup map) {
        super(panel, map);
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        return new InundationGroupGlyphDataRecord(this);
    }

    public MapGlyph getLayerGlyph(InundationLayer il) {
        MapGlyph glyph = (MapGlyph)this._glyphMap.get(il);
        return glyph;
    }

    @Override
    protected void init() {
        if (this._glyphMap == null) {
            this._glyphMap = new HashMap();
        }
        if (this._needsInit) {
            if (this._map == null) {
                return;
            }
            InundationGroupGlyphDataRecord data = (InundationGroupGlyphDataRecord)this.getDataRecord();
            if (data == null) {
                data = (InundationGroupGlyphDataRecord)this.getDefaultDataRecord();
                this.setDataRecord(data);
            }
            InundationGroup ig = (InundationGroup)this._map;
            for (int ii = 0; ii < ig.getNumberOfParameters(); ++ii) {
                InundationParameter ip = ig.getInundationParameter(ii);
                for (int jj = 0; jj < ig.getNumberOfExceedenceProbabilities(); ++jj) {
                    InundationLayer il = ip.get(jj);
                    String mapClassName = il.getMapClassName();
                    MapGlyph glyph = null;
                    if (mapClassName == null) continue;
                    glyph = (MapGlyph)this._glyphMap.get(il);
                    if (glyph == null) {
                        try {
                            glyph = MapGlyphFactory.newMapGlyph(Class.forName(mapClassName));
                            glyph.setMapPanel(this._mapPanel);
                            this._glyphMap.put(il, glyph);
                        }
                        catch (Exception e) {
                            System.out.println("InundationGroupGlyph: Could not instantiate a MapGlyph matching the map class: " + mapClassName);
                            System.out.println("InundationGroupGlyph: " + e.toString());
                            e.printStackTrace();
                            continue;
                        }
                    }
                    GlyphDataRecord glyphDataRecord = data.getDataRecord(il, glyph);
                }
            }
            this._needsInit = false;
        }
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        try {
            if (this._map == null) {
                return;
            }
            if (this._needsInit) {
                this.init();
            }
            InundationGroup ig = (InundationGroup)this._map;
            InundationGroupGlyphDataRecord data = (InundationGroupGlyphDataRecord)this.getDataRecord();
            System.out.println("Draw: " + data);
            for (int ii = 0; ii < ig.getNumberOfParameters(); ++ii) {
                InundationParameter ip = ig.getInundationParameter(ii);
                for (int jj = ig.getNumberOfExceedenceProbabilities() - 1; jj >= 0; --jj) {
                    InundationLayer il = ip.get(jj);
                    Boolean TF = data.getDrawn(il);
                    if (!TF.booleanValue()) continue;
                    this.drawLayer(g, scl, ig, data, il);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawLayer(Graphics g, MapScale scl, InundationGroup ig, InundationGroupGlyphDataRecord data, InundationLayer il) {
        MapGlyph glyph = (MapGlyph)this._glyphMap.get(il);
        GlyphDataRecord datarec = data.getDataRecord(il, glyph);
        Workspace fileOpener = AppDaddy.getWorkspace();
        MapObject map = il.getMapObject(fileOpener);
        glyph.setMap(map);
        if (glyph.getDataRecord() == null || !glyph.getDataRecord().equals(datarec)) {
            glyph.setDataRecord(datarec);
            datarec.setModified(true);
        }
        glyph.setShown(true);
        System.out.println("Drawing Inundation Layer: " + il + " with: " + datarec);
        glyph.draw(g, scl);
    }
}

