/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.appInterface.AppDaddy;
import hec.appInterface.Workspace;
import hec.map.ElevationGlyphDataRecord;
import hec.map.GlyphDataRecord;
import hec.map.MapGlyph;
import hec.map.MapObject;
import hec.map.inundation.InundationGroup;
import hec.map.inundation.InundationGroupGlyph;
import hec.map.inundation.InundationLayer;
import hec.map.inundation.InundationParameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class InundationGroupGlyphDataRecord
extends GlyphDataRecord
implements Cloneable {
    HashMap _drawLayerMap = new HashMap();
    HashMap _gdrMap = new HashMap();

    public InundationGroupGlyphDataRecord() {
    }

    public InundationGroupGlyphDataRecord(InundationGroupGlyph glyph) {
        this();
        this.setGlyph(glyph);
    }

    private void initScaling() {
        Collection c2 = this._gdrMap.values();
        Iterator valIterator = c2.iterator();
        Workspace fileOpener = AppDaddy.getWorkspace();
        while (valIterator.hasNext()) {
            ElevationGlyphDataRecord gdr = (ElevationGlyphDataRecord)valIterator.next();
            Set keySet = this._gdrMap.keySet();
            Iterator keyIterator = keySet.iterator();
            ArrayList<MapObject> mapCollection = new ArrayList<MapObject>(keySet.size());
            while (keyIterator.hasNext()) {
                InundationLayer il = (InundationLayer)keyIterator.next();
                mapCollection.add(il.getMapObject(fileOpener));
            }
            gdr.setMap(mapCollection);
        }
    }

    public GlyphDataRecord getDataRecord(InundationLayer il, MapGlyph glyph) {
        GlyphDataRecord gdr = (GlyphDataRecord)this._gdrMap.get(il);
        if (gdr == null && glyph != null) {
            gdr = glyph.getDefaultDataRecord();
            GlyphDataRecord old = this._gdrMap.put(il, gdr);
            this.initScaling();
            if (old != null) {
                old.deleteObservers();
            }
        }
        return gdr;
    }

    public void setDataRecord(InundationLayer il, GlyphDataRecord gdr) {
        if (il == null || gdr == null) {
            return;
        }
        GlyphDataRecord old = this._gdrMap.put(il, gdr);
        this.initScaling();
        if (old != null) {
            old.deleteObservers();
        }
    }

    @Override
    public Object clone() {
        InundationGroupGlyphDataRecord data = (InundationGroupGlyphDataRecord)super.clone();
        data._drawLayerMap = (HashMap)this._drawLayerMap.clone();
        data._gdrMap = new HashMap(this._gdrMap.size());
        Set keys = this._gdrMap.keySet();
        for (InundationLayer il : keys) {
            GlyphDataRecord gdr = (GlyphDataRecord)this._gdrMap.get(il);
            data._gdrMap.put(il.clone(), gdr.clone());
        }
        return data;
    }

    public Boolean getDrawn(InundationLayer il) {
        if (il == null) {
            return null;
        }
        Boolean TF = (Boolean)this._drawLayerMap.get(il);
        if (TF == null) {
            TF = false;
            this._drawLayerMap.put(il, TF);
        }
        return TF;
    }

    public List getDrawnLayers() {
        ArrayList list = new ArrayList(this._drawLayerMap.size());
        Set keys = this._drawLayerMap.keySet();
        for (Object key : keys) {
            Boolean TF = (Boolean)this._drawLayerMap.get(key);
            if (!TF.booleanValue()) continue;
            list.add(key);
        }
        return list;
    }

    public void setDrawn(InundationLayer il, Boolean TF) {
        if (il == null) {
            return;
        }
        this._drawLayerMap.put(il, TF);
    }

    public void setGlyph(InundationGroupGlyph glyph) {
        InundationGroup ig = (InundationGroup)glyph.getMap();
        if (ig != null) {
            for (int ii = 0; ii < ig.getNumberOfParameters(); ++ii) {
                InundationParameter ip = ig.getInundationParameter(ii);
                for (int jj = 0; jj < ig.getNumberOfExceedenceProbabilities(); ++jj) {
                    InundationLayer il = ip.get(jj);
                    if (this._drawLayerMap.containsKey(il)) continue;
                    this._drawLayerMap.put(il, false);
                }
            }
        }
    }

    @Override
    protected void read0(String type, String param, BufferedReader input) throws IOException {
        if (type.equals("InundationLayer")) {
            StringTokenizer st = new StringTokenizer(param, ",");
            double d = RMAIO.parseDouble(st.nextToken());
            Boolean B = false;
            String mapUrl = null;
            if (st.hasMoreTokens()) {
                mapUrl = st.nextToken();
                if (st.hasMoreTokens()) {
                    B = true;
                }
            }
            InundationLayer il = new InundationLayer(d);
            if (mapUrl != null) {
                il._mapUrl = mapUrl;
            }
            this._drawLayerMap.put(il, B);
        } else if (type.equals("InundationDataRecordBegin")) {
            StringTokenizer st = new StringTokenizer(param, ",");
            double d = RMAIO.parseDouble(st.nextToken());
            Boolean B = false;
            String mapUrl = null;
            if (st.hasMoreTokens()) {
                mapUrl = st.nextToken();
                if (st.hasMoreTokens()) {
                    B = true;
                }
            }
            InundationLayer il = new InundationLayer(d);
            if (mapUrl != null) {
                il._mapUrl = mapUrl;
            }
            String line = input.readLine();
            String gdrClass = RMAIO.getParam(line, "=");
            try {
                Class<?> c2 = Class.forName(gdrClass);
                GlyphDataRecord gdr = (GlyphDataRecord)c2.newInstance();
                gdr.read(input);
                this._gdrMap.put(il, gdr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void write0(BufferedWriter output) throws IOException {
        Set keys = this._gdrMap.keySet();
        for (InundationLayer il : keys) {
            output.write("InundationDataRecordBegin=");
            output.write(RMAIO.toString(il.getExceedenceProbability()));
            if (il.getMapUrl().trim().length() > 0) {
                output.write(",");
                output.write(il.getMapUrl());
            }
            output.newLine();
            GlyphDataRecord gdr = (GlyphDataRecord)this._gdrMap.get(il);
            gdr.write(output);
            output.write("GlyphDataRecordEnd");
            output.newLine();
        }
        keys = this._drawLayerMap.keySet();
        for (InundationLayer il : keys) {
            Boolean B;
            if (il.getMapUrl().trim().length() <= 0 || (B = (Boolean)this._drawLayerMap.get(il)) == null || !B.booleanValue()) continue;
            output.write("InundationLayer=");
            output.write(RMAIO.toString(il.getExceedenceProbability()));
            output.write(",");
            output.write(il.getMapUrl());
            output.write(",");
            output.write(B.toString());
            output.newLine();
        }
    }
}

