/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.map.inundation.InundationGroupTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import rma.lang.Modifiable;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAUtil;

public abstract class InundationGroupPanel
extends JPanel
implements Modifiable {
    protected String _tabName;
    protected InundationGroupTableModel _inundationTableModel;
    protected RmaJTable _inundationTable;
    protected ReflectMultiListener _listeners = new ReflectMultiListener();
    protected boolean _modified;
    protected boolean _ignoreModifiedEvents;

    public InundationGroupPanel(String tabName) {
        this._tabName = tabName;
        this.buildControls();
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        this._modified = modified;
        if (modified) {
            RMAUtil.setParentModified(this);
        } else {
            RMAUtil.setChildrenUnmodified(this);
        }
    }

    public void setIgnoreModifiedEvents(boolean ignore) {
        this._ignoreModifiedEvents = ignore;
    }

    public boolean isIgnoringModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    public String getTabname() {
        return this._tabName;
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        this._inundationTable = new RmaJTable(this);
        this._inundationTable.setNumRows(10);
        this._inundationTable.setColumnBackground(0, Color.lightGray);
        this._inundationTable.setPreferredScrollableViewportSize(this._inundationTable.getPreferredSize());
        this._inundationTable.getSelectionModel().setSelectionMode(0);
        this.add((Component)this._inundationTable.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        this._inundationTable.getScrollPane().setPreferredSize(new Dimension(450, 250));
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public abstract void fillPanel(Object var1);

    public boolean savePanel() {
        this._inundationTable.commitEdit(true);
        return true;
    }
}

