/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.map.MapPanel;
import hec.map.inundation.InundationGroupDialog;
import hec.map.inundation.InundationGroupEditor;
import hec.map.inundation.InundationGroupSelection;
import hec.map.inundation.RenderingInundationGroupPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;

public class InundationGroupRenderingDialog
extends InundationGroupDialog {
    public static final boolean DEBUG = true;
    boolean _canceled = false;
    MapPanel _mapPanel;
    InundationGroupSelection _selection;

    public InundationGroupRenderingDialog(Frame parent, boolean modal, MapPanel mapPanel) {
        super("Inundation Group Rendering Control", parent, modal);
        this._mapPanel = mapPanel;
        long t1 = System.currentTimeMillis();
        this.buildControls();
        long t2 = System.currentTimeMillis();
        long t3 = (t2 - t1) / 1000L;
        System.out.println("BuildControls() - " + t3 + " seconds.");
    }

    private void buildControls() {
        this.setTitle("Inundation Group Rendering Control");
        this.buildMenus();
        this.getContentPane().setLayout(new GridBagLayout());
        this._inundationGroupPanel = new RenderingInundationGroupPanel("Inundation Layers");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this._inundationGroupPanel, gbc);
        ButtonCmdPanel buttons = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)buttons, gbc);
        buttons.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                int id = event.getID();
                if (id == 8) {
                    InundationGroupRenderingDialog.this.okPressed();
                } else if (id == 2) {
                    InundationGroupRenderingDialog.this.applyPressed();
                } else if (id == 4) {
                    InundationGroupRenderingDialog.this.cancelPressed();
                }
            }
        });
        this.pack();
        Dimension d = this.getPreferredSize();
        this.setDefaultSize(d.width, d.height);
    }

    private void buildMenus() {
    }

    public void okPressed() {
        this._canceled = false;
        if (this.isModified()) {
            this.saveForm();
            this.setModified(false);
        }
        this.setVisible(false);
    }

    public void applyPressed() {
        this._canceled = false;
        if (this.isModified()) {
            this.saveForm();
            this.setModified(false);
        }
        this.fillForm(this._selection);
    }

    public void cancelPressed() {
        this._canceled = true;
        this.setVisible(false);
    }

    public static void runStaticTest() {
        Frame frame = new Frame();
        frame.setLocation(50, 50);
        InundationGroupEditor editor = new InundationGroupEditor(frame, true);
        editor.fillForm(null);
        editor.pack();
        editor.setVisible(true);
    }

    @Override
    public void fillForm(Object obj) {
        if (!(obj instanceof InundationGroupSelection)) {
            return;
        }
        this._selection = (InundationGroupSelection)obj;
        this._inundationGroupPanel.fillPanel(this._selection);
    }

    @Override
    protected void windowClosing() {
        this.checkSave();
    }

    public boolean checkSave() {
        int opt;
        if (this.isModified() && this.isVisible() && (opt = JOptionPane.showConfirmDialog(this, "Data has changed. Save Changes?", "Confirm Changes", 0)) == 0) {
            this.saveForm();
            return true;
        }
        return false;
    }

    public void saveForm() {
        boolean saved = this._inundationGroupPanel.savePanel();
        if (!saved) {
            return;
        }
        this.setModified(false);
    }
}

