/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.map.JLayerSelection;
import hec.map.JLayerSelectionParent;
import hec.map.JLayerSelectorTreePanel;
import hec.map.LayerSelectionFactory;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.inundation.InundationGroup;
import hec.map.inundation.InundationGroupGlyph;
import hec.map.inundation.InundationGroupRenderingDialog;
import hec.map.inundation.InundationLayer;
import hec.map.inundation.InundationParameter;
import java.awt.Frame;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class InundationGroupSelection
extends JLayerSelection
implements JLayerSelectionParent {
    HashMap _layerSelectionMap = new HashMap();
    InundationGroupRenderingDialog _dialog = null;

    public InundationGroupSelection(JLayerSelectionParent parent, JFrame parentFrame, MapPanel mapPanel, MapGlyph glyph) {
        super(parent, parentFrame, mapPanel, glyph);
        this.addOptionsPopupMenu();
        this.buildLayerSelectionMap();
        this.refresh();
    }

    @Override
    protected boolean allowScaleAdjustment() {
        return true;
    }

    private void buildLayerSelectionMap() {
        InundationGroup ig = (InundationGroup)((InundationGroupGlyph)this._glyph).getMap();
        for (int ii = 0; ii < ig.getNumberOfParameters(); ++ii) {
            InundationParameter ip = ig.getInundationParameter(ii);
            for (int jj = 0; jj < ig.getNumberOfExceedenceProbabilities(); ++jj) {
                InundationLayer il = ip.get(jj);
                MapGlyph glyph = ((InundationGroupGlyph)this._glyph).getLayerGlyph(il);
                JLayerSelection jls = (JLayerSelection)LayerSelectionFactory.buildSelection(this, this._parentFrame, this._mapPanel, glyph);
                this._layerSelectionMap.put(il, jls);
            }
        }
    }

    public JLayerSelection getLayerSelection(InundationLayer il) {
        JLayerSelection jls = (JLayerSelection)this._layerSelectionMap.get(il);
        return jls;
    }

    @Override
    public boolean hasOptionDialog() {
        return true;
    }

    @Override
    public void showOptionDialog() {
        if (!(this._glyph instanceof InundationGroupGlyph)) {
            return;
        }
        if (this._dialog == null) {
            this._dialog = new InundationGroupRenderingDialog((Frame)this._parentFrame, false, this._mapPanel);
        }
        this._dialog.fillForm(this);
        this._dialog.setVisible(true);
        this.refresh();
    }

    @Override
    public void closeOptionDialog() {
        if (this._dialog != null) {
            this._dialog.setVisible(false);
        }
    }

    @Override
    public void moveCurrentLayerUp() {
    }

    @Override
    public void moveCurrentLayerDown() {
    }

    @Override
    public void moveCurrentLayerTop() {
    }

    @Override
    public void moveCurrentLayerBottom() {
    }

    @Override
    public void setCurrentLayer(JLayerSelection jls) {
    }

    @Override
    public void setModifiedLayerSelection(JLayerSelection jls) {
        if (this._dialog != null) {
            this._dialog.setModified(true);
        }
    }

    @Override
    public void update(Object o) {
        System.out.println("InundationGroupSelection:update(): " + o);
    }

    @Override
    public void repaint() {
    }

    @Override
    public void nodeChanged(JLayerSelection jls) {
    }

    @Override
    public void setLegendVisible(DefaultMutableTreeNode node, boolean show) {
    }

    @Override
    public void expand() {
    }

    @Override
    public void collapse() {
    }

    @Override
    public boolean isExpanded(DefaultMutableTreeNode node) {
        return false;
    }

    @Override
    public boolean isConfigurationLocked() {
        return this._parent.isConfigurationLocked();
    }

    @Override
    public boolean isFirstNode(JLayerSelection layerSelection) {
        return false;
    }

    @Override
    public boolean isLastNode(JLayerSelection layerSelection) {
        return false;
    }

    @Override
    public JLayerSelectorTreePanel.JLayerSelectionNode getSelectionNodeFor(JLayerSelection selection) {
        System.out.println("JLayerSelectionParent.getSelectionNodeFor TODO implement me");
        return null;
    }

    @Override
    public void nodeChanged(DefaultMutableTreeNode node) {
        System.out.println("JLayerSelectionParent.nodeChanged TODO implement me");
    }
}

