/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.map.ElevationMap;
import hec.map.MapObject;
import hec.map.MapObjectFactory;
import hec.map.WorldRect;
import java.lang.reflect.Field;

public class InundationLayer
extends NamedType
implements Cloneable {
    double _exceedenceProbability;
    String _mapUrl = "";
    String _mapClassName;
    transient MapObject _mapObject;

    public InundationLayer(double exceedenceProbability) {
        this._exceedenceProbability = exceedenceProbability;
    }

    public InundationLayer() {
    }

    @Override
    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return clone;
    }

    public MapObject getMapObject(FileOpener fileOpener) {
        if (this._mapObject == null) {
            Identifier mapId = new Identifier(this._mapUrl);
            Identifier fileId = null;
            if (AppDaddy.getWorkspace() != null) {
                fileId = AppDaddy.getWorkspace().openFile(mapId, true);
            } else {
                try {
                    fileId = fileOpener.openFile(mapId, false);
                }
                catch (Exception e) {
                    System.out.println("Error opening Inundation Layer Map file. " + e);
                }
            }
            if (fileId == null) {
                return null;
            }
            this._mapObject = MapObjectFactory.newMapObject(fileOpener, fileId);
        }
        return this._mapObject;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InundationLayer)) {
            return super.equals(o);
        }
        InundationLayer il = (InundationLayer)o;
        return il._exceedenceProbability == this._exceedenceProbability && il._mapUrl.equals(this._mapUrl);
    }

    public int hashCode() {
        int hashCode = this._mapUrl.hashCode();
        if (this._mapUrl.length() > 0) {
            boolean bl = false;
        }
        Double D = new Double(this._exceedenceProbability);
        hashCode = 31 * hashCode + D.hashCode();
        return hashCode;
    }

    public String getMapClassName() {
        return this._mapClassName;
    }

    public static String findMapClassNameForUrl(String url) {
        Class mapClass;
        if (url == null) {
            url = "";
        }
        String mapClassName = null;
        if (url.length() > 0 && (mapClass = MapObjectFactory.getClassForUrl(url)) != null) {
            mapClassName = mapClass.getName();
        }
        return mapClassName;
    }

    public boolean setMapUrl(String url) {
        if (url == null) {
            url = "";
        }
        this._mapClassName = null;
        if (url.length() > 0) {
            Class mapClass = MapObjectFactory.getClassForUrl(url);
            if (!ElevationMap.class.isAssignableFrom(mapClass)) {
                this._mapUrl = "";
                return false;
            }
            this._mapClassName = mapClass.getName();
        }
        this._mapUrl = url;
        return true;
    }

    public double getExceedenceProbability() {
        return this._exceedenceProbability;
    }

    public String getMapUrl() {
        return this._mapUrl;
    }

    @Override
    public String toString() {
        return this._mapUrl;
    }

    public void load() {
    }

    public void unload() {
    }

    public void growExtents(WorldRect extents) {
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

