/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.lang.NamedType;
import hec.map.WorldRect;
import hec.map.inundation.InundationLayer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;

public class InundationParameter
extends NamedType {
    String _mapClassName;
    List _inundationLayers = new Vector();
    transient boolean _needToSort = false;

    public InundationParameter() {
    }

    public InundationParameter(String parameter) {
        super(parameter);
    }

    public String getMapClassName() {
        return this._mapClassName;
    }

    public void addExceedenceProbability(int idx, Double D) {
        InundationLayer il = new InundationLayer(D);
        this._inundationLayers.add(idx, il);
    }

    public void addExceedenceProbability(Double D) {
        InundationLayer il = new InundationLayer(D);
        this._inundationLayers.add(il);
    }

    public void removeExceedenceProbability(Double D) {
        for (int ii = 0; ii < this._inundationLayers.size(); ++ii) {
            InundationLayer il = (InundationLayer)this._inundationLayers.get(ii);
            if (il.getExceedenceProbability() != D.doubleValue()) continue;
            this._inundationLayers.remove(il);
        }
    }

    public void addInundationLayer(InundationLayer il) {
        this._inundationLayers.add(il);
        this._needToSort = true;
    }

    public int size() {
        if (this._inundationLayers == null) {
            return -1;
        }
        return this._inundationLayers.size();
    }

    public InundationLayer get(int index) {
        if (this._inundationLayers == null) {
            return null;
        }
        if (this._needToSort) {
            this.sort();
        }
        return (InundationLayer)this._inundationLayers.get(index);
    }

    public void validate(String mapUrl) throws Exception {
        String mapClassName = InundationLayer.findMapClassNameForUrl(mapUrl);
        if (mapClassName == null) {
            throw new RuntimeException("Inundation Layer is not an Elevation Map.");
        }
        if (this._mapClassName == null) {
            return;
        }
        if (!this._mapClassName.equals(mapClassName)) {
            throw new RuntimeException("Inundation Layer types must all be the same for a given Parameter.");
        }
    }

    public void sort() {
        this._needToSort = false;
    }

    public void growExtents(WorldRect extents) {
        for (int ii = 0; ii < this._inundationLayers.size(); ++ii) {
            InundationLayer il = (InundationLayer)this._inundationLayers.get(ii);
            il.growExtents(extents);
        }
    }

    public void load() {
        for (int ii = 0; ii < this._inundationLayers.size(); ++ii) {
            InundationLayer il = (InundationLayer)this._inundationLayers.get(ii);
            il.load();
        }
    }

    public void unload() {
        for (int ii = 0; ii < this._inundationLayers.size(); ++ii) {
            InundationLayer il = (InundationLayer)this._inundationLayers.get(ii);
            il.unload();
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

