/*
 * Decompiled with CFR 0.152.
 */
package hec.map.inundation;

import hec.appInterface.AppDaddy;
import hec.appInterface.Workspace;
import hec.map.GlyphDataRecord;
import hec.map.JLayerSelection;
import hec.map.MapGlyph;
import hec.map.MapObject;
import hec.map.inundation.InundationGroup;
import hec.map.inundation.InundationGroupGlyph;
import hec.map.inundation.InundationGroupGlyphDataRecord;
import hec.map.inundation.InundationGroupSelection;
import hec.map.inundation.InundationGroupTableModel;
import hec.map.inundation.InundationLayer;
import hec.map.inundation.InundationParameter;
import java.awt.Component;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJTable;
import rma.swing.table.RmaCellEditor;
import rma.util.RMAIO;

public class RenderingInundationGroupTableModel
extends InundationGroupTableModel
implements Observer {
    RmaJCheckBox _checkBox;
    RmaCellEditor _editor;
    InundationGroupGlyph _glyph;
    InundationGroupSelection _selection;
    HashMap _map2ilHash = new HashMap();

    public RenderingInundationGroupTableModel(RmaJTable table, InundationGroupSelection selection) {
        super(table, selection);
    }

    @Override
    public void saveData() {
        InundationGroupGlyphDataRecord dataRecord = (InundationGroupGlyphDataRecord)this._selection.getDataRecord();
        dataRecord.setModified(true);
        dataRecord.notifyObservers(this._selection);
        System.out.println("saveData(): " + dataRecord);
    }

    public void showPropertiesDialog(int colidx, int rowidx) {
        if (colidx < 0 || rowidx < 0 || colidx >= this.getColumnCount() || rowidx >= this.getRowCount()) {
            return;
        }
        if (colidx == 0) {
            colidx = 1;
        }
        InundationParameter ip = this._currentGroup.getInundationParameter(colidx - 1);
        InundationLayer il = ip.get(rowidx);
        InundationGroupGlyphDataRecord dataRecord = (InundationGroupGlyphDataRecord)this._selection.getDataRecord();
        GlyphDataRecord gdr = dataRecord.getDataRecord(il, null);
        if (gdr == null) {
            return;
        }
        gdr.deleteObserver(this);
        gdr.addObserver(this);
        MapGlyph glyph = this._glyph.getLayerGlyph(il);
        Workspace fileOpener = AppDaddy.getWorkspace();
        MapObject mo = il.getMapObject(fileOpener);
        glyph.setMap(mo);
        this._map2ilHash.put(mo, il);
        glyph.setDataRecord(gdr);
        JLayerSelection jls = this._selection.getLayerSelection(il);
        jls.setGlyph(glyph);
        jls.showOptionDialog();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof GlyphDataRecord && arg instanceof JLayerSelection) {
            GlyphDataRecord gdr = (GlyphDataRecord)o;
            JLayerSelection jls = (JLayerSelection)arg;
            jls.updateGlyph();
            MapGlyph glyph = jls.getGlyph();
            MapObject mo = (MapObject)glyph.getMap();
            InundationLayer il = (InundationLayer)this._map2ilHash.get(mo);
            InundationGroupGlyphDataRecord dataRecord = (InundationGroupGlyphDataRecord)this._selection.getDataRecord();
            dataRecord.setDataRecord(il, gdr);
        }
    }

    @Override
    public void setData(Object obj) {
        this._selection = (InundationGroupSelection)obj;
        this._glyph = (InundationGroupGlyph)this._selection.getGlyph();
        InundationGroup ig = (InundationGroup)this._glyph.getMap();
        this.setInundationGroup(ig);
        InundationGroupGlyphDataRecord dataRecord = (InundationGroupGlyphDataRecord)this._selection.getDataRecord();
        System.out.println("setData(): " + dataRecord);
    }

    @Override
    protected void initializeComponents() {
        this._table.setColumnEnabled(false, 0);
        this._table.setHorizontalAlignment(2, 0);
        this._table.setBackground(SwingUtilities.windowForComponent(this._table).getBackground());
        InundationLayerCheckBox component = new InundationLayerCheckBox();
        for (int ii = 0; ii < this._currentGroup.getNumberOfParameters(); ++ii) {
            this._table.getColumnModel().getColumn(ii + 1).setCellRenderer(component);
            this._table.getColumnModel().getColumn(ii + 1).setCellEditor(component);
        }
        this._table.getColumnModel().setColumnMargin(10);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = super.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            InundationParameter ip = this._currentGroup.getInundationParameter(columnIndex - 1);
            return ip.get(rowIndex);
        }
        return obj;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return;
        }
        InundationParameter ip = this._currentGroup.getInundationParameter(columnIndex - 1);
        InundationLayer il = ip.get(rowIndex);
        InundationGroupGlyphDataRecord dataRecord = (InundationGroupGlyphDataRecord)this._selection.getDataRecord();
        System.out.println("setValueAt(): " + dataRecord);
        dataRecord.setDrawn(il, (Boolean)aValue);
    }

    private class InundationLayerCheckBox
    extends RmaCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        RmaJCheckBox _rendererComponent;
        RmaJCheckBox _editorComponent;

        public InundationLayerCheckBox() {
            super(new RmaJCheckBox());
            this._editorComponent = (RmaJCheckBox)this.editorComponent;
            this._editorComponent.setHorizontalAlignment(2);
            this.setClickCountToStart(2);
            this._rendererComponent = new RmaJCheckBox();
            this._rendererComponent.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getComponent(this._rendererComponent, value);
        }

        private Component getComponent(RmaJCheckBox component, Object value) {
            InundationLayer il = (InundationLayer)value;
            InundationGroupGlyphDataRecord dataRecord = (InundationGroupGlyphDataRecord)RenderingInundationGroupTableModel.this._selection.getDataRecord();
            Boolean TF = dataRecord.getDrawn(il);
            String mapUrl = il.getMapUrl();
            if (mapUrl == null || mapUrl.trim().length() < 1) {
                component.setSelected(false);
                component.setText("");
                component.setIsEditable(false);
            } else {
                component.setIsEditable(true);
                component.setSelected(TF);
                component.setText(RMAIO.getFileFromPath(mapUrl));
            }
            component.invalidate();
            return component;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getComponent(this._editorComponent, value);
        }
    }
}

