/*
 * Decompiled with CFR 0.152.
 */
package hec.map.legend;

import hec.map.MapCanvas;
import hec.map.legend.LegendRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.plaf.LayerUI;

public class LegendLayerUI
extends LayerUI<MapCanvas> {
    LegendRenderer mLegendRenderer = null;

    public void setLegendModel(LegendRenderer legendRenderer) {
        this.mLegendRenderer = legendRenderer;
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        super.paint(g, c2);
        if (this.mLegendRenderer == null) {
            return;
        }
        JComponent legendComponent = this.mLegendRenderer.getLegendComponent();
        if (legendComponent == null) {
            return;
        }
        int borderWidth = 2;
        int borderBuffer = 2;
        Dimension componentSize = legendComponent.getSize();
        Dimension legendSize = new Dimension(componentSize.width + borderWidth * 2 + borderBuffer * 2, componentSize.height + borderWidth * 2 + borderBuffer * 2);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(10, 10);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, legendSize.width, legendSize.height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, legendSize.width, legendSize.height);
        g2d.drawRect(1, 1, legendSize.width - 2, legendSize.height - 2);
        g2d.drawRect(2, 2, legendSize.width - 4, legendSize.height - 4);
        g2d.translate(borderWidth + borderBuffer, borderWidth + borderBuffer);
        legendComponent.printAll(g2d);
        g2d.dispose();
    }
}

