/*
 * Decompiled with CFR 0.152.
 */
package hec.map.mrsid;

import com.mrsid.LTIGeoCoord;
import com.mrsid.LTIScene;
import com.mrsid.LTISceneBuffer;
import com.mrsid.LTIUtils;
import com.mrsid.MrSidImageReader;
import hec.map.LocalRect;
import hec.map.MapIdentifier;
import hec.map.MapScale;
import hec.map.WorldRect;
import hec.map.image.ImageMap;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MrSidMap
extends ImageMap {
    MrSidImageReader mReader;

    public MrSidMap() {
        this.init();
    }

    public MrSidMap(MapIdentifier mid) {
        super(mid);
        this.init();
    }

    @Override
    public void setMapIdentifier(MapIdentifier id) {
        super.setMapIdentifier(id);
        this.init();
    }

    private void init() {
        String path;
        if (this._mapId != null && (path = this._mapId.getPath()) != null && path.endsWith(".sid")) {
            this._URLstring = path;
        }
    }

    @Override
    public void load() throws IOException {
        super.load(false);
        if (this.mReader == null) {
            this.mReader = new MrSidImageReader();
        }
        if (!this.mReader.loaded()) {
            try {
                String path = this.getImageID().getPath();
                this.mReader.openFile(path);
                LTIGeoCoord coord = this.mReader.getGeoCoord();
                double n = coord.getY();
                double w = coord.getX();
                double e = coord.getXRes() * (double)this.mReader.getWidth() + w;
                double s = n - Math.abs(coord.getYRes() * (double)this.mReader.getHeight());
                this.setExtent(new WorldRect(w, n, e, s));
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    @Override
    public void unload() {
        if (this.mReader != null) {
            this.mReader.closeFile();
        }
        super.unload();
    }

    public synchronized Image getImage(MapScale scale) {
        LocalRect mapBounds = scale.getViewRect();
        WorldRect worldImgExtents = this.getExtent();
        LocalRect localImgExtents = scale.wr2lr(worldImgExtents);
        double sceneX = localImgExtents.l < 0 ? (double)Math.abs(localImgExtents.l) : 0.0;
        double sceneY = localImgExtents.t < 0 ? (double)Math.abs(localImgExtents.t) : 0.0;
        LTISceneBuffer buffer = new LTISceneBuffer();
        Rectangle sceneRect = new Rectangle();
        sceneRect.x = (int)sceneX;
        sceneRect.y = (int)sceneY;
        int IMG_WIDTH = this.mReader.getWidth();
        int IMG_HEIGHT = this.mReader.getHeight();
        double mag = (double)localImgExtents.width() / (double)IMG_WIDTH;
        int level = LTIUtils.magToLevel((double)mag);
        double maxMag = this.mReader.getMaxMagnification();
        double minMag = this.mReader.getMinMagnification();
        if ((mag = LTIUtils.levelToMag((int)(--level))) < minMag) {
            mag = minMag;
        }
        if (mag > maxMag) {
            mag = maxMag;
        }
        Dimension d = null;
        try {
            d = this.mReader.getDimsAtMag(mag);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sceneRect.width = d.width;
        sceneRect.height = d.height;
        if (sceneRect.width > mapBounds.width()) {
            sceneRect.width = mapBounds.width();
        }
        if (sceneRect.height > mapBounds.height()) {
            sceneRect.height = mapBounds.height();
        }
        sceneRect.x = (int)((double)sceneRect.x * ((double)IMG_WIDTH * mag / (double)localImgExtents.width()));
        sceneRect.y = (int)((double)sceneRect.y * ((double)IMG_HEIGHT * mag / (double)localImgExtents.height()));
        sceneRect.width = (int)((double)sceneRect.width * ((double)IMG_WIDTH * mag / (double)localImgExtents.width()));
        sceneRect.height = (int)((double)sceneRect.height * ((double)IMG_HEIGHT * mag / (double)localImgExtents.height()));
        if ((double)(sceneRect.width + sceneRect.x) > (double)IMG_WIDTH * mag) {
            sceneRect.width = (int)((double)IMG_WIDTH * mag - (double)sceneRect.x);
            if (sceneRect.width < 0) {
                sceneRect.width = 0;
            }
        }
        if ((double)(sceneRect.height + sceneRect.y) > (double)IMG_HEIGHT * mag) {
            sceneRect.height = (int)((double)IMG_HEIGHT * mag - (double)sceneRect.y);
            if (sceneRect.height < 0) {
                sceneRect.height = 0;
            }
        }
        if (sceneRect.x < 0 || sceneRect.y < 0 || sceneRect.width <= 0 || sceneRect.height <= 0) {
            return null;
        }
        LTIScene scene = new LTIScene((double)sceneRect.x, (double)sceneRect.y, (double)sceneRect.width, (double)sceneRect.height, mag);
        long t0 = System.currentTimeMillis();
        this.mReader.read(scene, buffer);
        long t1 = System.currentTimeMillis();
        System.out.println("Time to load the scene " + (t1 - t0) + " miliseconds.");
        int iWIDTH = buffer.getTotalNumColumns();
        int iHEIGHT = buffer.getTotalNumRows();
        BufferedImage IMAGE = new BufferedImage(iWIDTH, iHEIGHT, 1);
        WritableRaster raster = IMAGE.getRaster();
        int size = buffer.size();
        int NUM_BANKS = 3;
        byte[][] data = new byte[NUM_BANKS][0];
        data[0] = buffer.getBand1();
        data[1] = buffer.getBand2();
        data[2] = buffer.getBand3();
        t1 = System.currentTimeMillis();
        int[] color = new int[3];
        for (int i = 0; i < size; ++i) {
            color[0] = data[0][i];
            color[1] = data[1][i];
            color[2] = data[2][i];
            raster.setPixel(i % iWIDTH, i / iWIDTH, color);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Time to copy pixel array of size (" + size + ") took " + (t2 - t1) + " miliseconds.");
        return IMAGE;
    }
}

