/*
 * Decompiled with CFR 0.152.
 */
package hec.map.mrsid;

import hec.map.LocalRect;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.image.DragPoint;
import hec.map.image.ImageGlyph;
import hec.map.image.ImageGlyphDataRecord;
import hec.map.mrsid.MrSidMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public class MrSidMapGlyph
extends ImageGlyph {
    WorldRect oldWorldRect = null;
    WorldRect _imageWorldExtents = null;
    Object _semaphore = new Object();
    Thread t = null;
    Point2D[] tempPoints = null;
    Point2D.Double TEST_PT0 = new Point2D.Double();
    Point2D.Double TEST_PT1 = new Point2D.Double();

    public MrSidMapGlyph(MapPanel panel, MrSidMap map) {
        super(panel, map);
    }

    @Override
    protected void scaleTransform(AffineTransform af, MapScale scl) {
    }

    @Override
    public void setShown(boolean shown) {
        if (shown) {
            this.oldWorldRect = null;
        }
        super.setShown(shown);
        if (this._mapIdentifier == null) {
            return;
        }
        MapIdentifier id = this.getMap().getMapIdentifier();
        if (id == null) {
            return;
        }
        id.setMapShown(shown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics, MapScale scl) {
        if (!_paintOk) {
            return;
        }
        ImageGlyphDataRecord data = this.getImageGlyphDataRecord();
        MrSidMap map = (MrSidMap)this.getMap();
        if (this._image == null) {
            try {
                map.load();
            }
            catch (Exception exception) {}
        } else {
            try {
                map.load(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LocalRect mapBounds = scl.getViewRect();
        WorldRect rc = map.getExtent();
        LocalRect lc = scl.wr2lr(rc);
        LocalRect mapLocalBounds = scl.wr2lr(rc);
        WorldRect swr = scl.getWorldRect();
        if (this.oldWorldRect == null || !swr.equals(this.oldWorldRect)) {
            ImageLoaderThread il = new ImageLoaderThread(map, scl);
            il.run();
            this.oldWorldRect = swr;
        }
        if (!swr.intersects(this._map.getExtent())) {
            return;
        }
        if (!_paintOk) {
            return;
        }
        WorldRect extents = map.getExtent();
        Object object = this._semaphore;
        synchronized (object) {
            if (this._image == null) {
                return;
            }
            if (this._imageWorldExtents == null) {
                return;
            }
            LocalRect lr = scl.wr2lr(this._imageWorldExtents);
            int x = lr.l;
            int y = lr.t;
            int width = lr.r - lr.l;
            int height = lr.b - lr.t;
            AffineTransform localRotatedTransform = new AffineTransform();
            float alpha = data.getAlpha();
            AlphaComposite ac = null;
            AffineTransform t = ((Graphics2D)graphics).getTransform();
            localRotatedTransform.rotate(((MrSidMap)this._map).getRotation(), lr.l + lr.width() / 2, lr.t + lr.height() / 2);
            if (!data.getDrawImageOutline()) {
                if (alpha < 0.0f || alpha > 1.0f) {
                    alpha = 1.0f;
                }
                ac = AlphaComposite.getInstance(3, alpha);
                ((Graphics2D)graphics).setComposite(ac);
                ((Graphics2D)graphics).setTransform(localRotatedTransform);
                graphics.drawImage(this._image, x, y, width, height, this._mapPanel);
            } else {
                ((Graphics2D)graphics).setTransform(localRotatedTransform);
                this.drawBorder((Graphics2D)graphics, lc);
                this.drawFileName(graphics, lc);
            }
            if (this._adjustmentEnabled) {
                this.drawDragPoints((Graphics2D)graphics, lc);
            }
            ((Graphics2D)graphics).setTransform(t);
        }
    }

    @Override
    public void adjustImage(DragPoint dragPoint, Point PT0, Point PT1) {
        MapObjectInterface mapObject = this.getMap();
        WorldRect wr = mapObject.getExtent();
        MapScale scale = this.getMapPanel().scale();
        Graphics2D g2d = null;
        ImageGlyphDataRecord data = this.getImageGlyphDataRecord();
        LocalRect lc = this.getMapPanel().scale().wr2lr(wr);
        AffineTransform localRotatedTransform = new AffineTransform();
        localRotatedTransform.rotate(((MrSidMap)this._map).getRotation(), lc.l + lc.width() / 2, lc.t + lc.height() / 2);
        if (this.tempPoints == null) {
            this.tempPoints = new Point2D[4];
            for (int i = 0; i < this.tempPoints.length; ++i) {
                this.tempPoints[i] = new Point2D.Double();
            }
        }
        if (!data.getShowImageWhileDragging()) {
            g2d = (Graphics2D)this.getMapPanel().viewport().getGraphics().create();
            g2d.setXORMode(new Color(255, 255, 255));
            g2d.setTransform(localRotatedTransform);
            this.drawDragPoints(g2d, lc);
        }
        this.TEST_PT0.x = PT0.x;
        this.TEST_PT0.y = PT0.y;
        this.TEST_PT1.x = PT1.x;
        this.TEST_PT1.y = PT1.y;
        double diffX = 0.0;
        double diffY = 0.0;
        if (dragPoint.getPosition() != 5) {
            // empty if block
        }
        diffX = scale.x2e((int)this.TEST_PT1.x) - scale.x2e((int)this.TEST_PT0.x);
        diffY = scale.y2n((int)this.TEST_PT1.y) - scale.y2n((int)this.TEST_PT0.y);
        double rotation = ((MrSidMap)this._map).getRotation();
        double cosRot = Math.cos(rotation);
        double sinRot = Math.sin(rotation);
        double de = diffX;
        double dn = diffY;
        if (dragPoint.getPosition() == 5) {
            wr.e += diffX;
            wr.w += diffX;
            wr.n += diffY;
            wr.s += diffY;
            this._imageWorldExtents.e += diffX;
            this._imageWorldExtents.w += diffX;
            this._imageWorldExtents.n += diffY;
            this._imageWorldExtents.s += diffY;
        } else if (dragPoint.getPosition() == 4) {
            diffX = de * cosRot - dn * sinRot;
            wr.e += diffX;
            this._imageWorldExtents.e += diffX;
            double dxCen = -diffX / 2.0 * (1.0 - cosRot);
            double dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 3) {
            diffX = de * cosRot - dn * sinRot;
            wr.w += diffX;
            this._imageWorldExtents.w += diffX;
            double dxCen = -diffX / 2.0 * (1.0 - cosRot);
            double dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 2) {
            diffY = de * sinRot + dn * cosRot;
            wr.n += diffY;
            this._imageWorldExtents.n += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 8) {
            diffY = de * sinRot + dn * cosRot;
            wr.s += diffY;
            this._imageWorldExtents.s += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 0) {
            diffY = de * sinRot + dn * cosRot;
            wr.n += diffY;
            this._imageWorldExtents.n += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
            diffX = de * cosRot - dn * sinRot;
            wr.w += diffX;
            this._imageWorldExtents.w += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 1) {
            diffY = de * sinRot + dn * cosRot;
            wr.n += diffY;
            this._imageWorldExtents.n += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
            diffX = de * cosRot - dn * sinRot;
            wr.e += diffX;
            this._imageWorldExtents.e += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 6) {
            diffY = de * sinRot + dn * cosRot;
            wr.s += diffY;
            this._imageWorldExtents.s += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
            diffX = de * cosRot - dn * sinRot;
            wr.w += diffX;
            this._imageWorldExtents.w += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 7) {
            diffY = de * sinRot + dn * cosRot;
            wr.s += diffY;
            this._imageWorldExtents.s += diffY;
            double dyCen = -diffY / 2.0 * (1.0 - cosRot);
            double dxCen = diffY / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
            diffX = de * cosRot - dn * sinRot;
            wr.e += diffX;
            this._imageWorldExtents.e += diffX;
            dxCen = -diffX / 2.0 * (1.0 - cosRot);
            dyCen = -diffX / 2.0 * sinRot;
            wr.s += dyCen;
            wr.n += dyCen;
            wr.e += dxCen;
            wr.w += dxCen;
            this._imageWorldExtents.e += dxCen;
            this._imageWorldExtents.w += dxCen;
            this._imageWorldExtents.n += dyCen;
            this._imageWorldExtents.s += dyCen;
        } else if (dragPoint.getPosition() == 9) {
            WorldPt cPT1 = new WorldPt(wr.w + (wr.e - wr.w) / 2.0, wr.s + (wr.n - wr.s) / 2.0);
            Point cPT = new Point(scale.e2x(cPT1.e), scale.n2y(cPT1.n));
            double dx0 = cPT.x - PT0.x;
            double dy0 = cPT.y - PT0.y;
            double dx1 = cPT.x - PT1.x;
            double dy1 = cPT.y - PT1.y;
            rotation = Math.atan2(dx0, dy0) - Math.atan2(dx1, dy1);
            ((MrSidMap)this._map).setRotation(rotation);
        }
        if (!data.getShowImageWhileDragging()) {
            this.drawDragPoints(g2d, this.getMapPanel().scale().wr2lr(wr));
            g2d.setPaintMode();
        } else {
            this.getMapPanel().paintMap();
        }
        if (g2d != null) {
            g2d.dispose();
        }
    }

    private class ImageLoaderThread {
        MrSidMap _mrSidMap = null;
        MapScale _scale = null;

        public ImageLoaderThread(MrSidMap map, MapScale scale) {
            this._mrSidMap = map;
            this._scale = new MapScale(scale);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int y;
            if (this._mrSidMap == null) {
                return;
            }
            BufferedImage img = (BufferedImage)this._mrSidMap.getImage(this._scale);
            WorldRect extents = this._mrSidMap.getExtent();
            LocalRect lr = this._scale.wr2lr(extents);
            int x = lr.l;
            if (x < 0) {
                x = 0;
            }
            if ((y = lr.t) < 0) {
                y = 0;
            }
            LocalRect mapBounds = this._scale.getViewRect();
            double width = Math.abs(lr.r - x);
            double height = Math.abs(y - lr.b);
            if (width > (double)mapBounds.width()) {
                width = mapBounds.width();
            }
            if (height > (double)mapBounds.height()) {
                height = mapBounds.height();
            }
            lr.r = x + (int)width;
            lr.b = y + (int)height;
            lr.t = y;
            lr.l = x;
            Object object = MrSidMapGlyph.this._semaphore;
            synchronized (object) {
                MrSidMapGlyph.this._imageWorldExtents = this._scale.lr2wr(lr);
                MrSidMapGlyph.this._image = img;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MrSidMapGlyph.this.getMapPanel().paintMap();
                }
            });
        }
    }
}

