/*
 * Decompiled with CFR 0.152.
 */
package hec.map.nettin;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.nettin.NetTinGlyph;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.List;
import rma.util.RMAIO;

public class NetTinAdapter
extends MapMouseAdapter {
    boolean _zoomIn = false;
    boolean _drawDragRect = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalRect _dragRect = new LocalRect();
    LocalRect _oldDragRect = new LocalRect();
    boolean _drawingRegion = false;
    LocalRegion _region = new LocalRegion();
    NetTinGlyph _tinglyph = null;

    public NetTinAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
        List gvec = this._mapPanel.glyphList();
        for (int i = 0; i < gvec.size(); ++i) {
            MapGlyph g = (MapGlyph)gvec.get(i);
            if (g == null || !(g instanceof NetTinGlyph)) continue;
            this._tinglyph = (NetTinGlyph)g;
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (NetTinAdapter.pressedButton1(e) && !this._drawingRegion) {
            for (int i = 0; i < this._mapPanel.glyphList().size(); ++i) {
                float depth;
                MapGlyph glyph = (MapGlyph)this._mapPanel.glyphList().get(i);
                if (glyph == null || !(glyph instanceof NetTinGlyph) || !glyph.isShown() || (depth = ((NetTinGlyph)glyph).getElevationAt(e.getX(), e.getY())) == Float.NEGATIVE_INFINITY) continue;
                String str = RMAIO.toString(depth);
                int ii = str.indexOf(".");
                if (ii >= 0 && str.length() > ii + 3) {
                    str = str.substring(0, ii + 2);
                }
                Graphics gfx = this._mapCanvas.getGraphics();
                gfx.setColor(Color.black);
                gfx.setPaintMode();
                gfx.setFont(new Font("SansSerif", 0, 14));
                gfx.drawString(str, e.getX(), e.getY());
                gfx.setPaintMode();
                break;
            }
        } else if (NetTinAdapter.pressedButton1(e) && this._drawingRegion) {
            Graphics gfx = this._mapCanvas.getGraphics();
            gfx.setColor(Color.black);
            gfx.setXORMode(Color.white);
            gfx.drawLine(this._endPt.x, this._endPt.y, this._beginPt.x, this._beginPt.y);
            for (int i = 0; i < this._mapPanel.glyphList().size(); ++i) {
                MapGlyph glyph = (MapGlyph)this._mapPanel.glyphList().get(i);
                if (glyph == null || !(glyph instanceof NetTinGlyph) || !glyph.isShown()) continue;
                ((NetTinGlyph)glyph).drawElevationStats(gfx, this._region);
            }
            gfx.setPaintMode();
            this._drawingRegion = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._beginPt.init(e.getX(), e.getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (NetTinAdapter.pressedButton1(e) && (Math.abs(this._endPt.x - e.getX()) > 2 || Math.abs(this._endPt.y - e.getY()) > 2)) {
            Graphics gfx = this._mapCanvas.getGraphics();
            gfx.setColor(Color.black);
            gfx.setXORMode(Color.white);
            if (!this._drawingRegion) {
                this._drawingRegion = true;
                this._region.pts.removeAllElements();
                this._region.pts.addElement(new LocalPt(this._beginPt));
                this._endPt.init(this._beginPt);
            }
            gfx.drawLine(this._endPt.x, this._endPt.y, e.getX(), e.getY());
            this._endPt.init(e.getX(), e.getY());
            this._region.pts.addElement(new LocalPt(this._endPt));
        }
    }
}

