/*
 * Decompiled with CFR 0.152.
 */
package hec.map.nettin;

import hec.map.ElevationGlyph;
import hec.map.GlyphDataRecord;
import hec.map.LocalPt;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.nettin.EdgeContainer;
import hec.map.nettin.NetTinGlyphDataRec;
import hec.map.nettin.NetTinMap;
import hec.map.nettin.NodeContainer;
import hec.map.nettin.TriangleContainer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import rma.util.AspectShadingColorContour;
import rma.util.ColorContour;
import rma.util.RMAIO;

public class NetTinGlyph
extends MapGlyph
implements ElevationGlyph {
    public static final int contourNONE = 0;
    public static final int contourELEV = 1;
    public static final int contourDEPTH = 2;
    public static final int contourINUNDATION = 3;
    public static final int contourEDGE_ELEVATION = 4;
    protected WorldRect _curWR = null;
    protected double _curZoom = Double.NEGATIVE_INFINITY;
    transient float[] _lafc = null;
    transient double _aspectAngle = Double.NEGATIVE_INFINITY;
    transient boolean _aspectEnabled = true;
    int[] lx = new int[10];
    int[] ly = new int[10];
    int[] idx = new int[4];

    public NetTinGlyph() {
    }

    public NetTinGlyph(MapPanel panel, NetTinMap map) {
        super(panel, map);
        if (this._mapIdentifier.getGlyphDataRecord() == null) {
            this._mapIdentifier.setGlyphDataRecord(new NetTinGlyphDataRec());
        }
    }

    @Override
    public void fillMap(boolean shown) {
        if (!shown) {
            this._curWR = null;
            this._curZoom = Double.NEGATIVE_INFINITY;
        }
        super.fillMap(shown);
    }

    @Override
    public double getMaximumElevation() {
        NetTinMap map = (NetTinMap)this._map;
        NodeContainer nodeC = map.getNodes();
        if (nodeC == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return nodeC.max;
    }

    @Override
    public double getMinimumElevation() {
        NetTinMap map = (NetTinMap)this._map;
        NodeContainer nodeC = map.getNodes();
        if (nodeC == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return nodeC.min;
    }

    protected void scaleNodes(MapScale scl) {
        NetTinMap map = (NetTinMap)this._map;
        NodeContainer nodeC = map.getNodes();
        if (nodeC == null) {
            return;
        }
        WorldPt pt = new WorldPt();
        for (int ii = 0; _paintOk && ii < nodeC.size(); ++ii) {
            if (nodeC.e[ii] == Double.NEGATIVE_INFINITY || nodeC.n[ii] == Double.NEGATIVE_INFINITY) {
                nodeC.x[ii] = Integer.MIN_VALUE;
                nodeC.y[ii] = Integer.MIN_VALUE;
                continue;
            }
            pt.e = nodeC.e[ii];
            pt.n = nodeC.n[ii];
            if (this._curWR.contains(pt)) {
                nodeC.x[ii] = scl.e2x(nodeC.e[ii]);
                nodeC.y[ii] = scl.n2y(nodeC.n[ii]);
                continue;
            }
            nodeC.x[ii] = Integer.MIN_VALUE;
        }
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        NetTinGlyphDataRec data = (NetTinGlyphDataRec)this.getDataRecord();
        if (data == null) {
            data = new NetTinGlyphDataRec();
            this.setDataRecord(data);
        }
        if (!data.getSet()) {
            data.setGlyph(this);
        }
        ColorContour cc = data.getColorContour();
        NetTinMap map = (NetTinMap)this._map;
        NodeContainer nodeC = map.getNodes();
        EdgeContainer edgeC = map.getEdges();
        TriangleContainer triC = map.getTriangles();
        if (nodeC == null || edgeC == null || triC == null) {
            return;
        }
        int ii = 1;
        if (this._curWR != null) {
            if (!this._curWR.equals(scl.getWorldRect()) || scl.getZoom() != this._curZoom) {
                this._curWR = scl.getWorldRect();
                this._curZoom = scl.getZoom();
                this.scaleNodes(scl);
            }
        } else {
            this._curWR = scl.getWorldRect();
            this._curZoom = scl.getZoom();
            this.scaleNodes(scl);
        }
        if (_paintOk && data.getDrawEdges()) {
            for (ii = 0; _paintOk && ii < edgeC.size(); ++ii) {
                Color color;
                float val;
                int nA = edgeC.intNodeIdA[ii];
                int nB = edgeC.intNodeIdB[ii];
                if (nA == Integer.MIN_VALUE) continue;
                if (nodeC.x[nA] != Integer.MIN_VALUE && nodeC.x[nB] != Integer.MIN_VALUE) {
                    val = (nodeC.z[nA] + nodeC.z[nB]) / 2.0f;
                    color = cc.getColor(val);
                    g.setColor(color);
                    g.drawLine(nodeC.x[nA], nodeC.y[nA], nodeC.x[nB], nodeC.y[nB]);
                    continue;
                }
                if (nodeC.x[nA] != Integer.MIN_VALUE) {
                    val = (nodeC.z[nA] + nodeC.z[nB]) / 2.0f;
                    color = cc.getColor(val);
                    g.setColor(color);
                    g.drawLine(nodeC.x[nA], nodeC.y[nA], scl.e2x(nodeC.e[nB]), scl.n2y(nodeC.n[nB]));
                    continue;
                }
                if (nodeC.x[nB] == Integer.MIN_VALUE) continue;
                val = (nodeC.z[nA] + nodeC.z[nB]) / 2.0f;
                color = cc.getColor(val);
                g.setColor(color);
                g.drawLine(scl.e2x(nodeC.e[nA]), scl.n2y(nodeC.n[nA]), nodeC.x[nB], nodeC.y[nB]);
            }
        } else if (_paintOk && cc instanceof AspectShadingColorContour) {
            this.aspectShadeElevation(g, scl, cc);
        } else if (_paintOk) {
            this.contourElevation(g, scl, cc);
        }
    }

    protected void aspectShadeElevation(Graphics g, MapScale scl, ColorContour cc) {
        NetTinGlyphDataRec data = (NetTinGlyphDataRec)this.getDataRecord();
        double[] val = new double[3];
        LocalPt[] lpt = new LocalPt[]{new LocalPt(), new LocalPt(), new LocalPt()};
        NetTinMap map = (NetTinMap)this._map;
        NodeContainer nodeC = map.getNodes();
        EdgeContainer edgeC = map.getEdges();
        TriangleContainer triC = map.getTriangles();
        boolean ii = true;
        double aa = data.getAspectAngle();
        boolean aspectEnabled = data.getAspectEnabled();
        if (this._aspectAngle != aa || this._lafc == null || this._aspectEnabled != aspectEnabled) {
            this.computeShading(aspectEnabled, aa);
        }
        int nmax = triC.size();
        int[] nid = new int[3];
        for (int i = 0; _paintOk && i < triC.size(); ++i) {
            int j;
            if (!triC.getTriangleNodes(i, edgeC, nid) || nodeC.x[nid[0]] == Integer.MIN_VALUE && nodeC.x[nid[1]] == Integer.MIN_VALUE && nodeC.x[nid[2]] == Integer.MIN_VALUE) continue;
            for (j = 0; j < 3; ++j) {
                int in = nid[j];
                if (nodeC.x[in] != Integer.MIN_VALUE) {
                    lpt[j].x = nodeC.x[in];
                    lpt[j].y = nodeC.y[in];
                } else {
                    lpt[j].x = scl.e2x(nodeC.e[in]);
                    lpt[j].y = scl.n2y(nodeC.n[in]);
                }
                val[j] = nodeC.z[in];
            }
            for (j = 0; j < 3; ++j) {
                this.lx[j] = lpt[j].x;
                this.ly[j] = lpt[j].y;
            }
            g.setColor(cc.getColor(val[0], this._lafc[i]));
            if (!(g instanceof Graphics2D)) continue;
            Graphics2D g2 = (Graphics2D)g;
            Composite oldac = g2.getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, data.getAlpha());
            g2.setComposite(ac);
            g.fillPolygon(this.lx, this.ly, 3);
            if (oldac == null) continue;
            g2.setComposite(oldac);
        }
    }

    protected void contourElevation(Graphics g, MapScale scl, ColorContour cc) {
        int i;
        double[] val = new double[3];
        LocalPt[] lpt = new LocalPt[]{new LocalPt(), new LocalPt(), new LocalPt()};
        NetTinMap map = (NetTinMap)this._map;
        NodeContainer nodeC = map.getNodes();
        EdgeContainer edgeC = map.getEdges();
        TriangleContainer triC = map.getTriangles();
        boolean ii = true;
        double max = cc.getMaxValue();
        double min = cc.getMinValue();
        int ncontours = 20;
        NetTinGlyphDataRec data = (NetTinGlyphDataRec)this.getDataRecord();
        double aa = data.getAspectAngle();
        boolean aspectEnabled = data.getAspectEnabled();
        if (this._aspectAngle != aa || this._lafc == null || this._aspectEnabled != aspectEnabled) {
            this.computeShading(aspectEnabled, aa);
        }
        double[] contourVal = new double[ncontours + 1];
        contourVal[0] = min;
        for (i = 1; _paintOk && i <= ncontours; ++i) {
            contourVal[i] = min + (double)i * (max - min) / (double)ncontours;
        }
        int nmax = triC.size();
        int[] nid = new int[3];
        for (i = 0; _paintOk && i < triC.size(); ++i) {
            if (!triC.getTriangleNodes(i, edgeC, nid) || nodeC.x[nid[0]] == Integer.MIN_VALUE && nodeC.x[nid[1]] == Integer.MIN_VALUE && nodeC.x[nid[2]] == Integer.MIN_VALUE) continue;
            for (int j = 0; j < 3; ++j) {
                int in = nid[j];
                if (nodeC.x[in] != Integer.MIN_VALUE) {
                    lpt[j].x = nodeC.x[in];
                    lpt[j].y = nodeC.y[in];
                } else {
                    lpt[j].x = scl.e2x(nodeC.e[in]);
                    lpt[j].y = scl.n2y(nodeC.n[in]);
                }
                val[j] = nodeC.z[in];
            }
            if (lpt[0].x == lpt[1].x && lpt[0].y == lpt[1].y || lpt[0].x == lpt[2].x && lpt[0].y == lpt[2].y || lpt[1].x == lpt[2].x && lpt[1].y == lpt[2].y) {
                g.setColor(cc.getColor((val[0] + val[1] + val[2]) / 3.0, this._lafc[i]));
                g.drawLine(lpt[0].x, lpt[0].y, lpt[1].x, lpt[1].y);
                g.drawLine(lpt[0].x, lpt[0].y, lpt[2].x, lpt[2].y);
                g.drawLine(lpt[2].x, lpt[2].y, lpt[1].x, lpt[1].y);
                continue;
            }
            this.contourTriangle(g, lpt, val, contourVal, ncontours, min, max, cc, this._lafc[i]);
        }
    }

    protected void contourTriangle(Graphics g, LocalPt[] lpt, double[] val, double[] conval, int ncon, double cmin, double cmax, ColorContour cc, double lafc) {
        int i;
        NetTinGlyphDataRec data = (NetTinGlyphDataRec)this.getDataRecord();
        this.idx[0] = 0;
        this.idx[1] = 1;
        this.idx[2] = 2;
        this.idx[3] = 0;
        double min = val[0];
        int imin = 0;
        double max = val[0];
        int imax = 0;
        for (i = 1; i < 3; ++i) {
            if (min > val[i]) {
                min = val[i];
                imin = i;
            }
            if (!(max < val[i])) continue;
            max = val[i];
            imax = i;
        }
        if (max < cmin) {
            return;
        }
        if (min >= cmax) {
            for (i = 0; i < 3; ++i) {
                this.lx[i] = lpt[i].x;
                this.ly[i] = lpt[i].y;
            }
            g.setColor(cc.getColor(cmax, lafc));
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Composite oldac = g2.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, data.getAlpha());
                g2.setComposite(ac);
                g.fillPolygon(this.lx, this.ly, 3);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            }
            return;
        }
        if (imin == imax) {
            int j;
            for (i = 0; i < 3; ++i) {
                this.lx[i] = lpt[i].x;
                this.ly[i] = lpt[i].y;
            }
            for (j = 1; j <= ncon && max > conval[j]; ++j) {
            }
            g.setColor(cc.getColor(conval[j - 1], lafc));
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Composite oldac = g2.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, data.getAlpha());
                g2.setComposite(ac);
                g.fillPolygon(this.lx, this.ly, 3);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            }
            return;
        }
        int ic0 = 0;
        int ic1 = ncon;
        for (i = 0; _paintOk && i < ncon; ++i) {
            if (min > conval[i] && min < conval[i + 1]) {
                ic0 = i;
            }
            if (!(max > conval[i]) || !(max < conval[i + 1])) continue;
            ic1 = i;
        }
        for (i = ic0; _paintOk && i <= ic1; ++i) {
            int icnt = 0;
            for (int j = 0; j < 3; ++j) {
                if (val[j] >= conval[i]) {
                    this.lx[icnt] = lpt[j].x;
                    this.ly[icnt] = lpt[j].y;
                    ++icnt;
                }
                if (!(val[j] > conval[i] && val[this.idx[j + 1]] <= conval[i]) && (!(val[this.idx[j + 1]] > conval[i]) || !(val[j] <= conval[i]))) continue;
                double fac = (conval[i] - val[j]) / (val[this.idx[j + 1]] - val[j]);
                this.lx[icnt] = lpt[j].x + (int)(fac * (double)(lpt[this.idx[j + 1]].x - lpt[j].x));
                this.ly[icnt] = lpt[j].y + (int)(fac * (double)(lpt[this.idx[j + 1]].y - lpt[j].y));
                ++icnt;
            }
            if (icnt <= 2) continue;
            g.setColor(cc.getColor(conval[i], lafc));
            if (!(g instanceof Graphics2D)) continue;
            Graphics2D g2 = (Graphics2D)g;
            Composite oldac = g2.getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, data.getAlpha());
            g2.setComposite(ac);
            g.fillPolygon(this.lx, this.ly, 3);
            if (oldac == null) continue;
            g2.setComposite(oldac);
        }
    }

    protected void computeShading(boolean aspectEnabled, double aspectAngle) {
        double[] val = new double[3];
        LocalPt[] lpt = new LocalPt[]{new LocalPt(), new LocalPt(), new LocalPt()};
        NetTinMap map = (NetTinMap)this._map;
        NodeContainer nodeC = map.getNodes();
        EdgeContainer edgeC = map.getEdges();
        TriangleContainer triC = map.getTriangles();
        boolean ii = true;
        this._aspectAngle = aspectAngle;
        this._aspectEnabled = aspectEnabled;
        double aa = aspectAngle;
        double theta = -Math.PI / 180 * (aa - 90.0);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double sinPhi = 0.5;
        double aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
        cosTheta /= aaMag;
        sinTheta /= aaMag;
        sinPhi /= aaMag;
        double[] vec0 = new double[3];
        double[] vec1 = new double[3];
        double[] cross = new double[3];
        int nmax = triC.size();
        int[] nid = new int[3];
        this._lafc = new float[triC.size()];
        for (int i = 0; _paintOk && i < triC.size(); ++i) {
            if (!triC.getTriangleNodes(i, edgeC, nid)) continue;
            this._lafc[i] = 1.0f;
            if (!aspectEnabled) continue;
            for (int j = 0; j < 3; ++j) {
                val[j] = nodeC.z[nid[j]];
            }
            vec0[0] = nodeC.e[nid[1]] - nodeC.e[nid[0]];
            vec0[1] = nodeC.n[nid[1]] - nodeC.n[nid[0]];
            vec0[2] = (val[1] - val[0]) * 10.0;
            vec1[0] = nodeC.e[nid[2]] - nodeC.e[nid[0]];
            vec1[1] = nodeC.n[nid[2]] - nodeC.n[nid[0]];
            vec1[2] = (val[2] - val[0]) * 10.0;
            cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
            cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
            cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
            double nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
            double dot = 1.0;
            if (nMag != 0.0) {
                dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
            }
            if (cross[2] < 0.0) {
                dot *= -1.0;
            }
            this._lafc[i] = (float)((dot + 1.25) / 2.25);
        }
    }

    @Override
    public double getNoDataValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public float getElevationAt(int ix, int iy) {
        float[] val = new float[3];
        MapScale scl = this._mapPanel.scale();
        WorldPt pt = new WorldPt(scl.x2e(ix), scl.y2n(iy));
        WorldPt[] wpt = new WorldPt[]{new WorldPt(), new WorldPt(), new WorldPt()};
        WorldRegion wreg = new WorldRegion();
        wreg.pts.addElement(wpt[0]);
        wreg.pts.addElement(wpt[1]);
        wreg.pts.addElement(wpt[2]);
        NetTinMap map = (NetTinMap)this._map;
        if (map == null) {
            System.out.println("Error getting tin for depth interpolation");
            return Float.NEGATIVE_INFINITY;
        }
        NodeContainer nodeC = map.getNodes();
        EdgeContainer edgeC = map.getEdges();
        TriangleContainer triC = map.getTriangles();
        if (nodeC == null || edgeC == null || triC == null) {
            return Float.NEGATIVE_INFINITY;
        }
        boolean ii = true;
        int nmax = triC.size();
        int[] nid = new int[3];
        for (int i = 0; i < triC.size(); ++i) {
            if (!triC.getTriangleNodes(i, edgeC, nid) || nodeC.x[nid[0]] == Integer.MIN_VALUE && nodeC.x[nid[1]] == Integer.MIN_VALUE && nodeC.x[nid[2]] == Integer.MIN_VALUE) continue;
            for (int j = 0; j < 3; ++j) {
                int in = nid[j];
                wpt[j].e = nodeC.e[in];
                wpt[j].n = nodeC.n[in];
            }
            if (!wreg.contains(pt)) continue;
            return triC.interpolateDepth(i, pt, edgeC, nodeC);
        }
        return Float.NEGATIVE_INFINITY;
    }

    public void cropToViewPort() {
        NetTinMap map = (NetTinMap)this._map;
        if (map == null) {
            return;
        }
        map.crop(this._mapPanel.scale().getWorldRect());
    }

    @Override
    public void drawElevationStats(Graphics g, LocalRegion region) {
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        float avg = 0.0f;
        float[] val = new float[4];
        MapScale scl = this._mapPanel.scale();
        WorldRegion wreg = new WorldRegion();
        for (int kk = 0; kk < region.pts.size(); ++kk) {
            wreg.pts.addElement(scl.lp2wp((LocalPt)region.pts.elementAt(kk)));
        }
        WorldPt[] wpt = new WorldPt[]{new WorldPt(), new WorldPt(), new WorldPt()};
        NetTinMap map = (NetTinMap)this._map;
        if (map == null) {
            System.out.println("Error getting tin for depth interpolation");
            return;
        }
        NodeContainer nodeC = map.getNodes();
        EdgeContainer edgeC = map.getEdges();
        TriangleContainer triC = map.getTriangles();
        if (nodeC == null || edgeC == null || triC == null) {
            return;
        }
        boolean ii = true;
        int nmax = triC.size();
        int[] nid = new int[3];
        float elmax = Float.MIN_VALUE;
        float elmin = Float.MAX_VALUE;
        float elmean = 0.0f;
        float elarea = 0.0f;
        g.setPaintMode();
        g.setColor(Color.lightGray);
        for (int i = 0; i < triC.size(); ++i) {
            if (!triC.getTriangleNodes(i, edgeC, nid) || nodeC.x[nid[0]] == Integer.MIN_VALUE || nodeC.x[nid[1]] == Integer.MIN_VALUE || nodeC.x[nid[2]] == Integer.MIN_VALUE) continue;
            for (int j = 0; j < 3; ++j) {
                wpt[j].init(nodeC.e[nid[j]], nodeC.n[nid[j]]);
            }
            if (!wreg.contains(wpt[0]) || !wreg.contains(wpt[1]) || !wreg.contains(wpt[2])) continue;
            g.drawLine(nodeC.x[nid[0]], nodeC.y[nid[0]], nodeC.x[nid[1]], nodeC.y[nid[1]]);
            g.drawLine(nodeC.x[nid[1]], nodeC.y[nid[1]], nodeC.x[nid[2]], nodeC.y[nid[2]]);
            g.drawLine(nodeC.x[nid[2]], nodeC.y[nid[2]], nodeC.x[nid[0]], nodeC.y[nid[0]]);
            if (!triC.calcElevStats(i, edgeC, nodeC, val)) continue;
            if (elmax < val[0]) {
                elmax = val[0];
            }
            if (elmin > val[1]) {
                elmin = val[1];
            }
            elmean += val[2] * val[3];
            elarea += val[3];
        }
        if ((double)elarea > 0.0) {
            elmean /= elarea;
        }
        LocalPt lp = region.getCenterPt();
        g.setPaintMode();
        g.setFont(new Font("SansSerif", 0, 12));
        FontMetrics fm = g.getFontMetrics();
        if ((double)elarea > 0.0) {
            String str1 = "MAX: " + RMAIO.setPrecision2(elmax, 0);
            String str2 = "MIN: " + RMAIO.setPrecision2(elmin, 0);
            String str3 = "AVG: " + RMAIO.setPrecision2(elmean, 0);
            String str4 = "AREA: " + RMAIO.setPrecision2(elarea, 0);
            int h = fm.getHeight() * 4;
            int w = fm.stringWidth(str4);
            g.setColor(Color.white);
            g.fillRect(lp.x - 1, lp.y - fm.getMaxAscent() - 1, w + 2, h + 2);
            g.setColor(Color.black);
            g.drawString(str1, lp.x, lp.y);
            lp.y += fm.getHeight();
            g.drawString(str2, lp.x, lp.y);
            lp.y += fm.getHeight();
            g.drawString(str3, lp.x, lp.y);
            lp.y += fm.getHeight();
            g.drawString(str4, lp.x, lp.y);
        } else {
            String str1 = "NO POINTS SELECTED";
            int h = fm.getHeight();
            int w = fm.stringWidth(str1);
            g.setColor(Color.white);
            g.fillRect(lp.x - 1, lp.y - fm.getMaxAscent() - 1, w + 2, h + 2);
            g.setColor(Color.black);
            g.drawString(str1, lp.x, lp.y);
        }
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        NetTinGlyphDataRec rec = new NetTinGlyphDataRec();
        rec.setGlyph(this);
        return rec;
    }
}

