/*
 * Decompiled with CFR 0.152.
 */
package hec.map.nettin;

import hec.appInterface.AppDaddy;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.ElevationMap;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.nettin.EdgeContainer;
import hec.map.nettin.NodeContainer;
import hec.map.nettin.TriangleContainer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class NetTinMap
extends MapObject
implements Serializable,
MapObjectInterface,
ElevationMap {
    NodeContainer _nodes = null;
    EdgeContainer _edges = null;
    TriangleContainer _triangles = null;

    public NetTinMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public NetTinMap() {
        this.init();
    }

    void init() {
        this._loaded = false;
        this._nodes = null;
        this._edges = null;
        this._triangles = null;
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            String ext;
            HecFile file = this._mapId.getFile();
            boolean binary = false;
            String name = file.getName();
            int idx = name.lastIndexOf(".");
            if (idx > -1 && (ext = name.substring(idx + 1)).lastIndexOf("bin") > -1) {
                binary = true;
            }
            if (binary) {
                this.loadBin(file);
            } else {
                String pathname = this._mapId.getPath() + "bin";
                Identifier pathId = new Identifier(pathname);
                pathId.setName(RMAIO.getFileFromPath(pathname));
                Identifier idOut = AppDaddy.getWorkspace().createFile(pathId);
                if (idOut == null) {
                    idOut = AppDaddy.getWorkspace().openFile(pathId, true);
                    if (idOut != null) {
                        this.loadBin(idOut.getFile());
                    }
                } else {
                    this.loadAsciiWriteBin(file, idOut.getFile());
                }
                this.getMapIdentifier().setIdentifier(pathId);
                this.getMapIdentifier().setFile(idOut.getFile());
            }
            this._loaded = true;
        }
    }

    @Override
    public void unload() {
        this.init();
    }

    protected void loadAsciiWriteBin(HecFile fileIn, HecFile fileOut) {
        System.out.println("NetTinMap  " + fileIn.getName() + " starting ascii load.");
        long t1 = new Date().getTime();
        long t12 = new Date().getTime();
        BufferedReader in = null;
        DataOutputStream out = null;
        try {
            int ii;
            in = fileIn.getBufferedReader();
            int section = -1;
            int counter = 0;
            int nodesize = 0;
            int edgesize = 0;
            int trianglesize = 0;
            StringTokenizer st = null;
            String tok = null;
            String line = in.readLine();
            int id = Integer.MIN_VALUE;
            while (line != null) {
                if (line.indexOf("NODES") >= 0) {
                    section = 0;
                    System.out.println("Reading Node IDs");
                    line = in.readLine();
                    ++counter;
                    continue;
                }
                if (line.indexOf("EDGES") >= 0) {
                    section = 1;
                    System.out.println("Reading Edge IDs");
                    line = in.readLine();
                    ++counter;
                    continue;
                }
                if (line.indexOf("TRIANGLES") >= 0) {
                    section = 2;
                    System.out.println("Reading Triangles IDs");
                    line = in.readLine();
                    ++counter;
                    continue;
                }
                st = new StringTokenizer(line);
                switch (section) {
                    case 0: {
                        tok = st.nextToken();
                        id = RMAIO.parseInt(tok);
                        if (id <= nodesize) break;
                        nodesize = id;
                        break;
                    }
                    case 1: {
                        tok = st.nextToken();
                        id = RMAIO.parseInt(tok);
                        if (id <= edgesize) break;
                        edgesize = id;
                        break;
                    }
                    case 2: {
                        tok = st.nextToken();
                        id = RMAIO.parseInt(tok);
                        if (id <= trianglesize) break;
                        trianglesize = id;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("NetTinMap ascii load failure  " + fileIn.getName() + " does not have the correct format.");
                    }
                }
                line = in.readLine();
                if (++counter % 100000 != 0) continue;
                System.out.println("L: " + counter + " N: " + nodesize + " E: " + edgesize + " T: " + trianglesize);
            }
            this._nodes = new NodeContainer(nodesize + 1);
            this._edges = new EdgeContainer(edgesize + 1);
            this._triangles = new TriangleContainer(trianglesize + 1);
            int nodeadded = 0;
            int edgeadded = 0;
            int triangleadded = 0;
            double x = Double.NEGATIVE_INFINITY;
            double y = Double.NEGATIVE_INFINITY;
            float z = Float.NEGATIVE_INFINITY;
            int intNodeAId = Integer.MIN_VALUE;
            int intNodeBId = Integer.MIN_VALUE;
            int intBoundary = Integer.MIN_VALUE;
            int intEdgeAId = Integer.MIN_VALUE;
            int intEdgeBId = Integer.MIN_VALUE;
            int intEdgeCId = Integer.MIN_VALUE;
            boolean boundary = false;
            in = fileIn.getBufferedReader();
            line = in.readLine();
            counter = 0;
            while (line != null) {
                if (line.indexOf("NODES") >= 0) {
                    section = 0;
                    System.out.println("Reading Nodes");
                    line = in.readLine();
                    ++counter;
                    continue;
                }
                if (line.indexOf("EDGES") >= 0) {
                    section = 1;
                    System.out.println("Reading Edges");
                    line = in.readLine();
                    ++counter;
                    continue;
                }
                if (line.indexOf("TRIANGLES") >= 0) {
                    section = 2;
                    System.out.println("Reading Triangles");
                    line = in.readLine();
                    ++counter;
                    continue;
                }
                st = new StringTokenizer(line);
                switch (section) {
                    case 0: {
                        tok = st.nextToken();
                        id = RMAIO.parseInt(tok);
                        tok = st.nextToken();
                        x = RMAIO.parseDouble(tok);
                        tok = st.nextToken();
                        y = RMAIO.parseDouble(tok);
                        tok = st.nextToken();
                        z = RMAIO.parseFloat(tok);
                        this._nodes.addNode(id, x, y, z);
                        ++nodeadded;
                        break;
                    }
                    case 1: {
                        tok = st.nextToken();
                        id = RMAIO.parseInt(tok);
                        tok = st.nextToken();
                        intNodeAId = RMAIO.parseInt(tok);
                        tok = st.nextToken();
                        intNodeBId = RMAIO.parseInt(tok);
                        tok = st.nextToken();
                        intBoundary = RMAIO.parseInt(tok);
                        boundary = intBoundary == 0;
                        this._edges.addEdge(id, intNodeAId, intNodeBId, boundary);
                        ++edgeadded;
                        break;
                    }
                    case 2: {
                        tok = st.nextToken();
                        id = RMAIO.parseInt(tok);
                        tok = st.nextToken();
                        intEdgeAId = RMAIO.parseInt(tok);
                        tok = st.nextToken();
                        intEdgeBId = RMAIO.parseInt(tok);
                        tok = st.nextToken();
                        intEdgeCId = RMAIO.parseInt(tok);
                        this._triangles.addTriangle(id, intEdgeAId, intEdgeBId, intEdgeCId);
                        ++triangleadded;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("NetTinMap ascii load failure  " + fileIn.getName() + " does not have the correct format.");
                    }
                }
                line = in.readLine();
                if (++counter % 100000 != 0) continue;
                System.out.println("L: " + counter + " N: " + nodeadded + "/" + nodesize + " E: " + edgeadded + "/" + edgesize + " T: " + triangleadded + "/" + trianglesize);
            }
            in.close();
            t12 = new Date().getTime();
            System.out.println("NetTinMap  " + fileIn.getName() + " took " + (t12 - t1) + " ms to ascii load.");
            System.out.println("NetTinMap  " + fileIn.getName() + " starting binary write.");
            out = fileOut.getDataOutputStream();
            out.writeInt(this._nodes.e.length);
            for (ii = 0; ii < this._nodes.e.length; ++ii) {
                out.writeDouble(this._nodes.e[ii]);
                out.writeDouble(this._nodes.n[ii]);
                out.writeFloat(this._nodes.z[ii]);
            }
            out.writeInt(this._edges.intNodeIdA.length);
            for (ii = 0; ii < this._edges.intNodeIdA.length; ++ii) {
                out.writeInt(this._edges.intNodeIdA[ii]);
                out.writeInt(this._edges.intNodeIdB[ii]);
                out.writeBoolean(this._edges.boundary[ii]);
            }
            out.writeInt(this._triangles.intEdgeIdA.length);
            for (ii = 0; ii < this._triangles.intEdgeIdA.length; ++ii) {
                out.writeInt(this._triangles.intEdgeIdA[ii]);
                out.writeInt(this._triangles.intEdgeIdB[ii]);
                out.writeInt(this._triangles.intEdgeIdC[ii]);
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        long t2 = new Date().getTime();
        System.out.println("NetTinMap  " + fileIn.getName() + " took " + (t2 - t12) + " ms to binary write.");
    }

    public void loadBin(HecFile fileIn) {
        System.out.println("NetTinMap  " + fileIn.getName() + " starting binary load.");
        long t1 = new Date().getTime();
        DataInputStream in = null;
        try {
            int ii;
            in = fileIn.getDataInputStream();
            int arrayLength = in.readInt();
            double[] e = new double[arrayLength];
            double[] n = new double[arrayLength];
            float[] z = new float[arrayLength];
            this._nodes = new NodeContainer(e, n, z);
            for (ii = 0; ii < arrayLength; ++ii) {
                this._nodes.e[ii] = in.readDouble();
                this._nodes.n[ii] = in.readDouble();
                this._nodes.z[ii] = in.readFloat();
            }
            this._nodes.calcMinMax();
            arrayLength = in.readInt();
            int[] intNodeIdA = new int[arrayLength];
            int[] intNodeIdB = new int[arrayLength];
            boolean[] boundary = new boolean[arrayLength];
            this._edges = new EdgeContainer(intNodeIdA, intNodeIdB, boundary);
            for (ii = 0; ii < arrayLength; ++ii) {
                this._edges.intNodeIdA[ii] = in.readInt();
                this._edges.intNodeIdB[ii] = in.readInt();
                this._edges.boundary[ii] = in.readBoolean();
            }
            arrayLength = in.readInt();
            int[] intEdgeIdA = new int[arrayLength];
            int[] intEdgeIdB = new int[arrayLength];
            int[] intEdgeIdC = new int[arrayLength];
            this._triangles = new TriangleContainer(intEdgeIdA, intEdgeIdB, intEdgeIdC);
            for (ii = 0; ii < arrayLength; ++ii) {
                this._triangles.intEdgeIdA[ii] = in.readInt();
                this._triangles.intEdgeIdB[ii] = in.readInt();
                this._triangles.intEdgeIdC[ii] = in.readInt();
            }
            in.close();
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace();
        }
        long t2 = new Date().getTime();
        System.out.println("NetTinMap  " + fileIn.getName() + " took " + (t2 - t1) + " ms to binary load.");
    }

    public NodeContainer getNodes() {
        return this._nodes;
    }

    public EdgeContainer getEdges() {
        return this._edges;
    }

    public TriangleContainer getTriangles() {
        return this._triangles;
    }

    @Override
    public double getMaximumElevation() {
        if (this._nodes != null) {
            return this._nodes.max;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMinimumElevation() {
        if (this._nodes != null) {
            return this._nodes.min;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getNoDataValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public float[] getElevation(double[] northing, double[] easting) {
        float[] elevations = new float[northing != null ? northing.length : 0];
        WorldPt wp = new WorldPt();
        for (int i = 0; i < elevations.length; ++i) {
            wp.e = easting[i];
            wp.n = northing[i];
            elevations[i] = this.getElevation(wp);
        }
        return elevations;
    }

    @Override
    public float getElevation(WorldPt pt) {
        WorldPt[] wpt = new WorldPt[]{new WorldPt(), new WorldPt(), new WorldPt()};
        WorldRegion wreg = new WorldRegion();
        wreg.pts.addElement(wpt[0]);
        wreg.pts.addElement(wpt[1]);
        wreg.pts.addElement(wpt[2]);
        if (this._nodes == null || this._edges == null || this._triangles == null) {
            return Float.NEGATIVE_INFINITY;
        }
        boolean ii = true;
        int nmax = this._triangles.size();
        int[] nid = new int[3];
        for (int i = 0; i < this._triangles.size(); ++i) {
            if (!this._triangles.getTriangleNodes(i, this._edges, nid) || this._nodes.x[nid[0]] == Integer.MIN_VALUE && this._nodes.x[nid[1]] == Integer.MIN_VALUE && this._nodes.x[nid[2]] == Integer.MIN_VALUE) continue;
            for (int j = 0; j < 3; ++j) {
                int in = nid[j];
                wpt[j].e = this._nodes.e[in];
                wpt[j].n = this._nodes.n[in];
            }
            if (!wreg.contains(pt)) continue;
            return this._triangles.interpolateDepth(i, pt, this._edges, this._nodes);
        }
        return Float.NEGATIVE_INFINITY;
    }

    public void crop(WorldRect wr) {
        int idx;
        int i;
        int[] nodeId = new int[3];
        int nedge = 0;
        int nnode = 0;
        int ntri = 0;
        int[] usedNodes = new int[this._nodes.size()];
        for (i = 0; i < this._nodes.size(); ++i) {
            usedNodes[i] = -1;
        }
        int[] usedEdges = new int[this._edges.size()];
        for (i = 0; i < this._edges.size(); ++i) {
            usedEdges[i] = -1;
        }
        int[] usedTri = new int[this._triangles.size()];
        for (i = 0; i < this._triangles.size(); ++i) {
            usedTri[i] = -1;
        }
        for (i = 0; i < this._triangles.size(); ++i) {
            if (!this._triangles.getTriangleNodes(i, this._edges, nodeId) || this._nodes.x[nodeId[0]] == Integer.MIN_VALUE || this._nodes.x[nodeId[1]] == Integer.MIN_VALUE || this._nodes.x[nodeId[2]] == Integer.MIN_VALUE) continue;
            usedTri[i] = ntri;
            for (int j = 0; j < 3; ++j) {
                if (usedNodes[nodeId[j]] >= 0) continue;
                usedNodes[nodeId[j]] = nnode++;
            }
            if (usedEdges[this._triangles.intEdgeIdA[i]] < 0) {
                usedEdges[this._triangles.intEdgeIdA[i]] = nedge++;
            }
            if (usedEdges[this._triangles.intEdgeIdB[i]] < 0) {
                usedEdges[this._triangles.intEdgeIdB[i]] = nedge++;
            }
            if (usedEdges[this._triangles.intEdgeIdC[i]] < 0) {
                usedEdges[this._triangles.intEdgeIdC[i]] = nedge++;
            }
            ++ntri;
        }
        NodeContainer nc = new NodeContainer(nnode);
        EdgeContainer ec = new EdgeContainer(nedge);
        TriangleContainer tc = new TriangleContainer(ntri);
        for (i = 0; i < this._nodes.size(); ++i) {
            idx = usedNodes[i];
            if (idx < 0) continue;
            nc.e[idx] = this._nodes.e[i];
            nc.n[idx] = this._nodes.n[i];
            nc.z[idx] = this._nodes.z[i];
        }
        for (i = 0; i < this._edges.size(); ++i) {
            idx = usedEdges[i];
            if (idx < 0) continue;
            ec.intNodeIdA[idx] = usedNodes[this._edges.intNodeIdA[i]];
            ec.intNodeIdB[idx] = usedNodes[this._edges.intNodeIdB[i]];
            ec.boundary[idx] = this._edges.boundary[i];
        }
        for (i = 0; i < this._triangles.size(); ++i) {
            idx = usedTri[i];
            if (idx < 0) continue;
            tc.intEdgeIdA[idx] = usedEdges[this._triangles.intEdgeIdA[i]];
            tc.intEdgeIdB[idx] = usedEdges[this._triangles.intEdgeIdB[i]];
            tc.intEdgeIdC[idx] = usedEdges[this._triangles.intEdgeIdC[i]];
        }
        Identifier pathId = new Identifier("maps/crop.netbin");
        Identifier idOut = AppDaddy.getWorkspace().createFile(pathId);
        if (idOut == null) {
            System.out.println("NetTinMap binary write failed - no file identifier.");
            return;
        }
        long t12 = new Date().getTime();
        DataOutputStream out = null;
        try {
            int ii;
            System.out.println("NetTinMap starting binary write.");
            HecFile fileOut = idOut.getFile();
            if (fileOut == null) {
                System.out.println("NetTinMap binary write failed - no file.");
                return;
            }
            out = fileOut.getDataOutputStream();
            out.writeInt(nc.e.length);
            for (ii = 0; ii < nc.e.length; ++ii) {
                out.writeDouble(nc.e[ii]);
                out.writeDouble(nc.n[ii]);
                out.writeFloat(nc.z[ii]);
            }
            out.writeInt(ec.intNodeIdA.length);
            for (ii = 0; ii < ec.intNodeIdA.length; ++ii) {
                out.writeInt(ec.intNodeIdA[ii]);
                out.writeInt(ec.intNodeIdB[ii]);
                out.writeBoolean(ec.boundary[ii]);
            }
            out.writeInt(tc.intEdgeIdA.length);
            for (ii = 0; ii < tc.intEdgeIdA.length; ++ii) {
                out.writeInt(tc.intEdgeIdA[ii]);
                out.writeInt(tc.intEdgeIdB[ii]);
                out.writeInt(tc.intEdgeIdC[ii]);
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        long t2 = new Date().getTime();
        System.out.println("NetTinMap  took " + (t2 - t12) + " ms to binary write.");
    }

    @Override
    public boolean mapIdentifierEquals(MapIdentifier mapid) {
        String asciiFile;
        if (this.getMapIdentifier().equals(mapid)) {
            return true;
        }
        if (mapid == null) {
            return false;
        }
        String thatExt = RMAIO.getFileExtension(mapid.getPath());
        if (".net".equals(thatExt) && (asciiFile = this.getMapIdentifier().getPath()).endsWith(".netbin")) {
            asciiFile = asciiFile.substring(0, asciiFile.length() - 3);
            return RMAIO.pathsEqual(mapid.getPath(), asciiFile);
        }
        return false;
    }
}

