/*
 * Decompiled with CFR 0.152.
 */
package hec.map.nettin;

import hec.map.WorldPt;
import hec.map.nettin.EdgeContainer;
import hec.map.nettin.NodeContainer;

public class TriangleContainer {
    protected int _size;
    public int[] intEdgeIdA;
    public int[] intEdgeIdB;
    public int[] intEdgeIdC;
    transient EdgeContainer _edgeContainer = null;
    transient int[][] _nodes = null;

    public TriangleContainer(int size) {
        this._size = size;
        this.intEdgeIdA = new int[size];
        this.intEdgeIdB = new int[size];
        this.intEdgeIdC = new int[size];
        for (int ii = 0; ii < size; ++ii) {
            this.intEdgeIdA[ii] = Integer.MIN_VALUE;
            this.intEdgeIdB[ii] = Integer.MIN_VALUE;
            this.intEdgeIdC[ii] = Integer.MIN_VALUE;
        }
    }

    public TriangleContainer(int[] argIntEdgeIdA, int[] argIntEdgeIdB, int[] argIntEdgeIdC) {
        this.intEdgeIdA = argIntEdgeIdA;
        this.intEdgeIdB = argIntEdgeIdB;
        this.intEdgeIdC = argIntEdgeIdC;
        this._size = this.intEdgeIdA.length;
        if (this.intEdgeIdB.length < this._size) {
            this._size = this.intEdgeIdB.length;
        }
        if (this.intEdgeIdC.length < this._size) {
            this._size = this.intEdgeIdC.length;
        }
    }

    public void addTriangle(int id, int argIntEdgeAId, int argIntEdgeBId, int argIntEdgeCId) {
        this.intEdgeIdA[id] = argIntEdgeAId;
        this.intEdgeIdB[id] = argIntEdgeBId;
        this.intEdgeIdC[id] = argIntEdgeCId;
    }

    public int size() {
        return this._size;
    }

    public boolean getTriangleNodes(int id, EdgeContainer ec, int[] nodes) {
        if (id < 0 || id >= this._size || ec == null || nodes == null || nodes.length < 3) {
            return false;
        }
        if (this._edgeContainer != ec) {
            this._edgeContainer = ec;
            this._nodes = new int[3][this._size];
            for (int i = 0; i < this._size; ++i) {
                int eid = this.intEdgeIdA[i];
                if (eid < 0 || eid >= ec._size) {
                    this._nodes[0][i] = -1;
                    continue;
                }
                this._nodes[0][i] = ec.intNodeIdA[eid];
                this._nodes[1][i] = ec.intNodeIdB[eid];
                eid = this.intEdgeIdB[i];
                if (eid < 0 || eid >= ec._size) {
                    this._nodes[0][i] = -1;
                    continue;
                }
                int n = ec.intNodeIdA[eid];
                if (n != this._nodes[0][i] && n != this._nodes[1][i]) {
                    this._nodes[2][i] = n;
                    continue;
                }
                n = ec.intNodeIdB[eid];
                if (n != this._nodes[0][i] && n != this._nodes[1][i]) {
                    this._nodes[2][i] = n;
                    continue;
                }
                eid = this.intEdgeIdC[id];
                if (eid < 0 || eid >= ec._size) {
                    this._nodes[0][i] = -1;
                    continue;
                }
                n = ec.intNodeIdA[eid];
                if (n != this._nodes[0][i] && n != this._nodes[1][i]) {
                    this._nodes[2][i] = n;
                    continue;
                }
                n = ec.intNodeIdB[eid];
                if (n != this._nodes[0][i] && n != this._nodes[1][i]) {
                    this._nodes[2][i] = n;
                    continue;
                }
                this._nodes[0][i] = -1;
            }
        }
        if (this._nodes[0][id] < 0) {
            return false;
        }
        nodes[0] = this._nodes[0][id];
        nodes[1] = this._nodes[1][id];
        nodes[2] = this._nodes[2][id];
        return true;
    }

    public float interpolateDepth(int id, WorldPt pt, EdgeContainer ec, NodeContainer nodeCon) {
        if (id < 0 || id >= this._size || pt == null || nodeCon == null) {
            return Float.NEGATIVE_INFINITY;
        }
        double[] x = new double[3];
        double[] y = new double[3];
        float[] z = new float[3];
        int[] nodes = new int[3];
        if (!this.getTriangleNodes(id, ec, nodes)) {
            return Float.NEGATIVE_INFINITY;
        }
        for (int i = 0; i < 3; ++i) {
            x[i] = nodeCon.e[nodes[i]];
            y[i] = nodeCon.n[nodes[i]];
            z[i] = nodeCon.z[nodes[i]];
        }
        double denom = (x[1] - x[0]) * (y[2] - y[0]) - (x[2] - x[0]) * (y[1] - y[0]);
        if (denom == 0.0) {
            return Float.NEGATIVE_INFINITY;
        }
        double xl = ((pt.e - x[0]) * (y[2] - y[0]) - (x[2] - x[0]) * (pt.n - y[0])) / denom;
        double yl = ((x[1] - x[0]) * (pt.n - y[0]) - (pt.e - x[0]) * (y[1] - y[0])) / denom;
        float val = (float)(xl * (double)z[1] + yl * (double)z[2] + (1.0 - xl - yl) * (double)z[0]);
        return val;
    }

    public boolean calcElevStats(int id, EdgeContainer ec, NodeContainer nc, float[] val) {
        if (id < 0 || id > this._size || ec == null || nc == null || val == null || val.length < 4) {
            return false;
        }
        int[] nodes = new int[3];
        if (!this.getTriangleNodes(id, ec, nodes)) {
            return false;
        }
        val[0] = nc.z[nodes[0]];
        val[1] = nc.z[nodes[0]];
        for (int i = 1; i < 3; ++i) {
            if (val[0] < nc.z[nodes[i]]) {
                val[0] = nc.z[nodes[i]];
            }
            if (!(val[1] > nc.z[nodes[i]])) continue;
            val[1] = nc.z[nodes[i]];
        }
        val[2] = (nc.z[nodes[0]] + nc.z[nodes[1]] + nc.z[nodes[2]]) / 3.0f;
        val[3] = (float)Math.abs(0.5 * ((nc.e[nodes[1]] - nc.e[nodes[0]]) * (nc.n[nodes[2]] - nc.n[nodes[0]]) - (nc.e[nodes[2]] - nc.e[nodes[0]]) * (nc.n[nodes[1]] - nc.n[nodes[0]])));
        return true;
    }
}

