/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.map.raster.AbstractSegmentData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ComputeSegmentData
extends AbstractSegmentData {
    int mNumParams = 0;
    int mRows = 0;
    int mColumns = 0;
    float mNoDataValue = 0.0f;
    byte[] mData;
    ByteBuffer mDataBuffer = null;

    public ComputeSegmentData(int numParams, int rows, int cols, float f) {
        this.mNumParams = numParams;
        this.mRows = rows;
        this.mColumns = cols;
        this.mNoDataValue = f;
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.mData = new byte[this.mNumParams * this.mColumns * this.mRows * 4];
        int bytesRead = in.read(this.mData, 0, this.mData.length);
        this.mDataBuffer = ByteBuffer.wrap(this.mData);
    }

    @Override
    public float getValue(int paramIdx, int valueIdx) {
        if (paramIdx < 0 || paramIdx >= this.mNumParams) {
            return this.mNoDataValue;
        }
        if (valueIdx < 0 || valueIdx > this.mColumns * this.mRows) {
            return this.mNoDataValue;
        }
        int idx = (paramIdx * (this.mRows * this.mColumns) + valueIdx) * 4;
        if (idx >= this.mData.length && idx + 4 >= this.mData.length) {
            return this.mNoDataValue;
        }
        return this.mDataBuffer.getFloat(idx);
    }

    @Override
    public void setValue(int paramIdx, int valueIdx, float value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initialize() {
    }

    @Override
    public int getNumberParameters() {
        return this.mNumParams;
    }

    @Override
    public int getNumberRows() {
        return this.mRows;
    }

    @Override
    public int getNumberColumns() {
        return this.mColumns;
    }

    @Override
    public void write(DataOutputStream in) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[] getValues(int paramIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

