/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.appInterface.Workspace;
import hec.client.FileChooserFld;
import hec.data.Parameter;
import hec.data.Units;
import hec.gui.MoverDialog;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectFactory;
import hec.map.aidem.AiDemMap;
import hec.map.raster.RasterImportProgressIndicator;
import hec.map.raster.RasterMap;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.AccessTable;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;
import rma.swing.text.FilenameDocument;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class CreateRaster
extends RmaJDialog {
    RmaJTextField _mapNameTextField;
    RmaJTextField _filenameTextField;
    RmaJRadioButton _countResampleRadioButton;
    RmaJRadioButton _averageResampleRadioButton;
    JButton _buildButton;
    RmaJTable _table;
    RmaTableModel _tableModel;
    ReflectMultiListener listener = new ReflectMultiListener();
    Frame _parent;
    boolean _buildingSmrmp = false;

    public CreateRaster(Frame parent, boolean modal) {
        super(parent, false);
        this._parent = parent;
        this.setSize(400, 400);
        this.setLocation(50, 50);
        this.setTitle("Create SMRMP");
        this.buildComponents();
        this.buildMenus();
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Layer");
        columnNames.add("Parameter");
        columnNames.add("Unit");
        Vector rows = new Vector();
        Vector<String> row = new Vector<String>(1);
        row.add("");
        row.add("");
        row.add("");
        rows.add(row);
        Vector<Boolean> editable = new Vector<Boolean>();
        editable.add(true);
        editable.add(true);
        editable.add(true);
        this._tableModel = new RmaTableModel(columnNames, rows, editable);
        this._table.setModel(this._tableModel);
        FileChooserFld fileCellEditor = new FileChooserFld();
        if (AppDaddy.getWorkspace() != null) {
            fileCellEditor.setDefaultPath(AppDaddy.getWorkspace().getWorkspacePath() + "/maps");
        }
        String[] filters = new String[RasterMap.IMPORT_EXTENSIONS.length];
        for (int ii = 0; ii < RasterMap.IMPORT_EXTENSIONS.length; ++ii) {
            String filter = RasterMap.IMPORT_EXTENSIONS[ii];
            if (filter.startsWith(".")) {
                filter = filter.substring(1);
            }
            filters[ii] = filter;
        }
        ArrayList<RMAFilenameFilter> fileFilters = new ArrayList<RMAFilenameFilter>();
        fileFilters.add(new RMAFilenameFilter(filters, "Raster Files"));
        fileCellEditor.setFilters(fileFilters);
        RmaCellEditor editor = new RmaCellEditor(fileCellEditor);
        this._table.setColumnEditor(0, editor);
        JComboBox paramEditor = this._table.setComboBoxEditor(1, Parameter.getAvailableParameters());
        JComboBox unitEditor = this._table.setComboBoxEditor(2, Units.getAvailableUnits());
    }

    private void buildComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Map Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        this.getContentPane().add((Component)label, gbc);
        this._mapNameTextField = new RmaJTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._mapNameTextField, gbc);
        label = AppDaddy.getWorkspace() != null ? new JLabel("Filename: " + AppDaddy.getWorkspace().getWorkspacePath() + "/maps/") : new JLabel("/maps/");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        this.getContentPane().add((Component)label, gbc);
        this._filenameTextField = new RmaJTextField();
        this._filenameTextField.setDocument(new FilenameDocument());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._filenameTextField, gbc);
        JPanel resamplePanel = new JPanel(new GridBagLayout());
        TitledBorder border = new TitledBorder("Resampling Method:");
        resamplePanel.setBorder(border);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.getContentPane().add((Component)resamplePanel, gbc);
        ButtonGroup group = new ButtonGroup();
        this._countResampleRadioButton = new RmaJRadioButton("Count");
        group.add(this._countResampleRadioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        gbc.fill = 2;
        resamplePanel.add((Component)this._countResampleRadioButton, gbc);
        this._averageResampleRadioButton = new RmaJRadioButton("Average");
        this._averageResampleRadioButton.setSelected(true);
        group.add(this._averageResampleRadioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        gbc.fill = 2;
        resamplePanel.add((Component)this._averageResampleRadioButton, gbc);
        this._table = new AccessTable(this){

            @Override
            protected void checkAppendRow(int row) {
                int lastRow;
                int rowCount = this.getModel().getRowCount();
                if (rowCount > 1 && !this.doesRowContainData(lastRow = rowCount - 1)) {
                    return;
                }
                super.checkAppendRow(row);
            }

            private boolean doesRowContainData(int rowToCheck) {
                if (rowToCheck >= 0) {
                    Vector<?> rowData = this.getRow(rowToCheck);
                    if (rowData.get(0) == null || rowData.get(1) == null || rowData.get(2) == null) {
                        return false;
                    }
                    String layerpath = rowData.get(0).toString().trim();
                    String parameter = rowData.get(1).toString().trim();
                    String unit = rowData.get(2).toString().trim();
                    return layerpath.length() > 1 || parameter.length() > 1 || unit.length() > 1;
                }
                return false;
            }
        };
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 4;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.getContentPane().add((Component)this._table.getScrollPane(), gbc);
        this._buildButton = new JButton("Build SMRMP");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        this.getContentPane().add((Component)this._buildButton, gbc);
        this._buildButton.addActionListener(this.listener.add(this, this._buildButton, "buildRaster"));
    }

    private void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Add Maps", 77);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2, false));
        menuItem.addActionListener(this.listener.add(this, menuItem, "addMaps"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Exit", 88);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2, false));
        menu.add(menuItem);
        this.setJMenuBar(menuBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void buildRaster() {
        if (this._buildingSmrmp) {
            return;
        }
        try {
            this._buildButton.setEnabled(false);
            this._table.commitEdit(true);
            int i = Integer.MIN_VALUE;
            if (this._averageResampleRadioButton.isSelected()) {
                i = 10;
            } else if (this._countResampleRadioButton.isSelected()) {
                i = 11;
            }
            if (i == Integer.MIN_VALUE) {
                RMAIO.postError(this, "The category must be defined for the SMRMP.");
                return;
            }
            final int category = i;
            final String mapName = this._mapNameTextField.getText().trim();
            if (mapName.length() < 1) {
                RMAIO.postError(this, "The map name must be defined for the SMRMP.");
                return;
            }
            Object filepath = this._filenameTextField.getText().trim();
            if (((String)filepath).length() < 1) {
                RMAIO.postError(this, "The Filename must be defined for the SMRMP.");
                return;
            }
            if (((String)filepath).indexOf(".smrmp") == -1) {
                filepath = ((String)filepath).concat(".smrmp");
            }
            filepath = AppDaddy.getWorkspace().getWorkspacePath() + "/maps/" + (String)filepath;
            Identifier request = new Identifier((String)filepath);
            Identifier tmpId = AppDaddy.getWorkspace().openFile(request, false);
            if (tmpId == null) {
                tmpId = AppDaddy.getWorkspace().createFile(request);
            }
            if (tmpId == null) {
                RMAIO.postError(this, "Could not open or create the filename.");
                return;
            }
            final Identifier rasterId = tmpId;
            Vector rows = this._tableModel.getDataVector();
            if (rows.size() < 1) {
                RMAIO.postError(this, "No Layers defined to build SMRMP with.");
                return;
            }
            ArrayList<RasterImport> maps = new ArrayList<RasterImport>(rows.size());
            for (int ii = 0; ii < rows.size() - 1; ++ii) {
                int err;
                String layerpath = null;
                String parameter = null;
                String unit = null;
                Vector row = (Vector)rows.get(ii);
                layerpath = row.get(0).toString().trim();
                parameter = row.get(1).toString().trim();
                unit = row.get(2).toString().trim();
                if (layerpath.length() < 1) {
                    int err2 = RMAIO.postYesNoWarning(this, "Layer filename is unspecified, do you wish to continue building SMRMP?");
                    if (err2 != 1) continue;
                    return;
                }
                if (parameter.length() < 1) {
                    int err3 = RMAIO.postYesNoWarning(this, "Layer parameter is unspecified, do you wish to continue building SMRMP?");
                    if (err3 != 1) continue;
                    return;
                }
                if (unit.length() < 1) {
                    int err4 = RMAIO.postYesNoWarning(this, "Layer unit is unspecified, do you wish to continue building SMRMP?");
                    if (err4 != 1) continue;
                    return;
                }
                request = new Identifier(layerpath);
                Identifier layerId = AppDaddy.getWorkspace().openFile(request, false);
                if (layerId == null) {
                    int err5 = RMAIO.postYesNoWarning(this, "Unable to open Layer file, do you wish to continue building SMRMP?");
                    if (err5 != 1) continue;
                    return;
                }
                MapIdentifier mapId = new MapIdentifier(layerId);
                Workspace fileOpener = AppDaddy.getWorkspace();
                MapObject map = MapObjectFactory.newMapObject((FileOpener)fileOpener, mapId);
                if (map == null) {
                    err = RMAIO.postYesNoWarning(this, "Unable to load map for file: " + layerpath + ". Do you wish to continue building SMRMP?");
                    if (err != 1) continue;
                    return;
                }
                if (map instanceof AiDemMap) {
                    maps.add(new RasterImport(map, parameter, unit));
                    continue;
                }
                err = RMAIO.postYesNoWarning(this, "Unable to import map of type: " + map.getClass().getName() + ". Do you wish to continue building SMRMP?");
                if (err != 1) continue;
                return;
            }
            if (maps.size() < 1) {
                RMAIO.postError(this, "Selected layers are not accepted types to build SMRMP.");
                return;
            }
            final AiDemMap[] aidemMaps = new AiDemMap[maps.size()];
            final String[] params = new String[maps.size()];
            final String[] units = new String[maps.size()];
            for (int ii = 0; ii < maps.size(); ++ii) {
                RasterImport rasterImport = (RasterImport)maps.get(ii);
                aidemMaps[ii] = (AiDemMap)rasterImport.map;
                params[ii] = rasterImport.parameter;
                units[ii] = rasterImport.unit;
            }
            final RasterImportProgressIndicator progress = new RasterImportProgressIndicator(this, mapName);
            progress.pack();
            progress.setVisible(true);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        RasterMap rasterMap = RasterMap.importMap(progress, rasterId, mapName, category, params, units, aidemMaps);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    progress.done();
                    CreateRaster.this._buildingSmrmp = false;
                    CreateRaster.this._buildButton.setEnabled(true);
                }
            };
            Thread t = new Thread(r);
            this._buildingSmrmp = true;
            t.start();
        }
        finally {
            if (!this._buildingSmrmp) {
                this._buildButton.setEnabled(true);
            }
        }
    }

    public void addMaps() {
        this._table.commitEdit(true);
        MoverDialog dialog = new MoverDialog(this, true, "Add Maps");
        dialog.setMoveUpDownVisible(true);
        String path = AppDaddy.getWorkspace().getWorkspacePath() + "/maps";
        Vector available = new Vector();
        for (int ii = 0; ii < RasterMap.IMPORT_EXTENSIONS.length; ++ii) {
            available.addAll(AppDaddy.getWorkspace().getFileList(path, "*" + RasterMap.IMPORT_EXTENSIONS[ii]));
        }
        AbstractList selected = new ArrayList();
        dialog.setData(available, selected);
        dialog.setVisible(true);
        selected = dialog.getSelectedObjectsVector();
        boolean firstPass = true;
        for (int ii = 0; ii < selected.size(); ++ii) {
            Identifier id = (Identifier)selected.get(ii);
            boolean firstPassRowHasData = false;
            int lastRowIdx = this._table.getRowCount() - 1;
            Vector<Object> row = this._table.getRow(lastRowIdx);
            if (firstPass) {
                for (int jj = 0; jj < row.size(); ++jj) {
                    Object o = row.get(jj);
                    if (o == null || o.toString().trim().length() <= 0) continue;
                    firstPassRowHasData = true;
                    break;
                }
            }
            row = new Vector(3);
            row.add(id.getPath());
            row.add("");
            row.add("");
            if (firstPass && !firstPassRowHasData) {
                this._table.setRow(lastRowIdx, row);
            } else {
                this._table.appendRow(row);
            }
            firstPass = false;
        }
    }

    public static void main(String[] args) {
        CreateRaster.runStaticTest();
    }

    public static void runStaticTest() {
        Frame frame = new Frame();
        frame.setLocation(100, 100);
        CreateRaster dialog = new CreateRaster(frame, true);
        dialog.setVisible(true);
    }

    public class RasterImport {
        public MapObject map;
        public String parameter;
        public String unit;

        public RasterImport(MapObject map, String parameter, String unit) {
            this.map = map;
            this.parameter = parameter;
            this.unit = unit;
        }
    }
}

