/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.map.raster.AbstractSegmentData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MapSegmentData
extends AbstractSegmentData {
    public float[][] data = null;
    float noDataVal;
    int mRows;
    int mCols;
    int mNumParams;

    public MapSegmentData(int numParams, int rows, int cols, float f) {
        this.mNumParams = numParams;
        this.mRows = rows;
        this.mCols = cols;
        this.data = new float[numParams][rows * cols];
        this.noDataVal = f;
        this.initialize();
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.data[0].length * this.data.length * 4);
        int idx = 0;
        for (int jj = 0; jj < this.data[0].length; ++jj) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                buf.putFloat(idx * 4, this.data[ii][jj]);
                ++idx;
            }
        }
        byte[] array = buf.array();
        out.write(array);
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        byte[] buf = new byte[this.data[0].length * this.data.length * 4];
        int bytesRead = in.read(buf, 0, buf.length);
        if (bytesRead < 0) {
            return;
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(buf);
        int idx = 0;
        for (int jj = 0; jj < this.data[0].length; ++jj) {
            for (int ii = 0; ii < this.data.length; ++ii) {
                if (idx >= buf.length || idx >= bytesRead) continue;
                this.data[ii][jj] = byteBuf.getFloat(idx * 4);
                ++idx;
            }
        }
    }

    @Override
    public void initialize() {
        for (int ii = 0; ii < this.data.length; ++ii) {
            for (int jj = 0; jj < this.data[ii].length; ++jj) {
                this.data[ii][jj] = this.noDataVal;
            }
        }
    }

    @Override
    public void setValue(int paramIdx, int valueIdx, float value) {
        if (paramIdx < 0 || paramIdx >= this.data.length) {
            return;
        }
        if (valueIdx < 0 || valueIdx >= this.data[paramIdx].length) {
            return;
        }
        this.data[paramIdx][valueIdx] = value;
    }

    @Override
    public float getValue(int paramIdx, int valueIdx) {
        if (paramIdx < 0 || paramIdx >= this.data.length) {
            return this.noDataVal;
        }
        if (valueIdx < 0 || valueIdx >= this.data[paramIdx].length) {
            return this.noDataVal;
        }
        return this.data[paramIdx][valueIdx];
    }

    @Override
    public int getNumberParameters() {
        return this.mNumParams;
    }

    @Override
    public int getNumberRows() {
        return this.mRows;
    }

    @Override
    public int getNumberColumns() {
        return this.mCols;
    }

    @Override
    public float[] getValues(int paramIdx) {
        return this.data[paramIdx];
    }
}

