/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.appInterface.FileOpener;
import hec.data.Parameter;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObjectFactory;
import hec.map.aidem.AiDemBaseMap;
import hec.map.raster.RasterImportProgressIndicator;
import hec.map.raster.RasterMap;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class RasterConversionAction
extends AbstractAction {
    private JFrame mParent = null;
    private String mStartDirectory = null;
    FileOpener mFileOpener = null;
    Logger mLogger;

    public void RasterConversionAction() {
        this.mLogger = Logger.getLogger(this.getClass().getName());
    }

    public void setFileOpener(FileOpener fileOpener) {
        this.mFileOpener = fileOpener;
    }

    public void setParentFrame(JFrame parent) {
        this.mParent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final List<File> fileList = this.selectFiles();
        if (fileList == null || fileList.size() == 0) {
            return;
        }
        final RasterImportProgressIndicator progress = new RasterImportProgressIndicator(this.mParent, "");
        progress.pack();
        if (this.mParent != null) {
            progress.setLocationRelativeTo(this.mParent);
        }
        progress.setVisible(true);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (File file : fileList) {
                    Identifier request;
                    if (progress.isCanceled()) break;
                    progress.resetIncrementCount();
                    AiDemBaseMap mapObject = (AiDemBaseMap)MapObjectFactory.newMapObject(RasterConversionAction.this.mFileOpener, new Identifier(file.getAbsolutePath()));
                    MapIdentifier mapId = mapObject.getMapIdentifier();
                    Identifier tmpId = RasterConversionAction.this.mFileOpener.openFile(new Identifier(mapId.getPath()), false);
                    mapId.setFile(tmpId.getFile());
                    final String mapName = mapObject.getName();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progress.setTitle("Creating Map : " + RMAIO.getFileNameNoExtension(mapName));
                        }
                    });
                    AiDemBaseMap[] aidemMaps = new AiDemBaseMap[]{mapObject};
                    String[] params = new String[]{Parameter.getParamString(-1)};
                    String[] units = new String[]{"undef"};
                    Object filepath = mapObject.getMapIdentifier().getPath();
                    filepath = RMAIO.getPathNoExtension((String)filepath);
                    if (!((String)filepath).endsWith(".smrmp")) {
                        filepath = (String)filepath + ".smrmp";
                    }
                    if ((tmpId = RasterConversionAction.this.mFileOpener.openFile(request = new Identifier((String)filepath), false)) == null) {
                        tmpId = RasterConversionAction.this.mFileOpener.createFile(request);
                    }
                    if (tmpId == null) {
                        RasterConversionAction.this.mLogger.severe("Could not open or create the filename - " + (String)filepath);
                        continue;
                    }
                    Identifier rasterId = tmpId;
                    try {
                        RasterMap.importMap(progress, rasterId, mapName, 11, params, units, aidemMaps);
                    }
                    catch (Exception e) {
                        progress.done();
                        e.printStackTrace();
                        Object msg = "";
                        msg = (String)msg + e.getMessage();
                        JOptionPane.showMessageDialog(RasterConversionAction.this.mParent, msg, "Error!", 0);
                        return;
                    }
                }
                progress.done();
                if (!progress.isCanceled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(RasterConversionAction.this.mParent, "Map conversion complete.");
                        }
                    });
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void setStartDirectory(String startDirectory) {
        this.mStartDirectory = startDirectory;
    }

    protected List<File> selectFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        JFileChooser fileChooser = new JFileChooser(this.getFileChooserDirectory());
        fileChooser.setApproveButtonText("Select");
        fileChooser.setMultiSelectionEnabled(true);
        List<FileFilter> fileFilters = this.getFileFilters();
        for (FileFilter fileFilter : fileFilters) {
            fileChooser.addChoosableFileFilter(fileFilter);
        }
        int results = fileChooser.showOpenDialog(new JFrame());
        if (results == 1) {
            return fileList;
        }
        File[] selectedFiles = fileChooser.getSelectedFiles();
        for (int i = 0; i < selectedFiles.length; ++i) {
            File file = selectedFiles[i];
            fileList.add(file);
        }
        return fileList;
    }

    protected List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> fileFilters = new ArrayList<FileFilter>();
        fileFilters.add(new RMAFilenameFilter("asc", "ArcInfo DEM (*.asc)"));
        fileFilters.add(new RMAFilenameFilter("flt", "ESRI FLT (*.flt)"));
        return fileFilters;
    }

    private String getFileChooserDirectory() {
        String dir = System.getProperty("user.home");
        if (this.mStartDirectory != null) {
            dir = this.mStartDirectory;
        }
        Preferences pref = Preferences.userNodeForPackage(RasterConversionAction.class);
        dir = pref.get("LastDirectory", dir);
        return dir;
    }
}

