/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.map.ElevationGlyph;
import hec.map.GlyphDataRecord;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.raster.RasterGlyphDataRecord;
import hec.map.raster.RasterMap;
import hec.map.raster.Resolution;
import hec.map.raster.SegmentInfo;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.SwingUtilities;
import rma.util.ColorContour;
import rma.util.PruningList;

public class RasterGlyph
extends MapGlyph
implements Serializable,
ImageObserver,
ElevationGlyph,
Observer {
    protected HashMap _viewableImageHash = new HashMap();
    protected PruningList _segImageList = new PruningList(4);
    boolean mInterpolate = true;

    public RasterGlyph() {
        this.init();
    }

    public RasterGlyph(MapPanel panel, RasterMap map) {
        this.setMapPanel(panel);
        this.setMap(map);
    }

    @Override
    protected void init() {
    }

    public void setInterpolate(boolean b) {
        this.mInterpolate = b;
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        return new RasterGlyphDataRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillMap(boolean load) {
        super.fillMap(load);
        RasterGlyphDataRecord data = (RasterGlyphDataRecord)this.getDataRecord();
        if (data == null) {
            data = new RasterGlyphDataRecord();
            this.setDataRecord(data);
        }
        if (!data.getSet()) {
            data.setGlyph(this);
        }
        if (!load) {
            Object object = this._viewableImageHash;
            synchronized (object) {
                this._viewableImageHash.clear();
                this._viewableImageHash.notify();
            }
            object = this._segImageList;
            synchronized (object) {
                this._segImageList.clear();
                this._segImageList.notify();
            }
        }
    }

    @Override
    public double getNoDataValue() {
        return this._map != null ? ((RasterMap)this._map).getNoDataValue() : Double.NEGATIVE_INFINITY;
    }

    public double getElevation(WorldPt pt) {
        if (this._map == null) {
            return this.getNoDataValue();
        }
        RasterMap map = (RasterMap)this._map;
        return map.getElevation(pt);
    }

    @Override
    public double getMaximumElevation() {
        if (this._map == null) {
            return this.getNoDataValue();
        }
        RasterMap map = (RasterMap)this._map;
        return map.getMaxValue();
    }

    @Override
    public double getMinimumElevation() {
        if (this._map == null) {
            return this.getNoDataValue();
        }
        RasterMap map = (RasterMap)this._map;
        return map.getMinValue();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ArrayList) {
            ArrayList segLoadList = (ArrayList)arg;
            this.createImages(segLoadList);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RasterGlyph.this._mapPanel.paintMap();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImages(ArrayList segs) {
        if (this._map == null || this._mapPanel == null) {
            return;
        }
        try {
            RasterGlyphDataRecord data = (RasterGlyphDataRecord)this.getDataRecord();
            if (data == null) {
                data = new RasterGlyphDataRecord();
                this.setDataRecord(data);
            }
            if (!data.getSet()) {
                data.setGlyph(this);
            }
            RasterMap map = (RasterMap)this._map;
            Resolution res = map.getResolution();
            ArrayList<BufferedImage> imgList = new ArrayList<BufferedImage>(segs.size());
            Object object = this._segImageList;
            synchronized (object) {
                for (int xx = 0; xx < segs.size(); ++xx) {
                    BufferedImage img = null;
                    SegmentInfo si = (SegmentInfo)segs.get(xx);
                    for (int jj = 0; jj < this._segImageList.size(); ++jj) {
                        SegmentImage segimg = (SegmentImage)this._segImageList.get(jj);
                        if (segimg.segment != si || segimg.image == null) continue;
                        img = segimg.image;
                        SegmentImage old = (SegmentImage)this._segImageList.add(segimg);
                        this.createImageEdges(segimg.image, segs, res, si, data);
                        break;
                    }
                    if (img == null && (img = this.buildImage(segs, res, si, data)) != null) {
                        SegmentImage segimg = new SegmentImage();
                        segimg.segment = si;
                        segimg.image = img;
                        SegmentImage segmentImage = (SegmentImage)this._segImageList.add(segimg);
                    }
                    imgList.add(img);
                }
                this._segImageList.notify();
            }
            object = this._viewableImageHash;
            synchronized (object) {
                this._viewableImageHash.clear();
                for (int ii = 0; ii < segs.size(); ++ii) {
                    SegmentInfo si = (SegmentInfo)segs.get(ii);
                    Image img = (Image)imgList.get(ii);
                    if (si == null || img == null) continue;
                    this._viewableImageHash.put(si, img);
                }
                this._viewableImageHash.notify();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage buildImage(ArrayList segs, Resolution res, SegmentInfo si, RasterGlyphDataRecord data) {
        if (si.loading || si.segData == null) {
            return null;
        }
        long t1 = System.currentTimeMillis();
        RasterMap map = (RasterMap)this._map;
        BufferedImage img = new BufferedImage(map._colsInASegment, map._rowsInASegment, 2);
        WritableRaster working = img.getRaster();
        DataBufferInt rasterDB = (DataBufferInt)working.getDataBuffer();
        int[] pix = rasterDB.getBankData()[0];
        SegmentInfo segmentInfo = si;
        synchronized (segmentInfo) {
            Arrays.fill(pix, 0);
            double[] rgb = new double[3];
            ColorContour cc = data.getColorContour();
            boolean aspectOn = data.getAspectEnabled();
            double lafc = 1.0;
            if (!aspectOn) {
                for (int row = map._rowsInASegment - 1; row >= 0; --row) {
                    for (int col = 0; col < map._colsInASegment; ++col) {
                        int pixId = (map._rowsInASegment - 1 - row) * map._colsInASegment + col;
                        int segId = row * map._colsInASegment + col;
                        float val = si.segData.getValue(0, segId);
                        pix[pixId] = val == map._noDataValue ? 0 : cc.getRGB(rgb, val, lafc);
                    }
                }
            } else {
                double aa = data.getAspectAngle();
                double theta = -Math.PI / 180 * (aa - 90.0);
                double cosTheta = Math.cos(theta);
                double sinTheta = Math.sin(theta);
                double sinPhi = 0.5;
                double aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
                cosTheta /= aaMag;
                sinTheta /= aaMag;
                sinPhi /= aaMag;
                double[] vec0 = new double[3];
                double[] vec1 = new double[3];
                double[] cross = new double[3];
                double mapResX = res.deltaX;
                double mapResY = res.deltaY;
                for (int row = map._rowsInASegment - 2; row > 0; --row) {
                    for (int col = 1; col < map._colsInASegment - 1; ++col) {
                        int pixId = (map._rowsInASegment - 1 - row) * map._colsInASegment + col;
                        int segId = row * map._colsInASegment + col;
                        float val = si.segData.getValue(0, segId);
                        if (val == map._noDataValue) {
                            pix[pixId] = 0;
                            continue;
                        }
                        int in = segId + map._colsInASegment;
                        float eleN = in < 0 ? val : si.segData.getValue(0, in);
                        int ie = segId + 1;
                        float eleE = ie % map._colsInASegment == 0 ? val : si.segData.getValue(0, ie);
                        int is = segId - map._colsInASegment;
                        int length = si.segData.getNumberColumns() * si.segData.getNumberRows();
                        float eleS = is >= length ? val : si.segData.getValue(0, is);
                        int iw = segId - 1;
                        float eleW = iw % map._colsInASegment == 0 ? val : si.segData.getValue(0, iw);
                        vec0[0] = 2.0 * mapResX;
                        vec0[1] = 0.0;
                        vec0[2] = (eleE - eleW) * 10.0f;
                        vec1[0] = 0.0;
                        vec1[1] = 2.0 * mapResY;
                        vec1[2] = (eleN - eleS) * 10.0f;
                        cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                        cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                        cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                        double nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                        double dot = 1.0;
                        if (nMag != 0.0) {
                            dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                        }
                        if (cross[2] < 0.0) {
                            dot *= -1.0;
                        }
                        lafc = (dot + 1.25) / 2.25;
                        pix[pixId] = cc.getRGB(rgb, val, lafc);
                    }
                }
            }
            this.createImageEdges(img, segs, res, si, data);
            si.notify();
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Image Build took: " + (t2 - t1) + " ms.");
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImageEdges(BufferedImage img, ArrayList segs, Resolution res, SegmentInfo si, RasterGlyphDataRecord data) {
        if (si.loading || si.segData == null) {
            return;
        }
        boolean aspectOn = data.getAspectEnabled();
        if (!aspectOn) {
            return;
        }
        RasterMap map = (RasterMap)this._map;
        WritableRaster working = img.getRaster();
        DataBufferInt rasterDB = (DataBufferInt)working.getDataBuffer();
        int[] pix = rasterDB.getBankData()[0];
        double[] rgb = new double[3];
        ColorContour cc = data.getColorContour();
        double lafc = 1.0;
        SegmentInfo segmentInfo = si;
        synchronized (segmentInfo) {
            double aa = data.getAspectAngle();
            double theta = -Math.PI / 180 * (aa - 90.0);
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double sinPhi = 0.5;
            double aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
            cosTheta /= aaMag;
            sinTheta /= aaMag;
            sinPhi /= aaMag;
            double[] vec0 = new double[3];
            double[] vec1 = new double[3];
            double[] cross = new double[3];
            double mapResX = res.deltaX;
            double mapResY = res.deltaY;
            int segNorthIdx = si.index + res.segmentsWide;
            int segSouthIdx = si.index - res.segmentsWide;
            int segWestIdx = si.index - 1;
            int segEastIdx = si.index + 1;
            SegmentInfo segInfoNorth = null;
            SegmentInfo segInfoSouth = null;
            SegmentInfo segInfoWest = null;
            SegmentInfo segInfoEast = null;
            for (int ii = 0; ii < segs.size(); ++ii) {
                int length;
                double dot;
                double nMag;
                float eleW;
                int iw;
                float eleS;
                int is;
                float eleE;
                int ie;
                float eleN;
                int in;
                float val;
                int segId;
                int pixId;
                int col;
                int row;
                SegmentInfo segmentInfo2;
                SegmentInfo segInfoInList = (SegmentInfo)segs.get(ii);
                if (segInfoInList == si) continue;
                if (segInfoNorth == null && segInfoInList.index == segNorthIdx) {
                    segmentInfo2 = segInfoNorth = segInfoInList;
                    synchronized (segmentInfo2) {
                        row = map._rowsInASegment - 1;
                        for (col = 0; col < map._colsInASegment; ++col) {
                            pixId = (map._rowsInASegment - 1 - row) * map._colsInASegment + col;
                            segId = row * map._colsInASegment + col;
                            val = si.segData.getValue(0, segId);
                            if (val == map._noDataValue) {
                                pix[pixId] = 0;
                                continue;
                            }
                            if (segInfoNorth != null && segInfoNorth.segData != null && !segInfoNorth.loading) {
                                in = col;
                                eleN = segInfoNorth.segData.getValue(0, in);
                            } else {
                                eleN = val;
                            }
                            ie = segId + 1;
                            eleE = ie % map._colsInASegment == 0 ? val : si.segData.getValue(0, ie);
                            is = segId - map._colsInASegment;
                            eleS = si.segData.getValue(0, is);
                            iw = segId - 1;
                            eleW = segId % map._colsInASegment == 0 ? val : si.segData.getValue(0, iw);
                            vec0[0] = 2.0 * mapResX;
                            vec0[1] = 0.0;
                            vec0[2] = (eleE - eleW) * 10.0f;
                            vec1[0] = 0.0;
                            vec1[1] = 2.0 * mapResY;
                            vec1[2] = (eleN - eleS) * 10.0f;
                            cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                            cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                            cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                            nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                            dot = 1.0;
                            if (nMag != 0.0) {
                                dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                            }
                            if (cross[2] < 0.0) {
                                dot *= -1.0;
                            }
                            lafc = (dot + 1.25) / 2.25;
                            pix[pixId] = cc.getRGB(rgb, val, lafc);
                        }
                        segInfoNorth.notify();
                    }
                }
                if (segInfoSouth == null && segInfoInList.index == segSouthIdx) {
                    segmentInfo2 = segInfoSouth = segInfoInList;
                    synchronized (segmentInfo2) {
                        row = 0;
                        for (col = 0; col < map._colsInASegment; ++col) {
                            pixId = (map._rowsInASegment - 1 - row) * map._colsInASegment + col;
                            segId = row * map._colsInASegment + col;
                            val = si.segData.getValue(0, segId);
                            if (val == map._noDataValue) {
                                pix[pixId] = 0;
                                continue;
                            }
                            in = segId + map._colsInASegment;
                            eleN = si.segData.getValue(0, in);
                            ie = segId + 1;
                            eleE = ie % map._colsInASegment == 0 ? val : si.segData.getValue(0, ie);
                            if (segInfoSouth != null && segInfoSouth.segData != null && !segInfoSouth.loading) {
                                is = (map._rowsInASegment - 1) * map._colsInASegment + col;
                                eleS = segInfoSouth.segData.getValue(0, is);
                            } else {
                                eleS = val;
                            }
                            iw = segId - 1;
                            eleW = segId % map._colsInASegment == 0 ? val : si.segData.getValue(0, iw);
                            vec0[0] = 2.0 * mapResX;
                            vec0[1] = 0.0;
                            vec0[2] = (eleE - eleW) * 10.0f;
                            vec1[0] = 0.0;
                            vec1[1] = 2.0 * mapResY;
                            vec1[2] = (eleN - eleS) * 10.0f;
                            cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                            cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                            cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                            nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                            dot = 1.0;
                            if (nMag != 0.0) {
                                dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                            }
                            if (cross[2] < 0.0) {
                                dot *= -1.0;
                            }
                            lafc = (dot + 1.25) / 2.25;
                            pix[pixId] = cc.getRGB(rgb, val, lafc);
                        }
                        segInfoSouth.notify();
                    }
                }
                if (segInfoWest == null && segInfoInList.index == segWestIdx) {
                    segmentInfo2 = segInfoWest = segInfoInList;
                    synchronized (segmentInfo2) {
                        col = 0;
                        for (row = map._rowsInASegment - 2; row > 0; --row) {
                            pixId = (map._rowsInASegment - 1 - row) * map._colsInASegment + col;
                            segId = row * map._colsInASegment + col;
                            val = si.segData.getValue(0, segId);
                            if (val == map._noDataValue) {
                                pix[pixId] = 0;
                                continue;
                            }
                            in = segId + map._colsInASegment;
                            eleN = in < 0 ? val : si.segData.getValue(0, in);
                            ie = segId + 1;
                            eleE = si.segData.getValue(0, ie);
                            is = segId - map._colsInASegment;
                            length = si.segData.getNumberColumns() * si.segData.getNumberRows();
                            eleS = is >= length ? val : si.segData.getValue(0, is);
                            if (segInfoWest != null && segInfoWest.segData != null && !segInfoWest.loading) {
                                iw = row * map._colsInASegment + map._colsInASegment - 1;
                                eleW = segInfoWest.segData.getValue(0, iw);
                            } else {
                                eleW = val;
                            }
                            vec0[0] = 2.0 * mapResX;
                            vec0[1] = 0.0;
                            vec0[2] = (eleE - eleW) * 10.0f;
                            vec1[0] = 0.0;
                            vec1[1] = 2.0 * mapResY;
                            vec1[2] = (eleN - eleS) * 10.0f;
                            cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                            cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                            cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                            nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                            dot = 1.0;
                            if (nMag != 0.0) {
                                dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                            }
                            if (cross[2] < 0.0) {
                                dot *= -1.0;
                            }
                            lafc = (dot + 1.25) / 2.25;
                            pix[pixId] = cc.getRGB(rgb, val, lafc);
                        }
                        segInfoWest.notify();
                    }
                }
                if (segInfoEast != null || segInfoInList.index != segEastIdx) continue;
                segmentInfo2 = segInfoEast = segInfoInList;
                synchronized (segmentInfo2) {
                    col = map._colsInASegment - 1;
                    for (row = map._rowsInASegment - 2; row > 0; --row) {
                        pixId = (map._rowsInASegment - 1 - row) * map._colsInASegment + col;
                        segId = row * map._colsInASegment + col;
                        val = si.segData.getValue(0, segId);
                        if (val == map._noDataValue) {
                            pix[pixId] = 0;
                            continue;
                        }
                        in = segId + map._colsInASegment;
                        eleN = in < 0 ? val : si.segData.getValue(0, in);
                        if (segInfoEast != null && segInfoEast.segData != null && !segInfoEast.loading) {
                            ie = row * map._colsInASegment;
                            eleE = segInfoEast.segData.getValue(0, ie);
                        } else {
                            eleE = val;
                        }
                        is = segId - map._colsInASegment;
                        length = si.segData.getNumberColumns() * si.segData.getNumberRows();
                        eleS = is >= length ? val : si.segData.getValue(0, is);
                        iw = segId - 1;
                        eleW = si.segData.getValue(0, iw);
                        vec0[0] = 2.0 * mapResX;
                        vec0[1] = 0.0;
                        vec0[2] = (eleE - eleW) * 10.0f;
                        vec1[0] = 0.0;
                        vec1[1] = 2.0 * mapResY;
                        vec1[2] = (eleN - eleS) * 10.0f;
                        cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                        cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                        cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                        nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                        dot = 1.0;
                        if (nMag != 0.0) {
                            dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                        }
                        if (cross[2] < 0.0) {
                            dot *= -1.0;
                        }
                        lafc = (dot + 1.25) / 2.25;
                        pix[pixId] = cc.getRGB(rgb, val, lafc);
                    }
                    segInfoEast.notify();
                    continue;
                }
            }
            si.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g, MapScale scl) {
        if (this._map == null || this._mapPanel == null) {
            return;
        }
        RasterGlyphDataRecord data = (RasterGlyphDataRecord)this.getDataRecord();
        if (data == null) {
            data = new RasterGlyphDataRecord();
            this.setDataRecord(data);
        }
        if (data.isModified()) {
            PruningList pruningList = this._segImageList;
            synchronized (pruningList) {
                this._segImageList.clear();
                this._segImageList.notify();
            }
            data.setModified(false);
        }
        WorldRect swr = scl.getWorldRect();
        if (_paintOk && swr.intersects(this._map.getExtent())) {
            long t1 = System.currentTimeMillis();
            RasterMap map = (RasterMap)this._map;
            ArrayList segFoundList = map.loadArea(swr, this);
            if (segFoundList != null && segFoundList.size() > 0) {
                this.createImages(segFoundList);
            }
            HashMap hashMap = this._viewableImageHash;
            synchronized (hashMap) {
                Set set = this._viewableImageHash.keySet();
                for (SegmentInfo si : set) {
                    Image img = (Image)this._viewableImageHash.get(si);
                    if (img == null) continue;
                    WorldRect iwr = swr.getIntersection(si.extents);
                    if (iwr == null) {
                        return;
                    }
                    double xscl = (double)map._colsInASegment / (si.extents.e - si.extents.w);
                    double yscl = (double)map._rowsInASegment / (si.extents.n - si.extents.s);
                    double cellWidth = 1.0 / xscl;
                    double cellHeight = 1.0 / yscl;
                    if (iwr.w > si.extents.w && (iwr.w - si.extents.w) % cellWidth > 0.0) {
                        iwr.w -= (iwr.w - si.extents.w) % cellWidth;
                    }
                    if (iwr.e < si.extents.e && (si.extents.e - iwr.e) % cellWidth > 0.0) {
                        iwr.e += (si.extents.e - iwr.e) % cellWidth;
                    }
                    if (iwr.s > si.extents.s && (iwr.s - si.extents.s) % cellHeight > 0.0) {
                        iwr.s -= (iwr.s - si.extents.s) % cellHeight;
                    }
                    if (iwr.n < si.extents.n && (si.extents.n - iwr.n) % cellHeight > 0.0) {
                        iwr.n += (si.extents.n - iwr.n) % cellHeight;
                    }
                    int sx1 = (int)((iwr.w - si.extents.w) * xscl);
                    int sy1 = (int)((si.extents.n - iwr.n) * yscl);
                    int sx2 = (int)((iwr.e - si.extents.w) * xscl);
                    int sy2 = (int)((si.extents.n - iwr.s) * yscl);
                    LocalRect ilr = scl.wr2lr(iwr);
                    System.err.println("Paint: " + ilr.l + "," + ilr.t + "," + ilr.r + "," + ilr.b + "    " + sx1 + "," + sy1 + "," + sx2 + "," + sy2);
                    if (!(g instanceof Graphics2D)) continue;
                    Graphics2D g2 = (Graphics2D)g.create();
                    Composite oldac = g2.getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, data.getAlpha());
                    g2.setComposite(ac);
                    LocalRect lrc = scl.wr2lr(this._map.getExtent());
                    WorldRect wRect = scl.getWorldRect();
                    Rectangle rect = new Rectangle();
                    rect.x = (int)Math.floor(lrc.l);
                    rect.y = (int)Math.floor(lrc.t + 5);
                    rect.width = (int)Math.ceil(lrc.width());
                    rect.height = (int)Math.ceil(lrc.height());
                    if (this.mInterpolate) {
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    }
                    g2.drawImage(img, ilr.l, ilr.t, ilr.r, ilr.b, sx1, sy1, sx2, sy2, this);
                    if (oldac != null) {
                        g2.setComposite(oldac);
                    }
                    g2.dispose();
                }
                long t2 = System.currentTimeMillis();
                System.err.println("Draw took: " + (t2 - t1) + " ms.");
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    @Override
    public float getElevationAt(int ix, int iy) {
        if (this._mapPanel == null || this._map == null) {
            return Float.NEGATIVE_INFINITY;
        }
        WorldPt wpt = new WorldPt(this._mapPanel.scale().x2e(ix), this._mapPanel.scale().y2n(iy));
        return (float)this.getElevation(wpt);
    }

    @Override
    public void drawElevationStats(Graphics g, LocalRegion region) {
    }

    public class SegmentImage {
        public SegmentInfo segment = null;
        public BufferedImage image = null;
    }
}

