/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rma.swing.RmaJDialog;

public class RasterImportProgressIndicator
extends RmaJDialog {
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Window _parent;
    JProgressBar progressBar;
    int _numProgressUpdates = 1;
    int _incrementCount;
    boolean _canceled = false;
    JPanel progressPanel = null;

    public RasterImportProgressIndicator(JFrame parent, String mapName) {
        super((Frame)parent, false);
        this._parent = parent;
        this.buildComponents(mapName);
    }

    public RasterImportProgressIndicator(JDialog parent, String mapName) {
        super((Dialog)parent, false);
        this._parent = parent;
        this.buildComponents(mapName);
    }

    private void buildComponents(String mapName) {
        this.setResizable(false);
        this.setTitle("Creating SMRMP Map: " + mapName);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.progressPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5505;
        this.getContentPane().add((Component)this.progressPanel, gbc);
        JLabel totalLabel = new JLabel("Percent Completion");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5505;
        this.progressPanel.add((Component)totalLabel, gbc);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.5;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5505;
        this.progressPanel.add((Component)this.progressBar, gbc);
        this.progressBar.setMaximum(100);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.insets = this.INSETS5555;
        this.getContentPane().add((Component)panel, gbc);
        JButton canelButton = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 15;
        gbc.insets = this.INSETS5555;
        panel.add((Component)canelButton, gbc);
        canelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RasterImportProgressIndicator.this.cancelImport();
            }
        });
    }

    private void cancelImport() {
        JLabel canceledLabel = new JLabel("Canceling Import.  Cleanup in progress");
        canceledLabel.setForeground(Color.red);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        this.progressPanel.removeAll();
        this.progressPanel.add((Component)canceledLabel, gbc);
        this.progressPanel.revalidate();
        this.progressPanel.repaint();
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setNumProgressUpdates(int n) {
        if (n < 1) {
            n = 1;
        }
        this._numProgressUpdates = n;
    }

    public void resetIncrementCount() {
        this._incrementCount = 0;
    }

    public void incrementProgress() {
        ++this._incrementCount;
        int percentComplete = this._incrementCount * 100 / this._numProgressUpdates;
        if (percentComplete > 100) {
            percentComplete = 100;
        }
        SwingUtilities.invokeLater(new IncrementProgress(percentComplete));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (this._parent != null) {
                this._parent.setCursor(new Cursor(3));
            }
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }

    public void done() {
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        if (this._parent != null) {
            this._parent.setCursor(new Cursor(0));
        }
    }

    public class IncrementProgress
    implements Runnable {
        int _percentageComplete;

        public IncrementProgress(int i) {
            this._percentageComplete = i;
        }

        @Override
        public void run() {
            RasterImportProgressIndicator.this.progressBar.setValue(this._percentageComplete);
        }
    }
}

