/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.appInterface.FileOpener;
import hec.data.Parameter;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.ElevationMap;
import hec.map.GridMap;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.aidem.AiDemBaseMap;
import hec.map.raster.ComputeSegmentData;
import hec.map.raster.MapSegmentData;
import hec.map.raster.RasterImportProgressIndicator;
import hec.map.raster.RasterSegmentIterator;
import hec.map.raster.Resolution;
import hec.map.raster.SegmentData;
import hec.map.raster.SegmentInfo;
import hec.map.raster.SegmentLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class RasterMap
extends MapObject
implements Serializable,
MapObjectInterface,
ElevationMap,
GridMap {
    public static final String EXTENSION = ".smrmp";
    public static final int BYTES_IN_STRING = 160;
    public static final int BYTES_IN_FLOAT = 4;
    public static final String VERSION_CONTINUOUS_ONLY = "0.1";
    public static final String VERSION = "0.2";
    public static final float RESAMPLE_TO_UNDEFINED_RATIO = 0.75f;
    public static final int CONTINUOUS_DATA = 10;
    public static final int CATEGORY_DATA = 11;
    public static final String[] IMPORT_EXTENSIONS = new String[]{".asc", ".flt"};
    String _name;
    String _version;
    int _dataType;
    int _numTimes;
    long[] _times;
    int _numParameters;
    String[] _parameterNames;
    String[] _parameterUnits;
    float[] _minValues;
    float[] _maxValues;
    float _lowerLeftX;
    float _lowerLeftY;
    float _axisRotation;
    float _noDataValue;
    int _rowsInASegment;
    int _colsInASegment;
    int _resampleRatio;
    ArrayList _resolutions = new ArrayList();
    ArrayList _segmentDataPool = new ArrayList(4);
    HashMap _segHash = new HashMap();
    long _endOfHeader;
    SegmentInfo _lowerLeft;
    SegmentInfo _lowerRight;
    SegmentInfo _upperLeft;
    SegmentInfo _upperRight;
    Resolution _currentRes;
    Thread _segLoaderThread = null;

    public RasterMap(String fileName) {
        super(fileName);
        this.init();
    }

    public RasterMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public RasterMap() {
        this.init();
    }

    void init() {
    }

    @Override
    public WorldRect getGridCellSize() {
        Resolution baseRes = (Resolution)this._resolutions.get(0);
        WorldRect r = new WorldRect();
        r.w = 0.0;
        r.s = 0.0;
        r.e = baseRes.deltaX;
        r.n = baseRes.deltaY;
        return r;
    }

    public Resolution getBaseResolution() {
        Resolution baseRes = (Resolution)this._resolutions.get(0);
        return baseRes;
    }

    public Resolution getResolution() {
        return this._currentRes;
    }

    public SegmentInfo getLowerLeft() {
        return this._lowerLeft;
    }

    public SegmentInfo getLowerRight() {
        return this._lowerRight;
    }

    public SegmentInfo getUpperLeft() {
        return this._upperLeft;
    }

    public SegmentInfo getUpperRight() {
        return this._upperRight;
    }

    public int getRowsInASegment() {
        return this._rowsInASegment;
    }

    public int getColumnsInASegment() {
        return this._colsInASegment;
    }

    public float getValue(WorldPt pt) {
        return this.getElevation(pt);
    }

    @Override
    public boolean supportsNoDataValue() {
        return true;
    }

    @Override
    public double getNoDataValue() {
        return this._noDataValue;
    }

    @Override
    public double getMaximumElevation() {
        return this.getMaxValue();
    }

    public float getMaxValue() {
        if (this._maxValues == null) {
            this.calcMinMax();
        }
        if (this._maxValues != null && this._maxValues.length > 0) {
            return this._maxValues[0];
        }
        return -3.4028235E38f;
    }

    @Override
    public double getMinimumElevation() {
        return this.getMinValue();
    }

    public float getMinValue() {
        if (this._minValues == null) {
            this.calcMinMax();
        }
        if (this._minValues != null && this._minValues.length > 0) {
            return this._minValues[0];
        }
        return -3.4028235E38f;
    }

    private void calcMinMax() {
        try {
            this.readHeader(this.getMapIdentifier().getFile());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public RasterSegmentIterator getSegmentIterator() {
        RasterSegmentIterator iterator = new RasterSegmentIterator(this);
        return iterator;
    }

    @Override
    public float[] getElevation(double[] northing, double[] easting) {
        List pointList;
        if (northing == null || easting == null) {
            return new float[0];
        }
        if (northing.length != easting.length) {
            throw new RuntimeException("Northing/Easting value arrays are not the same length");
        }
        int NORTHING = 1;
        int EASTING = 2;
        int ELEV_INDEX = 0;
        float[] elevations = new float[northing.length];
        if (this._resolutions.isEmpty()) {
            float noDataValue = (float)this.getNoDataValue();
            Arrays.fill(elevations, noDataValue);
            return elevations;
        }
        SegmentInfo UNDEF_INFO = new SegmentInfo(this, new WorldRect(), -1);
        HashMap segmentInfoMap = new HashMap();
        Resolution baseRes = (Resolution)this._resolutions.get(0);
        for (int i = 0; i < elevations.length; ++i) {
            double xoff;
            int segcol;
            double yoff;
            int segrow;
            int segidx;
            SegmentInfo si = null;
            double e = easting[i];
            double n = northing[i];
            if (this._extent.contains(e, n) && (segidx = (segrow = (int)((yoff = n - this._extent.s) / (double)(baseRes.deltaY * (float)this._rowsInASegment))) * baseRes.segmentsWide + (segcol = (int)((xoff = e - this._extent.w) / (double)(baseRes.deltaX * (float)this._colsInASegment)))) < baseRes.segments.size()) {
                si = (SegmentInfo)baseRes.segments.get(segidx);
            }
            if (si == null) {
                si = UNDEF_INFO;
            }
            if ((pointList = (ArrayList<double[]>)segmentInfoMap.get(si)) == null) {
                pointList = new ArrayList<double[]>();
                segmentInfoMap.put(si, pointList);
            }
            double[] point = new double[3];
            point[ELEV_INDEX] = i;
            point[NORTHING] = n;
            point[EASTING] = e;
            pointList.add(point);
        }
        Set segmentInfoKeys = segmentInfoMap.keySet();
        Iterator iter = segmentInfoKeys.iterator();
        ArrayList<SegmentInfo> loaderList = new ArrayList<SegmentInfo>(1);
        loaderList.add(null);
        SegmentLoader sloader = new SegmentLoader(this, baseRes, null, this._mapId);
        ComputeSegmentData sd = new ComputeSegmentData(this._numParameters, this._rowsInASegment, this._colsInASegment, this._noDataValue);
        while (iter.hasNext()) {
            SegmentInfo si = (SegmentInfo)iter.next();
            pointList = (List)segmentInfoMap.get(si);
            if (si != UNDEF_INFO) {
                SegmentInfo tempSi = new SegmentInfo(this, si.extents, si.index);
                tempSi.segData = sd;
                loaderList.set(0, tempSi);
                sloader.setSegmentLoaderList(loaderList);
                sloader.run();
                for (int i = 0; pointList != null && i < pointList.size(); ++i) {
                    float value;
                    double[] point = (double[])pointList.get(i);
                    elevations[(int)point[ELEV_INDEX]] = value = this.findValueInSegment(tempSi, baseRes, point[NORTHING], point[EASTING]);
                }
                continue;
            }
            for (int i = 0; pointList != null && i < pointList.size(); ++i) {
                double[] point = (double[])pointList.get(i);
                elevations[(int)point[ELEV_INDEX]] = this._noDataValue;
            }
        }
        return elevations;
    }

    @Override
    public float getElevation(WorldPt pt) {
        return this.getBaseValue(pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getBaseValue(WorldPt pt) {
        if (!this._extent.contains(pt)) {
            return (float)this.getNoDataValue();
        }
        if (this._resolutions.isEmpty()) {
            return (float)this.getNoDataValue();
        }
        if (this._currentRes == this._resolutions.get(0)) {
            SegmentInfo segmentInfo;
            if (this._lowerLeft != null) {
                segmentInfo = this._lowerLeft;
                synchronized (segmentInfo) {
                    if (this._lowerLeft.extents.contains(pt)) {
                        return this.findValueInSegment(this._lowerLeft, pt);
                    }
                }
            }
            if (this._lowerRight != null) {
                segmentInfo = this._lowerRight;
                synchronized (segmentInfo) {
                    if (this._lowerRight.extents.contains(pt)) {
                        return this.findValueInSegment(this._lowerRight, pt);
                    }
                }
            }
            if (this._upperLeft != null) {
                segmentInfo = this._upperLeft;
                synchronized (segmentInfo) {
                    if (this._upperLeft.extents.contains(pt)) {
                        return this.findValueInSegment(this._upperLeft, pt);
                    }
                }
            }
            if (this._upperRight != null) {
                segmentInfo = this._upperRight;
                synchronized (segmentInfo) {
                    if (this._upperRight.extents.contains(pt)) {
                        return this.findValueInSegment(this._upperRight, pt);
                    }
                }
            }
        }
        Resolution baseRes = (Resolution)this._resolutions.get(0);
        double yoff = pt.n - this._extent.s;
        int segrow = (int)(yoff / (double)(baseRes.deltaY * (float)this._rowsInASegment));
        double xoff = pt.e - this._extent.w;
        int segcol = (int)(xoff / (double)(baseRes.deltaX * (float)this._colsInASegment));
        int segidx = segrow * baseRes.segmentsWide + segcol;
        if (segidx >= baseRes.segments.size()) {
            return (float)this.getNoDataValue();
        }
        SegmentInfo si = (SegmentInfo)baseRes.segments.get(segidx);
        xoff = pt.e - si.extents.w;
        yoff = pt.n - si.extents.s;
        int col = (int)(xoff / (double)baseRes.deltaX);
        int row = (int)(yoff / (double)baseRes.deltaY);
        long segbytes = si.index * this._colsInASegment * this._rowsInASegment * 4;
        long cellbytes = (row * this._colsInASegment + col) * 4;
        long skip = this._endOfHeader + segbytes + cellbytes;
        HecFile file = this._mapId.getFile();
        try {
            byte[] floatbytes = file.getByteArray((int)skip, 4);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(floatbytes));
            float f = in.readFloat();
            in.close();
            return f;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
            return (float)this.getNoDataValue();
        }
    }

    private float findValueInSegment(SegmentInfo si, WorldPt pt) {
        return this.findValueInSegment(si, this._currentRes, pt.n, pt.e);
    }

    private float findValueInSegment(SegmentInfo si, Resolution resolution, double northing, double easting) {
        double xoff = easting - si.extents.w;
        double yoff = northing - si.extents.s;
        int col = (int)(xoff / (double)resolution.deltaX);
        int row = (int)(yoff / (double)resolution.deltaY);
        int cell = row * this._colsInASegment + col;
        return si.segData.getValue(0, cell);
    }

    private void populateSegmentPool() {
        SegmentData sd1 = this.buildSegment();
        SegmentData sd2 = this.buildSegment();
        SegmentData sd3 = this.buildSegment();
        SegmentData sd4 = this.buildSegment();
        this.returnSegment(sd1);
        this.returnSegment(sd2);
        this.returnSegment(sd3);
        this.returnSegment(sd4);
    }

    protected SegmentData buildSegment() {
        SegmentData sd = null;
        if (this._segmentDataPool.size() < 1) {
            sd = new MapSegmentData(this._numParameters, this._rowsInASegment, this._colsInASegment, this._noDataValue);
        } else {
            sd = (SegmentData)this._segmentDataPool.remove(0);
            for (Object key : this._segHash.keySet()) {
                Object val = this._segHash.get(key);
                if (val != sd) continue;
                this._segHash.remove(key);
                break;
            }
        }
        return sd;
    }

    private boolean buildSegment(SegmentInfo si) {
        SegmentData sd = (SegmentData)this._segHash.get(si);
        if (sd != null) {
            si.segData = sd;
            this._segmentDataPool.remove(sd);
            this._segHash.remove(si);
            return true;
        }
        si.segData = sd = this.buildSegment();
        return false;
    }

    protected void returnSegment(SegmentData sd) {
        if (sd == null) {
            return;
        }
        if (this._segmentDataPool.size() < 4) {
            this._segmentDataPool.add(sd);
        } else {
            sd = null;
        }
    }

    protected void returnSegment(SegmentInfo si) {
        if (si == null || si.segData == null) {
            return;
        }
        if (this._segmentDataPool.size() < 4) {
            if (!si.loading) {
                this._segHash.put(si, si.segData);
            }
            this.returnSegment(si.segData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList loadArea(WorldRect area, Observer observer) {
        SegmentInfo segmentInfo;
        int idx;
        if (!this.getExtent().intersects(area)) {
            System.err.println("Area not contained in this map.");
            return null;
        }
        boolean foundHashedData = false;
        SegmentInfo sw = null;
        SegmentInfo nw = null;
        SegmentInfo se = null;
        SegmentInfo ne = null;
        Resolution r = null;
        int sRow = -1;
        int nRow = -1;
        int eCol = -1;
        int wCol = -1;
        if (area.contains(this.getExtent())) {
            r = (Resolution)this._resolutions.get(this._resolutions.size() - 1);
            sRow = 0;
            wCol = 0;
            nRow = r.segmentsHigh - 1;
            eCol = r.segmentsWide - 1;
        } else {
            for (int ii = 0; ii < this._resolutions.size(); ++ii) {
                r = (Resolution)this._resolutions.get(ii);
                float segmentWidth = r.deltaX * (float)this._colsInASegment;
                float segmentHeight = r.deltaY * (float)this._rowsInASegment;
                if (!((double)segmentWidth > area.width()) || !((double)segmentHeight > area.height())) continue;
                System.err.println("Using resolution: " + ii);
                break;
            }
            sRow = (int)((area.s - (double)this._lowerLeftY) / (double)(r.deltaY * (float)this._rowsInASegment));
            nRow = (int)((area.n - (double)this._lowerLeftY) / (double)(r.deltaY * (float)this._rowsInASegment));
            wCol = (int)((area.w - (double)this._lowerLeftX) / (double)(r.deltaX * (float)this._colsInASegment));
            eCol = (int)((area.e - (double)this._lowerLeftX) / (double)(r.deltaX * (float)this._colsInASegment));
        }
        System.err.println("sRow: " + sRow + "  nRow: " + nRow + "  wCol: " + wCol + "  eCol: " + eCol);
        if (nRow >= r.segmentsHigh && sRow < r.segmentsHigh) {
            nRow = r.segmentsHigh - 1;
        }
        if (sRow < 0 && nRow >= 0) {
            sRow = 0;
        }
        if (eCol >= r.segmentsWide && wCol < r.segmentsWide) {
            eCol = r.segmentsWide - 1;
        }
        if (wCol < 0 && eCol >= 0) {
            wCol = 0;
        }
        if (sRow >= 0 && sRow < r.segmentsHigh && wCol >= 0 && wCol < r.segmentsWide) {
            idx = sRow * r.segmentsWide + wCol;
            sw = (SegmentInfo)r.segments.get(idx);
            if (sw.index != idx) {
                System.err.println("Segment index does not match array index.");
            }
        }
        if (nRow >= 0 && nRow < r.segmentsHigh && wCol >= 0 && wCol < r.segmentsWide) {
            idx = nRow * r.segmentsWide + wCol;
            nw = (SegmentInfo)r.segments.get(idx);
            if (nw.index != idx) {
                System.err.println("Segment index does not match array index.");
            }
        }
        if (sRow >= 0 && sRow < r.segmentsHigh && eCol >= 0 && eCol < r.segmentsWide) {
            idx = sRow * r.segmentsWide + eCol;
            se = (SegmentInfo)r.segments.get(idx);
            if (se.index != idx) {
                System.err.println("Segment index does not match array index.");
            }
        }
        if (nRow >= 0 && nRow < r.segmentsHigh && eCol >= 0 && eCol < r.segmentsWide) {
            idx = nRow * r.segmentsWide + eCol;
            ne = (SegmentInfo)r.segments.get(idx);
            if (ne.index != idx) {
                System.err.println("Segment index does not match array index.");
            }
        }
        boolean resChanged = false;
        if (r != this._currentRes) {
            resChanged = true;
            this._currentRes = r;
        }
        if (resChanged) {
            if (this._lowerLeft != null) {
                SegmentInfo segmentWidth = this._lowerLeft;
                synchronized (segmentWidth) {
                    this.returnSegment(this._lowerLeft);
                    this._lowerLeft.segData = null;
                    this._lowerLeft.notify();
                }
                this._lowerLeft = null;
            }
            if (this._lowerRight != null) {
                SegmentInfo segmentWidth = this._lowerRight;
                synchronized (segmentWidth) {
                    this.returnSegment(this._lowerRight);
                    this._lowerRight.segData = null;
                    this._lowerRight.notify();
                }
                this._lowerRight = null;
            }
            if (this._upperLeft != null) {
                SegmentInfo segmentWidth = this._upperLeft;
                synchronized (segmentWidth) {
                    this.returnSegment(this._upperLeft);
                    this._upperLeft.segData = null;
                    this._upperLeft.notify();
                }
                this._upperLeft = null;
            }
            if (this._upperRight != null) {
                SegmentInfo segmentWidth = this._upperRight;
                synchronized (segmentWidth) {
                    this.returnSegment(this._upperRight);
                    this._upperRight.segData = null;
                    this._upperRight.notify();
                }
                this._upperRight = null;
            }
        } else {
            if (this._lowerLeft != null && this._lowerLeft != sw && this._lowerLeft != se && this._lowerLeft != nw && this._lowerLeft != ne) {
                SegmentInfo segmentWidth = this._lowerLeft;
                synchronized (segmentWidth) {
                    this.returnSegment(this._lowerLeft);
                    this._lowerLeft.segData = null;
                    this._lowerLeft.notify();
                }
                this._lowerLeft = null;
            }
            if (this._lowerRight != null && this._lowerRight != sw && this._lowerRight != se && this._lowerRight != nw && this._lowerRight != ne) {
                SegmentInfo segmentWidth = this._lowerRight;
                synchronized (segmentWidth) {
                    this.returnSegment(this._lowerRight);
                    this._lowerRight.segData = null;
                    this._lowerRight.notify();
                }
                this._lowerRight = null;
            }
            if (this._upperLeft != null && this._upperLeft != sw && this._upperLeft != se && this._upperLeft != nw && this._upperLeft != ne) {
                SegmentInfo segmentWidth = this._upperLeft;
                synchronized (segmentWidth) {
                    this.returnSegment(this._upperLeft);
                    this._upperLeft.segData = null;
                    this._upperLeft.notify();
                }
                this._upperLeft = null;
            }
            if (this._upperRight != null && this._upperRight != sw && this._upperRight != se && this._upperRight != nw && this._upperRight != ne) {
                SegmentInfo segmentWidth = this._upperRight;
                synchronized (segmentWidth) {
                    this.returnSegment(this._upperRight);
                    this._upperRight.segData = null;
                    this._upperRight.notify();
                }
                this._upperRight = null;
            }
        }
        ArrayList<SegmentInfo> segLoadList = new ArrayList<SegmentInfo>(4);
        ArrayList<SegmentInfo> segFoundList = new ArrayList<SegmentInfo>(4);
        if (sw != null) {
            if (sw.segData == null) {
                segmentInfo = sw;
                synchronized (segmentInfo) {
                    if (!this.buildSegment(sw)) {
                        sw.loading = true;
                        segLoadList.add(sw);
                    } else {
                        foundHashedData = true;
                        segFoundList.add(sw);
                    }
                    sw.notify();
                }
            } else {
                segFoundList.add(sw);
            }
            this._lowerLeft = sw;
        } else {
            this._lowerLeft = null;
        }
        if (se != null && se != sw) {
            if (se.segData == null) {
                segmentInfo = se;
                synchronized (segmentInfo) {
                    if (!this.buildSegment(se)) {
                        se.loading = true;
                        segLoadList.add(se);
                    } else {
                        foundHashedData = true;
                        segFoundList.add(se);
                    }
                    se.notify();
                }
            } else {
                segFoundList.add(se);
            }
            this._lowerRight = se;
        } else {
            this._lowerRight = null;
        }
        if (nw != null && nw != sw) {
            if (nw.segData == null) {
                segmentInfo = nw;
                synchronized (segmentInfo) {
                    if (!this.buildSegment(nw)) {
                        nw.loading = true;
                        segLoadList.add(nw);
                    } else {
                        foundHashedData = true;
                        segFoundList.add(nw);
                    }
                    nw.notify();
                }
            } else {
                segFoundList.add(nw);
            }
            this._upperLeft = nw;
        } else {
            this._upperLeft = null;
        }
        if (ne != null && ne != sw && ne != nw && ne != se) {
            if (ne.segData == null) {
                segmentInfo = ne;
                synchronized (segmentInfo) {
                    if (!this.buildSegment(ne)) {
                        ne.loading = true;
                        segLoadList.add(ne);
                    } else {
                        foundHashedData = true;
                        segFoundList.add(ne);
                    }
                    ne.notify();
                }
            } else {
                segFoundList.add(ne);
            }
            this._upperRight = ne;
        } else {
            this._upperRight = null;
        }
        if (segLoadList.size() > 0) {
            this.loadSegments(this._currentRes, segLoadList, observer);
        }
        return segFoundList;
    }

    public long getEndOfHeader() {
        return this._endOfHeader;
    }

    public List getResolutions() {
        return Collections.unmodifiableList(this._resolutions);
    }

    private synchronized void loadSegments(Resolution res, ArrayList segLoadList, Observer o) {
        SegmentLoader loader = new SegmentLoader(this, res, segLoadList, o);
        if (this._segLoaderThread != null) {
            loader.joinOnThread(this._segLoaderThread);
        }
        this._segLoaderThread = new Thread(loader);
        this._segLoaderThread.setPriority(Thread.currentThread().getPriority() - 1);
        this._segLoaderThread.start();
        this.notify();
    }

    @Override
    public void unload() {
        this.init();
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            HecFile file = this._mapId.getFile();
            if (file == null) {
                Identifier id = this.openFile(this._mapId);
                if (id != null) {
                    file = id.getFile();
                    this._mapId.setFile(file);
                } else {
                    return;
                }
            }
            this.readHeader(file);
            this._loaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readHeader(HecFile file) throws IOException {
        int bytesRead = 0;
        try (DataInputStream in = null;){
            int ii;
            in = file.getDataInputStream();
            byte[] bytes = new byte[160];
            bytesRead += in.read(bytes);
            this._name = new String(bytes).trim();
            bytesRead += in.read(bytes);
            this._version = new String(bytes).trim();
            if (this._version.equals(VERSION_CONTINUOUS_ONLY)) {
                this._dataType = 10;
            } else if (this._version.equals(VERSION)) {
                this._dataType = in.readInt();
                bytesRead += 4;
            }
            this._numTimes = in.readInt();
            bytesRead += 4;
            this._times = new long[this._numTimes];
            for (ii = 0; ii < this._numTimes; ++ii) {
                this._times[ii] = in.readLong();
                bytesRead += 8;
            }
            this._numParameters = in.readInt();
            bytesRead += 4;
            this._parameterNames = new String[this._numParameters];
            this._parameterUnits = new String[this._numParameters];
            this._minValues = new float[this._numParameters];
            this._maxValues = new float[this._numParameters];
            for (ii = 0; ii < this._numParameters; ++ii) {
                bytesRead += in.read(bytes);
                this._parameterNames[ii] = new String(bytes).trim();
                bytesRead += in.read(bytes);
                this._parameterUnits[ii] = new String(bytes).trim();
                this._minValues[ii] = in.readFloat();
                bytesRead += 4;
                this._maxValues[ii] = in.readFloat();
                bytesRead += 4;
            }
            this._lowerLeftX = in.readFloat();
            bytesRead += 4;
            this._lowerLeftY = in.readFloat();
            bytesRead += 4;
            this._axisRotation = in.readFloat();
            bytesRead += 4;
            this._noDataValue = in.readFloat();
            bytesRead += 4;
            this._rowsInASegment = in.readInt();
            bytesRead += 4;
            this._colsInASegment = in.readInt();
            bytesRead += 4;
            this._resampleRatio = in.readInt();
            bytesRead += 4;
            int numResolutions = in.readInt();
            bytesRead += 4;
            this._resolutions.clear();
            Resolution[] r = new Resolution[numResolutions];
            for (int ii2 = 0; ii2 < numResolutions; ++ii2) {
                int totalRowCount = in.readInt();
                bytesRead += 4;
                int totalColCount = in.readInt();
                bytesRead += 4;
                float deltaX = in.readFloat();
                bytesRead += 4;
                float deltaY = in.readFloat();
                bytesRead += 4;
                r[ii2] = new Resolution(this, totalColCount, totalRowCount, deltaX, deltaY, ii2);
            }
            this._resolutions.addAll(Arrays.asList(r));
            this._endOfHeader = bytesRead;
            float width = (float)r[0].totalColCount * r[0].deltaX;
            float rightSide = this._lowerLeftX + width;
            float height = (float)r[0].totalRowCount * r[0].deltaY;
            float topSide = this._lowerLeftY + height;
            this._extent = new WorldRect(this._lowerLeftX, topSide, rightSide, this._lowerLeftY);
            this.populateSegmentPool();
        }
    }

    protected void writeHeader(HecFile file) throws IOException {
        DataOutputStream out = file.getDataOutputStream();
        this.writeHeader(out);
        out.close();
    }

    protected void writeHeader(DataOutputStream out) throws IOException {
        int ii;
        int bytesWritten = 0;
        byte[] bytes = new byte[160];
        byte[] strBytes = this._name.getBytes();
        System.arraycopy(strBytes, 0, bytes, 0, strBytes.length);
        out.write(bytes);
        bytesWritten += bytes.length;
        strBytes = this._version.getBytes();
        Arrays.fill(bytes, strBytes.length, bytes.length - 1, (byte)0);
        System.arraycopy(strBytes, 0, bytes, 0, strBytes.length);
        out.write(bytes);
        bytesWritten += bytes.length;
        out.writeInt(this._dataType);
        bytesWritten += 4;
        out.writeInt(this._numTimes);
        bytesWritten += 4;
        for (ii = 0; ii < this._numTimes; ++ii) {
            out.writeLong(this._times[ii]);
            bytesWritten += 8;
        }
        out.writeInt(this._numParameters);
        bytesWritten += 4;
        for (ii = 0; ii < this._numParameters; ++ii) {
            strBytes = this._parameterNames[ii].getBytes();
            Arrays.fill(bytes, strBytes.length, bytes.length - 1, (byte)0);
            System.arraycopy(strBytes, 0, bytes, 0, strBytes.length);
            out.write(bytes);
            bytesWritten += bytes.length;
            strBytes = this._parameterUnits[ii].getBytes();
            Arrays.fill(bytes, strBytes.length, bytes.length - 1, (byte)0);
            System.arraycopy(strBytes, 0, bytes, 0, strBytes.length);
            out.write(bytes);
            bytesWritten += bytes.length;
            out.writeFloat(this._minValues[ii]);
            bytesWritten += 4;
            out.writeFloat(this._maxValues[ii]);
            bytesWritten += 4;
        }
        out.writeFloat(this._lowerLeftX);
        bytesWritten += 4;
        out.writeFloat(this._lowerLeftY);
        bytesWritten += 4;
        out.writeFloat(this._axisRotation);
        bytesWritten += 4;
        out.writeFloat(this._noDataValue);
        bytesWritten += 4;
        out.writeInt(this._rowsInASegment);
        bytesWritten += 4;
        out.writeInt(this._colsInASegment);
        bytesWritten += 4;
        out.writeInt(this._resampleRatio);
        bytesWritten += 4;
        out.writeInt(this._resolutions.size());
        bytesWritten += 4;
        for (ii = 0; ii < this._resolutions.size(); ++ii) {
            out.writeInt(((Resolution)this._resolutions.get((int)ii)).totalRowCount);
            bytesWritten += 4;
            out.writeInt(((Resolution)this._resolutions.get((int)ii)).totalColCount);
            bytesWritten += 4;
            out.writeFloat(((Resolution)this._resolutions.get((int)ii)).deltaX);
            bytesWritten += 4;
            out.writeFloat(((Resolution)this._resolutions.get((int)ii)).deltaY);
            bytesWritten += 4;
        }
        this._endOfHeader = bytesWritten;
    }

    public static RasterMap importMap(RasterImportProgressIndicator progress, FileOpener fileOpener, int typeOfData, AiDemBaseMap map) throws IOException {
        String[] params = new String[]{Parameter.getParamString(-1)};
        String[] units = new String[]{"undef"};
        AiDemBaseMap[] maps = new AiDemBaseMap[]{map};
        String path = map.getMapIdentifier().getPath();
        int idx = path.lastIndexOf(".");
        if (idx < 0) {
            return null;
        }
        String rasterPath = path.substring(0, idx) + EXTENSION;
        Identifier requestId = new Identifier(rasterPath);
        Identifier rasterId = fileOpener.openFile(requestId, false);
        if (rasterId == null) {
            rasterId = fileOpener.createFile(requestId);
        }
        return RasterMap.importMap(progress, rasterId, map.getName(), typeOfData, params, units, maps);
    }

    public static RasterMap importMap(RasterImportProgressIndicator progress, Identifier smrmpId, String mapName, int dataType, String[] params, String[] units, AiDemBaseMap[] maps) throws IOException {
        int ii;
        if (maps.length < 1) {
            return null;
        }
        HecFile smrmpFile = smrmpId.getFile();
        MapIdentifier mapid = new MapIdentifier(smrmpId);
        RasterMap rastermap = new RasterMap(mapid);
        WorldRect ext = null;
        double resX = Double.NEGATIVE_INFINITY;
        double resY = Double.NEGATIVE_INFINITY;
        for (ii = 0; ii < maps.length; ++ii) {
            maps[ii].loadHeader();
            if (ext == null) {
                ext = maps[ii].getExtent();
                continue;
            }
            if (resX == Double.NEGATIVE_INFINITY) {
                resX = maps[ii].getResolutionX();
                resY = maps[ii].getResolutionY();
            }
            if (!ext.equals(maps[ii].getExtent())) {
                RMAIO.postError(progress, "Map, " + maps[ii].getMapIdentifier().getName() + ", does not have matching extents.");
                return null;
            }
            if (maps[ii].getResolutionX() == resX && maps[ii].getResolutionY() == resY) continue;
            RMAIO.postError(progress, "Map, " + maps[ii].getMapIdentifier().getName() + ", does not have matching resolution.");
            return null;
        }
        for (int i = 0; i < maps.length; ++i) {
            if (rastermap._extent == null) {
                rastermap._extent = new WorldRect();
            }
            rastermap._extent.grow(maps[i].getExtent());
        }
        rastermap._extent = maps[0].getExtent();
        rastermap._lowerLeftX = (float)maps[0].getExtent().w;
        rastermap._lowerLeftY = (float)maps[0].getExtent().s;
        rastermap._name = "";
        rastermap._version = VERSION;
        rastermap._dataType = dataType;
        rastermap._numTimes = maps.length;
        rastermap._times = new long[maps.length];
        rastermap._numParameters = maps.length;
        rastermap._parameterNames = new String[maps.length];
        rastermap._parameterUnits = new String[maps.length];
        for (ii = 0; ii < params.length; ++ii) {
            rastermap._parameterNames[ii] = params[ii];
            rastermap._parameterUnits[ii] = units[ii];
        }
        rastermap._minValues = new float[maps.length];
        rastermap._maxValues = new float[maps.length];
        rastermap._axisRotation = 0.0f;
        rastermap._noDataValue = (float)maps[0].getNoDataValue();
        System.err.println("No Data Val: " + rastermap._noDataValue);
        rastermap._resampleRatio = 4;
        int ratioRoot = (int)Math.sqrt(rastermap._resampleRatio);
        int heightSplit = maps[0].getAreaHeight() / 1024;
        if (heightSplit > ratioRoot) {
            if (heightSplit % ratioRoot != 0) {
                heightSplit = heightSplit + ratioRoot - heightSplit % ratioRoot;
            } else if (heightSplit % rastermap._resampleRatio > 0) {
                heightSplit = heightSplit + rastermap._resampleRatio - heightSplit % rastermap._resampleRatio;
            }
        }
        if (heightSplit < 1) {
            heightSplit = 1;
        }
        int height = maps[0].getAreaHeight() / heightSplit;
        int mod = maps[0].getAreaHeight() % heightSplit;
        if (mod > 0) {
            height += heightSplit - mod;
        }
        if ((mod = height % ratioRoot) > 0) {
            height += ratioRoot - mod;
        }
        rastermap._rowsInASegment = height;
        int widthSplit = maps[0].getAreaWidth() / 1280;
        if (widthSplit > ratioRoot) {
            if (widthSplit % ratioRoot != 0) {
                widthSplit = widthSplit + ratioRoot - widthSplit % ratioRoot;
            }
            if (widthSplit % rastermap._resampleRatio > 0) {
                widthSplit = widthSplit + rastermap._resampleRatio - widthSplit % rastermap._resampleRatio;
            }
        }
        if (widthSplit < 1) {
            widthSplit = 1;
        }
        int width = maps[0].getAreaWidth() / widthSplit;
        mod = maps[0].getAreaWidth() % widthSplit;
        if (mod > 0) {
            width += widthSplit - mod;
        }
        if ((mod = width % ratioRoot) > 0) {
            width += rastermap._resampleRatio - mod;
        }
        rastermap._colsInASegment = width;
        System.out.println("Segment width x height: " + rastermap._colsInASegment + " x " + rastermap._rowsInASegment);
        int segmentsWide = maps[0].getAreaWidth() / rastermap._colsInASegment;
        if (maps[0].getAreaWidth() % rastermap._colsInASegment > 0) {
            ++segmentsWide;
        }
        int segmentsHigh = maps[0].getAreaHeight() / rastermap._rowsInASegment;
        if (maps[0].getAreaHeight() % rastermap._rowsInASegment > 0) {
            ++segmentsHigh;
        }
        Resolution res = new Resolution(rastermap, segmentsWide * rastermap._colsInASegment, segmentsHigh * rastermap._rowsInASegment, (float)maps[0].getResolutionX(), (float)maps[0].getResolutionY(), 0);
        rastermap._resolutions.add(res);
        int numProgressUpdates = res.getSegmentCount();
        while (!(progress != null && progress.isCanceled() || res.segmentsWide <= 1 && res.segmentsHigh <= 1)) {
            res = res.resample(rastermap._resampleRatio);
            rastermap._resolutions.add(res);
            numProgressUpdates += res.getSegmentCount();
        }
        for (int ii2 = 0; ii2 < rastermap._resolutions.size() && progress != null && !progress.isCanceled(); ++ii2) {
            Resolution r = (Resolution)rastermap._resolutions.get(ii2);
            System.err.println("Resolution #" + ii2 + " sw,sh: " + r.segmentsWide + "," + r.segmentsHigh + " r.bytes: " + r.numBytes);
        }
        for (int mm = 0; mm < maps.length && progress != null && !progress.isCanceled(); ++mm) {
            rastermap._parameterNames[mm] = params[mm];
            rastermap._parameterUnits[mm] = units[mm];
            rastermap._minValues[mm] = (float)maps[mm].getMinimumElevation();
            rastermap._maxValues[mm] = (float)maps[mm].getMaximumElevation();
        }
        if (progress != null) {
            progress.setNumProgressUpdates(numProgressUpdates);
        }
        if (progress != null && progress.isCanceled()) {
            return null;
        }
        rastermap.writeHeader(smrmpFile);
        rastermap.segmentAndResample(rastermap, progress, smrmpFile, maps);
        if (progress != null && progress.isCanceled()) {
            return null;
        }
        return rastermap;
    }

    private void segmentAndResample(RasterMap rastermap, RasterImportProgressIndicator progress, HecFile smrpFile, AiDemBaseMap[] maps) throws IOException {
        int percentageDone = 10;
        int mapColWidth = maps[0].getAreaWidth();
        int mapRowHeight = maps[0].getAreaHeight();
        Resolution res = (Resolution)this._resolutions.get(0);
        if (res == null) {
            return;
        }
        SegmentData sd = this.buildSegment();
        System.err.println("Writing Base Resolution");
        long t0 = System.currentTimeMillis();
        DataOutputStream out = smrpFile.getAppendedDataOutputStream();
        for (int segRow = 0; segRow < res.segmentsHigh; ++segRow) {
            for (int segCol = 0; segCol < res.segmentsWide; ++segCol) {
                sd.initialize();
                for (int mm = 0; mm < maps.length; ++mm) {
                    if (progress != null && progress.isCanceled()) {
                        return;
                    }
                    int colstart = segCol * this._colsInASegment;
                    int icnt = this._colsInASegment;
                    if (colstart + this._colsInASegment >= mapColWidth) {
                        icnt = mapColWidth - colstart;
                    }
                    for (int isrow = 0; isrow < this._rowsInASegment; ++isrow) {
                        int row = segRow * this._rowsInASegment + isrow;
                        if (row >= mapRowHeight) {
                            for (int segidx = isrow * this._colsInASegment; segidx < (isrow + 1) * this._colsInASegment; ++segidx) {
                                sd.setValue(mm, segidx, this._noDataValue);
                            }
                            continue;
                        }
                        long segmentStartPos = isrow * this._colsInASegment;
                        long mapRowHeightLong = mapRowHeight;
                        long mapColWidthLong = mapColWidth;
                        long rowLong = row;
                        long colStartLong = colstart;
                        long mapStartPos = (mapRowHeightLong - 1L - rowLong) * mapColWidthLong + colStartLong;
                        maps[mm].fillArray(sd.getValues(mm), segmentStartPos, mapStartPos, icnt);
                        for (int zz = 0; zz < icnt; ++zz) {
                            float value = sd.getValue(mm, (int)segmentStartPos + zz);
                            if (value == this._noDataValue) continue;
                            if (!RMAConst.isValidValue(rastermap._minValues[mm])) {
                                rastermap._minValues[mm] = value;
                            }
                            if (!RMAConst.isValidValue(rastermap._maxValues[mm])) {
                                rastermap._maxValues[mm] = value;
                            }
                            if (value < rastermap._minValues[mm]) {
                                rastermap._minValues[mm] = value;
                            }
                            if (!(value > rastermap._maxValues[mm])) continue;
                            rastermap._maxValues[mm] = value;
                        }
                        if (icnt >= this._colsInASegment) continue;
                        for (int segidx = isrow * this._colsInASegment + icnt; segidx < (isrow + 1) * this._colsInASegment; ++segidx) {
                            sd.setValue(mm, segidx, this._noDataValue);
                        }
                    }
                }
                sd.write(out);
                if (progress == null) continue;
                progress.incrementProgress();
            }
        }
        out.close();
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        this.writeHeader(ds);
        ds.close();
        byte[] newHeader = bs.toByteArray();
        smrpFile.writeBytes(0L, newHeader);
        long t1 = System.currentTimeMillis();
        System.err.println("\nBase Resolution Written in: " + (t1 - t0) + " ms. File size: " + smrpFile.length());
        Resolution readRes = res;
        this.returnSegment(sd);
        SegmentData readSeg = this.buildSegment();
        SegmentData writeSeg = this.buildSegment();
        long bytesToReadRes = this._endOfHeader;
        for (int ii = 1; ii < this._resolutions.size(); ++ii) {
            System.err.println("Writing Resolution #" + ii + ". Reading from byte: " + Long.toString(bytesToReadRes));
            Resolution writeRes = (Resolution)this._resolutions.get(ii);
            this.resampleAndWrite(progress, smrpFile, readRes, readSeg, writeRes, writeSeg, bytesToReadRes);
            if (progress != null && progress.isCanceled()) {
                return;
            }
            bytesToReadRes += readRes.numBytes;
            readRes = writeRes;
            long t2 = System.currentTimeMillis();
            System.err.println("Resolution #" + ii + " Written in: " + (t2 - t1) + " ms. File size: " + smrpFile.length());
            t1 = t2;
        }
        this.returnSegment(readSeg);
        this.returnSegment(writeSeg);
    }

    private void resampleAndWrite(RasterImportProgressIndicator progress, HecFile smrmpFile, Resolution readRes, SegmentData readSeg, Resolution writeRes, SegmentData writeSeg, long bytesToReadRes) throws IOException {
        long bytesInASegment = writeSeg.getNumberParameters() * writeSeg.getNumberRows() * writeSeg.getNumberColumns() * 4;
        long ratioRoot = (long)Math.sqrt(this._resampleRatio);
        long numCol = (long)this._colsInASegment / ratioRoot;
        long numRow = (long)this._rowsInASegment / ratioRoot;
        int[] catCount = new int[this._resampleRatio];
        float[] catVal = new float[this._resampleRatio];
        DataInputStream in = null;
        writeSeg.initialize();
        DataOutputStream out = smrmpFile.getAppendedDataOutputStream();
        smrmpFile.unlockFile(new FileLock(" ", 5));
        for (long row = 0L; row < (long)writeRes.segmentsHigh; ++row) {
            for (long col = 0L; col < (long)writeRes.segmentsWide; ++col) {
                long rowLimit = ratioRoot;
                for (long sr = 0L; sr < rowLimit; ++sr) {
                    long prevResRow = row * ratioRoot + sr;
                    if (prevResRow >= (long)readRes.segmentsHigh) continue;
                    long colLimit = ratioRoot;
                    int sc = 0;
                    while ((long)sc < colLimit) {
                        if (progress != null && progress.isCanceled()) {
                            return;
                        }
                        long prevResCol = col * ratioRoot + (long)sc;
                        if (prevResCol < (long)readRes.segmentsWide) {
                            in = smrmpFile.getDataInputStream();
                            long prevResRowLong = prevResRow;
                            long segmentsWideLong = readRes.segmentsWide;
                            long prevResColLong = prevResCol;
                            long bytesToReadSeg = (prevResRow * (long)readRes.segmentsWide + prevResCol) * bytesInASegment;
                            long skipValue = bytesToReadRes + bytesToReadSeg;
                            System.out.println("Resample row=" + row + " col=" + col + " sr=" + sr + " sc=" + sc + " ratioroot=" + ratioRoot + " bytesInSegment=" + bytesInASegment + " ReadRes.SegmentWide=" + readRes.segmentsWide + "bytesToReadRes=" + bytesToReadRes + " bytesToReadSeg=" + bytesToReadSeg + " skipValue=" + skipValue);
                            long actSkipValue = in.skip(skipValue);
                            if (actSkipValue != skipValue) {
                                System.out.println("Bad Skip  Skip Value=" + skipValue + ", Actual Skip Value=" + actSkipValue);
                            }
                            readSeg.initialize();
                            readSeg.read(in);
                            in.close();
                            int k = 0;
                            while ((long)k < numRow) {
                                long wr = sr * numRow + (long)k;
                                int l = 0;
                                while ((long)l < numCol) {
                                    long wc = (long)sc * numCol + (long)l;
                                    int undefinedVals = 0;
                                    int writeSegIdx = (int)(wr * (long)this._colsInASegment + wc);
                                    for (int paramIdx = 0; paramIdx < writeSeg.getNumberParameters(); ++paramIdx) {
                                        int readSegIdx;
                                        int j;
                                        int i;
                                        if (this._dataType == 10) {
                                            writeSeg.setValue(paramIdx, writeSegIdx, 0.0f);
                                            i = 0;
                                            while ((long)i < ratioRoot) {
                                                j = 0;
                                                while ((long)j < ratioRoot) {
                                                    readSegIdx = (int)(((long)k * ratioRoot + (long)i) * (long)this._colsInASegment + ((long)l * ratioRoot + (long)j));
                                                    if (readSeg.getValue(paramIdx, readSegIdx) != this._noDataValue) {
                                                        float v = writeSeg.getValue(paramIdx, writeSegIdx) + readSeg.getValue(paramIdx, readSegIdx);
                                                        writeSeg.setValue(paramIdx, writeSegIdx, v);
                                                    } else {
                                                        ++undefinedVals;
                                                    }
                                                    ++j;
                                                }
                                                ++i;
                                            }
                                            if ((float)undefinedVals >= (float)this._resampleRatio * 0.75f) {
                                                writeSeg.setValue(paramIdx, writeSegIdx, this._noDataValue);
                                                continue;
                                            }
                                            float v = writeSeg.getValue(paramIdx, writeSegIdx) / (float)(this._resampleRatio - undefinedVals);
                                            writeSeg.setValue(paramIdx, writeSegIdx, v);
                                            continue;
                                        }
                                        if (this._dataType != 11) continue;
                                        for (int cc = 0; cc < catCount.length; ++cc) {
                                            catCount[cc] = 0;
                                            catVal[cc] = this._noDataValue;
                                        }
                                        writeSeg.setValue(paramIdx, writeSegIdx, this._noDataValue);
                                        i = 0;
                                        while ((long)i < ratioRoot) {
                                            j = 0;
                                            while ((long)j < ratioRoot) {
                                                readSegIdx = (int)(((long)k * ratioRoot + (long)i) * (long)this._colsInASegment + ((long)l * ratioRoot + (long)j));
                                                if (readSeg.getValue(paramIdx, readSegIdx) == this._noDataValue) {
                                                    ++undefinedVals;
                                                } else {
                                                    for (int cc = 0; cc < catCount.length; ++cc) {
                                                        if (catCount[cc] < 1) {
                                                            catVal[cc] = readSeg.getValue(paramIdx, readSegIdx);
                                                            int n = cc;
                                                            catCount[n] = catCount[n] + 1;
                                                            continue;
                                                        }
                                                        if (catVal[cc] != readSeg.getValue(paramIdx, readSegIdx)) continue;
                                                        int n = cc;
                                                        catCount[n] = catCount[n] + 1;
                                                    }
                                                }
                                                ++j;
                                            }
                                            ++i;
                                        }
                                        if (!((float)undefinedVals < (float)this._resampleRatio * 0.75f)) continue;
                                        int highIdx = 0;
                                        for (int cc = 0; cc < catVal.length; ++cc) {
                                            if (catCount[cc] <= catCount[highIdx]) continue;
                                            highIdx = cc;
                                        }
                                        writeSeg.setValue(paramIdx, writeSegIdx, catVal[highIdx]);
                                    }
                                    ++l;
                                }
                                ++k;
                            }
                        }
                        ++sc;
                    }
                }
                writeSeg.write(out);
                writeSeg.initialize();
                if (progress == null) continue;
                progress.incrementProgress();
            }
        }
        out.close();
        System.err.print("\n");
    }

    public WorldPt getLowerLeftCorner() {
        return new WorldPt(this._lowerLeftX, this._lowerLeftY);
    }
}

