/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.map.WorldPt;
import hec.map.raster.RasterMap;
import hec.map.raster.Resolution;
import hec.map.raster.SegmentData;
import hec.map.raster.SegmentInfo;
import hec.map.raster.SegmentLoader;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class RasterSegmentIterator {
    RasterMap _map;
    SegmentData _segmentData;
    Resolution _baseResolution;
    SegmentInfo _currentSegment;
    int _segmentIndex = 0;
    int _arrayIndex = -1;
    int _layerIndex = 0;

    public RasterSegmentIterator(RasterMap map) {
        this._map = map;
        this._segmentData = map.buildSegment();
        this._baseResolution = this._map.getBaseResolution();
        this._currentSegment = this._baseResolution.getSegmentInfo(this._segmentIndex);
        this.loadSegment();
    }

    public boolean hasNext() {
        if (this._segmentIndex < this._baseResolution.getSegmentCount() - 1) {
            return true;
        }
        int length = this._segmentData.getNumberColumns() * this._segmentData.getNumberRows();
        return this._arrayIndex < length - 1;
    }

    public boolean hasPrevious() {
        if (this._segmentIndex > 0) {
            return true;
        }
        return this._arrayIndex > 0;
    }

    public float next() throws NoSuchElementException {
        ++this._arrayIndex;
        int length = this._segmentData.getNumberColumns() * this._segmentData.getNumberRows();
        if (this._arrayIndex >= length) {
            ++this._segmentIndex;
            if (this._segmentIndex >= this._baseResolution.getSegmentCount()) {
                throw new NoSuchElementException();
            }
            this._currentSegment.segData = null;
            this._currentSegment = this._baseResolution.getSegmentInfo(this._segmentIndex);
            this._arrayIndex = 0;
            this.loadSegment();
        }
        float val = this._segmentData.getValue(this._layerIndex, this._arrayIndex);
        return val;
    }

    public float previous() throws NoSuchElementException {
        --this._arrayIndex;
        if (this._arrayIndex < 0) {
            --this._segmentIndex;
            if (this._segmentIndex < 0) {
                throw new NoSuchElementException();
            }
            this._currentSegment.segData = null;
            this._currentSegment = this._baseResolution.getSegmentInfo(this._segmentIndex);
            this.loadSegment();
        }
        float val = this._segmentData.getValue(this._layerIndex, this._arrayIndex);
        return val;
    }

    private void loadSegment() {
        this._currentSegment.segData = this._segmentData;
        ArrayList<SegmentInfo> segLoaderList = new ArrayList<SegmentInfo>(1);
        segLoaderList.add(this._currentSegment);
        SegmentLoader loader = new SegmentLoader(this._map, this._baseResolution, segLoaderList, null);
        Thread t = new Thread(loader);
        t.start();
        try {
            t.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float current() {
        float val = this._segmentData.getValue(this._layerIndex, this._arrayIndex);
        return val;
    }

    public WorldPt getLocation() {
        int dataCol = this._arrayIndex % this._map._colsInASegment;
        int dataRow = this._arrayIndex / this._map._colsInASegment;
        int segCol = this._segmentIndex % this._baseResolution.segmentsWide;
        int segRow = this._segmentIndex / this._baseResolution.segmentsWide;
        double e = this._map.getExtent().e;
        e += (double)((float)(segCol * this._map._colsInASegment) * this._baseResolution.deltaX);
        if (this._arrayIndex >= 0) {
            e += (double)((float)dataCol * this._baseResolution.deltaX);
        }
        double n = this._map.getExtent().n;
        n += (double)((float)(segRow * this._map._rowsInASegment) * this._baseResolution.deltaY);
        if (this._arrayIndex >= 0) {
            n += (double)((float)dataRow * this._baseResolution.deltaY);
        }
        return new WorldPt(e, n);
    }
}

