/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.map.WorldRect;
import hec.map.raster.RasterMap;
import hec.map.raster.SegmentInfo;
import java.util.ArrayList;

public class Resolution {
    int totalRowCount;
    int totalColCount;
    int segmentsWide;
    int segmentsHigh;
    float deltaX;
    float deltaY;
    RasterMap map;
    long numBytes;
    int index;
    ArrayList segments = new ArrayList();

    public Resolution(RasterMap m, int c2, int r, float x, float y, int i) {
        this.set(m, c2, r, x, y, i);
    }

    public void set(RasterMap m, int c2, int r, float x, float y, int i) {
        this.map = m;
        this.totalColCount = c2;
        this.totalRowCount = r;
        this.deltaX = x;
        this.deltaY = y;
        this.index = i;
        this.segmentsWide = this.totalColCount / m._colsInASegment;
        this.segmentsHigh = this.totalRowCount / m._rowsInASegment;
        long tempSegmentsWide = this.segmentsWide;
        long tempSegmentsHigh = this.segmentsHigh;
        long tempColsInSegment = m._colsInASegment;
        long tempRowsInSegment = m._rowsInASegment;
        long tempNumParameters = m._numParameters;
        long tempBytesInFloat = 4L;
        this.numBytes = tempSegmentsWide * tempSegmentsHigh * tempColsInSegment * tempRowsInSegment * tempNumParameters * tempBytesInFloat;
        this.buildSegments();
    }

    public SegmentInfo getSegmentInfo(int idx) {
        return (SegmentInfo)this.segments.get(idx);
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    void buildSegments() {
        this.segments.clear();
        float segmentWidth = this.deltaX * (float)this.map._colsInASegment;
        float segmentHeight = this.deltaY * (float)this.map._rowsInASegment;
        WorldRect extents = null;
        for (int row = 0; row < this.segmentsHigh; ++row) {
            for (int col = 0; col < this.segmentsWide; ++col) {
                double rw = this.map._lowerLeftX + (float)col * segmentWidth;
                double rn = this.map._lowerLeftY + (float)(row + 1) * segmentHeight;
                double re = this.map._lowerLeftX + (float)(col + 1) * segmentWidth;
                double rs = this.map._lowerLeftY + (float)row * segmentHeight;
                extents = new WorldRect(rw, rn, re, rs);
                int segidx = row * this.segmentsWide + col;
                SegmentInfo si = new SegmentInfo(this.map, extents, segidx);
                this.segments.add(si);
                System.err.println("Res: " + this.index + "  Segment: " + segidx + "  " + extents);
            }
        }
    }

    public Resolution resample(int ratio) {
        int c2 = this.totalColCount / (int)Math.sqrt(ratio);
        int r = this.totalRowCount / (int)Math.sqrt(ratio);
        int sw = c2 / this.map._colsInASegment;
        int sh = r / this.map._rowsInASegment;
        if (r % this.map._rowsInASegment > 0) {
            ++sh;
        }
        if (c2 % this.map._colsInASegment > 0) {
            ++sw;
        }
        r = sh * this.map._rowsInASegment;
        c2 = sw * this.map._colsInASegment;
        Resolution res = new Resolution(this.map, c2, r, this.deltaX * (float)Math.sqrt(ratio), this.deltaY * (float)Math.sqrt(ratio), this.index + 1);
        return res;
    }
}

