/*
 * Decompiled with CFR 0.152.
 */
package hec.map.raster;

import hec.io.HecFile;
import hec.map.raster.RasterMap;
import hec.map.raster.Resolution;
import hec.map.raster.SegmentInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class SegmentLoader
extends Observable
implements Runnable {
    Resolution _res;
    List _segLoaderList;
    Thread _joinOnThread = null;
    RasterMap _map;

    public SegmentLoader(RasterMap map, Resolution res, List segLoaderList, Observer o) {
        this._map = map;
        this._res = res;
        this._segLoaderList = segLoaderList;
        if (o != null) {
            this.addObserver(o);
        }
    }

    public void joinOnThread(Thread t) {
        this._joinOnThread = t;
    }

    public void setSegmentLoaderList(List segLoaderList) {
        this._segLoaderList = segLoaderList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._joinOnThread != null) {
            try {
                this._joinOnThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FilterInputStream in = null;
        try {
            Resolution r;
            HecFile file = this._map.getMapIdentifier().getFile();
            long baseSkip = this._map.getEndOfHeader();
            List resolutions = this._map.getResolutions();
            for (int ii = 0; ii < resolutions.size() && (r = (Resolution)resolutions.get(ii)) != this._res; ++ii) {
                baseSkip += r.numBytes;
            }
            SegmentInfo si = null;
            for (int ii = 0; ii < this._segLoaderList.size(); ++ii) {
                SegmentInfo segmentInfo = si = (SegmentInfo)this._segLoaderList.get(ii);
                synchronized (segmentInfo) {
                    if (si.segData == null) {
                        si.loading = false;
                        si.notify();
                        continue;
                    }
                    try {
                        long numFloats = si.segData.getNumberParameters() * si.segData.getNumberColumns() * si.segData.getNumberRows();
                        long skip = baseSkip + (long)si.index * numFloats * 4L;
                        byte[] filebytes = file.getByteArray(skip, (int)(numFloats * 4L));
                        in = new DataInputStream(new ByteArrayInputStream(filebytes));
                        si.segData.read((DataInputStream)in);
                        in.close();
                        si.loading = false;
                        si.notify();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this._segLoaderList.remove(si);
                        this._map.returnSegment(si);
                        si.segData = null;
                        si.loading = false;
                        si.notify();
                    }
                    continue;
                }
            }
            this.setChanged();
            this.notifyObservers(this._segLoaderList);
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

