/*
 * Decompiled with CFR 0.152.
 */
package hec.map.renderer;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.renderer.CanvasRenderer;
import hec.map.renderer.FutureCallback;
import hec.map.renderer.GlyphTaskFactory;
import hec.map.renderer.GridFactory;
import hec.map.renderer.LabelsDrawFactory;
import hec.map.renderer.MapScaleImage;
import hec.map.renderer.RenderTaskFactory;
import hec.map.renderer.TracksRepaint;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public abstract class AbstractThreadedRenderer
implements CanvasRenderer {
    private static final Logger logger = Logger.getLogger(AbstractThreadedRenderer.class.getName());
    private final ExecutorService es;
    private final ConcurrentMap<RenderTaskFactory, MapScaleImage> inProgress = new ConcurrentHashMap<RenderTaskFactory, MapScaleImage>();
    private final ConcurrentMap<RenderTaskFactory, SoftReference<MapScaleImage>> completed = new ConcurrentHashMap<RenderTaskFactory, SoftReference<MapScaleImage>>();
    private Map<RenderTaskFactory, List<Integer>> timingMap = new HashMap<RenderTaskFactory, List<Integer>>();

    public AbstractThreadedRenderer(ExecutorService es) {
        this.es = es;
    }

    public AbstractThreadedRenderer() {
        this(Executors.newFixedThreadPool(5));
    }

    protected abstract List getCombinedGlyphs(MapCanvas var1);

    public static void clearScreenImage(Image image) {
        Graphics graphics = image.getGraphics();
        if (graphics instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)graphics;
            g2D.setBackground(new Color(255, 255, 255, 0));
            g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, image.getWidth(null), image.getHeight(null));
            g2D.fill(rect);
        }
        graphics.dispose();
    }

    public MapScaleImage getMapScaleImage(RenderTaskFactory factory) {
        this.possiblyMoveToComplete(factory);
        MapScaleImage retval = null;
        SoftReference weakRef = (SoftReference)this.completed.get(factory);
        if (weakRef != null && (retval = (MapScaleImage)weakRef.get()) == null) {
            logger.info("weakref returned null. " + factory);
        }
        if (retval == null) {
            retval = (MapScaleImage)this.inProgress.get(factory);
            this.possiblyMoveToComplete(factory);
        }
        return retval;
    }

    public Image getImage(MapScaleImage completedItem) {
        Image image = null;
        if (completedItem != null) {
            try {
                image = (Image)completedItem.get();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(AbstractThreadedRenderer.class.getName()).log(Level.SEVERE, null, ex);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                Logger.getLogger(AbstractThreadedRenderer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return image;
    }

    public void startFactories(Collection<RenderTaskFactory> dirtyFactories, MapScale ms) {
        ArrayList<Future> started = new ArrayList<Future>(dirtyFactories.size());
        for (RenderTaskFactory toStart : dirtyFactories) {
            this.signalCancel(toStart);
            MapScaleImage newTask = null;
            if (this.shouldRenderInBackground(toStart)) {
                newTask = toStart.buildFuture(ms);
            }
            started.add(this.cleanlyStartNew(toStart, newTask));
        }
    }

    public Future cleanlyStartNew(RenderTaskFactory item, MapScaleImage newTask) {
        Future<?> fur = null;
        if (item != null) {
            MapScaleImage existingItem = (MapScaleImage)this.inProgress.get(item);
            if (existingItem != null) {
                try {
                    existingItem.awaitActualCompletion();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AbstractThreadedRenderer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (newTask != null) {
                this.inProgress.put(item, newTask);
                fur = this.es.submit(newTask);
            }
        }
        return fur;
    }

    private List<RenderTaskFactory> buildDrawItemsForLayers(MapCanvas canvas) {
        List glyphList;
        ArrayList<RenderTaskFactory> retval = new ArrayList<RenderTaskFactory>();
        if (canvas.getDrawGrids()) {
            GridFactory runnable = new GridFactory(canvas);
            retval.add(runnable);
        }
        if ((glyphList = this.getCombinedGlyphs(canvas)) != null) {
            for (int i = 0; i < glyphList.size(); ++i) {
                MapGlyph glyph;
                Object item = glyphList.get(i);
                if (!(item instanceof MapGlyph) || !(glyph = (MapGlyph)item).isShown()) continue;
                GlyphTaskFactory factory = new GlyphTaskFactory(i, glyph, canvas);
                retval.add(factory);
            }
        }
        LabelsDrawFactory labelDraw = new LabelsDrawFactory(canvas);
        retval.add(labelDraw);
        return retval;
    }

    public List<RenderTaskFactory> possiblyInitialize(MapCanvas canvas, MapScale scale) {
        ArrayList<RenderTaskFactory> retval = new ArrayList<RenderTaskFactory>();
        retval.addAll(this.buildDrawItemsForLayers(canvas));
        return retval;
    }

    private Set<RenderTaskFactory> getDirtyFactories(List<RenderTaskFactory> factories, MapScale presentScale, MapCanvas canvas) {
        HashSet<RenderTaskFactory> needsRedraw = new HashSet<RenderTaskFactory>();
        for (RenderTaskFactory factory : factories) {
            MapScaleImage inProgressScaleImage;
            this.possiblyMoveToComplete(factory);
            MapScaleImage completedScaleImage = null;
            SoftReference weakRef = (SoftReference)this.completed.get(factory);
            if (weakRef != null) {
                completedScaleImage = (MapScaleImage)weakRef.get();
            }
            if (completedScaleImage == null) {
                needsRedraw.add(factory);
                continue;
            }
            MapGlyph glyph = null;
            if (factory instanceof GlyphTaskFactory) {
                glyph = ((GlyphTaskFactory)factory).glyph;
            }
            boolean consideredDirty = true;
            if (glyph instanceof TracksRepaint) {
                TracksRepaint tracksRepaint = (TracksRepaint)((Object)glyph);
                consideredDirty = tracksRepaint.isRepaintNeeded();
            }
            if (glyph != null && consideredDirty) {
                this.signalCancel(factory);
                this.completed.remove(factory);
                this.inProgress.remove(factory);
                if (!glyph.isShown()) continue;
                needsRedraw.add(factory);
                continue;
            }
            if (!AbstractThreadedRenderer.haveExtentsChanged(completedScaleImage.getMapScale(), presentScale) || (inProgressScaleImage = (MapScaleImage)this.inProgress.get(factory)) != null && !AbstractThreadedRenderer.haveExtentsChanged(inProgressScaleImage.getMapScale(), presentScale)) continue;
            needsRedraw.add(factory);
        }
        return needsRedraw;
    }

    public void cancelInProgress(Collection<RenderTaskFactory> dirtyFactories) {
        for (RenderTaskFactory factory : dirtyFactories) {
            this.signalCancel(factory);
        }
    }

    private void signalCancel(RenderTaskFactory factory) {
        this.possiblyMoveToComplete(factory);
        MapScaleImage task = (MapScaleImage)this.inProgress.get(factory);
        if (task != null && !task.isCancelled()) {
            boolean bl = task.cancel(true);
        }
    }

    public void possiblyMoveToComplete(RenderTaskFactory factory) {
        MapScaleImage inProgressItem = (MapScaleImage)this.inProgress.get(factory);
        if (inProgressItem != null && inProgressItem.isDone() && inProgressItem.isFinished()) {
            if (inProgressItem.isCancelled()) {
                this.inProgress.remove(factory, inProgressItem);
            } else {
                try {
                    Image image = (Image)inProgressItem.get();
                    if (image != null) {
                        this.completed.put(factory, new SoftReference<MapScaleImage>(inProgressItem));
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AbstractThreadedRenderer.class.getName()).log(Level.SEVERE, null, ex);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(AbstractThreadedRenderer.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.inProgress.remove(factory, inProgressItem);
            }
        }
    }

    public static void setHints(Graphics bg) {
        if (bg != null && bg instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)bg;
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public static void writeToFile(String info, RenderedImage image) {
        String name = "img_" + info + "_" + System.currentTimeMillis();
        try {
            ImageIO.write(image, "png", new File(name + ".png"));
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static boolean haveExtentsChanged(MapScale oldScale, MapScale newScale) {
        if (oldScale != null) {
            LocalRect newLr = newScale.getViewRect();
            LocalRect oldLr = oldScale.getViewRect();
            boolean zoomEqual = oldScale.getZoom() == newScale.getZoom();
            boolean viewRectEqual = newLr.equals(oldLr);
            WorldRect newWr = newScale.getWorldRect();
            WorldRect oldWr = oldScale.getWorldRect();
            boolean worldRectEqual = newWr.equals(oldWr);
            WorldPt oldOrigin = oldScale.getOrigin();
            WorldPt newOrigin = newScale.getOrigin();
            boolean originEqual = newOrigin.equals(oldOrigin);
            boolean haveChanged = !zoomEqual || !viewRectEqual || !worldRectEqual || !originEqual;
            return haveChanged;
        }
        return true;
    }

    @Override
    public void renderToImage(Image imageBuffer, MapScale updatedScale, MapCanvas canvas) {
        List<RenderTaskFactory> factories = this.possiblyInitialize(canvas, updatedScale);
        Set<RenderTaskFactory> dirtyFactories = this.getDirtyFactories(factories, updatedScale, canvas);
        if (dirtyFactories != null && !dirtyFactories.isEmpty()) {
            this.cancelInProgress(dirtyFactories);
            this.startFactories(dirtyFactories, updatedScale);
        }
        this.bltWithPanZoom(factories, imageBuffer, updatedScale, canvas);
        Set<MapScaleImage> stillPending = this.findPending(factories);
        this.addRepaintListeners(stillPending, canvas);
    }

    public void bltWithPanZoom(List<RenderTaskFactory> factories, Image bi, MapScale newScale, MapCanvas canvas) {
        int width = bi.getWidth(null);
        int height = bi.getHeight(null);
        MapScale copy = new MapScale(newScale);
        Graphics graphics = bi.getGraphics();
        if (graphics instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)graphics;
            Color saveColor = g2D.getBackground();
            g2D.setColor(Color.WHITE);
            g2D.fillRect(0, 0, width, height);
            g2D.setColor(saveColor);
            for (int i = 0; i < factories.size(); ++i) {
                RenderTaskFactory factory = factories.get(i);
                int finalI = i;
                MapScaleImage mapScaleImage = this.getMapScaleImage(factory);
                if (mapScaleImage == null) {
                    long before = System.nanoTime();
                    factory.draw(graphics, copy);
                    continue;
                }
                if (!mapScaleImage.isFinished()) {
                    logger.fine("waiting for unfinished background render for:" + factory);
                }
                AbstractThreadedRenderer.paint((Graphics2D)graphics, copy, mapScaleImage.getMapScale(), this.getImage(mapScaleImage), factory);
            }
        }
    }

    public static void paint(Graphics2D g, MapScale renderToScale, MapScale imageScale, Image image, RenderTaskFactory drawItem) {
        if (image == null) {
            logger.fine("draw:null image, skipping");
        } else if (imageScale != null && renderToScale != null) {
            boolean wouldBeOnScreen = AbstractThreadedRenderer.isInView(renderToScale, imageScale);
            if (wouldBeOnScreen) {
                double newZoom;
                double oldZoom = imageScale.getZoom();
                if (oldZoom == (newZoom = renderToScale.getZoom())) {
                    AbstractThreadedRenderer.drawTranslated(g, renderToScale, imageScale, image, drawItem);
                } else {
                    AbstractThreadedRenderer.drawWithZoom(g, renderToScale, imageScale, image);
                }
            }
        } else {
            logger.fine("draw:one of the scales null, skipping");
        }
    }

    public static void drawWithZoom(Graphics2D g, MapScale toScale, MapScale fromScale, Image image) {
        LocalRect toLr = toScale.getViewRect();
        WorldRect toWr = toScale.getWorldRect();
        LocalRect lrNewToOld = fromScale.wr2lr(toWr, null);
        int dx1 = toLr.l;
        int dy1 = toLr.t;
        int dx2 = toLr.r;
        int dy2 = toLr.b;
        int sx1 = lrNewToOld.l;
        int sy1 = lrNewToOld.t;
        int sx2 = lrNewToOld.r;
        int sy2 = lrNewToOld.b;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        g2d.dispose();
    }

    public static void drawTranslated(Graphics2D g, MapScale renderIntoScale, MapScale fromScale, Image image, RenderTaskFactory item) {
        WorldPt fromOrigin = fromScale.getOrigin();
        WorldPt intoOrigin = renderIntoScale.getOrigin();
        LocalPt fromPt = renderIntoScale.wp2lp(fromOrigin);
        LocalPt toPt = renderIntoScale.wp2lp(intoOrigin);
        int x = fromPt.x - toPt.x;
        int y = fromPt.y - toPt.y;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.drawImage(image, x, y, null);
        g2d.dispose();
    }

    private static boolean isInView(MapScale renderToScale, MapScale imageScale) {
        boolean retval = true;
        if (renderToScale != null && imageScale != null) {
            WorldRect toWR = renderToScale.getWorldRect();
            WorldRect fromWR = imageScale.getWorldRect();
            if (toWR != null && fromWR != null && toWR.isValid() && fromWR.isValid() && !toWR.intersects(fromWR)) {
                retval = false;
            }
        }
        return retval;
    }

    protected boolean shouldRenderInBackground(RenderTaskFactory factory) {
        GlyphTaskFactory glyphFactory;
        boolean retval = true;
        if (factory instanceof LabelsDrawFactory) {
            retval = false;
        } else if (factory instanceof GridFactory) {
            retval = false;
        } else if (factory instanceof GlyphTaskFactory && GlyphTaskFactory.isInstanceOfOsmMapGlyph(glyphFactory = (GlyphTaskFactory)factory)) {
            retval = false;
        }
        return retval;
    }

    private Set<MapScaleImage> findPending(List<RenderTaskFactory> factories) {
        HashSet<MapScaleImage> pending = new HashSet<MapScaleImage>();
        for (RenderTaskFactory factory : factories) {
            MapScaleImage msi = (MapScaleImage)this.inProgress.get(factory);
            if (msi == null) continue;
            pending.add(msi);
        }
        return pending;
    }

    private void addRepaintListeners(Set<MapScaleImage> stillPending, final MapCanvas mc) {
        FutureCallback<Image> fc = new FutureCallback<Image>(){

            @Override
            public void onSuccess(Image result) {
                logger.finer("calling repaint");
                mc.repaint();
            }

            @Override
            public void onFailure(Throwable t) {
            }
        };
        for (MapScaleImage msi : stillPending) {
            msi.addCallback(fc);
        }
    }
}

