/*
 * Decompiled with CFR 0.152.
 */
package hec.map.renderer;

import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapScale;
import hec.map.ThreadedCanvasRenderer;
import hec.map.WorldRect;
import hec.map.renderer.MapScaleImage;
import hec.map.renderer.RenderTaskFactory;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class GlyphTaskFactory
extends RenderTaskFactory {
    private static final Logger logger = Logger.getLogger(GlyphTaskFactory.class.getName());
    final int glyphIndex;
    public final MapGlyph glyph;
    final MapCanvas canvas;

    public GlyphTaskFactory(int finalI, MapGlyph glyph, MapCanvas mc) {
        super("glyph" + finalI + glyph.toString());
        this.glyph = glyph;
        this.canvas = mc;
        this.glyphIndex = finalI;
    }

    public String toString() {
        return (this.glyph == null ? "null" : this.glyph.getName()) + this.glyphIndex;
    }

    @Override
    public MapScaleImage buildFuture(MapScale mapScale) {
        final long startedAt = System.nanoTime();
        final MapScale ms = new MapScale(mapScale);
        final int width = this.canvas.getWidth();
        final int height = this.canvas.getHeight();
        double canvasComputedScale = this.canvas.computeMapScale();
        int scalewidth = mapScale.getViewRect().width();
        double worldViewWidth = mapScale.getWorldRect().width();
        double computedScale = MapCanvas.computeMapScale(width, worldViewWidth);
        if (width != scalewidth || canvasComputedScale != computedScale) {
            logger.fine("w:" + width + " sw:" + scalewidth + " ccs:" + canvasComputedScale + " cs:" + computedScale);
        }
        WorldRect glyphBounds = this.glyph.getBounds();
        WorldRect scaleRect = ms.getWorldRect();
        if (glyphBounds != null && scaleRect != null && glyphBounds.isValid() && scaleRect.isValid() && !ms.getWorldRect().intersects(glyphBounds)) {
            return null;
        }
        Callable<Image> imageProducingCallable = new Callable<Image>(){

            @Override
            public Image call() {
                Image retval = GlyphTaskFactory.this.renderToImage(width, height, ms);
                logger.finer("took:" + (System.nanoTime() - startedAt) / 1000000L + " " + GlyphTaskFactory.this);
                return retval;
            }
        };
        MapScaleImage msi = new MapScaleImage(ms, imageProducingCallable);
        return msi;
    }

    public static boolean isInstanceOfOsmMapGlyph(MapGlyph glyph) {
        boolean retval = false;
        if (glyph != null) {
            retval = "hec.map.osm.OsmMapGlyph".equals(glyph.getClass().getName());
        }
        return retval;
    }

    public static boolean isInstanceOfOsmMapGlyph(GlyphTaskFactory item) {
        boolean retval = false;
        if (item != null) {
            retval = GlyphTaskFactory.isInstanceOfOsmMapGlyph(item.glyph);
        }
        return retval;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + this.glyphIndex;
        hash = 17 * hash + Objects.hashCode(this.name);
        hash = 17 * hash + Objects.hashCode(this.glyph);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlyphTaskFactory other = (GlyphTaskFactory)obj;
        if (this.glyphIndex != other.glyphIndex) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.glyph, other.glyph);
    }

    @Override
    public void draw(Graphics bg, MapScale ms) {
        ThreadedCanvasRenderer.setHints(bg);
        int scalewidth = ms.getViewRect().width();
        double worldViewWidth = ms.getWorldRect().width();
        double computedScale = MapCanvas.computeMapScale(scalewidth, worldViewWidth);
        this.canvas.paintGlyph(this.glyph, this.glyphIndex, (int)computedScale, bg, ms);
    }

    public Image renderToImage(int width, int height, MapScale ms) {
        if (Thread.currentThread().isInterrupted() || !MapGlyph.isPaintOk()) {
            logger.info("STARTED isInterrupted:" + Thread.currentThread().isInterrupted() + " isPaintOk:" + MapGlyph.isPaintOk());
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics bg = ((Image)image).getGraphics();
        this.draw(bg, ms);
        bg.dispose();
        if (Thread.currentThread().isInterrupted() || !MapGlyph.isPaintOk()) {
            image = null;
        } else {
            this.glyph.setRepaintNeeded(false);
        }
        return image;
    }
}

