/*
 * Decompiled with CFR 0.152.
 */
package hec.map.renderer;

import hec.map.MapCanvas;
import hec.map.MapScale;
import hec.map.renderer.AbstractThreadedRenderer;
import hec.map.renderer.MapScaleImage;
import hec.map.renderer.RenderTaskFactory;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.concurrent.Callable;

public class GridFactory
extends RenderTaskFactory {
    final MapCanvas canvas;

    public GridFactory(MapCanvas mc) {
        super("paintCoordinateGrid");
        this.canvas = mc;
    }

    @Override
    public MapScaleImage buildFuture(MapScale mapScale) {
        final MapScale ms = new MapScale(mapScale);
        final int width = this.canvas.getWidth();
        final int height = this.canvas.getHeight();
        return new MapScaleImage(ms, new Callable<Image>(){

            @Override
            public Image call() {
                BufferedImage image = new BufferedImage(width, height, 2);
                Graphics bg = ((Image)image).getGraphics();
                GridFactory.this.draw(bg, ms);
                bg.dispose();
                return image;
            }
        });
    }

    @Override
    public void draw(Graphics bg, MapScale mapScale) {
        AbstractThreadedRenderer.setHints(bg);
        this.canvas.paintCoordinateGrid(bg, mapScale);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.name);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridFactory other = (GridFactory)obj;
        return Objects.equals(this.name, other.name);
    }
}

