/*
 * Decompiled with CFR 0.152.
 */
package hec.map.renderer;

import hec.map.MapCanvas;
import hec.map.MapScale;
import hec.map.ThreadedCanvasRenderer;
import hec.map.renderer.MapScaleImage;
import hec.map.renderer.RenderTaskFactory;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.concurrent.Callable;

public class LabelsDrawFactory
extends RenderTaskFactory {
    final MapCanvas canvas;

    public LabelsDrawFactory(MapCanvas mc) {
        super("label");
        this.canvas = mc;
    }

    @Override
    public MapScaleImage buildFuture(MapScale mapScale) {
        final MapScale ms = new MapScale(mapScale);
        final int width = this.canvas.getWidth();
        final int height = this.canvas.getHeight();
        return new MapScaleImage(ms, new Callable<Image>(){

            @Override
            public Image call() {
                BufferedImage image = new BufferedImage(width, height, 2);
                Graphics bg = ((Image)image).getGraphics();
                LabelsDrawFactory.this.draw(bg, ms);
                bg.dispose();
                return image;
            }
        });
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.name);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelsDrawFactory other = (LabelsDrawFactory)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public void draw(Graphics bg, MapScale scale) {
        ThreadedCanvasRenderer.setHints(bg);
        this.canvas.drawMapLabels(bg);
    }
}

