/*
 * Decompiled with CFR 0.152.
 */
package hec.map.renderer;

import hec.map.MapScale;
import hec.map.renderer.FutureCallback;
import hec.util.concurrent.AwaitableFutureTask;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

public class MapScaleImage
extends AwaitableFutureTask<Image> {
    private static final Logger logger = Logger.getLogger(MapScaleImage.class.getName());
    private final MapScale mapScale;
    private List<Runnable> listeners = null;

    public MapScaleImage(MapScale mapScale, Callable<Image> callable) {
        super(callable);
        this.mapScale = new MapScale(mapScale);
    }

    public MapScale getMapScale() {
        return new MapScale(this.mapScale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable listener) {
        if (this.isDone()) {
            listener.run();
        } else {
            MapScaleImage mapScaleImage = this;
            synchronized (mapScaleImage) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList<Runnable>();
                }
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        MapScaleImage mapScaleImage = this;
        synchronized (mapScaleImage) {
            if (this.listeners != null) {
                for (Runnable listener : this.listeners) {
                    if (listener == null) continue;
                    listener.run();
                }
            }
        }
    }

    public void addCallback(final FutureCallback<Image> fc) {
        Runnable callbackListener = new Runnable(){

            @Override
            public void run() {
                Image value = null;
                try {
                    value = (Image)MapScaleImage.this.get();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    fc.onFailure(e.getCause());
                    return;
                }
                catch (RuntimeException e) {
                    fc.onFailure(e);
                    return;
                }
                catch (Error e) {
                    fc.onFailure(e);
                    return;
                }
                fc.onSuccess(value);
            }
        };
        this.addListener(callbackListener);
    }
}

