/*
 * Decompiled with CFR 0.152.
 */
package hec.map.selection;

import hec.map.selection.GraphicElementSelectionEvent;
import hec.map.selection.GraphicElementSelectionEventListener;
import hec.map.selection.GraphicElementSelectionEventNotifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class GraphicElementSelectionEventSupport
implements GraphicElementSelectionEventListener,
GraphicElementSelectionEventNotifier {
    private CopyOnWriteArrayList<GraphicElementSelectionEventListener> _listeners = new CopyOnWriteArrayList();

    @Override
    public void addListener(GraphicElementSelectionEventListener listener) {
        if (listener != null && listener != this && !this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removeListener(GraphicElementSelectionEventListener listener) {
        this._listeners.remove(listener);
    }

    protected Collection getSourceAsCollection(Object source) {
        HashSet<Object> alreadySeen = new HashSet<Object>();
        if (source instanceof Collection) {
            Collection srcs = (Collection)source;
            alreadySeen.addAll(srcs);
        } else if (source != this) {
            alreadySeen.add(source);
        }
        return alreadySeen;
    }

    @Override
    public void selectionChange(Object source, GraphicElementSelectionEvent event) {
        Collection srcs = this.getSourceAsCollection(source);
        if (srcs.contains(this)) {
            return;
        }
        srcs.add(this);
        for (GraphicElementSelectionEventListener listener : this._listeners) {
            if (srcs.contains(listener)) continue;
            try {
                listener.selectionChange(srcs, event);
            }
            catch (Exception e) {
                System.out.println("selectionChange: Exception on changing selection " + e);
            }
        }
    }

    @Override
    public void addToSelection(Object source, GraphicElementSelectionEvent event) {
        Collection srcs = this.getSourceAsCollection(source);
        if (srcs.contains(this)) {
            return;
        }
        srcs.add(this);
        for (GraphicElementSelectionEventListener listener : this._listeners) {
            if (srcs.contains(listener)) continue;
            try {
                listener.addToSelection(srcs, event);
            }
            catch (Exception e) {
                System.out.println("addToSelection:Exception adding to selection " + e);
            }
        }
    }

    @Override
    public void clearSelection(Object source, GraphicElementSelectionEvent event) {
        Collection srcs = this.getSourceAsCollection(source);
        if (srcs.contains(this)) {
            return;
        }
        srcs.add(this);
        for (GraphicElementSelectionEventListener listener : this._listeners) {
            if (srcs.contains(listener)) continue;
            try {
                listener.clearSelection(srcs, event);
            }
            catch (Exception e) {
                System.out.println("clearSelection:Exception clearing selection " + e);
            }
        }
    }
}

