/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.appInterface.AppDaddy;
import hec.appInterface.ApplicationFrame;
import hec.gui.NameDialog;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.model.StreamNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class StreamAlignmentAdapter
extends MapMouseAdapter
implements MouseListener,
MouseMotionListener,
KeyListener {
    StreamAlignmentGlyph _sysglyph = null;
    Vector _ptVec = new Vector();
    boolean _creatingRch = false;
    boolean _editingRch = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    StreamElement _streamElem;
    ApplicationFrame _frame = AppDaddy.getFrame();
    private AbstractAction _escapeAction;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public StreamAlignmentAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void init() {
        this.findGlyph();
        if (this._escapeAction == null) {
            this._escapeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StreamAlignmentAdapter.this.escapeKeyAction();
                }
            };
        }
        if (this._mapPanel.getActionMap().get("streamEscapeKey") == null) {
            this._mapPanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "streamEscapeKey");
            this._mapPanel.getActionMap().put("streamEscapeKey", this._escapeAction);
        }
    }

    protected void escapeKeyAction() {
        if (this._creatingRch) {
            this.removeRecentStreamNode();
        } else if (this._editingRch) {
            this.abortEditing();
        }
    }

    private void abortEditing() {
        this.findGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._creatingRch = false;
        this._editingRch = false;
        this._streamElem = null;
        this._mapPanel.viewport().setCursor(this.getCursor());
    }

    @Override
    public void abort() {
        this.abortEditing();
        this._mapPanel.getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
        this._mapPanel.getActionMap().remove("streamEscapeKey");
    }

    boolean findGlyph() {
        this._sysglyph = null;
        List gvec = this._mapPanel.managerGlyphList();
        for (int i = 0; i < gvec.size(); ++i) {
            MapGlyph g = (MapGlyph)gvec.get(i);
            if (g == null || !(g instanceof StreamAlignmentGlyph)) continue;
            this._sysglyph = (StreamAlignmentGlyph)g;
            break;
        }
        return this._sysglyph != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.findGlyph()) {
            return;
        }
        if (this._creatingRch && !e.isControlDown()) {
            this._mapPanel.viewport().setCursor(this.getCursor());
            this._creatingRch = false;
            if (Boolean.getBoolean("StreamAlignment.noAskName")) {
                this._sysglyph.createElement(this._ptVec);
            } else {
                NameDialog dialog = new NameDialog((Frame)((Object)this._frame), "Create New Stream", true);
                Vector streams = this._sysglyph._sysmap.getElementVector();
                Vector<String> names = new Vector<String>(streams.size());
                for (int i = 0; i < streams.size(); ++i) {
                    names.add(((StreamElement)streams.get(i)).getName());
                }
                dialog.setExistingNames(names);
                dialog.setName(this._sysglyph._sysmap.getNextDefaultElementName());
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    this._mapPanel.paintMap();
                    return;
                }
                StreamElement elem = this._sysglyph.createElement(dialog.getName(), this._ptVec);
                if (elem != null) {
                    elem.setDescription(dialog.getDescription());
                }
            }
        } else if (this._selectedPt != null && this._streamElem != null) {
            this._selectedPt.init(e.getX(), e.getY());
            this._mapPanel.viewport().setCursor(this.getCursor());
            if (this._streamElem.getLine().getLastPt().equals(this._selectedWPt)) {
                this._streamElem.getUpstreamNode().setLocation(this._selectedWPt);
            } else if (this._streamElem.getLine().getFirstPt().equals(this._selectedWPt)) {
                this._streamElem.getDownstreamNode().setLocation(this._selectedWPt);
            }
            this._streamElem.getLine().invalidate();
            this._streamElem.resetNodeCoord();
            this._sysglyph.connectElement(this._streamElem, this._selectedPt);
            this._streamElem.getAlignment().updateJunctionLocations();
            this._selectedPt = null;
            this._selectedWPt = null;
            this._sysglyph.resetStreamTics(this._streamElem);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            this._sysglyph._sysmap.setModified(true);
        } else if (e.isPopupTrigger() || StreamAlignmentAdapter.pressedButton3(e)) {
            this._mapPanel.viewport().setCursor(this.getCursor());
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._sysglyph.objectPopupMenu(pt, e.getModifiers());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.findGlyph();
        MapScale scl = this._mapPanel.scale(this._sysglyph);
        if (this._creatingRch) {
            this._pt0.init(this._pt);
            this._pt.init(e.getX(), e.getY());
            if (this._ptVec.size() == 0) {
                this._ptVec.addElement(new LocalPt(this._pt));
                this.drawPt(this._pt, true);
            } else {
                LocalPt lpt = (LocalPt)this._ptVec.elementAt(this._ptVec.size() - 1);
                if (lpt.x != this._pt.x || lpt.y != this._pt.y) {
                    this._ptVec.addElement(new LocalPt(this._pt));
                    this.drawPt(this._pt, true);
                }
            }
        } else if (this._editingRch && e.isControlDown() && e.isShiftDown()) {
            this._pt.init(e.getX(), e.getY());
            this.findGlyph();
            double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(this._pt.x + 5), (int)this._pt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)this._pt.x, (int)this._pt.y)).e);
            WorldPt wpt = scl.lp2wp(this._pt);
            this._streamElem.getLine().removePt(wpt, tol);
            this._mapPanel.paintMap();
        } else if (this._editingRch && e.isControlDown() && this._streamElem != null && this._sysglyph.findReach(this._streamElem.getIndex()) != null) {
            this._pt.init(e.getX(), e.getY());
            double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(this._pt.x + 5), (int)this._pt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)this._pt.x, (int)this._pt.y)).e);
            WorldPt wpt = scl.lp2wp(this._pt);
            this._streamElem.getLine().insertPt(wpt, tol);
            this.drawStreamElement(this._streamElem, false);
        } else if (!this._creatingRch && e.isControlDown()) {
            if (!this.findGlyph()) {
                return;
            }
            if (!this._sysglyph.isWriteLocked()) {
                JOptionPane.showMessageDialog((Component)((Object)this._frame), "StreamAlignment is not locked.\nPlease lock the Configuration first", "Can't create Stream Alignment", 2);
                return;
            }
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            this._creatingRch = true;
            this._pt0.init(e.getX(), e.getY());
            this._pt.init(this._pt0);
            this.drawPt(this._pt, true);
            this._ptVec.removeAllElements();
            this._ptVec.addElement(new LocalPt(this._pt));
        } else if (this._editingRch && this._streamElem != null) {
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            LocalPt lpt = new LocalPt();
            WorldPt wpt = this._streamElem.getReferencePt();
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(lpt)) {
                if (this._streamElem.getLine().getLastPt().equals(wpt) && this._streamElem.getUpstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else if (this._streamElem.getLine().getFirstPt().equals(wpt) && this._streamElem.getDownstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else {
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                }
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                return;
            }
            StreamNode sn = this._sysglyph.findStreamNode(this._streamElem, this._pt);
            if (sn != null && sn.getStreamCoord() != 1.0 && sn.getStreamCoord() != 0.0) {
                return;
            }
            this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
            for (int i = 0; i < this._streamElem.getLine().pts.size(); ++i) {
                wpt = (WorldPt)this._streamElem.getLine().pts.elementAt(i);
                if (wpt == null) continue;
                scl.wp2lp(wpt, lpt);
                if (!this._lrc.contains(lpt)) continue;
                if (this._streamElem.getLine().getLastPt().equals(wpt) && this._streamElem.getUpstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else if (this._streamElem.getLine().getFirstPt().equals(wpt) && this._streamElem.getDownstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else {
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                }
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                return;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseExited(e);
        if (!this.findGlyph()) {
            return;
        }
        MapScale scl = this._mapPanel.scale(this._sysglyph);
        if (this._creatingRch) {
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this._pt.init(e.getX(), e.getY());
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            g.setPaintMode();
            g.dispose();
        } else if (this._editingRch && this._streamElem != null) {
            this._pt.init(e.getX(), e.getY());
            LocalPt lpt = new LocalPt();
            WorldPt wpt = this._streamElem.getReferencePt();
            scl.wp2lp(wpt, lpt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(lpt)) {
                if (this._streamElem.getLine().getLastPt().equals(wpt) && this._streamElem.getUpstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else if (this._streamElem.getLine().getFirstPt().equals(wpt) && this._streamElem.getDownstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else {
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                }
                return;
            }
            this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
            for (int i = 0; i < this._streamElem.getLine().pts.size(); ++i) {
                wpt = (WorldPt)this._streamElem.getLine().pts.elementAt(i);
                if (wpt == null) continue;
                scl.wp2lp(wpt, lpt);
                if (!this._lrc.contains(lpt)) continue;
                if (this._streamElem.getLine().getLastPt().equals(wpt) && this._streamElem.getUpstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else if (this._streamElem.getLine().getFirstPt().equals(wpt) && this._streamElem.getDownstreamNode().getJunction() != null) {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                } else {
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                }
                return;
            }
            this._mapPanel.viewport().setCursor(this.getCursor());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._selectedPt != null && this._streamElem != null) {
            if (this._streamElem.getLine().getLastPt().equals(this._selectedWPt) && this._streamElem.getUpstreamNode().getJunction() != null) {
                return;
            }
            if (this._streamElem.getLine().getFirstPt().equals(this._selectedWPt) && this._streamElem.getDownstreamNode().getJunction() != null) {
                return;
            }
            this.drawStreamElement(this._streamElem, true);
            this._selectedPt.init(e.getX(), e.getY());
            this._mapPanel.scale(this._sysglyph).lp2wp(this._selectedPt, this._selectedWPt);
            this.drawStreamElement(this._streamElem, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this._creatingRch) {
            if (e.getClickCount() == 2) {
                if (!this.findGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                StreamElement res = this._sysglyph.selectElement(this._pt, false, true);
                if (res != null) {
                    this._editingRch = true;
                    this._sysglyph.objectDoubleClick(this._pt, e.getModifiers());
                } else {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                    this._editingRch = false;
                }
                this._streamElem = res;
            } else if (!this._editingRch) {
                if (!this.findGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                StreamElement res = this._sysglyph.selectElement(this._pt, false, false);
                this._editingRch = false;
                this._streamElem = res;
            }
        }
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StreamAlignmentAdapter._xpt[0] = pt.x - 3;
        StreamAlignmentAdapter._ypt[0] = pt.y;
        StreamAlignmentAdapter._xpt[1] = pt.x;
        StreamAlignmentAdapter._ypt[1] = pt.y + 3;
        StreamAlignmentAdapter._xpt[2] = pt.x + 3;
        StreamAlignmentAdapter._ypt[2] = pt.y;
        StreamAlignmentAdapter._xpt[3] = pt.x;
        StreamAlignmentAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawRegion(LocalRegion lreg, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        int icnt = 0;
        for (int i = 0; i < lreg.pts.size() && i < 4000; ++i) {
            LocalPt pt = (LocalPt)lreg.pts.elementAt(i);
            if (pt == null) continue;
            StreamAlignmentAdapter._xpt[0] = pt.x - 3;
            StreamAlignmentAdapter._ypt[0] = pt.y;
            StreamAlignmentAdapter._xpt[1] = pt.x;
            StreamAlignmentAdapter._ypt[1] = pt.y + 3;
            StreamAlignmentAdapter._xpt[2] = pt.x + 3;
            StreamAlignmentAdapter._ypt[2] = pt.y;
            StreamAlignmentAdapter._xpt[3] = pt.x;
            StreamAlignmentAdapter._ypt[3] = pt.y - 3;
            g.fillPolygon(_xpt, _ypt, 4);
            StreamAlignmentAdapter._xp[icnt] = pt.x;
            StreamAlignmentAdapter._yp[icnt] = pt.y;
            ++icnt;
        }
        g.drawPolygon(_xp, _yp, icnt);
        g.setPaintMode();
        g.dispose();
    }

    void drawStreamElement(StreamElement ireg, boolean isXOR) {
        if (this._sysglyph == null || ireg == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedReach(g, this._mapPanel.scale(this._sysglyph), ireg, isXOR, this._editingRch);
        g.dispose();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 27) {
            return;
        }
        if (this._creatingRch) {
            this.removeRecentStreamNode();
        } else if (this._editingRch) {
            this.abort();
        }
    }

    void removeRecentStreamNode() {
        Graphics g = this._mapCanvas.getGraphics();
        int npts = this._ptVec.size();
        if (npts <= 1) {
            this._ptVec.removeAllElements();
            this._creatingRch = false;
            this._mapPanel.viewport().setCursor(this.getCursor());
            this._mapPanel.paintMap();
            return;
        }
        g.setXORMode(Color.white);
        if (this._editingRch) {
            this.drawPt(this._pt, true);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        }
        this.drawPt(this._pt0, true);
        LocalPt lpt = (LocalPt)this._ptVec.elementAt(npts - 2);
        g.drawLine(this._pt0.x, this._pt0.y, lpt.x, lpt.y);
        this._ptVec.removeElementAt(npts - 1);
        this._pt0.init(lpt);
        if (this._editingRch) {
            g.setXORMode(Color.white);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this.drawPt(this._pt, true);
        }
        g.setPaintMode();
        g.dispose();
    }
}

