/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.map.LayerSymbol;
import hec.map.ModelDrawingAttributeSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class StreamAlignmentAttributeSet
extends ModelDrawingAttributeSet {
    public static final String REACHES = "Streams";
    public static final String NODES = "Stream Nodes";
    public static final String JUNCTIONS = "Stream Junctions";
    private static Icon _junctionIcon = null;
    private static Icon _reachIcon = null;
    private static Icon _nodeIcon = null;

    public StreamAlignmentAttributeSet() {
        this.setName("Stream Alignment");
        this._attributes.put(REACHES, true);
        this._attributes.put(NODES, true);
        this._attributes.put(JUNCTIONS, true);
    }

    @Override
    public String getDrawPropDialogClassname() {
        return "hec.map.streamAlignment.StreamAlignmentGlyphDialog";
    }

    @Override
    public Icon getIcon(String attrName) {
        if (attrName == null || attrName.length() < 1) {
            return super.getIcon(attrName);
        }
        if (attrName.equals(JUNCTIONS)) {
            if (_junctionIcon == null) {
                _junctionIcon = new SymbolIcon(1);
            }
            return _junctionIcon;
        }
        if (attrName.equals(REACHES)) {
            if (_reachIcon == null) {
                _reachIcon = new SymbolIcon(0);
            }
            return _reachIcon;
        }
        if (attrName.equals(NODES)) {
            if (_nodeIcon == null) {
                _nodeIcon = new SymbolIcon(2);
            }
            return _nodeIcon;
        }
        return null;
    }

    static class SymbolIcon
    implements Icon {
        float size = 15.0f;
        Color lineclr = Color.black;
        Color fillclr = null;
        int symbolType = 0;

        public SymbolIcon(int i) {
            this.symbolType = i;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            LayerSymbol.draw(g, x + 10, y + 10, this.symbolType, this.lineclr, this.fillclr, this.size);
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public int getIconHeight() {
            return 25;
        }
    }
}

