/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.map.streamAlignment.StreamAlignmentDPData;
import hec.map.streamAlignment.StreamAlignmentProps;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rma.util.RMAIO;

public class StreamAlignmentDrwPro
implements Serializable,
Cloneable,
StreamAlignmentProps {
    protected static List _dataList = new ArrayList();
    private static StreamAlignmentProps _drawProp = null;
    private static String _drawPropClassname = StreamAlignmentDrwPro.class.getName();
    protected int _mapScale = -1;

    public static void setDrawPropClassname(String classname) {
        _drawPropClassname = classname == null || classname.length() == 0 ? StreamAlignmentDrwPro.class.getName() : classname;
    }

    public static StreamAlignmentProps getInstance() {
        if (_drawProp == null) {
            System.out.println("getInstance:drawPropClassname=" + _drawPropClassname);
            Class<?> cls = null;
            try {
                cls = Class.forName(_drawPropClassname);
            }
            catch (ClassNotFoundException e) {
                System.out.println("StreamAlignmentProps.getInstance:ClassNotFoundException occurred " + e);
                return null;
            }
            Object obj = null;
            try {
                obj = cls.newInstance();
            }
            catch (InstantiationException e1) {
                System.out.println("StreamAlignmentProps.getInstance:InstantiationException occurred " + e1);
            }
            catch (IllegalAccessException e1) {
                System.out.println("StreamAlignmentProps.getInstance:IllegalAccessException occurred " + e1);
            }
            _drawProp = obj instanceof StreamAlignmentProps ? (StreamAlignmentProps)obj : new StreamAlignmentDrwPro();
        }
        return _drawProp;
    }

    protected StreamAlignmentDrwPro() {
        StreamAlignmentDPData data = new StreamAlignmentDPData();
        _dataList.add(data);
    }

    @Override
    public void read(BufferedReader input) throws IOException {
        String line;
        _dataList.clear();
        StreamAlignmentDPData data = null;
        int scale = 0;
        while ((line = input.readLine()) != null && line.indexOf("StreamAlignDrawPropEnd") < 0) {
            String prefix;
            String type = RMAIO.getType(line, "=");
            if (type.indexOf(".") > -1) {
                prefix = RMAIO.getType(type, ".");
                type = RMAIO.getParam(type, ".");
            } else {
                prefix = "-1";
            }
            String param = RMAIO.getParam(line, "=");
            int tmp = RMAIO.parseInt(prefix, -1);
            if (tmp != scale) {
                if (tmp == 0) {
                    tmp = -1;
                }
                data = new StreamAlignmentDPData(tmp);
                _dataList.add(data);
                scale = tmp;
            }
            if (type.compareTo("drawTicLabels") == 0) {
                data.setDrawTicLabels("true".equalsIgnoreCase(param));
                continue;
            }
            if (type.compareTo("drawTics") == 0) {
                data.setDrawTics("true".equalsIgnoreCase(param));
                continue;
            }
            if (type.compareTo("showStreamName") == 0) {
                data.setShowStreamName("true".equalsIgnoreCase(param));
                continue;
            }
            if (type.compareTo("streamWidth") == 0) {
                data.setStreamWidth(new Integer(param));
                continue;
            }
            if (type.compareTo("ticLength") == 0) {
                data.setTicLength(new Integer(param));
                continue;
            }
            if (type.compareTo("majorTicLength") == 0) {
                data.setMajorTicLength(new Integer(param));
                continue;
            }
            if (type.compareTo("streamColor") == 0) {
                int rgb = Integer.parseInt(param);
                data.setStreamColor(new Color(rgb));
                continue;
            }
            if (type.compareTo("nodeColor") == 0) {
                data.setNodeColor(new Color(Integer.parseInt(param)));
                continue;
            }
            if (type.compareTo("nodeOutlineColor") == 0) {
                data.setNodeOutlineColor(new Color(Integer.parseInt(param)));
                continue;
            }
            if (type.compareTo("drawNodes") == 0) {
                data.setDrawNodes("true".equalsIgnoreCase(param));
                continue;
            }
            if (type.compareTo("nodeWidth") == 0) {
                data.setNodeWidth(Integer.parseInt(param));
                continue;
            }
            if (type.compareTo("junctionColor") == 0) {
                data.setJunctionColor(new Color(Integer.parseInt(param)));
                continue;
            }
            if (type.compareTo("drawJunctions") == 0) {
                data.setDrawJunctions("true".equalsIgnoreCase(param));
                continue;
            }
            if (type.compareTo("junctionWidth") != 0) continue;
            data.setJunctionWidth(Integer.parseInt(param));
        }
        Collections.sort(_dataList);
    }

    @Override
    public void write(BufferedWriter output) throws IOException {
        RMAIO.fout(output, "StreamAlignDrawPropBegin");
        for (int i = _dataList.size() - 1; i >= 0; --i) {
            StreamAlignmentDPData data = (StreamAlignmentDPData)_dataList.get(i);
            this.writeData(output, data);
        }
        RMAIO.fout(output, "StreamAlignDrawPropEnd");
    }

    private void writeData(BufferedWriter output, StreamAlignmentDPData data) {
        int scale = data.getMapScale();
        Object prefix = "";
        if (scale > 1) {
            prefix = String.valueOf(scale) + ".";
        }
        RMAIO.fout(output, (String)prefix + "drawTicLabels=" + Boolean.valueOf(data.isDrawTicLabels()).toString());
        RMAIO.fout(output, (String)prefix + "drawTics=" + Boolean.valueOf(data.isDrawTics()).toString());
        RMAIO.fout(output, (String)prefix + "showStreamName=" + Boolean.valueOf(data.isShowStreamName()).toString());
        RMAIO.fout(output, (String)prefix + "streamWidth=" + new Integer(data.getStreamWidth()).toString());
        RMAIO.fout(output, (String)prefix + "ticLength=" + new Integer(data.getTicLength()).toString());
        RMAIO.fout(output, (String)prefix + "majorTicLength=" + new Integer(data.getMajorTicLength()).toString());
        RMAIO.fout(output, (String)prefix + "streamColor=" + data.getStreamColor().getRGB());
        RMAIO.fout(output, (String)prefix + "nodeColor" + data.getNodeColor().getRGB());
        RMAIO.fout(output, (String)prefix + "nodeOutlineColor" + data.getNodeOutlineColor().getRGB());
        RMAIO.fout(output, (String)prefix + "drawNodes" + data.isDrawNodes());
        RMAIO.fout(output, (String)prefix + "nodeWidth" + data.getNodeWidth());
        RMAIO.fout(output, (String)prefix + "junctionColor" + data.getJunctionColor().getRGB());
        RMAIO.fout(output, (String)prefix + "drawJunctions" + data.isDrawJunctions());
        RMAIO.fout(output, (String)prefix + "junctionWidth" + data.getJunctionWidth());
    }

    @Override
    public StreamAlignmentDPData getDrawingProperties(int scale) {
        StreamAlignmentDPData data;
        if (scale < 1) {
            return this.getDrawingProperties();
        }
        StreamAlignmentDPData retData = null;
        int size = _dataList.size();
        if (size == 0) {
            data = new StreamAlignmentDPData();
            _dataList.add(data);
            size = 1;
        }
        if (size == 1) {
            return (StreamAlignmentDPData)_dataList.get(0);
        }
        for (int i = 0; i < size; ++i) {
            data = (StreamAlignmentDPData)_dataList.get(i);
            if (data.getMapScale() < scale) continue;
            retData = data;
        }
        if (retData == null) {
            retData = (StreamAlignmentDPData)_dataList.get(size - 1);
        }
        return retData;
    }

    @Override
    public StreamAlignmentDPData getDrawingPropertiesForScale(int scale) {
        int size = _dataList.size();
        if (scale < 1) {
            return this.getDrawingProperties();
        }
        for (int i = 0; i < size; ++i) {
            StreamAlignmentDPData data = (StreamAlignmentDPData)_dataList.get(i);
            if (data.getMapScale() != scale) continue;
            return data;
        }
        return null;
    }

    @Override
    public StreamAlignmentDPData getDrawingProperties() {
        int size = _dataList.size();
        return (StreamAlignmentDPData)_dataList.get(size - 1);
    }

    @Override
    public int getNumberOfScales() {
        return _dataList.size();
    }

    @Override
    public List getScaleList() {
        return _dataList;
    }

    public static void deleteDPData(int mapScale) {
        if (mapScale < 1) {
            return;
        }
        StreamAlignmentProps props = StreamAlignmentDrwPro.getInstance();
        List list = props.getScaleList();
        if (list == null || mapScale < 1) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            StreamAlignmentDPData data = (StreamAlignmentDPData)list.get(i);
            if (data._mapScale != mapScale) continue;
            list.remove(data);
            break;
        }
    }

    public static StreamAlignmentDPData newDPData(int name) {
        StreamAlignmentDPData data = new StreamAlignmentDPData(name);
        StreamAlignmentProps props = StreamAlignmentDrwPro.getInstance();
        props.addDPData(data);
        return data;
    }

    @Override
    public void addDPData(StreamAlignmentDPData data) {
        _dataList.add(data);
        Collections.sort(_dataList);
    }

    @Override
    public void saveProperties(int location) {
    }

    @Override
    public void reset() {
        _dataList.clear();
    }
}

