/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.appInterface.AppDaddy;
import hec.appInterface.ApplicationFrame;
import hec.appInterface.ApplicationModule;
import hec.lang.NamedType;
import hec.map.ConformingMapText;
import hec.map.DisplayCoordinateReferenceSystem;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.WorldLine;
import hec.map.WorldLineSeg;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.appInterface.MapApplicationModule;
import hec.map.crs.CRSException;
import hec.map.renderer.TracksRepaint;
import hec.map.streamAlignment.StreamAlignmentAdapter;
import hec.map.streamAlignment.StreamAlignmentAttributeSet;
import hec.map.streamAlignment.StreamAlignmentDPData;
import hec.map.streamAlignment.StreamAlignmentDrwPro;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.map.streamAlignment.StreamAlignmentProps;
import hec.map.streamAlignment.StreamJunctionEditor;
import hec.map.streamAlignment.StreamModule;
import hec.map.streamAlignment.StreamNodeAdapter;
import hec.map.streamAlignment.StreamNodeEditorJDialog;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import hec.model.StreamPolyLine;
import hec.model.StreamPt;
import hec.model.StreamSegment;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import rma.swing.RmaImage;
import rma.swing.RmaJPopupMenu;
import rma.util.RMAIO;

public class StreamAlignmentGlyph
extends MapGlyph
implements ActionListener,
TracksRepaint {
    StreamAlignmentIfc _sysmap;
    StreamAlignmentProps _drawProp = StreamAlignmentDrwPro.getInstance();
    StreamAlignmentDPData _drawPropData;
    Vector<MapGlyph.Selection> _selectionVector = new Vector();
    boolean _isShown = true;
    LocalPt _popupPoint;
    StreamNode _selectedNode;
    StreamJunction _selectedJunc;
    StreamNodeEditorJDialog sneDialog;
    StreamJunctionEditor sjeDialog;
    transient int _glyphLevel;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    WorldPt _loc = new WorldPt();
    WorldPt _slp = new WorldPt();
    static Image _impactImage = null;
    static Image _reachImage = null;
    static Image _tsImage = null;
    StreamAlignmentAttributeSet _streamDas = null;
    private Action _deleteAction;

    public StreamAlignmentGlyph(MapPanel panel, StreamAlignmentIfc map) {
        super(panel, map);
        this._sysmap = map;
        if (!this._sysmap.setLocked(3) && ((Window)((Object)AppDaddy.getFrame())).isVisible()) {
            JOptionPane.showMessageDialog(panel, "Unable to display Stream Alignment.\nCurrently being edited.");
            System.out.println("failed to get read lock on stream alignment file");
            return;
        }
        if (_impactImage == null) {
            _impactImage = RmaImage.loadURLImage("Images/fia3.gif");
        }
        if (_reachImage == null) {
            _reachImage = RmaImage.loadURLImage("Images/fia3.gif");
        }
        if (_tsImage == null) {
            _tsImage = RmaImage.loadURLImage("Images/modelup.gif");
        }
        this._drawProp = this._sysmap.getDrawProp();
        this._streamDas = this.findAttributeSet();
    }

    public StreamAlignmentIfc getStreamAlignment() {
        return this._sysmap;
    }

    @Override
    public void init() {
        if (this._mapPanel.getActionMap().get("deleteStream") == null) {
            this._deleteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StreamAlignmentGlyph.this.deleteAction();
                }
            };
            this._mapPanel.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "deleteStream");
            this._mapPanel.getActionMap().put("deleteStream", this._deleteAction);
        }
    }

    protected void deleteAction() {
        System.out.println("deleteAction:");
        MapMouseAdapter mma = this._mapPanel.getMapMouseAdapter();
        if (mma instanceof StreamAlignmentAdapter) {
            if (this._selectionVector.size() == 0) {
                return;
            }
            MapGlyph.Selection obj = this._selectionVector.get(0);
            Object obj2 = obj.object;
            if (obj2 instanceof StreamElement) {
                StreamElement elem = (StreamElement)obj2;
                int opt = JOptionPane.showConfirmDialog(this._mapPanel, "Warning: do not delete a stream that is used by any model configuration.  Are you sure you want to delete Stream " + elem.getName() + "?", "Confirm Delete", 0, 3);
                if (opt != 0) {
                    return;
                }
                if (this._sysmap.deleteReach(elem.getName())) {
                    this._sysmap.setModified(true);
                    this._selectionVector.remove(obj);
                    this.setRepaintNeeded(true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StreamAlignmentGlyph.this._mapPanel.paintMap();
                        }
                    });
                }
            }
        }
    }

    private StreamAlignmentAttributeSet findAttributeSet() {
        ApplicationModule module = AppDaddy.getFrame().getCurrentModule();
        String moduleName = module != null ? module.toString() : " ";
        ModeDrawingAttributeSet modeDas = ModeDrawingAttributeSet.getModeAttributeSet(moduleName);
        if (modeDas == null) {
            return null;
        }
        return (StreamAlignmentAttributeSet)modeDas.getModelAttributeSet("Stream Alignment");
    }

    private StreamAlignmentDPData getDrawingPropertiesForCurrentScale() {
        int scale = (int)this._mapPanel.viewport().computeMapScale();
        return this._drawProp.getDrawingProperties(scale);
    }

    public StreamAlignmentDPData getDrawingProperties() {
        if (this._drawPropData == null) {
            this._drawPropData = this.getDrawingPropertiesForCurrentScale();
        }
        return this._drawPropData;
    }

    public boolean popupMenu(LocalPt pt) {
        StreamElement reach;
        if (this._sysmap == null || pt == null) {
            return false;
        }
        MapScale scl = this._mapPanel.scale(this);
        double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(pt.x + 15), (int)pt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)pt.x, (int)pt.y)).e);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        StreamElement elem = reach = this._sysmap.findReach(wpt, tol);
        String element = "Stream Element";
        if (reach == null) {
            return false;
        }
        ApplicationFrame frame = AppDaddy.getFrame();
        ApplicationModule mode = frame.getCurrentModule();
        RmaJPopupMenu menu = new RmaJPopupMenu(elem.getName());
        JMenuItem mitem = new JMenuItem(elem.getName());
        menu.add(mitem);
        menu.addSeparator();
        mitem = new JMenuItem("Edit " + element);
        mitem.setName(elem.getName());
        mitem.addActionListener(mode);
        mitem.setEnabled(false);
        menu.add(mitem);
        mitem = new JMenuItem("Rename " + element);
        mitem.setName(elem.getName());
        mitem.addActionListener(mode);
        menu.add(mitem);
        mitem = new JMenuItem("Delete " + element);
        mitem.setName(elem.getName());
        mitem.addActionListener(mode);
        menu.add(mitem);
        menu.addSeparator();
        mitem = new JMenuItem("Insert Stream Node");
        mitem.setName(elem.getName());
        mitem.addActionListener(mode);
        menu.add(mitem);
        this._popupPoint = pt;
        ((JPopupMenu)menu).show(this._mapPanel.viewport(), pt.x, pt.y);
        return true;
    }

    public LocalPt getPopupPoint() {
        return this._popupPoint;
    }

    public boolean junctionPopupMenu(LocalPt pt, StreamJunction junc) {
        if (this._sysmap == null || pt == null || junc == null) {
            return false;
        }
        this._selectedJunc = junc;
        String junctionName = "Stream Junction";
        boolean editable = this.isWriteLocked();
        RmaJPopupMenu menu = new RmaJPopupMenu("JN");
        JMenuItem mitem = new JMenuItem(junctionName);
        menu.add(mitem);
        menu.addSeparator();
        mitem = new JMenuItem(editable ? "Edit Stream Junction..." : "View Stream Junction");
        mitem.setName("Edit Junction");
        mitem.addActionListener(this);
        menu.add(mitem);
        menu.add(mitem);
        ((JPopupMenu)menu).show(this._mapPanel.viewport(), pt.x, pt.y);
        return true;
    }

    public boolean nodePopupMenu(LocalPt pt, StreamNode node) {
        if (this._sysmap == null || pt == null || node == null) {
            return false;
        }
        this._selectedNode = node;
        String station = RMAIO.setPrecision2(node.getStation(), 3);
        String stationName = "Station: " + station;
        boolean editable = this.isWriteLocked();
        RmaJPopupMenu menu = new RmaJPopupMenu("SN");
        JMenuItem mitem = new JMenuItem(stationName);
        menu.add(mitem);
        menu.addSeparator();
        mitem = new JMenuItem(editable ? "Edit Node..." : "View Node...");
        mitem.setName("Edit Node");
        mitem.addActionListener(this);
        menu.add(mitem);
        mitem = new JMenuItem("Delete Node");
        mitem.setName("Delete Node");
        mitem.setEnabled(editable);
        if (node.getStreamCoord() < 1.0E-4 || node.getStreamCoord() > 0.9999) {
            mitem.setEnabled(false);
        }
        mitem.addActionListener(this);
        menu.add(mitem);
        ((JPopupMenu)menu).show(this._mapPanel.viewport(), pt.x, pt.y);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object instanceof JMenuItem) {
            JMenuItem mitem = (JMenuItem)object;
            if ("Edit Node".equals(mitem.getName())) {
                this.createNodeEditDialog();
            } else if ("Delete Node".equals(mitem.getText())) {
                this.deleteNode();
            } else if ("Edit Junction".equals(mitem.getName())) {
                this.creatingJunctionEditingDialog();
            }
        }
    }

    public void creatingJunctionEditingDialog() {
        this.creatingJunctionEditingDialog(this._selectedJunc);
    }

    public void creatingJunctionEditingDialog(StreamJunction junc) {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        if (this.sjeDialog == null) {
            this.sjeDialog = new StreamJunctionEditor((Frame)((Object)frame), false);
        }
        this.sjeDialog.setAlignment(this._sysmap);
        this.sjeDialog.setEditable(this.isWriteLocked());
        this.sjeDialog.fillForm(junc);
        this.sjeDialog.setVisible(true);
        if (frame != null) {
            frame.getMapPanel().paintMap();
            frame.getMapPanel().waitforPaintComplete();
            ((Frame)((Object)frame)).repaint();
        }
    }

    public void createNodeEditDialog() {
        this.createNodeEditDialog(this._selectedNode);
    }

    public void createNodeEditDialog(StreamNode streamNode) {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        if (this.sneDialog == null) {
            this.sneDialog = new StreamNodeEditorJDialog((Frame)((Object)frame), false);
        }
        this.sneDialog.setAlignment(this._sysmap);
        this.sneDialog.setEditable(this.isWriteLocked());
        this.sneDialog.setData(streamNode);
        this.sneDialog.fillDialog();
        this.sneDialog.setVisible(true);
        if (frame != null) {
            frame.getMapPanel().paintMap();
            frame.getMapPanel().waitforPaintComplete();
            ((Frame)((Object)frame)).repaint();
        }
    }

    public void resetStreamTics(StreamElement stream) {
    }

    public boolean deleteAll() {
        boolean tf = this._sysmap.deleteAll();
        this.setRepaintNeeded(true);
        this._mapPanel.paintMap();
        return tf;
    }

    public void deleteNode() {
        this.deleteNode(this._selectedNode, true);
        this._selectedNode = null;
        this.clearSelection();
    }

    public boolean deleteNode(StreamNode node, boolean askConfirm) {
        double sCoord = node.getStreamCoord();
        if (sCoord < 1.0E-4 || sCoord > 0.9999) {
            System.out.println("deleteNode:end nodes must stay");
            return false;
        }
        int opt = 0;
        if (askConfirm) {
            opt = JOptionPane.showConfirmDialog((Component)((Object)AppDaddy.getFrame()), "Confirm deletion of Stream Node", "Confirm Delete", 0);
        }
        if (opt == 1) {
            return false;
        }
        this._sysmap.deleteStreamNode(node);
        StreamElement stream = node.getStream();
        stream.deleteStreamNode(node);
        StreamJunction junc = node.getJunction();
        if (node == this._selectedNode) {
            this._selectedNode = null;
        }
        MapGlyph.Selection sel = new MapGlyph.Selection(node, false);
        this._selectionVector.remove(sel);
        if (junc != null) {
            junc.removeNode(node);
        }
        this.setRepaintNeeded(true);
        this._mapPanel.paintMap();
        this._mapPanel.waitforPaintComplete();
        return true;
    }

    @Override
    public boolean isShown() {
        if (this._streamDas == null) {
            this._streamDas = this.findAttributeSet();
            if (this._streamDas == null) {
                return false;
            }
        }
        return this._streamDas.isShown();
    }

    @Override
    public void clearSelection() {
        this._selectionVector.removeAllElements();
        this.setRepaintNeeded(true);
        this._mapPanel.paintMap();
    }

    @Override
    public void clearSelection(String name) {
        boolean found = false;
        for (int i = 0; i < this._selectionVector.size(); ++i) {
            NamedType ireg;
            MapGlyph.Selection sel = this._selectionVector.elementAt(i);
            if (sel == null || !name.equals((ireg = (NamedType)sel.object).getName())) continue;
            this._selectionVector.removeElement(sel);
            found = true;
            break;
        }
        if (found) {
            this.setRepaintNeeded(true);
            this._mapPanel.paintMap();
        }
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        Object elem;
        int i;
        if (this._streamDas == null) {
            this._streamDas = this.findAttributeSet();
        }
        if (this._sysmap == null || !this.isShown()) {
            return;
        }
        scl = this._mapPanel.scale(this);
        this._glyphLevel = this._mapPanel.getGlyphLevel(this);
        this._drawPropData = this.getDrawingPropertiesForCurrentScale();
        Vector elemVec = this._sysmap.getElementVector();
        if (this._streamDas.isAttributeShown("Streams")) {
            for (i = 0; _paintOk && i < elemVec.size(); ++i) {
                Object elem2 = elemVec.get(i);
                if (elem2 == null || !(elem2 instanceof StreamElement)) continue;
                this.drawReach(g, scl, (StreamElement)elem2);
            }
        }
        if (this._streamDas.isAttributeShown("Stream Junctions") && this._drawPropData.isDrawJunctions()) {
            Vector jvec = this._sysmap.getJunctionVector();
            for (int i2 = 0; _paintOk && i2 < jvec.size(); ++i2) {
                elem = jvec.get(i2);
                if (elem == null || !(elem instanceof StreamJunction)) continue;
                this.drawJunction(g, scl, (StreamJunction)elem);
            }
        }
        if (this._streamDas.isAttributeShown("Stream Nodes") && this._drawPropData.isDrawNodes()) {
            Vector nodevec = this._sysmap.getNodeVector();
            for (int i3 = 0; _paintOk && i3 < nodevec.size(); ++i3) {
                elem = nodevec.get(i3);
                if (elem == null || !(elem instanceof StreamNode)) continue;
                this.drawNode(g, scl, (StreamNode)elem);
            }
        }
        for (i = 0; _paintOk && i < this._selectionVector.size(); ++i) {
            MapGlyph.Selection sel = this._selectionVector.elementAt(i);
            if (sel.object == null) continue;
            if (sel.object instanceof StreamElement) {
                if (!this._streamDas.isAttributeShown("Streams")) continue;
                this.drawSelectedReach(g, scl, (StreamElement)sel.object, false, sel.editing);
                continue;
            }
            if (sel.object instanceof StreamJunction) {
                if (!this._streamDas.isAttributeShown("Stream Junctions") || !this._drawPropData.isDrawJunctions()) continue;
                this.drawSelectedJunction(g, scl, (StreamJunction)sel.object, sel.editing);
                continue;
            }
            if (!(sel.object instanceof StreamNode) || !this._streamDas.isAttributeShown("Stream Nodes") || !this._drawPropData.isDrawNodes()) continue;
            this.drawSelectedNode(g, scl, (StreamNode)sel.object, sel.editing);
        }
    }

    public void selectJunction(Graphics g, MapScale scl, StreamJunction junc, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.removeAllElements();
            this.setRepaintNeeded(true);
        }
        if (junc == null) {
            return;
        }
        MapGlyph.Selection sel = new MapGlyph.Selection(junc, editing);
        if (!this._selectionVector.contains(sel)) {
            this._selectionVector.addElement(sel);
            this.setRepaintNeeded(true);
        }
        this.drawSelectedJunction(g, scl, junc, editing);
        this._mapPanel.paintMap();
    }

    public void drawSelectedJunction(Graphics g, MapScale scl, StreamJunction junc, boolean editing) {
        WorldPt pt = junc.getLocation();
        if (!pt.isValid()) {
            return;
        }
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt, lpt);
        int x = lpt.x;
        int y = lpt.y;
        int width = this._drawPropData.getJunctionWidth();
        int halfwidth = width / 2;
        int[] size = new int[]{2, 2};
        if (!_paintOk) {
            return;
        }
        g.setColor(this._drawPropData.getJunctionColor().darker());
        g.fillOval(x - halfwidth, y - halfwidth, width, width);
        g.setColor(Color.blue);
        g.drawOval(x - halfwidth, y - halfwidth, width, width);
        if (!_paintOk) {
            return;
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(x - halfwidth - 5, y - halfwidth - 5, 5, 5);
            g.fillRect(x - halfwidth - 5, y + halfwidth, 5, 5);
            g.fillRect(x + halfwidth, y - halfwidth - 5, 5, 5);
            g.fillRect(x + halfwidth, y + halfwidth, 5, 5);
        }
        if (!_paintOk) {
            return;
        }
    }

    public void selectNode(Graphics g, MapScale scl, StreamNode node, boolean editing) {
        if (node == null) {
            return;
        }
        this._selectionVector.removeAllElements();
        MapGlyph.Selection sel = new MapGlyph.Selection(node, editing);
        if (!this._selectionVector.contains(sel)) {
            this._selectionVector.addElement(sel);
        }
        this.setRepaintNeeded(true);
        this.drawSelectedNode(g, scl, node, editing);
        this._mapPanel.paintMap();
    }

    public void drawSelectedNode(Graphics g, MapScale scl, StreamNode node, boolean editing) {
        WorldPt pt = node.getLocation();
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt, lpt);
        int x = lpt.x;
        int y = lpt.y;
        int[] size = new int[]{2, 2};
        if (!_paintOk) {
            return;
        }
        int width = this._drawPropData.getNodeWidth() + 2;
        int halfWidth = width / 2;
        g.setColor(Color.yellow);
        g.fillOval(x - halfWidth, y - halfWidth, width, width);
        g.setColor(Color.blue);
        g.drawOval(x - halfWidth, y - halfWidth, width, width);
        if (!_paintOk) {
            return;
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(x - (size[0] / 2 + 5), y - (size[1] / 2 + 5), 4, 4);
            g.fillRect(x - (size[0] / 2 + 5), y + (size[1] / 2 + 3), 4, 4);
            g.fillRect(x + (size[0] / 2 + 3), y - (size[1] / 2 + 5), 4, 4);
            g.fillRect(x + (size[0] / 2 + 3), y + (size[1] / 2 + 3), 4, 4);
        }
    }

    public StreamElement selectElement(String name, boolean add, boolean editing) {
        if (editing && !this.isWriteLocked()) {
            return null;
        }
        if (!add) {
            this._selectionVector.removeAllElements();
        }
        if (this._sysmap == null || name == null) {
            return null;
        }
        StreamElement reach = this.findReach(name);
        if (reach != null) {
            this.selectElement(reach, add, editing);
        } else if (!add) {
            this.setRepaintNeeded(true);
            this._mapPanel.paintMap();
        }
        return reach;
    }

    @Override
    public NamedType objectSelect(LocalPt pt, int modifiers) {
        if (pt == null) {
            return null;
        }
        return this.selectElement(pt, (modifiers & 1) != 0, false);
    }

    public StreamElement selectElement(LocalPt pt, boolean add, boolean editing) {
        if (editing && !this.isWriteLocked()) {
            return null;
        }
        double tol = 0.0;
        try {
            tol = Math.abs(this.transformPointToWorld((LocalPt)new LocalPt((int)(pt.x + 5), (int)pt.y)).e - this.transformPointToWorld((LocalPt)new LocalPt((int)pt.x, (int)pt.y)).e);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
        }
        boolean repaint = false;
        if (!add) {
            repaint = this._selectionVector.size() > 0;
            this._selectionVector.removeAllElements();
            this.setRepaintNeeded(true);
        }
        if (this._sysmap == null || pt == null) {
            return null;
        }
        WorldPt wpt = null;
        try {
            wpt = this.transformPointToWorld(pt);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        StreamElement reach = this._sysmap.findReach(wpt, tol);
        if (reach != null) {
            this.selectElement(reach, add, editing);
        } else if (!add && repaint) {
            this._mapPanel.paintMap();
        }
        return reach;
    }

    private void selectElement(StreamElement reach, boolean add, boolean editing) {
        MapGlyph.Selection sel = new MapGlyph.Selection(reach, editing);
        if (!this._selectionVector.contains(sel)) {
            this._selectionVector.addElement(sel);
            this.setRepaintNeeded(true);
        }
        if (add) {
            Graphics g = this._mapPanel.viewport().getGraphics();
            this.drawSelectedReach(g, this._mapPanel.scale(this), reach, false, editing);
            g.dispose();
        } else {
            this._mapPanel.paintMap();
        }
    }

    public StreamElement createElement(String streamName, StreamPolyLine streamPolyLine, double tolerance, boolean createJunctions) {
        StreamElement reach = this.createReach(streamName, streamPolyLine, tolerance, createJunctions);
        if (reach != null) {
            this.drawReach(this._mapPanel.viewport().getGraphics(), this._mapPanel.scale(this), reach);
        }
        this.setRepaintNeeded(true);
        this._mapPanel.paintMap();
        return reach;
    }

    public StreamElement createElement(Vector ptVec) {
        return this.createElement(null, ptVec);
    }

    public StreamElement createElement(String name, Vector ptVec) {
        if (this._sysmap == null || ptVec == null) {
            return null;
        }
        if (ptVec.size() < 1) {
            return null;
        }
        StreamPolyLine reg = new StreamPolyLine();
        MapScale scale = this._mapPanel.scale(this);
        if (ptVec.size() < 2) {
            LocalPt pt = (LocalPt)ptVec.elementAt(0);
            if (pt == null) {
                return null;
            }
            WorldPt lp2wp = scale.lp2wp(pt);
            reg.pts.addElement(new StreamPt(lp2wp));
            lp2wp = scale.lp2wp(new LocalPt(pt.x + 30, pt.y));
            reg.pts.addElement(new StreamPt(lp2wp));
        } else {
            for (int i = ptVec.size() - 1; i >= 0; --i) {
                LocalPt pt = (LocalPt)ptVec.elementAt(i);
                if (pt == null) continue;
                WorldPt lp2wp = scale.lp2wp(pt);
                reg.pts.addElement(new StreamPt(lp2wp));
            }
        }
        LocalPt lpt = (LocalPt)ptVec.elementAt(0);
        MapScale scl = this._mapPanel.scale(this);
        double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(lpt.x + 5), (int)lpt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)lpt.x, (int)lpt.y)).e);
        return this.createElement(name, reg, tol, true);
    }

    StreamElement createReach(StreamPolyLine line, double tol) {
        return this.createReach(null, line, tol, true);
    }

    StreamElement createReach(String streamName, StreamPolyLine line, double tol, boolean createJunctions) {
        if (line == null) {
            return null;
        }
        StreamElement reach = this._sysmap.newStreamElement();
        reach.setLine(line);
        if (streamName != null) {
            reach.setName(streamName);
        }
        StreamNode node0 = this._sysmap.newStreamNode(reach);
        node0.setStreamCoord(1.0);
        reach.addNode(node0);
        StreamNode node1 = this._sysmap.newStreamNode(reach);
        node1.setStreamCoord(0.0);
        reach.addNode(node1);
        if (createJunctions) {
            StreamNode newnode;
            int opt;
            double coord;
            StreamElement s;
            int i;
            boolean connectedUp = false;
            boolean connectedDown = false;
            WorldPt p0 = node0.getLocation();
            WorldRect rc0 = new WorldRect(p0.e - tol, p0.n + tol, p0.e + tol, p0.n - tol);
            WorldPt p1 = node1.getLocation();
            WorldRect rc1 = new WorldRect(p1.e - tol, p1.n + tol, p1.e + tol, p1.n - tol);
            StreamJunction j = null;
            Vector nodeVector = this._sysmap.getNodeVector();
            for (int i2 = 0; i2 < nodeVector.size(); ++i2) {
                int opt2;
                StreamNode n = (StreamNode)nodeVector.elementAt(i2);
                if (n == null || n == node0 || n == node1) continue;
                WorldPt p = n.getLocation();
                if (!connectedUp && rc0.contains(p)) {
                    opt2 = JOptionPane.showConfirmDialog(this._mapPanel, "Ok to connect Stream " + reach.getName() + " with Stream " + n.getStream().getName() + "?", "Connect Upstream Stream Node", 0);
                    if (opt2 == 0) {
                        j = n.getJunction();
                        if (j == null) {
                            j = this._sysmap.newStreamJunction();
                            j.addNode(n);
                        }
                        node0.getLocation().init(n.getLocation());
                        reach.getLine().getLastPt().init(n.getLocation());
                        reach.getLine().invalidate();
                        node0.setStreamCoord(1.0);
                        j.addNode(node0);
                        connectedUp = true;
                    }
                } else if (!connectedDown && rc1.contains(p) && (opt2 = JOptionPane.showConfirmDialog(this._mapPanel, "Ok to connect Stream " + reach.getName() + " with Stream " + n.getStream().getName() + "?", "Connect DownStream Stream Node", 0)) == 0) {
                    j = n.getJunction();
                    if (j == null) {
                        j = this._sysmap.newStreamJunction();
                        j.addNode(n);
                    }
                    node1.setLocation((WorldPt)n.getLocation().clone());
                    reach.getLine().getFirstPt().init((WorldPt)node1.getLocation().clone());
                    j.addNode(node1);
                    connectedDown = true;
                }
                if (connectedUp && connectedDown) break;
            }
            WorldPt loc = new WorldPt();
            if (node0.getJunction() == null) {
                Vector lineVector = this._sysmap.getElementVector();
                for (i = 0; i < lineVector.size(); ++i) {
                    double dist;
                    s = (StreamElement)lineVector.elementAt(i);
                    if (s == null || s == reach || !((dist = s.getLine().getNearestLocation(node0.getLocation(), loc)) <= tol) || (coord = s.getLine().getCoordAtLocation(loc)) == Double.NEGATIVE_INFINITY || (opt = JOptionPane.showConfirmDialog(this._mapPanel, "Ok to connect upstream end of new Stream " + reach.getName() + " with Stream " + s.getName() + "?", "Connect Stream Reaches", 0)) != 0) continue;
                    newnode = this._sysmap.newStreamNode(s);
                    newnode.setStreamCoord(coord);
                    s.addNode(newnode);
                    j = this._sysmap.newStreamJunction();
                    j.addNode(newnode);
                    node0.setLocation((WorldPt)newnode.getLocation().clone());
                    j.addNode(node0);
                    j.updateLocation();
                    break;
                }
            }
            if (node1.getJunction() == null) {
                Vector lineVector = this._sysmap.getElementVector();
                for (i = 0; i < lineVector.size(); ++i) {
                    double dist;
                    s = (StreamElement)lineVector.elementAt(i);
                    if (s == null || s == reach || !((dist = s.getLine().getNearestLocation(node1.getLocation(), loc)) <= tol) || (coord = s.getLine().getCoordAtLocation(loc)) == Double.NEGATIVE_INFINITY || (opt = JOptionPane.showConfirmDialog(this._mapPanel, "Ok to connect new Stream " + reach.getName() + " with Stream " + s.getName() + "?", "Connect Stream Reaches", 0)) != 0) continue;
                    newnode = this._sysmap.newStreamNode(s);
                    newnode.setStreamCoord(coord);
                    s.addNode(newnode);
                    j = this._sysmap.newStreamJunction();
                    j.addNode(newnode);
                    node1.setLocation((WorldPt)newnode.getLocation().clone());
                    j.addNode(node1);
                    j.updateLocation();
                    break;
                }
            }
            if (node0.getJunction() == null && node1.getJunction() == null) {
                WorldPt intersectPt = new WorldPt();
                Vector lineVector = this._sysmap.getElementVector();
                StreamPolyLine firstLineSegment = line.getFirstSegment();
                for (int i3 = 0; i3 < lineVector.size(); ++i3) {
                    int opt3;
                    double tmpcoord;
                    StreamElement s2 = (StreamElement)lineVector.elementAt(i3);
                    if (s2 == null || s2 == reach || !firstLineSegment.intersects(s2.getLine(), intersectPt) || (tmpcoord = reach.getCoordByLocation(intersectPt)) == 1.0 || (opt3 = JOptionPane.showConfirmDialog(this._mapPanel, "Ok to connect new Stream " + reach.getName() + " with Stream " + s2.getName() + "?", "Stream Reaches Intersect", 0)) != 0) continue;
                    boolean truncated = false;
                    LocalPt lpt = this._mapPanel.scale().wp2lp(intersectPt);
                    StreamNode newNode = this.findStreamNode(s2, lpt);
                    double coord2 = s2.getCoordByLocation(intersectPt);
                    if (newNode == null) {
                        newNode = this._sysmap.newStreamNode(s2);
                        newNode.setStreamCoord(coord2);
                        newNode.setLocation(intersectPt);
                        j = newNode.getJunction();
                    } else {
                        j = newNode.getJunction();
                    }
                    s2.addNode(newNode);
                    intersectPt = newNode.getLocation();
                    if (j == null) {
                        j = this._sysmap.newStreamJunction();
                        j.addNode(newNode);
                    }
                    for (int k = 0; k < reach.getLine().pts.size(); ++k) {
                        if (!reach.getLine().pts.get(k).equals(intersectPt)) continue;
                        reach.getLine().removePtsAfter(intersectPt);
                        truncated = true;
                        break;
                    }
                    if (!truncated) {
                        MapScale scl = this._mapPanel.scale(this);
                        tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(lpt.x + 5), (int)lpt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)lpt.x, (int)lpt.y)).e);
                        reach.getLine().insertPt(intersectPt, tol);
                        reach.getLine().removePtsAfter(intersectPt);
                    }
                    node1.setLocation((WorldPt)intersectPt.clone());
                    j.addNode(node1);
                    j.updateLocation();
                    break;
                }
            }
        }
        this._sysmap.setModified(true);
        return reach;
    }

    public void connectElement(StreamElement elem, LocalPt pt) {
        if (this._sysmap == null || elem == null) {
            return;
        }
        MapScale scl = this._mapPanel.scale(this);
        double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(pt.x + 15), (int)pt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)pt.x, (int)pt.y)).e);
        this._sysmap.connectReach(elem, tol);
    }

    public void connectAlignment(double tolerance) {
        this._sysmap.connectAlignment(tolerance);
    }

    public void drawJunction(Graphics g, MapScale scl, StreamJunction junc) {
        if (junc == null) {
            return;
        }
        WorldRect rc = new WorldRect();
        int width = this._drawPropData.getJunctionWidth();
        int halfwidth = width / 2;
        Vector nodevec = junc.getNodeVector();
        for (int i = 0; _paintOk && i < nodevec.size(); ++i) {
            StreamNode node = (StreamNode)nodevec.elementAt(i);
            if (i == 0) {
                rc.initToPoint(node.getLocation());
                continue;
            }
            rc.growToPoint(node.getLocation());
        }
        if (rc.isValid()) {
            LocalRect lr = this.transformRectToLocal(rc);
            int x0 = lr.l;
            int y0 = lr.t;
            int x1 = lr.r;
            int y1 = lr.b;
            if (!_paintOk) {
                return;
            }
            g.setPaintMode();
            g.setColor(this._drawPropData.getJunctionColor());
            g.fillOval(x0 - halfwidth, y0 - halfwidth, x1 - x0 + width, y1 - y0 + width);
            g.drawOval(x0 - halfwidth, y0 - halfwidth, x1 - x0 + width, y1 - y0 + width);
        } else {
            LocalPt lpt = scl.wp2lp(new WorldPt(rc.e, rc.n));
            int x = lpt.x;
            int y = lpt.y;
            if (!scl.getViewRect().contains(x, y)) {
                return;
            }
            g.setPaintMode();
            g.setColor(this._drawPropData.getJunctionColor());
            g.fillOval(x - halfwidth, y - halfwidth, width, width);
        }
    }

    public void drawNode(Graphics g, MapScale scl, StreamNode node) {
        LocalPt lpt;
        if (node == null) {
            return;
        }
        WorldPt pt = node.getLocation();
        if (pt == null || !pt.isValid()) {
            return;
        }
        try {
            lpt = this.transformPointToLocal(pt);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        if (!scl.getViewRect().contains(lpt)) {
            return;
        }
        int x = lpt.x;
        int y = lpt.y;
        int width = this._drawPropData.getNodeWidth();
        int halfWidth = width / 2;
        g.setPaintMode();
        g.setColor(this._drawPropData.getNodeColor());
        g.fillOval(x - halfWidth, y - halfWidth, width, width);
        g.setColor(this._drawPropData.getNodeOutlineColor());
        g.drawOval(x - halfWidth, y - halfWidth, width, width);
    }

    protected void drawReach(Graphics g, MapScale scl, StreamElement reach) {
        if (reach == null) {
            return;
        }
        Font oldFont = g.getFont();
        Color streamColor = this._drawPropData.getStreamColor();
        g.setColor(streamColor);
        WorldLine line = reach.getLine();
        WorldRect wrc = scl.getWorldRect();
        if (!wrc.contains(line)) {
            return;
        }
        double halfwidth = (double)this._drawPropData.getStreamWidth() / 2.0;
        this.drawLine(g, line, scl, halfwidth, streamColor, null);
        if (this._drawPropData.isDrawTics()) {
            double st0 = reach.getStationByCoord(0.0);
            double st1 = reach.getStationByCoord(1.0);
            double reachLength = reach.getLine().getLength();
            double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)20, (int)0)).e - scl.lp2wp((LocalPt)new LocalPt((int)0, (int)0)).e);
            double stTicIntv = this.getBestInterval(tol * Math.abs((st1 - st0) / reachLength));
            int majorIntv = 10;
            boolean thous = false;
            if (stTicIntv * (double)majorIntv >= 1000.0) {
                thous = true;
            }
            Vector pts = line.pts;
            WorldPt firstPt = null;
            WorldPt lastPt = null;
            WorldLineSeg lseg = new WorldLineSeg();
            WorldLineSeg lclipped = new WorldLineSeg();
            for (int i = 0; i < pts.size() - 1; ++i) {
                WorldPt pt0 = (WorldPt)pts.elementAt(i);
                WorldPt pt1 = (WorldPt)pts.elementAt(i + 1);
                lseg.init(pt0, pt1);
                lclipped.init(pt0, pt1);
                boolean icontain = wrc.intersect(lseg, lclipped);
                if (!icontain) continue;
                if (firstPt == null) {
                    firstPt = new WorldPt(lclipped.pt0);
                }
                if (lastPt == null) {
                    lastPt = new WorldPt(lclipped.pt1);
                    continue;
                }
                lastPt.init(lclipped.pt1);
            }
            if (firstPt == null || lastPt == null) {
                return;
            }
            st0 = reach.getStationByLocation(firstPt);
            st1 = reach.getStationByLocation(lastPt);
            double stmin = Math.ceil(st0 / stTicIntv) * stTicIntv;
            int ioff = (int)(stmin / stTicIntv + 0.01) % majorIntv;
            g.setFont(this._drawPropData.getTicLabelFont());
            WorldPt ticPt = new WorldPt();
            WorldPt ticSlope = new WorldPt();
            int icnt = 0;
            double st = stmin;
            while (_paintOk && st <= st1) {
                double coord = reach.getCoordByStation(st);
                reach.getLine().getSlopeAtCoord(coord, ticPt, ticSlope);
                ticSlope.n *= -1.0;
                if ((icnt + ioff) % majorIntv == 0) {
                    double strnd = st + 1.0E-4 * stTicIntv;
                    this.drawStationTic(g, scl, strnd, ticPt, ticSlope, true, thous);
                } else {
                    this.drawStationTic(g, scl, st, ticPt, ticSlope, false, thous);
                }
                st = stmin + (double)(++icnt) * stTicIntv;
            }
        }
        if (this._drawPropData.isShowStreamName() && _paintOk) {
            Font nameFont = this._drawPropData.getNameFont();
            g.setFont(nameFont);
            double coord = reach.getNameCoord();
            this.drawConformingString(g, scl, reach.getLine(), reach.getName(), coord, (int)halfwidth, nameFont, streamColor, 1, this._glyphLevel);
        }
        g.setFont(oldFont);
    }

    public void drawSelectedReach(Graphics g, MapScale scl, StreamElement lreg, boolean isXOR, boolean editing) {
        WorldLine line = lreg.getLine();
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.red);
        if (editing) {
            this.drawLine(g, line, scl, 3.0, Color.red, null, true, Color.blue, 3, isXOR);
        } else {
            this.drawLine(g, line, scl, 3.0, Color.red, null);
        }
        g.setPaintMode();
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public StreamElement findNearestReach(WorldPt wpt) {
        if (this._sysmap == null || wpt == null) {
            return null;
        }
        WorldPt wptBest = new WorldPt();
        return this._sysmap.findNearestReach(wpt, wptBest);
    }

    public StreamElement findNearestReach(LocalPt pt) {
        if (this._sysmap == null || pt == null) {
            return null;
        }
        WorldPt wptBest = new WorldPt();
        try {
            return this._sysmap.findNearestReach(super.transformPointToWorld(pt), wptBest);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public StreamElement findReach(LocalPt pt) {
        if (this._sysmap == null || pt == null) {
            return null;
        }
        return this.findReach(this._mapPanel.scale().lp2wp(pt));
    }

    public StreamElement findReach(WorldPt wpt) {
        if (this._sysmap == null || wpt == null) {
            return null;
        }
        try {
            double dist = Math.abs(this.transformPointToWorld((LocalPt)new LocalPt((int)5, (int)0)).e - this.transformPointToWorld((LocalPt)new LocalPt((int)0, (int)0)).e);
            wpt = this.transformPoint(wpt, DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem(), this._sysmap.getCoordinateReferenceSystem());
            return this._sysmap.findReach(wpt, dist);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public StreamElement findReach(LocalPt pt, StreamElement rch0) {
        if (this._sysmap == null || pt == null) {
            return null;
        }
        try {
            double dist = Math.abs(this.transformPointToWorld((LocalPt)new LocalPt((int)5, (int)0)).e - this.transformPointToWorld((LocalPt)new LocalPt((int)0, (int)0)).e);
            WorldPt wpt = this.transformPointToWorld(pt);
            return this._sysmap.findReach(wpt, dist, rch0);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public StreamElement findReach(String name) {
        if (this._sysmap == null || name == null) {
            return null;
        }
        return this._sysmap.findReach(name);
    }

    public StreamElement findReach(int idx) {
        if (this._sysmap == null || idx < 0) {
            return null;
        }
        return this._sysmap.findReach(idx);
    }

    private void drawStationTic(Graphics g, MapScale scl, double st, WorldPt midpt, WorldPt slope, boolean major, boolean thousands) {
        LocalPt transformPointToLocal;
        double ticlen = this._drawPropData.getTicLength();
        double maxfac = 1.0;
        if (major) {
            maxfac = (double)this._drawPropData.getMajorTicLength() / ticlen;
        }
        boolean iside = true;
        if (midpt == null) {
            return;
        }
        try {
            transformPointToLocal = this.transformPointToLocal(midpt);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        int x = transformPointToLocal.x;
        int y = transformPointToLocal.y;
        int x1 = x - (int)((double)iside * ticlen * maxfac * slope.n);
        int y1 = y + (int)((double)iside * ticlen * maxfac * slope.e);
        g.drawLine(x, y, x1, y1);
        if (major && this._drawPropData.isDrawTicLabels()) {
            int stK;
            FontMetrics metrics = g.getFontMetrics();
            Object str = thousands ? ((stK = (int)(st / 100.0)) % 10 > 0 ? RMAIO.setPrecision2(st / 1000.0, 1) + "K" : RMAIO.setPrecision2(st / 1000.0, 0) + "K") : RMAIO.setPrecision(st, 0);
            int w = metrics.stringWidth((String)str);
            int dx = x1 - x;
            int dy = y1 - y;
            int xt = Math.abs(dx) > Math.abs(dy) ? (dx < 0 ? x1 - w : x1) : x1 - w / 2;
            int yt = dy < 0 ? y1 - metrics.getMaxDescent() : y1 + metrics.getMaxAscent();
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem((String)str, xt, yt, this._glyphLevel, this._drawPropData.getTicLabelFont(), this._drawPropData.getStreamColor(), null, g));
        }
    }

    public void drawArrow(Graphics g, MapScale scl, WorldPt loc, WorldPt wslope) {
        LocalPt transformPointToLocal;
        double offset = 10.0;
        double alen = 20.0;
        double hlen = 5.0;
        double hoff = 3.0;
        int iside = -1;
        int idir = -1;
        WorldPt slope = new WorldPt(wslope);
        slope.n *= -1.0;
        try {
            transformPointToLocal = this.transformPointToLocal(loc);
        }
        catch (CRSException ex) {
            Logger.getLogger(StreamAlignmentGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        int x = transformPointToLocal.x;
        int y = transformPointToLocal.y;
        int x0 = x + (int)((double)(-iside) * slope.n * offset - slope.e * alen / 2.0);
        int y0 = y + (int)((double)iside * slope.e * offset - slope.n * alen / 2.0);
        int x1 = x + (int)((double)(-iside) * slope.n * offset + slope.e * alen / 2.0);
        int y1 = y + (int)((double)iside * slope.e * offset + slope.n * alen / 2.0);
        g.drawLine(x0, y0, x1, y1);
        if (idir > 0) {
            x0 = x1 + (int)(-slope.n * hoff - slope.e * hlen);
            y0 = y1 + (int)(slope.e * hoff - slope.n * hlen);
            g.drawLine(x0, y0, x1, y1);
            x0 = x1 + (int)(slope.n * hoff - slope.e * hlen);
            y0 = y1 + (int)(-slope.e * hoff - slope.n * hlen);
            g.drawLine(x0, y0, x1, y1);
        } else {
            x1 = x0 - (int)(-slope.n * hoff - slope.e * hlen);
            y1 = y0 - (int)(slope.e * hoff - slope.n * hlen);
            g.drawLine(x0, y0, x1, y1);
            x1 = x0 - (int)(slope.n * hoff - slope.e * hlen);
            y1 = y0 - (int)(-slope.e * hoff - slope.n * hlen);
            g.drawLine(x0, y0, x1, y1);
        }
    }

    public double getBestInterval(double delta) {
        double l = Math.floor(0.4342944819 * Math.log(delta));
        double b = Math.exp(2.302585093 * l);
        double c2 = delta / b;
        if (c2 >= 3.0) {
            return b * 5.0;
        }
        if (c2 > 1.5) {
            return b * 2.0;
        }
        return b;
    }

    public void drawConformingString_new(Graphics g, MapScale scl, WorldLine line, String str, double coord) {
        double coord1;
        double strmlen = line.getLength();
        WorldPt pt = (WorldPt)line.pts.elementAt(0);
        double strmlenLocal = scl.e2x(pt.e + strmlen) - scl.e2x(pt.e);
        double coordScl = 1.0 / strmlenLocal;
        FontMetrics metrics = g.getFontMetrics();
        int strwidth = metrics.stringWidth(str);
        int h = metrics.getHeight();
        double strCoordLen = (double)strwidth * coordScl;
        double offset = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)((int)((double)this._drawPropData.getTicLength() / 2.0 + (double)h + 0.5)), (int)0)).e - scl.lp2wp((LocalPt)new LocalPt((int)0, (int)0)).e);
        double offset2 = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(h / 2), (int)0)).e - scl.lp2wp((LocalPt)new LocalPt((int)0, (int)0)).e);
        double coord0 = coord - strCoordLen * 0.65;
        if (coord0 < 0.0) {
            coord0 = 0.0;
        }
        if ((coord1 = coord0 + strCoordLen * 1.3) > 1.0 && (coord0 = (coord1 = 1.0) - strCoordLen * 1.3) < 0.0) {
            return;
        }
        WorldLine offline = line.createOffsetLine(coord0, coord1, offset, 1);
        if (offline == null) {
            return;
        }
        offline = offline.createOffsetLine(0.0, 1.0, offset2, -1);
        this._mapPanel.viewport().addMapTextObject(new ConformingMapText(str, offline, scl, 0.1f, this._drawPropData.getNameFont(), this._drawPropData.getStreamColor(), null, g));
    }

    public void drawConformingString_old(Graphics g, MapScale scl, StreamElement stream, String str, double coord) {
        int i;
        double cbest;
        double dn;
        double de;
        double dist;
        WorldPt lastSlope;
        WorldPt lastPt;
        double c2;
        WorldLine line = stream.getLine();
        double strmlen = line.getLength();
        WorldPt pt = (WorldPt)line.pts.elementAt(0);
        double strmlenLocal = scl.e2x(pt.e + strmlen) - scl.e2x(pt.e);
        double localScl = strmlenLocal / strmlen;
        double coordScl = 1.0 / strmlenLocal;
        FontMetrics metrics = g.getFontMetrics();
        int h = metrics.getHeight();
        int ascent = metrics.getAscent();
        int w = metrics.getMaxAdvance();
        int numchar = str.length();
        double strCoordLen = (double)(numchar * h) * coordScl;
        double step = (double)h / localScl / 2.0;
        double cstep = (double)h * coordScl / 2.0;
        double offset = 2.0 * step;
        boolean iside = true;
        WorldLine strline = new WorldLine();
        double c0 = coord - strCoordLen / 2.0;
        double c1 = coord + strCoordLen / 2.0;
        pt = new WorldPt();
        WorldPt baseSlope = new WorldPt();
        line.getSlopeAtCoord(coord, pt, baseSlope);
        if (!scl.contains(pt)) {
            return;
        }
        WorldPt basePt = new WorldPt(pt.e - (double)iside * offset * baseSlope.n, pt.n + (double)iside * offset * baseSlope.e);
        strline.pts.addElement(basePt);
        WorldPt nextPt = basePt;
        WorldPt nextSlope = baseSlope;
        WorldPt bestPt = new WorldPt();
        for (c2 = coord - cstep; _paintOk && c2 >= c0; c2 -= cstep) {
            lastPt = nextPt;
            lastSlope = nextSlope;
            nextPt = new WorldPt(lastPt.e - lastSlope.e * step, lastPt.n - lastSlope.n * step);
            dist = line.getNearestLocation(nextPt, bestPt);
            de = nextPt.e - bestPt.e;
            dn = nextPt.n - bestPt.n;
            nextPt.init(bestPt.e + de * offset / dist, bestPt.n + dn * offset / dist);
            strline.pts.insertElementAt(nextPt, 0);
            cbest = line.getCoordAtLocation(bestPt);
            nextSlope = new WorldPt();
            line.getSlopeAtCoord(cbest, bestPt, nextSlope);
        }
        nextPt = basePt;
        nextSlope = baseSlope;
        for (c2 = coord + cstep; _paintOk && c2 <= c1; c2 += cstep) {
            lastPt = nextPt;
            lastSlope = nextSlope;
            nextPt = new WorldPt(lastPt.e + lastSlope.e * step, lastPt.n + lastSlope.n * step);
            dist = line.getNearestLocation(nextPt, bestPt);
            de = nextPt.e - bestPt.e;
            dn = nextPt.n - bestPt.n;
            nextPt.init(bestPt.e + de * offset / dist, bestPt.n + dn * offset / dist);
            strline.pts.addElement(nextPt);
            cbest = line.getCoordAtLocation(bestPt);
            nextSlope = new WorldPt();
            line.getSlopeAtCoord(cbest, bestPt, nextSlope);
        }
        Color bgclr = this._mapPanel.viewport().getBackground();
        Color fontClr = g.getColor();
        char[] strchar = new char[numchar + 1];
        str.getChars(0, numchar, strchar, 0);
        cstep = 1.0 / (double)numchar;
        int idir = 1;
        if (strline.getFirstPt().e > strline.getLastPt().e) {
            idir = -1;
        }
        nextPt = new WorldPt();
        nextSlope = new WorldPt();
        coordScl = 1.0 / (strline.getLength() * localScl);
        c2 = 0.0;
        if (idir < 0) {
            c2 = 1.0;
        }
        int[] locxarray = new int[numchar];
        int[] locyarray = new int[numchar];
        for (i = 0; _paintOk && i < numchar; ++i) {
            strline.getSlopeAtCoord(c2, nextPt, nextSlope);
            locxarray[i] = scl.e2x(nextPt.e);
            locyarray[i] = scl.n2y(nextPt.n);
            w = metrics.charWidth(strchar[i]) + 1;
            if (Math.abs(nextSlope.n) / Math.abs(nextSlope.e) >= (double)h / (double)w) {
                c2 += (double)(idir * ascent) * coordScl;
                continue;
            }
            c2 += (double)idir * (double)w / Math.abs(nextSlope.e) * coordScl;
        }
        c2 = 0.5;
        strline.getSlopeAtCoord(c2, nextPt, nextSlope);
        for (i = numchar / 2 - 1; _paintOk && i >= 0; --i) {
            w = metrics.charWidth(strchar[i]) + 1;
            c2 = Math.abs(nextSlope.n) / Math.abs(nextSlope.e) >= (double)h / (double)w ? (c2 -= (double)(idir * ascent) * coordScl) : (c2 -= (double)idir * (double)w / Math.abs(nextSlope.e) * coordScl);
            strline.getSlopeAtCoord(c2, nextPt, nextSlope);
            locxarray[i] = scl.e2x(nextPt.e);
            locyarray[i] = scl.n2y(nextPt.n);
        }
        c2 = 0.5;
        for (i = numchar / 2; _paintOk && i < numchar; ++i) {
            strline.getSlopeAtCoord(c2, nextPt, nextSlope);
            locxarray[i] = scl.e2x(nextPt.e);
            locyarray[i] = scl.n2y(nextPt.n);
            w = metrics.charWidth(strchar[i]);
            if (Math.abs(nextSlope.n) / Math.abs(nextSlope.e) >= (double)h / (double)w) {
                c2 += (double)(idir * ascent) * coordScl;
                continue;
            }
            c2 += (double)idir * (double)w / Math.abs(nextSlope.e) * coordScl;
        }
        g.setColor(bgclr);
        for (i = 0; _paintOk && i < numchar; ++i) {
            w = metrics.charWidth(strchar[i]) + 1;
            g.fillRect(locxarray[i], locyarray[i] - ascent, w, h);
        }
        g.setColor(fontClr);
        for (i = 0; _paintOk && i < numchar; ++i) {
            g.drawChars(strchar, i, 1, locxarray[i], locyarray[i]);
        }
    }

    public StreamJunction findStreamJunction(StreamElement stream, LocalPt pt) {
        if (this._sysmap == null || pt == null || stream == null) {
            return null;
        }
        MapScale scl = this._mapPanel.scale(this);
        double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(pt.x + 5), (int)pt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)pt.x, (int)pt.y)).e);
        WorldPt wpt = this._mapPanel.scale(this).lp2wp(pt);
        return this._sysmap.findStreamJunction(stream, wpt, tol);
    }

    public StreamNode findStreamNode(StreamElement stream, LocalPt pt) {
        if (this._sysmap == null || pt == null) {
            return null;
        }
        MapScale scl = this._mapPanel.scale(this);
        double tol = Math.abs(scl.lp2wp((LocalPt)new LocalPt((int)(pt.x + 5), (int)pt.y)).e - scl.lp2wp((LocalPt)new LocalPt((int)pt.x, (int)pt.y)).e);
        WorldPt wpt = scl.lp2wp(pt);
        return this._sysmap.findStreamNode(stream, wpt, tol);
    }

    public StreamNode findDownstreamNode(StreamElement stream, LocalPt pt) {
        if (this._sysmap == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale(this).lp2wp(pt);
        double coord = stream.getCoordByLocation(wpt);
        return this._sysmap.findDownstreamNode(stream, coord);
    }

    public StreamNode findUpstreamNode(StreamElement stream, LocalPt pt) {
        if (this._sysmap == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale(this).lp2wp(pt);
        double coord = stream.getCoordByLocation(wpt);
        return this._sysmap.findUpstreamNode(stream, coord);
    }

    @Override
    public void showMapElement(String glyphName, String glyphElement, boolean show) {
        if (this._streamDas == null || glyphElement == null) {
            return;
        }
        if (glyphElement.equalsIgnoreCase("shown")) {
            this._streamDas.setShown(show);
        } else {
            this._streamDas.setAttribute(glyphElement, show);
        }
    }

    @Override
    public void setShown(boolean show) {
        if (this._streamDas == null) {
            return;
        }
        this._streamDas.setShown(show);
    }

    public boolean getShown() {
        if (this._streamDas == null) {
            return false;
        }
        return this._streamDas.isShown();
    }

    @Override
    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        MapMouseAdapter adapter = frame.getMapPanel().getMapMouseAdapter();
        MapApplicationModule mode = (MapApplicationModule)frame.getCurrentModule();
        if (adapter instanceof StreamAlignmentAdapter || adapter instanceof StreamNodeAdapter || mode instanceof StreamModule) {
            StreamElement obj = this.findReach(pt);
            if (obj != null) {
                this._selectionVector.removeAllElements();
                MapGlyph.Selection sel = new MapGlyph.Selection(obj, adapter instanceof StreamAlignmentAdapter || adapter instanceof StreamNodeAdapter);
                this._selectionVector.addElement(sel);
                this.setRepaintNeeded(true);
                this._mapPanel.paintMap();
                return mode.objectDoubleClick(obj, pt);
            }
            this.clearSelection();
        }
        return false;
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        StreamNode node;
        StreamElement stream;
        ApplicationFrame frame = AppDaddy.getFrame();
        MapMouseAdapter adapter = ((MapApplicationFrame)frame).getMapPanel().getMapMouseAdapter();
        NamedType obj = null;
        if (adapter instanceof StreamAlignmentAdapter) {
            stream = this.findReach(pt);
            if (stream != null) {
                obj = stream;
            }
        } else if (adapter instanceof StreamNodeAdapter && (stream = this.findReach(pt)) != null && (node = this.findStreamNode(stream, pt)) != null) {
            obj = node;
        }
        if (obj == null) {
            return false;
        }
        MapApplicationModule mode = (MapApplicationModule)frame.getCurrentModule();
        this._mapPanel.paintMap();
        this._mapPanel.waitforPaintComplete();
        this.clearSelection();
        this._selectionVector.add(new MapGlyph.Selection(obj, false));
        return mode.objectPopupMenu(obj, pt);
    }

    protected void drawSelectedObject(Object obj, Graphics g) {
        if (obj instanceof StreamElement) {
            this.drawSelectedReach(g, this._mapPanel.scale(this), (StreamElement)obj, false, false);
        } else if (obj instanceof StreamNode) {
            this.drawSelectedNode(g, this._mapPanel.scale(this), (StreamNode)obj, false);
        } else if (obj instanceof StreamJunction) {
            this.drawSelectedJunction(g, this._mapPanel.scale(this), (StreamJunction)obj, false);
        }
    }

    @Override
    public void close() {
        if (this._sysmap != null) {
            this._sysmap.setLocked(1);
        }
        this._mapPanel.getInputMap(1).remove(KeyStroke.getKeyStroke(127, 0));
        this._mapPanel.getActionMap().remove("deleteStream");
    }

    @Override
    public ModelDrawingAttributeSet getAttributeSet() {
        return this._streamDas;
    }

    @Override
    public String getToolTipText(WorldPt wpt, MouseEvent e) {
        StreamElement se = this.findReach(wpt);
        if (se != null) {
            LocalPt lpt = this._mapPanel.scale().wp2lp(wpt);
            WorldPt wldPt = this._mapPanel.scale(this).lp2wp(lpt);
            StreamJunction sj = this.findStreamJunction(se, lpt);
            if (sj != null) {
                return "Stream Junction";
            }
            StreamNode sn = this.findStreamNode(se, lpt);
            if (sn != null) {
                WorldPt pt = sn.getLocation();
                return "<html>Stream Node: " + RMAIO.setPrecision(sn.getStation(), 3) + "<BR>" + RMAIO.setPrecision(pt.e, 3) + ", " + RMAIO.setPrecision(pt.n, 3) + "</html>";
            }
            double station = se.getStationByLocation(wldPt);
            return "<html>Stream: " + se.getName() + "<BR>Station:" + RMAIO.setPrecision2(station, 2) + "</html>";
        }
        return null;
    }

    public String getStreamSegmentsByNodes(Vector nodeVec, Vector ndirVec, Vector segVec) {
        if (this._sysmap == null) {
            return "Stream Alignment not available";
        }
        return this._sysmap.getStreamSegmentsByNodes(nodeVec, ndirVec, segVec);
    }

    @Override
    public boolean isWriteLocked() {
        MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
        if (mode == null) {
            return false;
        }
        if (mode.hasWriteLock(this)) {
            return true;
        }
        if (mode instanceof StreamModule) {
            StreamModule sm = (StreamModule)mode;
            sm.editConfiguration(true);
            return sm.hasWriteLock(this);
        }
        return false;
    }

    public List getConnectivityTo(StreamElement start, double startStation, StreamElement end) {
        ArrayList<StreamSegment> connectList = new ArrayList<StreamSegment>();
        if (start == null || end == null) {
            return connectList;
        }
        if (start == end) {
            StreamSegment ss = new StreamSegment();
            ss.setStream(start);
            ss.upstreamStation = startStation;
            connectList.add(ss);
            return connectList;
        }
        if (this._sysmap == null) {
            return connectList;
        }
        StreamSegment ss = new StreamSegment();
        ss.setStream(start);
        ss.upstreamStation = startStation;
        connectList.add(ss);
        if (!this.findConnectivity(start, startStation, end, connectList)) {
            connectList.clear();
            return connectList;
        }
        return connectList;
    }

    private boolean findConnectivity(StreamElement start, double startStation, StreamElement end, List streamSegments) {
        Vector streams = new Vector();
        Vector<StreamNode> startNodes = start.getNodeVectorSorted();
        for (int i = 0; i < startNodes.size(); ++i) {
            int cnt;
            StreamJunction startDnJunc;
            StreamNode startDnNode = startNodes.get(i);
            if (startDnNode.getStation() > startStation || (startDnJunc = startDnNode.getJunction()) == null || (cnt = startDnJunc.getOutflowingStreams(streams)) == 0) continue;
            for (int s = 0; s < streams.size(); ++s) {
                StreamNode node;
                StreamSegment ss;
                StreamElement elem = (StreamElement)streams.get(s);
                if (elem == start) continue;
                if (elem == end) {
                    ss = new StreamSegment(end);
                    ss.downstreamStation = end.getDownstreamNode().getStation();
                    node = startDnJunc.getNodeOnStream(end);
                    ss.upstreamStation = node.getStation();
                    streamSegments.add(ss);
                    return true;
                }
                node = startDnJunc.getNodeOnStream(elem);
                StreamSegment lastSs = (StreamSegment)streamSegments.get(streamSegments.size() - 1);
                ss = new StreamSegment(elem);
                ss.upstreamStation = node.getStation();
                streamSegments.add(ss);
                if (!this.findConnectivity(elem, node.getStation(), end, streamSegments)) {
                    streamSegments.remove(ss);
                    continue;
                }
                lastSs.downstreamStation = startDnNode.getStation();
                return true;
            }
        }
        return false;
    }

    public StreamJunction findStreamJunction(int streamJunctionId) {
        return this._sysmap.getJunction(streamJunctionId);
    }
}

