/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.appInterface.AppDaddy;
import hec.gui.NameDialog;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.streamAlignment.StreamAlignmentDPData;
import hec.map.streamAlignment.StreamAlignmentDrwPro;
import hec.map.streamAlignment.StreamAlignmentProps;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ClosableDialog;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFontButton;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.IntegerDocument;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class StreamAlignmentGlyphDialog
extends RmaJDialog
implements ClosableDialog,
Observer,
ChangeListener {
    private RmaJTextField _currentScaleTxt;
    private boolean _isOK = false;
    private RmaJTabbedPane _scaleTabbedPanel;
    private ButtonCmdPanel cmdPanel;
    int state;
    private ReflectMultiListener _listener;
    private JMenuItem _deleteMenuItem;
    private boolean _needToRebuildPanels;

    public StreamAlignmentGlyphDialog(Frame f, String sTitle, boolean modal) {
        this(f, modal);
        this.setTitle(sTitle);
    }

    public StreamAlignmentGlyphDialog(Frame f, boolean modal) {
        super(f, modal);
        this.buildComponents();
    }

    protected void buildComponents() {
        this.setTitle("Stream Alignment Properties");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(525, 520);
        this.setLocation();
        this.setDefaultSize(535, 550);
        this._currentScaleTxt = new RmaJTextField();
        this._currentScaleTxt.setBorder(null);
        this._currentScaleTxt.setEditable(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._currentScaleTxt, gbc);
        this._scaleTabbedPanel = new RmaJTabbedPane();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._scaleTabbedPanel, gbc);
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        StreamAlignmentGlyphDialog.this.okActionPerformed();
                        break;
                    }
                    case 2: {
                        StreamAlignmentGlyphDialog.this.applyActionPerformed();
                        break;
                    }
                    case 4: {
                        StreamAlignmentGlyphDialog.this.cancelActionPerformed();
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == StreamAlignmentGlyphDialog.this) {
                    StreamAlignmentGlyphDialog.this.StreamAlignmentGlyphDialog_WindowClosing(event);
                }
            }
        });
        StreamAlignmentProps props = StreamAlignmentDrwPro.getInstance();
        this.setProperties(props);
        this.buildMenus();
        this._scaleTabbedPanel.addChangeListener(this);
    }

    protected void buildMenus() {
        this._listener = new ReflectMultiListener();
        JMenuBar mbar = new JMenuBar();
        JMenu menu = new JMenu("Scale");
        menu.setMnemonic('S');
        mbar.add(menu);
        JMenuItem newMenuItem = new JMenuItem("New...", 78);
        newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newMenuItem.addActionListener(this._listener.add(this, newMenuItem, "addTabAction"));
        menu.add(newMenuItem);
        this._deleteMenuItem = new JMenuItem("Delete", 68);
        this._deleteMenuItem.setEnabled(false);
        this._deleteMenuItem.addActionListener(this._listener.add(this, this._deleteMenuItem, "deleteTabAction"));
        menu.add(this._deleteMenuItem);
        menu.addSeparator();
        JMenuItem setDefaultMenuItem = new JMenuItem("Set to Defaults", 83);
        setDefaultMenuItem.addActionListener(this._listener.add(this, setDefaultMenuItem, "setToDefaultsAction"));
        menu.add(setDefaultMenuItem);
        this.setJMenuBar(mbar);
    }

    public void setToDefaultsAction() {
        PropsPanel panel = (PropsPanel)this._scaleTabbedPanel.getSelectedComponent();
        panel.setToDefaults();
    }

    public void addTabAction() {
        NameDialog dialog = new NameDialog(this, "Create New Scale", true);
        dialog.setNameLabel("Scale:");
        IntegerDocument document = new IntegerDocument();
        document.setMin(1);
        dialog.setNameFieldDocument(document);
        dialog.setDescriptionVisible(false);
        dialog.setSnapToDefaultSize(false);
        Dimension d = dialog.getSize();
        dialog.setDefaultSize(0, 0);
        dialog.setSize(d.width, 130);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        String nameStr = dialog.getName();
        int name = RMAIO.parseInt(nameStr);
        if (RMAConst.isUndefinedValue(name)) {
            return;
        }
        StreamAlignmentDPData data = StreamAlignmentDrwPro.newDPData(name);
        PropsPanel panel = (PropsPanel)this._scaleTabbedPanel.getSelectedComponent();
        PropsPanel newPanel = new PropsPanel(data);
        newPanel.fillFormFrom(panel);
        this.setModified(true);
        for (int i = 1; i < this._scaleTabbedPanel.getTabCount(); ++i) {
            panel = (PropsPanel)this._scaleTabbedPanel.getComponentAt(i);
            if (name <= panel.getMapScale()) continue;
            this._scaleTabbedPanel.insertTab(nameStr, null, newPanel, null, i);
            this._scaleTabbedPanel.setSelectedIndex(i);
            return;
        }
        this._scaleTabbedPanel.addTab(String.valueOf(name), newPanel);
        this._scaleTabbedPanel.setSelectedIndex(this._scaleTabbedPanel.getTabCount() - 1);
    }

    public void deleteTabAction() {
        PropsPanel panel = (PropsPanel)this._scaleTabbedPanel.getSelectedComponent();
        int mapScale = panel.getMapScale();
        int opt = JOptionPane.showConfirmDialog(this, "<html>OK to delete StreamAlignment Properties for scale <b>1:" + mapScale + "</b></html>", "Confirm Deletion", 0);
        if (opt != 0) {
            return;
        }
        StreamAlignmentDrwPro.deleteDPData(mapScale);
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        frame.getMapPanel().paintMap();
        this.setProperties(StreamAlignmentDrwPro.getInstance());
        this.setModified(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int idx = this._scaleTabbedPanel.getSelectedIndex();
        this._deleteMenuItem.setEnabled(idx != 0);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            frame.getMapPanel().addObserver(this);
            this.updateCurrentScale();
        } else {
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            frame.getMapPanel().deleteObserver(this);
        }
        super.setVisible(b);
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("zoomIn".equals(arg) || "zoomByFactor".equals(arg) || "showAll".equals(arg)) {
            this.updateCurrentScale();
        }
    }

    private void updateCurrentScale() {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        double scale = frame.getMapPanel().viewport().computeMapScale();
        this._currentScaleTxt.setText("Current Scale 1:" + (int)scale);
    }

    void StreamAlignmentGlyphDialog_WindowClosing(WindowEvent event) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean closeDialog() {
        if (this.isModified()) {
            int sel = this.saveEditsMessageBox();
            if (sel == 0) {
                this.applyActionPerformed();
            } else if (sel == 1) {
                this.setModified(false);
            } else if (sel == 2 || sel == -1) {
                return false;
            }
        }
        this.cancelActionPerformed();
        return true;
    }

    void applyActionPerformed() {
        int tabCnt = this._scaleTabbedPanel.getTabCount();
        for (int i = 0; i < tabCnt; ++i) {
            PropsPanel panel = (PropsPanel)this._scaleTabbedPanel.getComponentAt(i);
            panel.saveProperties();
        }
        StreamAlignmentProps props = StreamAlignmentDrwPro.getInstance();
        if (this._needToRebuildPanels) {
            this.setProperties(props);
        }
        props.saveProperties(0);
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        frame.getMapPanel().paintMap();
    }

    void okActionPerformed() {
        this.applyActionPerformed();
        this._isOK = true;
        this.setVisible(false);
    }

    void cancelActionPerformed() {
        this._isOK = false;
        this.setVisible(false);
    }

    public void initDlg() {
    }

    public void setProperties(StreamAlignmentProps p) {
        this._scaleTabbedPanel.removeAll();
        if (p == null) {
            System.out.println("setProperties:ERROR:no StreamAlignment Properties");
            return;
        }
        List dpDataList = p.getScaleList();
        for (int i = 0; i < dpDataList.size(); ++i) {
            String name;
            StreamAlignmentDPData data = (StreamAlignmentDPData)dpDataList.get(i);
            PropsPanel panel = new PropsPanel(data);
            int scale = data.getMapScale();
            System.out.println("setProperties:stream alignment props at map scale " + scale);
            if (scale < 1) {
                name = "Default";
                this._scaleTabbedPanel.insertTab(name, null, panel, null, 0);
                continue;
            }
            name = String.valueOf(scale);
            this._scaleTabbedPanel.addTab(name, panel);
        }
    }

    public boolean isOK() {
        return this._isOK;
    }

    private int saveEditsMessageBox() {
        int option = JOptionPane.showOptionDialog(this, "Do you want to save your changes?", "Edit in Progress", 1, 2, null, null, "Yes");
        return option;
    }

    private class PropsPanel
    extends JPanel
    implements ActionListener {
        Object[] defaultColor;
        Object[] lineCustomColor;
        private RmaJIntegerField _mapScaleFld;
        private JLabel _mapScaleLabel;
        private StreamAlignmentDPData _dp;
        private StreamAlignmentDPData _origProps;
        private JPanel _propertiesPanel;
        private RmaJComboBox _streamWidthCB;
        private RmaJColorComboBox _streamColorCB;
        private RmaJComboBox _majorTicLengthCB;
        private RmaJComboBox _ticLengthCB;
        private RmaJCheckBox _showStreamNameCHK;
        private RmaJCheckBox _drawStationTicsCHK;
        private JButton _streamNameButton;
        private JButton _ticFontButton;
        private JLabel _ticLengthLabel;
        private JLabel _majorTicLengthLabel;
        private RmaJCheckBox _drawTicLabelsCHK;
        private RmaJCheckBox _drawNodesCHK;
        private RmaJColorComboBox _nodeColorCB;
        private RmaJColorComboBox _nodeOuterColorCB;
        private RmaJComboBox _nodeWidthCB;
        private RmaJCheckBox _drawJunctionsCHK;
        private RmaJColorComboBox _junctionColorCB;
        private RmaJComboBox _junctionWidthCB;
        private DrawPanel _previewPanel;
        private JPanel ButtonPanel;
        private JDialog _chooserDlg;
        private JColorChooser _chooserPane;
        private JLabel _nodeColorLabel;
        private JLabel _nodeOutlineColorLabel;
        private JLabel _nodeWidthLabel;
        private JLabel _junctionColorLabel;
        private JLabel _junctionWidthLabel;

        PropsPanel(StreamAlignmentDPData data) {
            super(new GridBagLayout());
            this.defaultColor = new Object[]{new Color(255, 128, 0), "Default"};
            this.lineCustomColor = new Object[]{Color.white, "Custom"};
            this._chooserDlg = null;
            this._chooserPane = null;
            this._origProps = data;
            this._dp = (StreamAlignmentDPData)this._origProps.clone();
            this.buildControls(data.getMapScale());
        }

        public void saveForm() {
            this.saveProperties();
        }

        protected void buildControls(int mapScale) {
            String iStr;
            int i;
            this._mapScaleLabel = new JLabel("Use Below Scale 1:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 11;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.add((Component)this._mapScaleLabel, gbc);
            this._mapScaleFld = new RmaJIntegerField(mapScale, 10);
            this._mapScaleLabel.setLabelFor(this._mapScaleFld);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.add((Component)this._mapScaleFld, gbc);
            this._propertiesPanel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 2;
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets(0, 5, 0, 5);
            gbc.ipadx = 20;
            gbc.ipady = 5;
            this.add((Component)this._propertiesPanel, gbc);
            JLabel jLabel1 = new JLabel("Stream Width:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this._propertiesPanel.add((Component)jLabel1, gbc);
            this._streamWidthCB = new RmaJComboBox();
            this._streamWidthCB.setEditable(true);
            this._streamWidthCB.setModifiable(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 5, 5);
            this._propertiesPanel.add((Component)this._streamWidthCB, gbc);
            JLabel jLabel2 = new JLabel("Stream Color:");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 10, 0, 5);
            this._propertiesPanel.add((Component)jLabel2, gbc);
            this._streamColorCB = new RmaJColorComboBox();
            this._streamColorCB.addItem(this.defaultColor);
            this._streamColorCB.setAllowsCustomColor(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(0, 10, 5, 5);
            this._propertiesPanel.add((Component)this._streamColorCB, gbc);
            this._majorTicLengthLabel = new JLabel("Major Tic Length:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 20, 0, 0);
            this._propertiesPanel.add((Component)this._majorTicLengthLabel, gbc);
            this._majorTicLengthCB = new RmaJComboBox();
            this._majorTicLengthCB.setEditable(true);
            this._majorTicLengthCB.setModifiable(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 10, 5, 5);
            this._propertiesPanel.add((Component)this._majorTicLengthCB, gbc);
            this._ticLengthLabel = new JLabel("Tic Length:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 20, 0, 0);
            this._propertiesPanel.add((Component)this._ticLengthLabel, gbc);
            this._ticLengthCB = new RmaJComboBox();
            this._ticLengthCB.setEditable(true);
            this._ticLengthCB.setModifiable(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 10, 5, 5);
            this._propertiesPanel.add((Component)this._ticLengthCB, gbc);
            this._showStreamNameCHK = new RmaJCheckBox("Show Stream Name");
            this._showStreamNameCHK.setSelected(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._showStreamNameCHK, gbc);
            this._drawStationTicsCHK = new RmaJCheckBox("Draw Station Tics");
            this._drawStationTicsCHK.setSelected(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._drawStationTicsCHK, gbc);
            this._drawTicLabelsCHK = new RmaJCheckBox("Draw Tic Labels");
            this._drawTicLabelsCHK.setSelected(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.anchor = 11;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 8, 0, 0);
            this._propertiesPanel.add((Component)this._drawTicLabelsCHK, gbc);
            this._streamNameButton = new RmaJFontButton("Choose Font...");
            this._streamNameButton.setActionCommand("Choose Font...");
            this._streamNameButton.setMnemonic('F');
            gbc = new GridBagConstraints();
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 10, 0, 0);
            this._propertiesPanel.add((Component)this._streamNameButton, gbc);
            this._ticFontButton = new RmaJFontButton("Choose Font...");
            this._ticFontButton.setActionCommand("Choose Font...");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 7;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 10, 0, 0);
            this._propertiesPanel.add((Component)this._ticFontButton, gbc);
            this._drawNodesCHK = new RmaJCheckBox("Draw Stream Nodes");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 8;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._drawNodesCHK, gbc);
            this._nodeColorLabel = new JLabel("Node Color:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 9;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 20, 0, 0);
            this._propertiesPanel.add((Component)this._nodeColorLabel, gbc);
            this._nodeColorCB = new RmaJColorComboBox();
            this._nodeColorCB.setAllowsCustomColor(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 9;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._nodeColorCB, gbc);
            this._nodeOutlineColorLabel = new JLabel("Node Outline Color:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 10;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 20, 0, 0);
            this._propertiesPanel.add((Component)this._nodeOutlineColorLabel, gbc);
            this._nodeOuterColorCB = new RmaJColorComboBox();
            this._nodeOuterColorCB.setAllowsCustomColor(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 10;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._nodeOuterColorCB, gbc);
            this._nodeWidthLabel = new JLabel("Node Width:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 11;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 20, 0, 0);
            this._propertiesPanel.add((Component)this._nodeWidthLabel, gbc);
            this._nodeWidthCB = new RmaJComboBox();
            this._nodeWidthCB.setModifiable(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 11;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._nodeWidthCB, gbc);
            this._drawJunctionsCHK = new RmaJCheckBox("Draw Junctions");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 12;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._drawJunctionsCHK, gbc);
            this._junctionColorLabel = new JLabel("Junction Color:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 13;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 20, 0, 0);
            this._propertiesPanel.add((Component)this._junctionColorLabel, gbc);
            this._junctionColorCB = new RmaJColorComboBox();
            this._junctionColorCB.setAllowsCustomColor(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 13;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._junctionColorCB, gbc);
            this._junctionWidthLabel = new JLabel("Junction Width:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 14;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 20, 0, 0);
            this._propertiesPanel.add((Component)this._junctionWidthLabel, gbc);
            this._junctionWidthCB = new RmaJComboBox();
            this._junctionWidthCB.setModifiable(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 14;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 5, 0, 0);
            this._propertiesPanel.add((Component)this._junctionWidthCB, gbc);
            this._previewPanel = new DrawPanel();
            this._previewPanel.setDrawingProperties(this._dp);
            this._previewPanel.setLayout(new FlowLayout(1, 5, 5));
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets(5, 5, 5, 5);
            gbc.ipadx = 150;
            gbc.ipady = 100;
            this.add((Component)this._previewPanel, gbc);
            this.ButtonPanel = new JPanel();
            this.ButtonPanel.setLayout(new FlowLayout(1, 5, 5));
            StreamAlignmentGlyphDialog.this.registerEnterKey(true);
            StreamAlignmentGlyphDialog.this.registerEscapeKey(true);
            jLabel1.setDisplayedMnemonic('W');
            jLabel1.setLabelFor(this._streamWidthCB);
            jLabel2.setDisplayedMnemonic('C');
            jLabel2.setLabelFor(this._streamColorCB);
            this._showStreamNameCHK.setMnemonic('S');
            this._ticFontButton.setMnemonic('o');
            this._drawStationTicsCHK.setMnemonic('D');
            this._ticLengthLabel.setDisplayedMnemonic('L');
            this._ticLengthLabel.setLabelFor(this._ticLengthCB);
            this._majorTicLengthLabel.setDisplayedMnemonic('M');
            this._majorTicLengthLabel.setLabelFor(this._majorTicLengthCB);
            this._drawTicLabelsCHK.setMnemonic('T');
            TitledBorder _temp = new TitledBorder("Edit Properties");
            _temp.setTitleColor(Color.black);
            this._propertiesPanel.setBorder(_temp);
            TitledBorder _temp1 = new TitledBorder("Preview");
            _temp1.setTitleColor(Color.black);
            this._previewPanel.setBorder(_temp1);
            StreamAlignmentGlyphDialog.this.state = 1;
            for (i = 0; i < 12; ++i) {
                iStr = String.valueOf(i);
                this._streamWidthCB.addItem(iStr);
                this._ticLengthCB.addItem(iStr);
                this._majorTicLengthCB.addItem(iStr);
                this._nodeWidthCB.addItem(iStr);
                this._junctionWidthCB.addItem(iStr);
            }
            for (i = 12; i < 28; i += 2) {
                iStr = String.valueOf(i);
                this._streamWidthCB.addItem(iStr);
                this._ticLengthCB.addItem(iStr);
                this._majorTicLengthCB.addItem(iStr);
                this._junctionWidthCB.addItem(iStr);
            }
            iStr = "36";
            this._streamWidthCB.addItem(iStr);
            this._ticLengthCB.addItem(iStr);
            this._majorTicLengthCB.addItem(iStr);
            iStr = "48";
            this._streamWidthCB.addItem(iStr);
            this._ticLengthCB.addItem(iStr);
            this._majorTicLengthCB.addItem(iStr);
            iStr = "72";
            this._streamWidthCB.addItem(iStr);
            this._ticLengthCB.addItem(iStr);
            this._majorTicLengthCB.addItem(iStr);
            this.fillForm();
            SymItem lSymItem = new SymItem();
            this._streamWidthCB.addItemListener(lSymItem);
            this._streamColorCB.addActionListener(this);
            this._majorTicLengthCB.addItemListener(lSymItem);
            this._ticLengthCB.addItemListener(lSymItem);
            this._nodeWidthCB.addItemListener(lSymItem);
            this._junctionWidthCB.addItemListener(lSymItem);
            this._nodeColorCB.addItemListener(lSymItem);
            this._nodeOuterColorCB.addItemListener(lSymItem);
            this._junctionColorCB.addItemListener(lSymItem);
            SymChange lSymChange = new SymChange();
            this._showStreamNameCHK.addChangeListener(lSymChange);
            this._drawJunctionsCHK.addChangeListener(lSymChange);
            this._drawNodesCHK.addChangeListener(lSymChange);
            this._drawStationTicsCHK.addItemListener(lSymItem);
            this._streamNameButton.addPropertyChangeListener("font", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    PropsPanel.this.streamNameButton_mouseClicked();
                }
            });
            this._ticFontButton.addPropertyChangeListener("font", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    PropsPanel.this.jButton2_mouseClicked();
                }
            });
            this._drawTicLabelsCHK.addActionListener(this);
            this._drawTicLabelsCHK.addChangeListener(lSymChange);
            this._drawStationTicsCHK.addChangeListener(lSymChange);
        }

        public int getMapScale() {
            return this._dp._mapScale;
        }

        public void fillFormFrom(PropsPanel panel) {
            StreamAlignmentDPData data = panel._dp;
            this._dp.set(data);
            this.fillForm();
            this.repaint();
            this._previewPanel.repaint();
        }

        public void setToDefaults() {
            this._dp.setDefaults();
            this.fillForm();
        }

        public void saveProperties() {
            this._origProps.set(this._dp);
        }

        public StreamAlignmentDPData getProperties() {
            return this._dp;
        }

        void updateScaleName() {
            int newScale = this._mapScaleFld.getValueUndefined();
            if (RMAConst.isUndefinedValue(newScale)) {
                this._mapScaleFld.setValue(this._dp.getMapScale());
                return;
            }
            if (newScale == this._dp.getMapScale()) {
                return;
            }
            int idx = StreamAlignmentGlyphDialog.this._scaleTabbedPanel.indexOfComponent(this);
            StreamAlignmentGlyphDialog.this._scaleTabbedPanel.setTitleAt(idx, String.valueOf(newScale));
            this._dp.setMapScale(newScale);
            StreamAlignmentGlyphDialog.this._needToRebuildPanels = true;
        }

        public void fillForm() {
            if (this._dp.getMapScale() < 1) {
                this._mapScaleFld.setVisible(false);
                this._mapScaleLabel.setVisible(false);
            }
            this._streamWidthCB.setSelectedItem("" + this._dp.getStreamWidth());
            this._majorTicLengthCB.setSelectedItem("" + this._dp.getMajorTicLength());
            this._ticLengthCB.setSelectedItem("" + this._dp.getTicLength());
            Color c2 = this._dp.getStreamColor();
            this._streamNameButton.setFont(this._dp.getNameFont());
            this._ticFontButton.setFont(this._dp.getTicLabelFont());
            this.selectColorItem(this._streamColorCB, c2);
            this._drawTicLabelsCHK.setSelected(this._dp.isDrawTicLabels());
            this._showStreamNameCHK.setSelected(this._dp.isShowStreamName());
            this._drawStationTicsCHK.setSelected(this._dp.isDrawTics());
            this._drawNodesCHK.setSelected(this._dp.isDrawNodes());
            this.selectColorItem(this._nodeColorCB, this._dp.getNodeColor());
            this.selectColorItem(this._nodeOuterColorCB, this._dp.getNodeOutlineColor());
            this._nodeWidthCB.setSelectedItem(String.valueOf(this._dp.getNodeWidth()));
            this._drawJunctionsCHK.setSelected(this._dp.isDrawJunctions());
            this.selectColorItem(this._junctionColorCB, this._dp.getJunctionColor());
            this._junctionWidthCB.setSelectedItem(String.valueOf(this._dp.getJunctionWidth()));
            this.drawStationTicsCHK_stateChanged(null);
            this.drawTicLabels_stateChanged(null);
            this.drawJunctionCHK_stateChanged();
            this.drawNodeCHK_stateChanged();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == this._streamColorCB) {
                this.streamColorCB_itemStateChanged(event);
            } else if (obj == this._drawTicLabelsCHK) {
                this.drawTicLabels_actionPerformed(event);
            }
        }

        void streamWidthCB_itemStateChanged(ItemEvent event) {
            String temp = (String)this._streamWidthCB.getSelectedItem();
            this._dp.setStreamWidth(RMAIO.parseInt(temp));
            this.repaint();
            this._previewPanel.repaint();
        }

        void streamColorCB_itemStateChanged(ActionEvent event) {
            this._dp.setStreamColor(this._streamColorCB.getSelectedColor());
            StreamAlignmentGlyphDialog.this.setModified(true);
            this.repaint();
        }

        void majorTicLengthCB_itemStateChanged(ItemEvent event) {
            String temp = (String)this._majorTicLengthCB.getSelectedItem();
            this._dp.setMajorTicLength(RMAIO.parseInt(temp));
            this.repaint();
        }

        void ticLenghtCB_itemStateChanged(ItemEvent event) {
            String temp = (String)this._ticLengthCB.getSelectedItem();
            this._dp.setTicLength(RMAIO.parseInt(temp));
            StreamAlignmentGlyphDialog.this.setModified(true);
            this.repaint();
        }

        private void junctionColorCB_itemStateChanged() {
            this._dp.setJunctionColor(this._junctionColorCB.getSelectedColor());
            StreamAlignmentGlyphDialog.this.setModified(true);
            this.repaint();
        }

        private void junctionWidthCB_itemStateChanged() {
            this._dp.setJunctionWidth(RMAIO.parseInt(this._junctionWidthCB.getSelectedItem()));
            StreamAlignmentGlyphDialog.this.setModified(true);
            this.repaint();
        }

        private void nodeOutlineColorCB_itemStateChanged() {
            this._dp.setNodeOutlineColor(this._nodeOuterColorCB.getSelectedColor());
            StreamAlignmentGlyphDialog.this.setModified(true);
            this.repaint();
        }

        private void nodeColorCB_itemStateChanged() {
            this._dp.setNodeColor(this._nodeColorCB.getSelectedColor());
            StreamAlignmentGlyphDialog.this.setModified(true);
            this.repaint();
        }

        private void nodeWidthCB_itemStateChanged() {
            this._dp.setNodeWidth(RMAIO.parseInt(this._nodeWidthCB.getSelectedItem()));
            StreamAlignmentGlyphDialog.this.setModified(true);
            this.repaint();
        }

        void showStreamNameCHK_stateChanged(ChangeEvent event) {
            this._dp.setShowStreamName(this._showStreamNameCHK.isSelected());
            if (this._showStreamNameCHK.isSelected()) {
                this._streamNameButton.setEnabled(true);
            } else {
                this._streamNameButton.setEnabled(false);
            }
            this.repaint();
        }

        void drawTicLabels_stateChanged(ChangeEvent event) {
            this._dp.setDrawTicLabels(this._drawTicLabelsCHK.isSelected());
            if (this._drawTicLabelsCHK.isSelected()) {
                this._ticFontButton.setForeground(Color.black);
                this._ticFontButton.setEnabled(true);
            } else {
                this._ticFontButton.setForeground(Color.cyan.darker());
                this._ticFontButton.setEnabled(false);
            }
            this.repaint();
        }

        void drawStationTicsCHK_stateChanged(ChangeEvent event) {
            this._dp.setDrawTics(this._drawStationTicsCHK.isSelected());
            if (this._drawStationTicsCHK.isSelected()) {
                this._drawTicLabelsCHK.setEnabled(true);
                this._majorTicLengthCB.setEnabled(true);
                this._ticLengthCB.setEnabled(true);
                this._ticLengthLabel.setEnabled(true);
                this._majorTicLengthLabel.setEnabled(true);
                this._ticFontButton.setForeground(Color.cyan.darker());
                this._ticFontButton.setEnabled(false);
            } else {
                this._drawTicLabelsCHK.setEnabled(false);
                this._majorTicLengthCB.setEnabled(false);
                this._ticLengthCB.setEnabled(false);
                this._ticFontButton.setForeground(Color.cyan.darker());
                this._ticLengthLabel.setEnabled(false);
                this._majorTicLengthLabel.setEnabled(false);
                this._ticFontButton.setEnabled(false);
                this._drawTicLabelsCHK.setSelected(false);
            }
            this.repaint();
        }

        void drawTicLabels_actionPerformed(ActionEvent event) {
            this._dp.setDrawTicLabels(this._drawTicLabelsCHK.isSelected());
            this.repaint();
        }

        void streamNameButton_mouseClicked() {
            this._dp.setNameFont(this._streamNameButton.getFont());
            this.repaint();
        }

        void jButton2_mouseClicked() {
            this._dp.setTicLabelFont(this._ticFontButton.getFont());
            this.repaint();
        }

        private JColorChooser getColorChooser() {
            if (this._chooserPane == null) {
                this._chooserPane = new JColorChooser();
            }
            this._chooserPane.setColor(this._streamColorCB.getSelectedColor());
            return this._chooserPane;
        }

        private void selectColorItem(RmaJColorComboBox combo, Color c2) {
            combo.setSelectedColor(c2);
        }

        private void drawJunctionCHK_stateChanged() {
            boolean enabled = this._drawJunctionsCHK.isSelected();
            this._dp.setDrawJunctions(enabled);
            this._junctionColorCB.setEnabled(enabled);
            this._junctionColorLabel.setEnabled(enabled);
            this._junctionWidthCB.setEnabled(enabled);
            this._junctionWidthLabel.setEnabled(enabled);
            this.repaint();
        }

        private void drawNodeCHK_stateChanged() {
            boolean enabled = this._drawNodesCHK.isSelected();
            this._dp.setDrawNodes(enabled);
            this._nodeColorCB.setEnabled(enabled);
            this._nodeColorLabel.setEnabled(enabled);
            this._nodeOuterColorCB.setEnabled(enabled);
            this._nodeOutlineColorLabel.setEnabled(enabled);
            this._nodeWidthCB.setEnabled(enabled);
            this._nodeWidthLabel.setEnabled(enabled);
        }

        class SymItem
        implements ItemListener {
            SymItem() {
            }

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object object = event.getSource();
                if (object == PropsPanel.this._streamWidthCB) {
                    PropsPanel.this.streamWidthCB_itemStateChanged(event);
                } else if (object == PropsPanel.this._majorTicLengthCB) {
                    PropsPanel.this.majorTicLengthCB_itemStateChanged(event);
                } else if (object == PropsPanel.this._ticLengthCB) {
                    PropsPanel.this.ticLenghtCB_itemStateChanged(event);
                } else if (object == PropsPanel.this._nodeWidthCB) {
                    PropsPanel.this.nodeWidthCB_itemStateChanged();
                } else if (object == PropsPanel.this._nodeColorCB) {
                    PropsPanel.this.nodeColorCB_itemStateChanged();
                } else if (object == PropsPanel.this._nodeOuterColorCB) {
                    PropsPanel.this.nodeOutlineColorCB_itemStateChanged();
                } else if (object == PropsPanel.this._junctionWidthCB) {
                    PropsPanel.this.junctionWidthCB_itemStateChanged();
                } else if (object == PropsPanel.this._junctionColorCB) {
                    PropsPanel.this.junctionColorCB_itemStateChanged();
                }
            }
        }

        class SymChange
        implements ChangeListener {
            SymChange() {
            }

            @Override
            public void stateChanged(ChangeEvent event) {
                Object object = event.getSource();
                if (object == PropsPanel.this._showStreamNameCHK) {
                    PropsPanel.this.showStreamNameCHK_stateChanged(event);
                } else if (object == PropsPanel.this._drawTicLabelsCHK) {
                    PropsPanel.this.drawTicLabels_stateChanged(event);
                } else if (object == PropsPanel.this._drawStationTicsCHK) {
                    PropsPanel.this.drawStationTicsCHK_stateChanged(event);
                } else if (object == PropsPanel.this._drawNodesCHK) {
                    PropsPanel.this.drawNodeCHK_stateChanged();
                } else if (object == PropsPanel.this._drawJunctionsCHK) {
                    PropsPanel.this.drawJunctionCHK_stateChanged();
                }
            }
        }

        class LineCustomColorOKListener
        implements ActionListener {
            LineCustomColorOKListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DefaultComboBoxModel)PropsPanel.this._streamColorCB.getModel()).removeElement(PropsPanel.this.lineCustomColor);
                PropsPanel.this.lineCustomColor[0] = PropsPanel.this._chooserPane.getColor();
                PropsPanel.this._streamColorCB.addItem(PropsPanel.this.lineCustomColor);
                PropsPanel.this._streamColorCB.setSelectedIndex(PropsPanel.this._streamColorCB.getItemCount() - 1);
                PropsPanel.this._streamColorCB.revalidate();
                PropsPanel.this.repaint();
            }
        }
    }

    private class DrawPanel
    extends JPanel {
        private StreamAlignmentDPData _dp;

        DrawPanel() {
        }

        public void setDrawingProperties(StreamAlignmentDPData dp) {
            this._dp = dp;
        }

        @Override
        public void paint(Graphics g) {
            int width;
            int x;
            int y;
            if (this._dp == null) {
                super.paint(g);
                return;
            }
            int w = this.getWidth();
            int h = this.getHeight();
            int topY = h / 2 - this._dp.getStreamWidth() / 2;
            g.setColor(Color.white);
            FontMetrics fm = g.getFontMetrics();
            g.fillRect(0, 0, w, h);
            g.setColor(this._dp.getStreamColor());
            g.fillRect(10, topY, w - 20, this._dp.getStreamWidth());
            if (this._dp.isDrawTics()) {
                g.drawLine(40, topY, 40, topY - this._dp.getTicLength());
                g.drawLine(60, topY, 60, topY - this._dp.getTicLength());
                g.drawLine(80, topY, 80, topY - this._dp.getTicLength());
                g.drawLine(100, topY, 100, topY - this._dp.getTicLength());
                g.drawLine(120, topY, 120, topY - this._dp.getTicLength());
                g.drawLine(20, topY, 20, topY - this._dp.getMajorTicLength());
                g.drawLine(140, topY, 140, topY - this._dp.getMajorTicLength());
                g.drawLine(16, topY - this._dp.getMajorTicLength(), 24, topY - this._dp.getMajorTicLength());
                g.drawLine(136, topY - this._dp.getMajorTicLength(), 144, topY - this._dp.getMajorTicLength());
                if (this._dp.isDrawTicLabels()) {
                    g.setFont(this._dp.getTicLabelFont());
                    fm = g.getFontMetrics();
                    h = fm.getHeight();
                    w = fm.stringWidth("20");
                    g.drawString("100", 20 - w / 2, topY - this._dp.getMajorTicLength() - 5);
                    w = fm.stringWidth("120");
                    g.drawString("200", 140 - w / 2, topY - this._dp.getMajorTicLength() - 5);
                }
            }
            if (this._dp.isShowStreamName()) {
                g.setFont(this._dp.getNameFont());
                fm = g.getFontMetrics();
                h = fm.getHeight();
                w = fm.stringWidth("Stream Name");
                y = topY + this._dp.getStreamWidth() + h + 10;
                x = (this.getWidth() - 20 - w) / 2 + 10;
                g.drawString("Stream Name", x, y);
            }
            y = topY + this._dp.getStreamWidth() / 2;
            --y;
            if (this._dp.isDrawNodes()) {
                x = 10;
                width = this._dp.getNodeWidth();
                int halfWidth = width / 2;
                g.setColor(this._dp.getNodeColor());
                g.fillOval(x - halfWidth, y - halfWidth, width, width);
                g.setColor(this._dp.getNodeOutlineColor());
                g.drawOval(x - halfWidth, y - halfWidth, width, width);
            }
            if (this._dp.isDrawJunctions()) {
                x = this.getWidth() - 10;
                width = this._dp.getJunctionWidth();
                int halfwidth = (int)((double)width / 2.5);
                g.setColor(this._dp.getJunctionColor());
                g.fillOval(x - halfwidth, y - halfwidth, width, width);
            }
        }
    }
}

