/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.model.StreamElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJRadioButton;

public class StreamConversionPanel
extends AbstractEditorPanel {
    private StreamElement _streamElement;
    private RmaJRadioButton _byPointRadio;
    private EnabledJPanel _locationPanel;
    private RmaJDecimalField _northingFld;
    private RmaJDecimalField _eastingFld;
    private RmaJRadioButton _byStationRadio;
    private EnabledJPanel _stationPanel;
    private RmaJDecimalField _stationFld;
    private EnabledJPanel _coordinatePanel;
    private RmaJDecimalField _coordinateFld;
    private JButton _calcButton;
    private RmaJRadioButton _byCoordinateRadio;

    public StreamConversionPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
        this.radioAction();
    }

    protected void buildControls() {
        JLabel label = new JLabel("Steam Conversion");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        this._byPointRadio = new RmaJRadioButton("Enter Location:", true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._byPointRadio, gbc);
        this._locationPanel = new EditableJPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._locationPanel, gbc);
        label = new JLabel("Northing:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._locationPanel.add((Component)label, gbc);
        this._northingFld = new RmaJDecimalField();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._locationPanel.add((Component)this._northingFld, gbc);
        label = new JLabel("Easting:");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._locationPanel.add((Component)label, gbc);
        this._eastingFld = new RmaJDecimalField();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._locationPanel.add((Component)this._eastingFld, gbc);
        this._byStationRadio = new RmaJRadioButton("Enter Station");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._byStationRadio, gbc);
        this._stationPanel = new EditableJPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._stationPanel, gbc);
        label = new JLabel("Station:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._stationPanel.add((Component)label, gbc);
        this._stationFld = new RmaJDecimalField();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._stationPanel.add((Component)this._stationFld, gbc);
        this._byCoordinateRadio = new RmaJRadioButton("Enter Coordinate:");
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._byCoordinateRadio, gbc);
        this._coordinatePanel = new EditableJPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._coordinatePanel, gbc);
        label = new JLabel("Coordinate:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._coordinatePanel.add((Component)label, gbc);
        this._coordinateFld = new RmaJDecimalField();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._coordinatePanel.add((Component)this._coordinateFld, gbc);
        this._calcButton = new JButton("Calculate");
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0E-4;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)this._calcButton, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._byPointRadio);
        bg.add(this._byCoordinateRadio);
        bg.add(this._byStationRadio);
    }

    private void addListeners() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StreamConversionPanel.this.radioAction();
            }
        };
        this._byPointRadio.addActionListener(al);
        this._byCoordinateRadio.addActionListener(al);
        this._byStationRadio.addActionListener(al);
        this._calcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StreamConversionPanel.this.calculateAction();
            }
        });
    }

    protected void calculateAction() {
        if (this._byCoordinateRadio.isSelected()) {
            double coord = this._coordinateFld.getValue();
            WorldPt pt = this._streamElement.getLocationByCoord(coord);
            double station = this._streamElement.getStationByCoord(coord);
            this._eastingFld.setValue(pt.e);
            this._northingFld.setValue(pt.n);
            this._stationFld.setValue(station);
        } else if (this._byStationRadio.isSelected()) {
            double station = this._stationFld.getValue();
            WorldPt pt = this._streamElement.getLocationByStation(station);
            double coord = this._streamElement.getCoordByStation(station);
            this._eastingFld.setValue(pt.e);
            this._northingFld.setValue(pt.n);
            this._coordinateFld.setValue(coord);
        } else if (this._byPointRadio.isSelected()) {
            WorldPt wpt = new WorldPt(this._eastingFld.getValue(), this._northingFld.getValue());
            double station = this._streamElement.getStationByLocation(wpt);
            double coord = this._streamElement.getCoordByLocation(wpt);
            this._coordinateFld.setValue(coord);
            this._stationFld.setValue(station);
        }
    }

    protected void radioAction() {
        if (this._byCoordinateRadio.isSelected()) {
            this._coordinatePanel.setEnabled(true);
            this._stationPanel.setEnabled(false);
            this._locationPanel.setEnabled(false);
        } else if (this._byStationRadio.isSelected()) {
            this._coordinatePanel.setEnabled(false);
            this._stationPanel.setEnabled(true);
            this._locationPanel.setEnabled(false);
        } else if (this._byPointRadio.isSelected()) {
            this._coordinatePanel.setEnabled(false);
            this._stationPanel.setEnabled(false);
            this._locationPanel.setEnabled(true);
        } else {
            this._coordinatePanel.setEnabled(false);
            this._stationPanel.setEnabled(false);
            this._locationPanel.setEnabled(false);
        }
    }

    @Override
    public void fillPanel(NamedType dobj) {
        if (dobj instanceof StreamElement) {
            this._streamElement = (StreamElement)dobj;
        } else {
            this._byCoordinateRadio.setSelected(false);
            this._byCoordinateRadio.setEnabled(false);
            this._byStationRadio.setSelected(false);
            this._byStationRadio.setEnabled(false);
            this._byPointRadio.setSelected(false);
            this._byPointRadio.setEnabled(false);
        }
        this.radioAction();
    }

    @Override
    public String getTabname() {
        return "Conversions";
    }

    @Override
    public boolean savePanel(NamedType dobj) {
        return true;
    }

    @Override
    public void setModified(boolean b) {
    }

    private class EditableJPanel
    extends EnabledJPanel {
        public EditableJPanel(LayoutManager lm) {
            super(lm);
        }

        @Override
        protected void setComponentEnabled(Component component, boolean enabled) {
            if (component instanceof JTextField) {
                ((JTextField)component).setEditable(enabled);
            }
        }
    }
}

