/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.gui.SelectorPanelEditor;
import hec.lang.NamedType;
import hec.map.streamAlignment.StreamConversionPanel;
import hec.map.streamAlignment.StreamStationingPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class StreamEditor
extends SelectorPanelEditor {
    StreamStationingPanel stationingPanel;
    private StreamConversionPanel conversionPanel;

    public StreamEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        this.setSize(400, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle("Stream Editor");
        this.stationingPanel = new StreamStationingPanel();
        this.addPanel(this.stationingPanel);
        if (Boolean.getBoolean("expertStreamMode")) {
            this.conversionPanel = new StreamConversionPanel();
            this.addPanel(this.conversionPanel);
        }
        this.buildMenus();
    }

    public void setStationText(String stationText) {
        this.stationingPanel.setStationText(stationText);
    }

    private void buildMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Streams");
        menu.setMnemonic('s');
        mb.add(menu);
        JMenuItem menuItem = new JMenuItem("Close", 99);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StreamEditor.this.windowClosing();
                StreamEditor.this.setVisible(false);
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(mb);
    }

    @Override
    public void fillForm(NamedType nt) {
        super.fillForm(nt);
        this.setModified(false);
    }
}

