/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.table.AbstractRmaTableModel;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.util.RMAIO;

public class StreamJunctionEditor
extends RmaJDialog {
    private RmaJTable _nodeTable;
    private ButtonCmdPanel _cmdPanel;
    private NodeTableModel _model;
    private RmaJDecimalField _easting;
    private RmaJDecimalField _northing;
    private boolean _canceled;
    private StreamAlignmentIfc _alignment;
    private String _title;

    public StreamJunctionEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    protected void buildControls() {
        this._title = "Stream Junction Editor";
        this.setTitle(this._title);
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Easting:", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._easting = new RmaJDecimalField();
        this._easting.setPrecision(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._easting, gbc);
        label = new JLabel("Northing:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._northing = new RmaJDecimalField();
        this._northing.setPrecision(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._northing, gbc);
        this._nodeTable = new RmaJTable(this, (Object[])new String[]{" \nStream", " \nStation", "Use Default\nStationing"}){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }

            @Override
            public Color getRowBackground(int row, int col) {
                return StreamJunctionEditor.this._model.getRowBackground(row, col);
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new GroupableTableHeader(this.columnModel);
            }
        };
        this._model = new NodeTableModel();
        RmaJTableSorter sorter = new RmaJTableSorter(this._model);
        this._nodeTable.setModel(sorter);
        sorter.addMouseListenerToHeaderInTable(this._nodeTable);
        this._nodeTable.setCheckBoxCellEditor(2);
        this._nodeTable.setDoubleCellEditor(1, true);
        TableColumnModel cm = this._nodeTable.getColumnModel();
        ColumnGroup cg = new ColumnGroup("Stream Nodes");
        cg.add(cm.getColumn(0));
        cg.add(cm.getColumn(1));
        cg.add(cm.getColumn(2));
        GroupableTableHeader header = (GroupableTableHeader)this._nodeTable.getTableHeader();
        header.addColumnGroup(cg);
        this._nodeTable.setMlHeaderRenderer();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._nodeTable.getScrollPane(), gbc);
        this._cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!StreamJunctionEditor.this.saveForm()) break;
                        StreamJunctionEditor.this._canceled = false;
                        StreamJunctionEditor.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        StreamJunctionEditor.this.saveForm();
                        break;
                    }
                    case 4: {
                        StreamJunctionEditor.this._canceled = true;
                        StreamJunctionEditor.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setSize(this.getPreferredSize());
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void fillForm(StreamJunction junc) {
        StreamNode n;
        Vector v;
        this._easting.setText("");
        this._northing.setText("");
        if (junc != null && (v = junc.getNodeVector()).size() > 0 && (n = (StreamNode)v.get(0)) != null) {
            WorldPt wpt = n.getLocation();
            this._easting.setValue(wpt.e);
            this._northing.setValue(wpt.n);
        }
        this._model.setJunction(junc);
        this.setModified(false);
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        this._easting.setEditable(false);
        this._northing.setEditable(false);
    }

    public void setAlignment(StreamAlignmentIfc alignment) {
        this._alignment = alignment;
    }

    public boolean saveForm() {
        this._nodeTable.commitEdit(true);
        StreamJunction junc = this._model.getJunction();
        if (junc == null) {
            return true;
        }
        Vector copies = this._model.getNodeVector();
        Vector nodes = junc.getNodeVector();
        block0: for (int i = 0; i < nodes.size(); ++i) {
            StreamNode node = (StreamNode)nodes.get(i);
            for (int j = 0; j < copies.size(); ++j) {
                StreamNode copy = (StreamNode)copies.get(j);
                if (node.getIndex() != copy.getIndex()) continue;
                node.setStation(copy.getStation());
                node.setDefaultStation(copy.isDefaultStation());
                continue block0;
            }
        }
        junc.setModified(true);
        if (this._alignment != null) {
            this._alignment.setModified(true);
        }
        this.setModified(false);
        return true;
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified) {
            this.setTitle(this._title + "*");
        } else {
            this.setTitle(this._title);
        }
    }

    class NodeTableModel
    extends AbstractRmaTableModel {
        StreamJunction _junc;
        Vector _nodeVector = new Vector();

        public NodeTableModel() {
            this.m_columnNames = new String[]{" \nStream", " \nStation", "Use Default\nStationing"};
        }

        @Override
        public String getColumnName(int col) {
            return this.m_columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this._junc == null) {
                return 0;
            }
            return this._nodeVector.size();
        }

        public void setJunction(StreamJunction junc) {
            this._junc = junc;
            this._nodeVector.clear();
            if (this._junc != null) {
                int size = this._junc.getNodeVector().size();
                this._nodeVector.ensureCapacity(size);
                for (int i = 0; i < size; ++i) {
                    StreamNode node = (StreamNode)this._junc.getNodeVector().get(i);
                    if ((node = (StreamNode)node.clone()) == null) continue;
                    this._nodeVector.add(node);
                }
            }
            this.fireTableDataChanged();
        }

        public StreamJunction getJunction() {
            return this._junc;
        }

        public Vector getNodeVector() {
            return this._nodeVector;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this._junc == null) {
                return null;
            }
            if (row >= this._nodeVector.size()) {
                return null;
            }
            StreamNode node = (StreamNode)this._nodeVector.get(row);
            if (node == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return node.getStream();
                }
                case 1: {
                    return new Double(node.getStation());
                }
                case 2: {
                    return "" + node.isDefaultStation();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!StreamJunctionEditor.this._nodeTable.isEnabled()) {
                return false;
            }
            if (this._junc == null) {
                return true;
            }
            if (row >= this._nodeVector.size()) {
                return true;
            }
            StreamNode node = (StreamNode)this._nodeVector.get(row);
            if (node == null) {
                return true;
            }
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return !node.isDefaultStation();
                }
                case 2: {
                    return true;
                }
            }
            return true;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (obj == null) {
                return;
            }
            if (row >= this._nodeVector.size()) {
                return;
            }
            StreamNode node = (StreamNode)this._nodeVector.get(row);
            if (node == null) {
                return;
            }
            System.out.println("setValueAt(): obj=" + obj.getClass() + " value=" + obj.toString());
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    if (obj instanceof Double) {
                        node.setStation((Double)obj);
                        return;
                    }
                    String s = obj.toString();
                    node.setStation(RMAIO.parseDouble(s));
                    break;
                }
                case 2: {
                    node.setDefaultStation("true".equals(obj.toString()));
                }
            }
        }

        public Color getRowBackground(int row, int col) {
            return this.isCellEditable(row, col) ? Color.white : Color.lightGray;
        }
    }
}

