/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.map.LocalPt;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class StreamNodeAdapter
extends MapMouseAdapter
implements MouseListener,
MouseMotionListener {
    public static final String LOCK_MSG = "You must first lock the Stream Alignment.";
    StreamAlignmentGlyph _sysglyph = null;
    StreamElement _streamElem = null;
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _nPt = new LocalPt();
    LocalPt _jPt = new LocalPt();
    StreamNode _selectedNode = null;
    StreamJunction _selectedJunc = null;
    boolean _movingNode = false;
    boolean _movingJunc = false;
    boolean _editingJunc = false;
    boolean _editingNode = false;
    boolean _selectedEndNode = false;
    boolean _movingAlongStream = false;
    MapPanel _mapPanel = null;
    double _upStreamCoord;
    double _downStreamCoord;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];

    public StreamNodeAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
        this._mapPanel = panel;
    }

    @Override
    public void init() {
        this.findGlyph();
    }

    @Override
    public void abort() {
        this.findGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._streamElem = null;
        this._selectedNode = null;
        this._selectedJunc = null;
        this._downStreamCoord = -1.0;
        this._upStreamCoord = -1.0;
        this._movingAlongStream = false;
        this._editingNode = false;
        this._editingJunc = false;
    }

    boolean findGlyph() {
        this._sysglyph = null;
        List gvec = this._mapPanel.managerGlyphList();
        for (int i = 0; i < gvec.size(); ++i) {
            MapGlyph g = (MapGlyph)gvec.get(i);
            if (g == null || !(g instanceof StreamAlignmentGlyph)) continue;
            this._sysglyph = (StreamAlignmentGlyph)g;
            break;
        }
        return this._sysglyph != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.findGlyph()) {
            return;
        }
        this._streamElem = this._sysglyph.findReach(this._pt);
        if (this._streamElem == null && !this._movingJunc || this._selectedNode == null && this._selectedJunc == null) {
            this.setNodeSelected(null, false);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            return;
        }
        if (e.isPopupTrigger() || StreamNodeAdapter.pressedButton3(e)) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._sysglyph.objectPopupMenu(pt, e.getModifiers());
            return;
        }
        if (this._movingJunc && this._selectedJunc != null) {
            this._mapPanel.viewport().setCursor(this.getCursor());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double coord = Double.NEGATIVE_INFINITY;
            double station = Double.NEGATIVE_INFINITY;
            if (this._movingAlongStream) {
                coord = this._streamElem.getLine().getCoordAtLocation(wpt);
                station = this._streamElem.getStationByCoord(coord);
                wpt = this._streamElem.getLocationByCoord(coord);
            }
            Vector v = this._selectedJunc.getNodeVector();
            StreamNode node = this._sysglyph.findStreamNode(this._streamElem, this._pt);
            if (node != null) {
                int opt;
                StreamJunction junc = node.getJunction();
                if (junc != null && junc != this._selectedJunc) {
                    opt = JOptionPane.showConfirmDialog(this._mapPanel, "Junction found at drop location. Connect Junctions?", "Connect?", 0, 3);
                    if (opt == 1) {
                        this.setJunctionSelected(null);
                        this._mapPanel.paintMap();
                        this._mapPanel.waitforPaintComplete();
                        this._movingJunc = false;
                        return;
                    }
                } else if (junc == null) {
                    opt = JOptionPane.showConfirmDialog(this._mapPanel, "Node found at drop location. Connect Node?", "Connect?", 0, 3);
                    if (opt == 1) {
                        this.setJunctionSelected(null);
                        this._mapPanel.paintMap();
                        this._mapPanel.waitforPaintComplete();
                        this._movingJunc = false;
                        return;
                    }
                    StreamNode selectedNode = this._selectedJunc.getNodeOnStream(this._streamElem);
                    if (selectedNode.isDefaultStation() || !node.isDefaultStation()) {
                        this._sysglyph.deleteNode(selectedNode, false);
                        this._selectedJunc.addNode(node);
                    } else if (node.isDefaultStation()) {
                        this._sysglyph.deleteNode(selectedNode, false);
                        this._selectedJunc.addNode(node);
                    }
                }
            }
            for (int i = 0; i < v.size(); ++i) {
                node = (StreamNode)v.get(i);
                if (node.getStream() == this._streamElem) {
                    node.setStreamCoord(coord);
                    continue;
                }
                node.setLocation(wpt);
                StreamElement elem = node.getStream();
                if (elem != null) {
                    if (elem.getDownstreamNode() == node) {
                        elem.getLine().getFirstPt().init(wpt);
                    } else if (elem.getUpstreamNode() == node) {
                        elem.getLine().getLastPt().init(wpt);
                    }
                }
                elem.getLine().invalidate();
                elem.resetNodeCoord();
            }
            if (this._streamElem != null) {
                this._streamElem.getAlignment().updateJunctionLocations();
            }
            this.setJunctionSelected(null);
            this._sysglyph._sysmap.setModified(true);
            if (this._streamElem != null) {
                this._sysglyph.resetStreamTics(this._streamElem);
            }
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            this._movingJunc = false;
        } else if (this._movingNode && this._selectedNode != null) {
            this._mapPanel.viewport().setCursor(this.getCursor());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double coord = this._streamElem.getLine().getCoordAtLocation(wpt);
            this._selectedNode.setStreamCoord(coord);
            this._streamElem.resetNodeCoord();
            this._streamElem.getAlignment().updateJunctionLocations();
            this.setNodeSelected(null, false);
            this._sysglyph.resetStreamTics(this._streamElem);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            this._sysglyph._sysmap.setModified(true);
        } else if (!this._movingNode && !this._movingJunc) {
            StreamNode node = null;
            StreamJunction junc = this._sysglyph.findStreamJunction(this._streamElem, this._pt);
            Graphics g = this._mapCanvas.getGraphics();
            MapScale scl = this._mapPanel.scale();
            if (junc != null) {
                this._sysglyph.selectJunction(g, scl, junc, false, false);
                if (junc != null) {
                    this._jPt.init(this._pt);
                }
                this.setJunctionSelected(junc);
                this.setNodeSelected(null, false);
            } else {
                node = this._sysglyph.findStreamNode(this._streamElem, this._pt);
                this._sysglyph.selectNode(g, scl, node, false);
                if (node != null) {
                    this._nPt.init(this._pt);
                }
                boolean endNode = false;
                if (node != null && (node.getStreamCoord() == 1.0 || node.getStreamCoord() == 0.0)) {
                    endNode = true;
                }
                this.setNodeSelected(node, endNode);
                this.setJunctionSelected(null);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.findGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        this._pt0.init(this._pt);
        this._streamElem = this._sysglyph.findReach(this._pt);
        if (this._streamElem == null) {
            this.setNodeSelected(null, false);
            return;
        }
        if (e.isControlDown() && this._sysglyph.findStreamNode(this._streamElem, this._pt) == null) {
            StreamAlignmentIfc _alignment = this._sysglyph._sysmap;
            if (!this._sysglyph.isWriteLocked()) {
                JOptionPane.showMessageDialog(this._mapPanel, LOCK_MSG, "Can't add Stream Node", 1);
                return;
            }
            StreamNode node = _alignment.newStreamNode(this._streamElem);
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            node.setLocation(wpt);
            double coord = this._streamElem.getCoordByLocation(wpt);
            node.setStreamCoord(coord);
            this._streamElem.addNode(node);
            _alignment.setModified(true);
            this._mapPanel.paintMap();
        } else if (!this._movingJunc && !this._movingNode) {
            StreamNode node = null;
            StreamJunction junc = this._sysglyph.findStreamJunction(this._streamElem, this._pt);
            Graphics g = this._mapCanvas.getGraphics();
            MapScale scl = this._mapPanel.scale();
            if (junc != null) {
                this._sysglyph.selectJunction(g, scl, junc, false, this._movingJunc);
                if (junc != null) {
                    this._jPt.init(this._pt);
                }
                this.setNodeSelected(null, false);
                this.setJunctionSelected(junc);
            } else {
                node = this._sysglyph.findStreamNode(this._streamElem, this._pt);
                this._sysglyph.selectNode(g, scl, node, this._editingNode);
                if (node != null) {
                    this._nPt.init(this._pt);
                }
                boolean endNode = false;
                if (node != null && (node.getStreamCoord() == 1.0 || node.getStreamCoord() == 0.0)) {
                    endNode = true;
                }
                this.setNodeSelected(node, endNode);
                this.setJunctionSelected(null);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this._editingJunc && !this._editingNode || e.isPopupTrigger() || StreamNodeAdapter.pressedButton3(e)) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        g.setXORMode(new Color(255, 255, 255));
        if (this._editingJunc) {
            StreamElement _streamElem = null;
            this._movingAlongStream = false;
            this._movingJunc = true;
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
            for (int i = 0; i < this._selectedJunc.getNodeVector().size(); ++i) {
                StreamNode node = (StreamNode)this._selectedJunc.getNodeVector().get(i);
                StreamElement elem = node.getStream();
                if (elem.getDownstreamNode() == node || elem.getUpstreamNode() == node) continue;
                _streamElem = elem;
                this._movingAlongStream = true;
                break;
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            if (_streamElem != null) {
                g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
                if (!this._pt.equals(this._pt0)) {
                    this.drawPt(this._pt, true);
                }
                WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
                double coord = _streamElem.getLine().getCoordAtLocation(wpt);
                pt = this._mapPanel.scale().wp2lp(_streamElem.getLocationByCoord(coord));
                if (coord >= this._upStreamCoord && this._upStreamCoord != -1.0) {
                    pt = this._mapPanel.scale().wp2lp(_streamElem.getLocationByCoord(this._upStreamCoord));
                } else if (coord <= this._downStreamCoord && this._downStreamCoord != -1.0) {
                    pt = this._mapPanel.scale().wp2lp(_streamElem.getLocationByCoord(this._downStreamCoord));
                }
                this._pt.init(pt);
                g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
                if (!this._pt.equals(this._pt0)) {
                    this.drawPt(this._pt, true);
                }
                g.setPaintMode();
                g.dispose();
            } else {
                g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
                if (!this._pt.equals(this._pt0)) {
                    this.drawPt(this._pt, true);
                }
                WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
                this._pt.init(pt);
                g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
                if (!this._pt.equals(this._pt0)) {
                    this.drawPt(this._pt, true);
                }
                g.setPaintMode();
            }
        } else if (this._editingNode) {
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
            double coord = this._streamElem.getLine().getCoordAtLocation(wpt);
            pt = this._mapPanel.scale().wp2lp(this._streamElem.getLocationByCoord(coord));
            this._pt.init(pt);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            this._movingNode = true;
            g.setPaintMode();
            g.dispose();
        }
        super.mouseMoved(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.findGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        this._pt0.init(this._pt);
        this._streamElem = this._sysglyph.findReach(this._pt);
        if (this._streamElem == null) {
            this.setNodeSelected(null, false);
            this.setJunctionSelected(null);
            Graphics g = this._mapCanvas.getGraphics();
            MapScale scl = this._mapPanel.scale();
            this._sysglyph.selectJunction(g, scl, null, false, false);
            g.dispose();
            return;
        }
        StreamJunction junc = this._sysglyph.findStreamJunction(this._streamElem, this._pt);
        if (junc != null) {
            StreamNode node;
            this.setJunctionSelected(junc);
            if (e.getClickCount() == 2) {
                if (!this._sysglyph.isWriteLocked()) {
                    JOptionPane.showMessageDialog(this._mapPanel, LOCK_MSG, "Can't add Edit Junction", 1);
                    return;
                }
                this._editingJunc = true;
            } else {
                this._editingJunc = false;
            }
            Graphics g = this._mapCanvas.getGraphics();
            MapScale scl = this._mapPanel.scale();
            this._sysglyph.selectJunction(g, scl, junc, false, this._editingJunc);
            g.dispose();
            for (int i = 0; i < this._selectedJunc.getNodeVector().size(); ++i) {
                node = (StreamNode)this._selectedJunc.getNodeVector().get(i);
                StreamElement elem = node.getStream();
                if (elem.getDownstreamNode() == node || elem.getUpstreamNode() == node) continue;
                this._streamElem = elem;
                break;
            }
            if (this._streamElem != null) {
                WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
                node = this._selectedJunc.getNodeOnStream(this._streamElem);
                double coord = node != null ? node.getStreamCoord() : this._streamElem.getCoordByLocation(wpt);
                node = this._sysglyph._sysmap.findDownstreamNode(this._streamElem, coord);
                this._downStreamCoord = node != null ? node.getStreamCoord() : -1.0;
                node = this._sysglyph._sysmap.findUpstreamNode(this._streamElem, coord);
                this._upStreamCoord = node != null ? node.getStreamCoord() : -1.0;
            } else {
                this._downStreamCoord = -1.0;
                this._upStreamCoord = -1.0;
            }
        } else {
            StreamNode node = this._sysglyph.findStreamNode(this._streamElem, this._pt);
            if (node == null) {
                this.setNodeSelected(null, false);
                return;
            }
            boolean endNode = false;
            if (node.getStreamCoord() == 1.0 || node.getStreamCoord() == 0.0) {
                endNode = true;
                return;
            }
            this.setNodeSelected(node, endNode);
            if (e.getClickCount() == 2) {
                if (!this._sysglyph.isWriteLocked()) {
                    JOptionPane.showMessageDialog(this._mapPanel, LOCK_MSG, "Can't add Edit Junction", 1);
                    return;
                }
                this._editingNode = true;
            } else {
                this._editingNode = false;
            }
            Graphics g = this._mapCanvas.getGraphics();
            MapScale scl = this._mapPanel.scale();
            this._sysglyph.selectNode(g, scl, node, this._editingNode);
        }
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StreamNodeAdapter._xpt[0] = pt.x - 3;
        StreamNodeAdapter._ypt[0] = pt.y;
        StreamNodeAdapter._xpt[1] = pt.x;
        StreamNodeAdapter._ypt[1] = pt.y + 3;
        StreamNodeAdapter._xpt[2] = pt.x + 3;
        StreamNodeAdapter._ypt[2] = pt.y;
        StreamNodeAdapter._xpt[3] = pt.x;
        StreamNodeAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    private void setNodeSelected(StreamNode node, boolean endNode) {
        this._selectedNode = node;
        this._selectedEndNode = endNode;
        if (node == null) {
            this.setNodeEditing(false, false);
        }
    }

    private void setJunctionSelected(StreamJunction junc) {
        this._selectedJunc = junc;
        if (junc == null) {
            this.setJunctionEditing(false);
        }
    }

    private void setJunctionEditing(boolean editing) {
        this._editingJunc = editing;
    }

    private void setNodeEditing(boolean editing, boolean endNode) {
        this._editingNode = editing;
        this._selectedEndNode = endNode;
    }
}

